/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.action;

import java.io.IOException;
import java.util.List;
import java.util.TimeZone;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.action.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.SqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;

public class SqlTranslateRequest
extends AbstractSqlQueryRequest {
    private static final ObjectParser<SqlTranslateRequest, Void> PARSER = SqlTranslateRequest.objectParser(SqlTranslateRequest::new);

    public SqlTranslateRequest() {
    }

    public SqlTranslateRequest(Mode mode, String query, List<SqlTypedParamValue> params, QueryBuilder filter, TimeZone timeZone, int fetchSize, TimeValue requestTimeout, TimeValue pageTimeout) {
        super(mode, query, params, filter, timeZone, fetchSize, requestTimeout, pageTimeout);
    }

    public SqlTranslateRequest(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText((String)this.query())) {
            validationException = ValidateActions.addValidationError((String)"query is required", validationException);
        }
        return validationException;
    }

    public String getDescription() {
        return "SQL Translate [" + this.query() + "][" + this.filter() + "]";
    }

    public static SqlTranslateRequest fromXContent(XContentParser parser, Mode mode) {
        SqlTranslateRequest request = (SqlTranslateRequest)((Object)PARSER.apply(parser, null));
        request.mode(mode);
        return request;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return new SqlQueryRequest(this.mode(), this.query(), this.params(), this.timeZone(), this.fetchSize(), this.requestTimeout(), this.pageTimeout(), (ToXContent)this.filter(), null).toXContent(builder, params);
    }
}

