/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.elasticsearch.xpack.core.ml.utils.time.DateTimeFormatterTimestampConverter;
import org.elasticsearch.xpack.core.ml.utils.time.TimestampConverter;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.CannotParseTimestampException;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DateTransformer;

public class DateFormatDateTransformer
implements DateTransformer {
    private final String timeFormat;
    private final TimestampConverter dateToEpochConverter;

    public DateFormatDateTransformer(String timeFormat) {
        this.timeFormat = timeFormat;
        this.dateToEpochConverter = DateTimeFormatterTimestampConverter.ofPattern((String)timeFormat, (ZoneId)ZoneOffset.UTC);
    }

    @Override
    public long transform(String timestamp) throws CannotParseTimestampException {
        try {
            return this.dateToEpochConverter.toEpochMillis(timestamp);
        }
        catch (DateTimeParseException e) {
            String message = String.format(Locale.ROOT, "Cannot parse date '%s' with format string '%s'", timestamp, this.timeFormat);
            throw new CannotParseTimestampException(message, e);
        }
    }
}

