/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalGeoHashGrid
extends InternalMultiBucketAggregation<InternalGeoHashGrid, Bucket>
implements GeoHashGrid {
    private final int requiredSize;
    private final List<Bucket> buckets;

    InternalGeoHashGrid(String name, int requiredSize, List<Bucket> buckets, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.requiredSize = requiredSize;
        this.buckets = buckets;
    }

    public InternalGeoHashGrid(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalGeoHashGrid.readSize(in);
        this.buckets = in.readList(x$0 -> new Bucket(x$0));
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalGeoHashGrid.writeSize(this.requiredSize, out);
        out.writeList(this.buckets);
    }

    @Override
    public String getWriteableName() {
        return "geohash_grid";
    }

    @Override
    public InternalGeoHashGrid create(List<Bucket> buckets) {
        return new InternalGeoHashGrid(this.name, this.requiredSize, buckets, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.geohashAsLong, prototype.docCount, aggregations);
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalGeoHashGrid doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var7_12;
        LongObjectPagedHashMap<ArrayList<Bucket>> buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoHashGrid grid = (InternalGeoHashGrid)aggregation;
            if (buckets == null) {
                buckets = new LongObjectPagedHashMap<ArrayList<Bucket>>(grid.buckets.size(), reduceContext.bigArrays());
            }
            for (Bucket bucket : grid.buckets) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(bucket.geohashAsLong);
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(bucket.geohashAsLong, existingBuckets);
                }
                existingBuckets.add(bucket);
            }
        }
        int size = Math.toIntExact(!reduceContext.isFinalReduce() ? buckets.size() : Math.min((long)this.requiredSize, buckets.size()));
        BucketPriorityQueue ordered = new BucketPriorityQueue(size);
        for (LongObjectPagedHashMap.Cursor cursor : buckets) {
            List sameCellBuckets = (List)cursor.value;
            Bucket removed = ordered.insertWithOverflow(((Bucket)sameCellBuckets.get(0)).reduce(sameCellBuckets, reduceContext));
            if (removed != null) {
                reduceContext.consumeBucketsAndMaybeBreak(-InternalGeoHashGrid.countInnerBucket(removed));
                continue;
            }
            reduceContext.consumeBucketsAndMaybeBreak(1);
        }
        buckets.close();
        Bucket[] list = new Bucket[ordered.size()];
        int n = ordered.size() - 1;
        while (var7_12 >= 0) {
            list[var7_12] = (Bucket)ordered.pop();
            --var7_12;
        }
        return new InternalGeoHashGrid(this.getName(), this.requiredSize, Arrays.asList(list), this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    int getRequiredSize() {
        return this.requiredSize;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.requiredSize, this.buckets);
    }

    @Override
    protected boolean doEquals(Object obj) {
        InternalGeoHashGrid other = (InternalGeoHashGrid)obj;
        return Objects.equals(this.requiredSize, other.requiredSize) && Objects.equals(this.buckets, other.buckets);
    }

    static class BucketPriorityQueue
    extends PriorityQueue<Bucket> {
        BucketPriorityQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(Bucket o1, Bucket o2) {
            int cmp = Long.compare(o2.getDocCount(), o1.getDocCount());
            if (cmp == 0 && (cmp = o2.compareTo(o1)) == 0) {
                cmp = System.identityHashCode(o2) - System.identityHashCode(o1);
            }
            return cmp > 0;
        }
    }

    static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements GeoHashGrid.Bucket,
    Comparable<Bucket> {
        protected long geohashAsLong;
        protected long docCount;
        protected InternalAggregations aggregations;

        Bucket(long geohashAsLong, long docCount, InternalAggregations aggregations) {
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.geohashAsLong = geohashAsLong;
        }

        private Bucket(StreamInput in) throws IOException {
            this.geohashAsLong = in.readLong();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.geohashAsLong);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKeyAsString() {
            return GeoHashUtils.stringEncode(this.geohashAsLong);
        }

        @Override
        public GeoPoint getKey() {
            return GeoPoint.fromGeohash(this.geohashAsLong);
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public int compareTo(Bucket other) {
            if (this.geohashAsLong > other.geohashAsLong) {
                return 1;
            }
            if (this.geohashAsLong < other.geohashAsLong) {
                return -1;
            }
            return 0;
        }

        public Bucket reduce(List<? extends Bucket> buckets, InternalAggregation.ReduceContext context) {
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            long docCount = 0L;
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                aggregationsList.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return new Bucket(this.geohashAsLong, docCount, aggs);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket = (Bucket)o;
            return this.geohashAsLong == bucket.geohashAsLong && this.docCount == bucket.docCount && Objects.equals(this.aggregations, bucket.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.geohashAsLong, this.docCount, this.aggregations);
        }
    }
}

