/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.PlainTransportFuture;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportStats;

public class TransportService
extends AbstractLifecycleComponent
implements TransportConnectionListener {
    public static final String DIRECT_RESPONSE_PROFILE = ".direct";
    public static final String HANDSHAKE_ACTION_NAME = "internal:transport/handshake";
    private final CountDownLatch blockIncomingRequestsLatch = new CountDownLatch(1);
    protected final Transport transport;
    protected final ThreadPool threadPool;
    protected final ClusterName clusterName;
    protected final TaskManager taskManager;
    private final TransportInterceptor.AsyncSender asyncSender;
    private final Function<BoundTransportAddress, DiscoveryNode> localNodeFactory;
    private final boolean connectToRemoteCluster;
    private final Transport.ResponseHandlers responseHandlers;
    private final TransportInterceptor interceptor;
    final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }
    });
    public static final TransportInterceptor NOOP_TRANSPORT_INTERCEPTOR = new TransportInterceptor(){};
    public static final Setting<List<String>> TRACE_LOG_INCLUDE_SETTING = Setting.listSetting("transport.tracer.include", Collections.emptyList(), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<List<String>> TRACE_LOG_EXCLUDE_SETTING = Setting.listSetting("transport.tracer.exclude", Arrays.asList("internal:discovery/zen/fd*", "cluster:monitor/nodes/liveness"), Function.identity(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final Logger tracerLog;
    volatile String[] tracerLogInclude;
    volatile String[] tracerLogExclude;
    private final RemoteClusterService remoteClusterService;
    private final boolean validateConnections;
    volatile DiscoveryNode localNode = null;
    private final Transport.Connection localNodeConnection = new Transport.Connection(){

        @Override
        public DiscoveryNode getNode() {
            return TransportService.this.localNode;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
            TransportService.this.sendLocalRequest(requestId, action, request, options);
        }

        @Override
        public void close() {
        }
    };
    public static final Set<String> VALID_ACTION_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("indices:admin", "indices:monitor", "indices:data/write", "indices:data/read", "indices:internal", "cluster:admin", "cluster:monitor", "cluster:internal", "internal:")));

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor transportInterceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        super(settings);
        this.validateConnections = !"transport".equals(settings.get(Client.CLIENT_TYPE_SETTING_S.getKey())) || TransportClient.CLIENT_TRANSPORT_SNIFF.get(settings) != false;
        this.transport = transport;
        this.threadPool = threadPool;
        this.localNodeFactory = localNodeFactory;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.setTracerLogInclude(TRACE_LOG_INCLUDE_SETTING.get(settings));
        this.setTracerLogExclude(TRACE_LOG_EXCLUDE_SETTING.get(settings));
        this.tracerLog = Loggers.getLogger(this.logger, ".tracer");
        this.taskManager = this.createTaskManager(settings, threadPool, taskHeaders);
        this.interceptor = transportInterceptor;
        this.asyncSender = this.interceptor.interceptSender(this::sendRequestInternal);
        this.connectToRemoteCluster = RemoteClusterService.ENABLE_REMOTE_CLUSTERS.get(settings);
        this.remoteClusterService = new RemoteClusterService(settings, this);
        this.responseHandlers = transport.getResponseHandlers();
        if (clusterSettings != null) {
            clusterSettings.addSettingsUpdateConsumer(TRACE_LOG_INCLUDE_SETTING, this::setTracerLogInclude);
            clusterSettings.addSettingsUpdateConsumer(TRACE_LOG_EXCLUDE_SETTING, this::setTracerLogExclude);
            if (this.connectToRemoteCluster) {
                this.remoteClusterService.listenForUpdates(clusterSettings);
            }
        }
        this.registerRequestHandler(HANDSHAKE_ACTION_NAME, () -> HandshakeRequest.INSTANCE, "same", false, false, (Request request, TransportChannel channel) -> channel.sendResponse(new HandshakeResponse(this.localNode, this.clusterName, this.localNode.getVersion())));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.remoteClusterService;
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    protected TaskManager createTaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders) {
        return new TaskManager(settings, threadPool, taskHeaders);
    }

    private ExecutorService getExecutorService() {
        return this.threadPool.generic();
    }

    void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(Strings.EMPTY_ARRAY);
    }

    void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(Strings.EMPTY_ARRAY);
    }

    @Override
    protected void doStart() {
        this.transport.addConnectionListener(this);
        this.transport.start();
        if (this.transport.boundAddress() != null && this.logger.isInfoEnabled()) {
            this.logger.info("{}", (Object)this.transport.boundAddress());
            for (Map.Entry<String, BoundTransportAddress> entry : this.transport.profileBoundAddresses().entrySet()) {
                this.logger.info("profile [{}]: {}", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.localNode = this.localNodeFactory.apply(this.transport.boundAddress());
        if (this.connectToRemoteCluster) {
            this.remoteClusterService.initializeRemoteClusters();
        }
    }

    @Override
    protected void doStop() {
        try {
            this.transport.stop();
        }
        catch (Throwable throwable) {
            for (Transport.ResponseContext holderToNotify : this.responseHandlers.prune(h -> true)) {
                this.getExecutorService().execute(new AbstractRunnable(holderToNotify){
                    final /* synthetic */ Transport.ResponseContext val$holderToNotify;
                    {
                        this.val$holderToNotify = responseContext;
                    }

                    @Override
                    public void onRejection(Exception e) {
                        TransportService.this.logger.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        TransportService.this.logger.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                    }

                    @Override
                    public void doRun() {
                        TransportException ex = new TransportException("transport stopped, action: " + this.val$holderToNotify.action());
                        this.val$holderToNotify.handler().handleException(ex);
                    }
                });
            }
            throw throwable;
        }
        for (Transport.ResponseContext holderToNotify : this.responseHandlers.prune(h -> true)) {
            this.getExecutorService().execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    protected void doClose() throws IOException {
        IOUtils.close(this.remoteClusterService, this.transport);
    }

    public final void acceptIncomingRequests() {
        this.blockIncomingRequestsLatch.countDown();
    }

    public TransportInfo info() {
        BoundTransportAddress boundTransportAddress = this.boundAddress();
        if (boundTransportAddress == null) {
            return null;
        }
        return new TransportInfo(boundTransportAddress, this.transport.profileBoundAddresses());
    }

    public TransportStats stats() {
        return this.transport.getStats();
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public List<String> getLocalAddresses() {
        return this.transport.getLocalAddresses();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.isLocalNode(node) || this.transport.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node, null);
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile) {
        if (this.isLocalNode(node)) {
            return;
        }
        this.transport.connectToNode(node, connectionProfile, (newConnection, actualProfile) -> {
            DiscoveryNode remote = this.handshake((Transport.Connection)newConnection, actualProfile.getHandshakeTimeout().millis(), cn -> true).discoveryNode;
            if (this.validateConnections && !node.equals(remote)) {
                throw new ConnectTransportException(node, "handshake failed. unexpected remote node " + remote);
            }
        });
    }

    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile profile) throws IOException {
        if (this.isLocalNode(node)) {
            return this.localNodeConnection;
        }
        return this.transport.openConnection(node, profile);
    }

    public DiscoveryNode handshake(Transport.Connection connection, long handshakeTimeout) throws ConnectTransportException {
        return this.handshake(connection, handshakeTimeout, this.clusterName::equals).discoveryNode;
    }

    public HandshakeResponse handshake(Transport.Connection connection, long handshakeTimeout, Predicate<ClusterName> clusterNamePredicate) throws ConnectTransportException {
        HandshakeResponse response;
        DiscoveryNode node = connection.getNode();
        try {
            PlainTransportFuture<HandshakeResponse> futureHandler = new PlainTransportFuture<HandshakeResponse>(new FutureTransportResponseHandler<HandshakeResponse>(){

                @Override
                public HandshakeResponse newInstance() {
                    return new HandshakeResponse();
                }
            });
            this.sendRequest(connection, HANDSHAKE_ACTION_NAME, (TransportRequest)HandshakeRequest.INSTANCE, TransportRequestOptions.builder().withTimeout(handshakeTimeout).build(), futureHandler);
            response = (HandshakeResponse)futureHandler.txGet();
        }
        catch (Exception e) {
            throw new IllegalStateException("handshake failed with " + node, e);
        }
        if (!clusterNamePredicate.test(response.clusterName)) {
            throw new IllegalStateException("handshake failed, mismatched cluster name [" + response.clusterName + "] - " + node);
        }
        if (!response.version.isCompatible(this.localNode.getVersion())) {
            throw new IllegalStateException("handshake failed, incompatible version [" + response.version + "] - " + node);
        }
        return response;
    }

    public void disconnectFromNode(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return;
        }
        this.transport.disconnectFromNode(node);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.transport.addConnectionListener(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.transport.removeConnectionListener(listener);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) throws TransportException {
        return this.submitRequest(node, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> TransportFuture<T> submitRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) throws TransportException {
        PlainTransportFuture<T> futureHandler = new PlainTransportFuture<T>(handler);
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendRequest(connection, action, request, options, futureHandler);
        }
        catch (NodeNotConnectedException ex) {
            futureHandler.handleException(ex);
        }
        return futureHandler;
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendRequest(connection, action, request, TransportRequestOptions.EMPTY, handler);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
        }
    }

    public final <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendRequest(connection, action, request, options, handler);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
        }
    }

    public final <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        this.asyncSender.sendRequest(connection, action, request, options, handler);
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return this.localNodeConnection;
        }
        return this.transport.getConnection(node);
    }

    public final <T extends TransportResponse> void sendChildRequest(DiscoveryNode node, String action, TransportRequest request, Task parentTask, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        try {
            Transport.Connection connection = this.getConnection(node);
            this.sendChildRequest(connection, action, request, parentTask, options, handler);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
        }
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportResponseHandler<T> handler) {
        this.sendChildRequest(connection, action, request, parentTask, TransportRequestOptions.EMPTY, handler);
    }

    public <T extends TransportResponse> void sendChildRequest(Transport.Connection connection, String action, TransportRequest request, Task parentTask, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        request.setParentTask(this.localNode.getId(), parentTask.getId());
        try {
            this.sendRequest(connection, action, request, options, handler);
        }
        catch (TaskCancelledException ex) {
            handler.handleException(new TransportException(ex));
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
        }
    }

    private <T extends TransportResponse> void sendRequestInternal(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        TimeoutHandler timeoutHandler;
        if (connection == null) {
            throw new IllegalStateException("can't send request to a null connection");
        }
        DiscoveryNode node = connection.getNode();
        Supplier<ThreadContext.StoredContext> storedContextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
        ContextRestoreResponseHandler<T> responseHandler = new ContextRestoreResponseHandler<T>(storedContextSupplier, handler);
        long requestId = this.responseHandlers.add(new Transport.ResponseContext<T>(responseHandler, connection, action));
        if (options.timeout() != null) {
            timeoutHandler = new TimeoutHandler(requestId, connection.getNode(), action);
            responseHandler.setTimeoutHandler(timeoutHandler);
        } else {
            timeoutHandler = null;
        }
        try {
            if (this.lifecycle.stoppedOrClosed()) {
                throw new TransportException("TransportService is closed stopped can't send request");
            }
            if (timeoutHandler != null) {
                assert (options.timeout() != null);
                timeoutHandler.future = this.threadPool.schedule(options.timeout(), "generic", timeoutHandler);
            }
            connection.sendRequest(requestId, action, request, options);
        }
        catch (Exception e) {
            final Transport.ResponseContext contextToNotify = this.responseHandlers.remove(requestId);
            if (contextToNotify != null) {
                if (timeoutHandler != null) {
                    timeoutHandler.cancel();
                }
                final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, e);
                this.threadPool.executor("generic").execute(new AbstractRunnable(){

                    @Override
                    public void onRejection(Exception e) {
                        TransportService.this.logger.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)contextToNotify.action()), (Throwable)e);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        TransportService.this.logger.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)contextToNotify.action()), (Throwable)e);
                    }

                    @Override
                    protected void doRun() throws Exception {
                        contextToNotify.handler().handleException(sendRequestException);
                    }
                });
            }
            this.logger.debug("Exception while sending request, handler likely already notified due to timeout", (Throwable)e);
        }
    }

    private void sendLocalRequest(long requestId, final String action, final TransportRequest request, TransportRequestOptions options) {
        final DirectResponseChannel channel = new DirectResponseChannel(this.logger, this.localNode, action, requestId, this, this.threadPool);
        try {
            this.onRequestSent(this.localNode, requestId, action, request, options);
            this.onRequestReceived(requestId, action);
            final RequestHandlerRegistry reg = this.getRequestHandler(action);
            if (reg == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            String executor = reg.getExecutor();
            if ("same".equals(executor)) {
                reg.processMessageReceived(request, channel);
            } else {
                this.threadPool.executor(executor).execute(new AbstractRunnable(){

                    @Override
                    protected void doRun() throws Exception {
                        reg.processMessageReceived(request, channel);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return reg.isForceExecution();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try {
                            channel.sendResponse(e);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            TransportService.this.logger.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
            }
        }
    }

    private boolean shouldTraceAction(String action) {
        if (this.tracerLogInclude.length > 0 && !Regex.simpleMatch(this.tracerLogInclude, action)) {
            return false;
        }
        if (this.tracerLogExclude.length > 0) {
            return !Regex.simpleMatch(this.tracerLogExclude, action);
        }
        return true;
    }

    public TransportAddress[] addressesFromString(String address, int perAddressLimit) throws UnknownHostException {
        return this.transport.addressesFromString(address, perAddressLimit);
    }

    private void validateActionName(String actionName) {
        if (!TransportService.isValidActionName(actionName)) {
            this.logger.warn("invalid action name [" + actionName + "] must start with one of: " + VALID_ACTION_PREFIXES);
        }
    }

    public static boolean isValidActionName(String actionName) {
        for (String prefix : VALID_ACTION_PREFIXES) {
            if (!actionName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Supplier<Request> requestFactory, String executor, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, false, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, Streamable.newWriteableReader(requestFactory), this.taskManager, handler, executor, false, true);
        this.transport.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, String executor, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, false, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, this.taskManager, handler, executor, false, true);
        this.transport.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, Supplier<Request> request, String executor, boolean forceExecution, boolean canTripCircuitBreaker, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, forceExecution, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, Streamable.newWriteableReader(request), this.taskManager, handler, executor, forceExecution, canTripCircuitBreaker);
        this.transport.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, String executor, boolean forceExecution, boolean canTripCircuitBreaker, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        handler = this.interceptor.interceptHandler(action, executor, forceExecution, handler);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, this.taskManager, handler, executor, forceExecution, canTripCircuitBreaker);
        this.transport.registerRequestHandler(reg);
    }

    @Override
    public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
        if (this.traceEnabled() && this.shouldTraceAction(action)) {
            this.traceRequestSent(node, requestId, action, options);
        }
    }

    protected boolean traceEnabled() {
        return this.tracerLog.isTraceEnabled();
    }

    @Override
    public void onResponseSent(long requestId, String action, TransportResponse response, TransportResponseOptions options) {
        if (this.traceEnabled() && this.shouldTraceAction(action)) {
            this.traceResponseSent(requestId, action);
        }
    }

    @Override
    public void onResponseSent(long requestId, String action, Exception e) {
        if (this.traceEnabled() && this.shouldTraceAction(action)) {
            this.traceResponseSent(requestId, action, e);
        }
    }

    protected void traceResponseSent(long requestId, String action, Exception e) {
        this.tracerLog.trace(() -> new ParameterizedMessage("[{}][{}] sent error response", (Object)requestId, (Object)action), (Throwable)e);
    }

    @Override
    public void onRequestReceived(long requestId, String action) {
        try {
            this.blockIncomingRequestsLatch.await();
        }
        catch (InterruptedException e) {
            this.logger.trace("interrupted while waiting for incoming requests block to be removed");
        }
        if (this.traceEnabled() && this.shouldTraceAction(action)) {
            this.traceReceivedRequest(requestId, action);
        }
    }

    public RequestHandlerRegistry getRequestHandler(String action) {
        return this.transport.getRequestHandler(action);
    }

    @Override
    public void onResponseReceived(long requestId, Transport.ResponseContext holder) {
        if (holder == null) {
            this.checkForTimeout(requestId);
        } else if (this.traceEnabled() && this.shouldTraceAction(holder.action())) {
            this.traceReceivedResponse(requestId, holder.connection().getNode(), holder.action());
        }
    }

    private void checkForTimeout(long requestId) {
        DiscoveryNode sourceNode;
        String action;
        assert (!this.responseHandlers.contains(requestId));
        TimeoutInfoHolder timeoutInfoHolder = this.timeoutInfoHandlers.remove(requestId);
        if (timeoutInfoHolder != null) {
            long time = System.currentTimeMillis();
            this.logger.warn("Received response for a request that has timed out, sent [{}ms] ago, timed out [{}ms] ago, action [{}], node [{}], id [{}]", (Object)(time - timeoutInfoHolder.sentTime()), (Object)(time - timeoutInfoHolder.timeoutTime()), (Object)timeoutInfoHolder.action(), (Object)timeoutInfoHolder.node(), (Object)requestId);
            action = timeoutInfoHolder.action();
            sourceNode = timeoutInfoHolder.node();
        } else {
            this.logger.warn("Transport response handler not found of id [{}]", (Object)requestId);
            action = null;
            sourceNode = null;
        }
        if (!this.traceEnabled()) {
            return;
        }
        if (action == null) {
            assert (sourceNode == null);
            this.traceUnresolvedResponse(requestId);
        } else if (this.shouldTraceAction(action)) {
            this.traceReceivedResponse(requestId, sourceNode, action);
        }
    }

    @Override
    public void onConnectionClosed(Transport.Connection connection) {
        try {
            List<Transport.ResponseContext> pruned = this.responseHandlers.prune(h -> h.connection().getCacheKey().equals(connection.getCacheKey()));
            this.getExecutorService().execute(() -> {
                for (Transport.ResponseContext holderToNotify : pruned) {
                    holderToNotify.handler().handleException(new NodeDisconnectedException(connection.getNode(), holderToNotify.action()));
                }
            });
        }
        catch (EsRejectedExecutionException ex) {
            this.logger.debug("Rejected execution on onConnectionClosed", (Throwable)ex);
        }
    }

    protected void traceReceivedRequest(long requestId, String action) {
        this.tracerLog.trace("[{}][{}] received request", (Object)requestId, (Object)action);
    }

    protected void traceResponseSent(long requestId, String action) {
        this.tracerLog.trace("[{}][{}] sent response", (Object)requestId, (Object)action);
    }

    protected void traceReceivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
        this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, (Object)action, (Object)sourceNode);
    }

    protected void traceUnresolvedResponse(long requestId) {
        this.tracerLog.trace("[{}] received response but can't resolve it to a request", (Object)requestId);
    }

    protected void traceRequestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
        this.tracerLog.trace("[{}][{}] sent to [{}] (timeout: [{}])", (Object)requestId, (Object)action, (Object)node, (Object)options.timeout());
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    private boolean isLocalNode(DiscoveryNode discoveryNode) {
        return Objects.requireNonNull(discoveryNode, "discovery node must not be null").equals(this.localNode);
    }

    static class DirectResponseChannel
    implements TransportChannel {
        final Logger logger;
        final DiscoveryNode localNode;
        private final String action;
        private final long requestId;
        final TransportService service;
        final ThreadPool threadPool;

        DirectResponseChannel(Logger logger, DiscoveryNode localNode, String action, long requestId, TransportService service, ThreadPool threadPool) {
            this.logger = logger;
            this.localNode = localNode;
            this.action = action;
            this.requestId = requestId;
            this.service = service;
            this.threadPool = threadPool;
        }

        @Override
        public String getProfileName() {
            return TransportService.DIRECT_RESPONSE_PROFILE;
        }

        @Override
        public void sendResponse(TransportResponse response) throws IOException {
            this.sendResponse(response, TransportResponseOptions.EMPTY);
        }

        @Override
        public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
            this.service.onResponseSent(this.requestId, this.action, response, options);
            TransportResponseHandler handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
            if (handler != null) {
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processResponse(handler, response);
                } else {
                    this.threadPool.executor(executor).execute(() -> this.processResponse(handler, response));
                }
            }
        }

        protected void processResponse(TransportResponseHandler handler, TransportResponse response) {
            try {
                handler.handleResponse(response);
            }
            catch (Exception e) {
                this.processException(handler, this.wrapInRemote(new ResponseHandlerFailureTransportException(e)));
            }
        }

        @Override
        public void sendResponse(Exception exception) throws IOException {
            this.service.onResponseSent(this.requestId, this.action, exception);
            TransportResponseHandler handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
            if (handler != null) {
                RemoteTransportException rtx = this.wrapInRemote(exception);
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processException(handler, rtx);
                } else {
                    this.threadPool.executor(handler.executor()).execute(() -> this.processException(handler, rtx));
                }
            }
        }

        protected RemoteTransportException wrapInRemote(Exception e) {
            if (e instanceof RemoteTransportException) {
                return (RemoteTransportException)e;
            }
            return new RemoteTransportException(this.localNode.getName(), this.localNode.getAddress(), this.action, e);
        }

        protected void processException(TransportResponseHandler handler, RemoteTransportException rtx) {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to handle exception for action [{}], handler [{}]", (Object)this.action, (Object)handler), (Throwable)e);
            }
        }

        @Override
        public String getChannelType() {
            return "direct";
        }

        @Override
        public Version getVersion() {
            return this.localNode.getVersion();
        }
    }

    public static final class ContextRestoreResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final TransportResponseHandler<T> delegate;
        private final Supplier<ThreadContext.StoredContext> contextSupplier;
        private volatile TimeoutHandler handler;

        public ContextRestoreResponseHandler(Supplier<ThreadContext.StoredContext> contextSupplier, TransportResponseHandler<T> delegate) {
            this.delegate = delegate;
            this.contextSupplier = contextSupplier;
        }

        @Override
        public T read(StreamInput in) throws IOException {
            return (T)this.delegate.read(in);
        }

        @Override
        public void handleResponse(T response) {
            if (this.handler != null) {
                this.handler.cancel();
            }
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleResponse(response);
            }
        }

        @Override
        public void handleException(TransportException exp) {
            if (this.handler != null) {
                this.handler.cancel();
            }
            try (ThreadContext.StoredContext ignore = this.contextSupplier.get();){
                this.delegate.handleException(exp);
            }
        }

        @Override
        public String executor() {
            return this.delegate.executor();
        }

        public String toString() {
            return this.getClass().getName() + "/" + this.delegate.toString();
        }

        void setTimeoutHandler(TimeoutHandler handler) {
            this.handler = handler;
        }
    }

    static class TimeoutInfoHolder {
        private final DiscoveryNode node;
        private final String action;
        private final long sentTime;
        private final long timeoutTime;

        TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
            this.node = node;
            this.action = action;
            this.sentTime = sentTime;
            this.timeoutTime = timeoutTime;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String action() {
            return this.action;
        }

        public long sentTime() {
            return this.sentTime;
        }

        public long timeoutTime() {
            return this.timeoutTime;
        }
    }

    final class TimeoutHandler
    implements Runnable {
        private final long requestId;
        private final long sentTime = System.currentTimeMillis();
        private final String action;
        private final DiscoveryNode node;
        volatile ScheduledFuture future;

        TimeoutHandler(long requestId, DiscoveryNode node, String action) {
            this.requestId = requestId;
            this.node = node;
            this.action = action;
        }

        @Override
        public void run() {
            if (TransportService.this.responseHandlers.contains(this.requestId)) {
                long timeoutTime = System.currentTimeMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(this.node, this.action, this.sentTime, timeoutTime));
                Transport.ResponseContext holder = TransportService.this.responseHandlers.remove(this.requestId);
                if (holder != null) {
                    assert (holder.action().equals(this.action));
                    assert (holder.connection().getNode().equals(this.node));
                    holder.handler().handleException(new ReceiveTimeoutTransportException(holder.connection().getNode(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
                } else {
                    TransportService.this.timeoutInfoHandlers.remove(this.requestId);
                }
            }
        }

        public void cancel() {
            assert (!TransportService.this.responseHandlers.contains(this.requestId)) : "cancel must be called after the requestId [" + this.requestId + "] has been removed from clientHandlers";
            FutureUtils.cancel(this.future);
        }
    }

    public static class HandshakeResponse
    extends TransportResponse {
        private DiscoveryNode discoveryNode;
        private ClusterName clusterName;
        private Version version;

        HandshakeResponse() {
        }

        public HandshakeResponse(DiscoveryNode discoveryNode, ClusterName clusterName, Version version) {
            this.discoveryNode = discoveryNode;
            this.version = version;
            this.clusterName = clusterName;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.discoveryNode = in.readOptionalWriteable(DiscoveryNode::new);
            this.clusterName = new ClusterName(in);
            this.version = Version.readVersion(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalWriteable(this.discoveryNode);
            this.clusterName.writeTo(out);
            Version.writeVersion(this.version, out);
        }

        public DiscoveryNode getDiscoveryNode() {
            return this.discoveryNode;
        }

        public ClusterName getClusterName() {
            return this.clusterName;
        }
    }

    static class HandshakeRequest
    extends TransportRequest {
        public static final HandshakeRequest INSTANCE = new HandshakeRequest();

        private HandshakeRequest() {
        }
    }
}

