/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlParserType;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class AnalysisLimits
implements ToXContentObject,
Writeable {
    public static final long DEFAULT_MODEL_MEMORY_LIMIT_MB = 1024L;
    static final long PRE_6_1_DEFAULT_MODEL_MEMORY_LIMIT_MB = 4096L;
    public static final long DEFAULT_CATEGORIZATION_EXAMPLES_LIMIT = 4L;
    public static final ParseField MODEL_MEMORY_LIMIT = new ParseField("model_memory_limit", new String[0]);
    public static final ParseField CATEGORIZATION_EXAMPLES_LIMIT = new ParseField("categorization_examples_limit", new String[0]);
    public static final ConstructingObjectParser<AnalysisLimits, Void> METADATA_PARSER = new ConstructingObjectParser("analysis_limits", true, a -> new AnalysisLimits(a[0] == null ? 4096L : (Long)a[0], a[1] == null ? 4L : (Long)a[1]));
    public static final ConstructingObjectParser<AnalysisLimits, Void> CONFIG_PARSER = new ConstructingObjectParser("analysis_limits", false, a -> new AnalysisLimits((Long)a[0], (Long)a[1]));
    public static final Map<MlParserType, ConstructingObjectParser<AnalysisLimits, Void>> PARSERS = new EnumMap<MlParserType, ConstructingObjectParser<AnalysisLimits, Void>>(MlParserType.class);
    private final Long modelMemoryLimit;
    private final Long categorizationExamplesLimit;

    public AnalysisLimits(Long categorizationExamplesLimit) {
        this(1024L, categorizationExamplesLimit);
    }

    public AnalysisLimits(Long modelMemoryLimit, Long categorizationExamplesLimit) {
        if (modelMemoryLimit != null && modelMemoryLimit < 1L) {
            String msg = Messages.getMessage("model_memory_limit must be at least 1 MiB. Value = {0,number}", modelMemoryLimit);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
        if (categorizationExamplesLimit != null && categorizationExamplesLimit < 0L) {
            String msg = Messages.getMessage("{0} cannot be less than {1,number}. Value = {2,number}", CATEGORIZATION_EXAMPLES_LIMIT, 0, categorizationExamplesLimit);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
        this.modelMemoryLimit = modelMemoryLimit;
        this.categorizationExamplesLimit = categorizationExamplesLimit;
    }

    public AnalysisLimits(StreamInput in) throws IOException {
        this(in.readOptionalLong(), in.readOptionalLong());
    }

    public static AnalysisLimits validateAndSetDefaults(@Nullable AnalysisLimits source, @Nullable ByteSizeValue maxModelMemoryLimit, long defaultModelMemoryLimit) {
        boolean maxModelMemoryIsSet = maxModelMemoryLimit != null && maxModelMemoryLimit.getMb() > 0L;
        long modelMemoryLimit = defaultModelMemoryLimit;
        if (maxModelMemoryIsSet) {
            modelMemoryLimit = Math.min(maxModelMemoryLimit.getMb(), modelMemoryLimit);
        }
        long categorizationExamplesLimit = 4L;
        if (source != null) {
            if (source.getModelMemoryLimit() != null) {
                modelMemoryLimit = source.getModelMemoryLimit();
            }
            if (source.getCategorizationExamplesLimit() != null) {
                categorizationExamplesLimit = source.getCategorizationExamplesLimit();
            }
        }
        if (maxModelMemoryIsSet && modelMemoryLimit > maxModelMemoryLimit.getMb()) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage(Messages.JOB_CONFIG_MODEL_MEMORY_LIMIT_GREATER_THAN_MAX, new ByteSizeValue(modelMemoryLimit, ByteSizeUnit.MB), maxModelMemoryLimit), new Object[0]);
        }
        return new AnalysisLimits(modelMemoryLimit, categorizationExamplesLimit);
    }

    @Nullable
    public Long getModelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public Long getCategorizationExamplesLimit() {
        return this.categorizationExamplesLimit;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalLong(this.modelMemoryLimit);
        out.writeOptionalLong(this.categorizationExamplesLimit);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelMemoryLimit != null) {
            builder.field(MODEL_MEMORY_LIMIT.getPreferredName(), this.modelMemoryLimit + "mb");
        }
        if (this.categorizationExamplesLimit != null) {
            builder.field(CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName(), this.categorizationExamplesLimit);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalysisLimits)) {
            return false;
        }
        AnalysisLimits that = (AnalysisLimits)other;
        return Objects.equals(this.modelMemoryLimit, that.modelMemoryLimit) && Objects.equals(this.categorizationExamplesLimit, that.categorizationExamplesLimit);
    }

    public int hashCode() {
        return Objects.hash(this.modelMemoryLimit, this.categorizationExamplesLimit);
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ConstructingObjectParser<AnalysisLimits, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MODEL_MEMORY_LIMIT.getPreferredName()).getMb();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.longValue();
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, MODEL_MEMORY_LIMIT, ObjectParser.ValueType.VALUE);
            parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), CATEGORIZATION_EXAMPLES_LIMIT);
        }
    }
}

