/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import java.util.List;
import javax.security.sasl.SaslClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SASLHelper {
    private final Control[] controls;
    private final int messageID;
    private final LDAPConnection connection;
    private final List<String> unhandledCallbackMessages;
    private final long responseTimeoutMillis;
    private final SASLBindRequest bindRequest;
    private final SaslClient saslClient;
    private final String mechanism;

    SASLHelper(SASLBindRequest bindRequest, LDAPConnection connection, String mechanism, SaslClient saslClient, Control[] controls, long responseTimeoutMillis, List<String> unhandledCallbackMessages) {
        this.bindRequest = bindRequest;
        this.connection = connection;
        this.mechanism = mechanism;
        this.saslClient = saslClient;
        this.controls = controls;
        this.responseTimeoutMillis = responseTimeoutMillis;
        this.unhandledCallbackMessages = unhandledCallbackMessages;
        this.messageID = -1;
    }

    BindResult processSASLBind() throws LDAPException {
        boolean hasNegotiatedSecurity2;
        BindResult bindResult;
        byte[] serverCredBytes;
        ASN1OctetString serverCreds;
        BindResult bindResult2;
        ASN1OctetString saslCredentials;
        byte[] credBytes;
        block29: {
            String qopString;
            Object qopObject;
            credBytes = null;
            try {
                if (this.saslClient.hasInitialResponse()) {
                    credBytes = this.saslClient.evaluateChallenge(new byte[0]);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (this.unhandledCallbackMessages.isEmpty()) {
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_INITIAL_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
                }
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_INITIAL_REQUEST_UNHANDLED_CALLBACKS.get(this.mechanism, StaticUtils.getExceptionMessage(e), StaticUtils.concatenateStrings(this.unhandledCallbackMessages)), e);
            }
            saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
            bindResult2 = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
            if (bindResult2.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) break block29;
            BindResult bindResult3 = bindResult2;
            Object var9_7 = null;
            boolean hasNegotiatedSecurity2 = false;
            if (this.saslClient.isComplete() && (qopObject = this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) != null && ((qopString = StaticUtils.toLowerCase(String.valueOf(qopObject))).contains(SASLQualityOfProtection.AUTH_INT.toString()) || qopString.contains(SASLQualityOfProtection.AUTH_CONF.toString()))) {
                hasNegotiatedSecurity2 = true;
            }
            if (hasNegotiatedSecurity2) {
                this.connection.applySASLQoP(this.saslClient);
            } else {
                try {
                    this.saslClient.dispose();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            return bindResult3;
        }
        try {
            serverCreds = bindResult2.getServerSASLCredentials();
            serverCredBytes = serverCreds == null ? null : serverCreds.getValue();
            while (true) {
                try {
                    credBytes = this.saslClient.evaluateChallenge(serverCredBytes);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (this.unhandledCallbackMessages.isEmpty()) {
                        throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_SUBSEQUENT_REQUEST.get(this.mechanism, StaticUtils.getExceptionMessage(e)), e);
                    }
                    throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_SASL_CANNOT_CREATE_SUBSEQUENT_REQUEST_UNHANDLED_CALLBACKS.get(this.mechanism, StaticUtils.getExceptionMessage(e), StaticUtils.concatenateStrings(this.unhandledCallbackMessages)), e);
                }
                saslCredentials = credBytes == null || credBytes.length == 0 ? null : new ASN1OctetString(credBytes);
                bindResult2 = this.bindRequest.sendBindRequest(this.connection, "", saslCredentials, this.controls, this.responseTimeoutMillis);
                if (bindResult2.getResultCode().equals(ResultCode.SASL_BIND_IN_PROGRESS)) break block31;
                ASN1OctetString serverCredentials = bindResult2.getServerSASLCredentials();
                if (serverCredentials != null) {
                    try {
                        this.saslClient.evaluateChallenge(serverCredentials.getValue());
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                bindResult = bindResult2;
                Object var9_8 = null;
                hasNegotiatedSecurity2 = false;
                break;
            }
        }
        catch (Throwable throwable) {
            String qopString;
            Object qopObject;
            Object var9_9 = null;
            boolean hasNegotiatedSecurity2 = false;
            if (this.saslClient.isComplete() && (qopObject = this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) != null && ((qopString = StaticUtils.toLowerCase(String.valueOf(qopObject))).contains(SASLQualityOfProtection.AUTH_INT.toString()) || qopString.contains(SASLQualityOfProtection.AUTH_CONF.toString()))) {
                hasNegotiatedSecurity2 = true;
            }
            if (hasNegotiatedSecurity2) {
                this.connection.applySASLQoP(this.saslClient);
            } else {
                try {
                    this.saslClient.dispose();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            throw throwable;
        }
        {
            block31: {
                String qopString;
                Object qopObject;
                if (this.saslClient.isComplete() && (qopObject = this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) != null && ((qopString = StaticUtils.toLowerCase(String.valueOf(qopObject))).contains(SASLQualityOfProtection.AUTH_INT.toString()) || qopString.contains(SASLQualityOfProtection.AUTH_CONF.toString()))) {
                    hasNegotiatedSecurity2 = true;
                }
                if (hasNegotiatedSecurity2) {
                    this.connection.applySASLQoP(this.saslClient);
                } else {
                    try {
                        this.saslClient.dispose();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                return bindResult;
            }
            serverCreds = bindResult2.getServerSASLCredentials();
            if (serverCreds == null) {
                serverCredBytes = null;
                continue;
            }
            serverCredBytes = serverCreds.getValue();
            continue;
        }
    }

    int getMessageID() {
        return this.messageID;
    }
}

