/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.SimpleChecksAdapter;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SFunction;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public final class SSource
extends AStatement {
    private final ScriptClassInfo scriptClassInfo;
    private final CompilerSettings settings;
    private final String name;
    private final String source;
    private final Printer debugStream;
    private final MainMethodReserved reserved;
    private final List<SFunction> functions;
    private final Globals globals;
    private final List<AStatement> statements;
    private Locals mainMethod;
    private final List<Method> getMethods;
    private byte[] bytes;

    public SSource(ScriptClassInfo scriptClassInfo, CompilerSettings settings, String name, String source, Printer debugStream, MainMethodReserved reserved, Location location, List<SFunction> functions, Globals globals, List<AStatement> statements) {
        super(location);
        this.scriptClassInfo = Objects.requireNonNull(scriptClassInfo);
        this.settings = Objects.requireNonNull(settings);
        this.name = Objects.requireNonNull(name);
        this.source = Objects.requireNonNull(source);
        this.debugStream = debugStream;
        this.reserved = Objects.requireNonNull(reserved);
        functions.addAll(globals.getSyntheticMethods().values());
        globals.getSyntheticMethods().clear();
        this.functions = Collections.unmodifiableList(functions);
        this.statements = Collections.unmodifiableList(statements);
        this.globals = globals;
        this.getMethods = new ArrayList<Method>();
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw new IllegalStateException("Illegal tree structure.");
    }

    public void analyze(PainlessLookup painlessLookup) {
        HashMap<String, PainlessMethod> methods = new HashMap<String, PainlessMethod>();
        for (SFunction function : this.functions) {
            function.generateSignature(painlessLookup);
            String key = PainlessLookupUtility.buildPainlessMethodKey(function.name, function.parameters.size());
            if (methods.put(key, function.method) == null) continue;
            throw this.createError(new IllegalArgumentException("Duplicate functions with name [" + function.name + "]."));
        }
        this.analyze(Locals.newProgramScope(painlessLookup, methods.values()));
    }

    @Override
    void analyze(Locals program) {
        for (SFunction function : this.functions) {
            Locals functionLocals = Locals.newFunctionScope(program, function.rtnType, function.parameters, function.reserved.getMaxLoopCounter());
            function.analyze(functionLocals);
        }
        if (this.statements == null || this.statements.isEmpty()) {
            throw this.createError(new IllegalArgumentException("Cannot generate an empty script."));
        }
        this.mainMethod = Locals.newMainMethodScope(this.scriptClassInfo, program, this.reserved.getMaxLoopCounter());
        for (int get = 0; get < this.scriptClassInfo.getGetMethods().size(); ++get) {
            Method method = this.scriptClassInfo.getGetMethods().get(get);
            String name = method.getName().substring(3);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            if (!this.reserved.getUsedVariables().contains(name)) continue;
            Class<?> rtn = this.scriptClassInfo.getGetReturns().get(get);
            this.mainMethod.addVariable(new Location("getter [" + name + "]", 0), rtn, name, true);
            this.getMethods.add(method);
        }
        AStatement last = this.statements.get(this.statements.size() - 1);
        for (AStatement statement : this.statements) {
            if (this.allEscape) {
                throw this.createError(new IllegalArgumentException("Unreachable statement."));
            }
            statement.lastSource = statement == last;
            statement.analyze(this.mainMethod);
            this.methodEscape = statement.methodEscape;
            this.allEscape = statement.allEscape;
        }
    }

    public void write() {
        ClassWriter writer;
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = WriterConstants.BASE_INTERFACE_TYPE.getInternalName();
        String className = WriterConstants.CLASS_TYPE.getInternalName();
        String[] classInterfaces = new String[]{interfaceBase};
        Object visitor = writer = new ClassWriter(classFrames);
        if (this.settings.isPicky()) {
            visitor = new SimpleChecksAdapter((ClassVisitor)visitor);
        }
        if (this.debugStream != null) {
            visitor = new TraceClassVisitor((ClassVisitor)visitor, this.debugStream, null);
        }
        visitor.visit(52, classAccess, className, null, Type.getType(this.scriptClassInfo.getBaseClass()).getInternalName(), classInterfaces);
        visitor.visitSource(Location.computeSourceName(this.name), null);
        MethodWriter bootstrapDef = new MethodWriter(136, WriterConstants.DEF_BOOTSTRAP_METHOD, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        bootstrapDef.visitCode();
        bootstrapDef.getStatic(WriterConstants.CLASS_TYPE, "$DEFINITION", WriterConstants.DEFINITION_TYPE);
        bootstrapDef.loadArgs();
        bootstrapDef.invokeStatic(WriterConstants.DEF_BOOTSTRAP_DELEGATE_TYPE, WriterConstants.DEF_BOOTSTRAP_DELEGATE_METHOD);
        bootstrapDef.returnValue();
        bootstrapDef.endMethod();
        visitor.visitField(9, "$NAME", WriterConstants.STRING_TYPE.getDescriptor(), null, null).visitEnd();
        visitor.visitField(9, "$SOURCE", WriterConstants.STRING_TYPE.getDescriptor(), null, null).visitEnd();
        visitor.visitField(9, "$STATEMENTS", WriterConstants.BITSET_TYPE.getDescriptor(), null, null).visitEnd();
        visitor.visitField(9, "$DEFINITION", WriterConstants.DEFINITION_TYPE.getDescriptor(), null, null).visitEnd();
        Method init = this.scriptClassInfo.getBaseClass().getConstructors().length == 0 ? new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString()) : new Method("<init>", MethodType.methodType(Void.TYPE, this.scriptClassInfo.getBaseClass().getConstructors()[0].getParameterTypes()).toMethodDescriptorString());
        MethodWriter constructor = new MethodWriter(1, init, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        constructor.visitCode();
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(Type.getType(this.scriptClassInfo.getBaseClass()), init);
        constructor.returnValue();
        constructor.endMethod();
        MethodWriter nameMethod = new MethodWriter(1, WriterConstants.GET_NAME_METHOD, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        nameMethod.visitCode();
        nameMethod.getStatic(WriterConstants.CLASS_TYPE, "$NAME", WriterConstants.STRING_TYPE);
        nameMethod.returnValue();
        nameMethod.endMethod();
        MethodWriter sourceMethod = new MethodWriter(1, WriterConstants.GET_SOURCE_METHOD, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        sourceMethod.visitCode();
        sourceMethod.getStatic(WriterConstants.CLASS_TYPE, "$SOURCE", WriterConstants.STRING_TYPE);
        sourceMethod.returnValue();
        sourceMethod.endMethod();
        MethodWriter statementsMethod = new MethodWriter(1, WriterConstants.GET_STATEMENTS_METHOD, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        statementsMethod.visitCode();
        statementsMethod.getStatic(WriterConstants.CLASS_TYPE, "$STATEMENTS", WriterConstants.BITSET_TYPE);
        statementsMethod.returnValue();
        statementsMethod.endMethod();
        MethodWriter executeMethod = new MethodWriter(1, this.scriptClassInfo.getExecuteMethod(), (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
        executeMethod.visitCode();
        this.write(executeMethod, this.globals);
        executeMethod.endMethod();
        for (SFunction sFunction : this.functions) {
            sFunction.write((ClassVisitor)visitor, this.settings, this.globals);
        }
        while (!this.globals.getSyntheticMethods().isEmpty()) {
            ArrayList<SFunction> current = new ArrayList<SFunction>(this.globals.getSyntheticMethods().values());
            this.globals.getSyntheticMethods().clear();
            for (SFunction sFunction : current) {
                sFunction.write((ClassVisitor)visitor, this.settings, this.globals);
            }
        }
        if (!this.globals.getConstantInitializers().isEmpty()) {
            Collection<Constant> inits = this.globals.getConstantInitializers().values();
            for (Constant constant : inits) {
                visitor.visitField(26, constant.name, constant.type.getDescriptor(), null, null).visitEnd();
            }
            MethodWriter methodWriter = new MethodWriter(8, WriterConstants.CLINIT, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
            methodWriter.visitCode();
            for (Constant constant : inits) {
                constant.initializer.accept(methodWriter);
                methodWriter.putStatic(WriterConstants.CLASS_TYPE, constant.name, constant.type);
            }
            methodWriter.returnValue();
            methodWriter.endMethod();
        }
        for (Method method : this.scriptClassInfo.getNeedsMethods()) {
            String string3 = method.getName();
            string3 = string3.substring(5);
            string3 = Character.toLowerCase(string3.charAt(0)) + string3.substring(1);
            MethodWriter ifaceMethod = new MethodWriter(1, method, (ClassVisitor)visitor, this.globals.getStatements(), this.settings);
            ifaceMethod.visitCode();
            ifaceMethod.push(this.reserved.getUsedVariables().contains(string3));
            ifaceMethod.returnValue();
            ifaceMethod.endMethod();
        }
        visitor.visitEnd();
        this.bytes = writer.toByteArray();
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        Label startTry = new Label();
        Label endTry = new Label();
        Label startExplainCatch = new Label();
        Label startOtherCatch = new Label();
        Label endCatch = new Label();
        writer.mark(startTry);
        if (this.reserved.getMaxLoopCounter() > 0) {
            Locals.Variable loop = this.mainMethod.getVariable(null, "#loop");
            writer.push(this.reserved.getMaxLoopCounter());
            writer.visitVarInsn(54, loop.getSlot());
        }
        for (Method method : this.getMethods) {
            String name = method.getName().substring(3);
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            Locals.Variable variable = this.mainMethod.getVariable(null, name);
            writer.loadThis();
            writer.invokeVirtual(Type.getType(this.scriptClassInfo.getBaseClass()), method);
            writer.visitVarInsn(method.getReturnType().getOpcode(54), variable.getSlot());
        }
        for (AStatement statement : this.statements) {
            statement.write(writer, globals);
        }
        if (!this.methodEscape) {
            switch (this.scriptClassInfo.getExecuteMethod().getReturnType().getSort()) {
                case 0: {
                    break;
                }
                case 1: {
                    writer.push(false);
                    break;
                }
                case 3: {
                    writer.push(0);
                    break;
                }
                case 4: {
                    writer.push(0);
                    break;
                }
                case 5: {
                    writer.push(0);
                    break;
                }
                case 7: {
                    writer.push(0L);
                    break;
                }
                case 6: {
                    writer.push(0.0f);
                    break;
                }
                case 8: {
                    writer.push(0.0);
                    break;
                }
                default: {
                    writer.visitInsn(1);
                }
            }
            writer.returnValue();
        }
        writer.mark(endTry);
        writer.goTo(endCatch);
        writer.visitTryCatchBlock(startTry, endTry, startExplainCatch, WriterConstants.PAINLESS_EXPLAIN_ERROR_TYPE.getInternalName());
        writer.mark(startExplainCatch);
        writer.loadThis();
        writer.swap();
        writer.dup();
        writer.getStatic(WriterConstants.CLASS_TYPE, "$DEFINITION", WriterConstants.DEFINITION_TYPE);
        writer.invokeVirtual(WriterConstants.PAINLESS_EXPLAIN_ERROR_TYPE, WriterConstants.PAINLESS_EXPLAIN_ERROR_GET_HEADERS_METHOD);
        writer.invokeInterface(WriterConstants.BASE_INTERFACE_TYPE, WriterConstants.CONVERT_TO_SCRIPT_EXCEPTION_METHOD);
        writer.throwException();
        writer.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.PAINLESS_ERROR_TYPE.getInternalName());
        writer.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.BOOTSTRAP_METHOD_ERROR_TYPE.getInternalName());
        writer.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.OUT_OF_MEMORY_ERROR_TYPE.getInternalName());
        writer.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.STACK_OVERFLOW_ERROR_TYPE.getInternalName());
        writer.visitTryCatchBlock(startTry, endTry, startOtherCatch, WriterConstants.EXCEPTION_TYPE.getInternalName());
        writer.mark(startOtherCatch);
        writer.loadThis();
        writer.swap();
        writer.invokeStatic(WriterConstants.COLLECTIONS_TYPE, WriterConstants.EMPTY_MAP_METHOD);
        writer.invokeInterface(WriterConstants.BASE_INTERFACE_TYPE, WriterConstants.CONVERT_TO_SCRIPT_EXCEPTION_METHOD);
        writer.throwException();
        writer.mark(endCatch);
    }

    public BitSet getStatements() {
        return this.globals.getStatements();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        ArrayList<AStatement> subs = new ArrayList<AStatement>(this.functions.size() + this.statements.size());
        subs.addAll(this.functions);
        subs.addAll(this.statements);
        return this.multilineToString(Collections.emptyList(), subs);
    }

    public static final class MainMethodReserved
    implements Reserved {
        private final Set<String> usedVariables = new HashSet<String>();
        private int maxLoopCounter = 0;

        @Override
        public void markUsedVariable(String name) {
            this.usedVariables.add(name);
        }

        @Override
        public Set<String> getUsedVariables() {
            return Collections.unmodifiableSet(this.usedVariables);
        }

        @Override
        public void addUsedVariables(SFunction.FunctionReserved reserved) {
            this.usedVariables.addAll(reserved.getUsedVariables());
        }

        @Override
        public void setMaxLoopCounter(int max) {
            this.maxLoopCounter = max;
        }

        @Override
        public int getMaxLoopCounter() {
            return this.maxLoopCounter;
        }
    }

    public static interface Reserved {
        public void markUsedVariable(String var1);

        public Set<String> getUsedVariables();

        public void addUsedVariables(SFunction.FunctionReserved var1);

        public void setMaxLoopCounter(int var1);

        public int getMaxLoopCounter();
    }
}

