/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.AltitudeRange;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.UnitSetLibrary;

public class RangeStats {
    private boolean _valid = false;
    private int _numPoints = 0;
    private int _startIndex = 0;
    private int _endIndex = 0;
    private int _numSegments = 0;
    private AltitudeRange _totalAltitudeRange = null;
    private AltitudeRange _movingAltitudeRange = null;
    private AltitudeRange _gentleAltitudeRange = null;
    private AltitudeRange _steepAltitudeRange = null;
    private Timestamp _earliestTimestamp = null;
    private Timestamp _latestTimestamp = null;
    private long _movingMilliseconds = 0L;
    private boolean _timesIncomplete = false;
    private boolean _timesOutOfSequence = false;
    private double _totalDistanceRads = 0.0;
    private double _movingDistanceRads = 0.0;
    private static final double STEEP_ANGLE = 0.15;

    public RangeStats(Track track, int n, int n2) {
        if (track != null && n >= 0 && n2 > n && n2 < track.getNumPoints()) {
            this._valid = this.calculateStats(track, n, n2);
        }
    }

    private boolean calculateStats(Track track, int n, int n2) {
        this._startIndex = n;
        this._endIndex = n2;
        this._numPoints = n2 - n + 1;
        this._totalAltitudeRange = new AltitudeRange();
        this._movingAltitudeRange = new AltitudeRange();
        this._gentleAltitudeRange = new AltitudeRange();
        this._steepAltitudeRange = new AltitudeRange();
        DataPoint dataPoint = null;
        Altitude altitude = null;
        this._movingDistanceRads = 0.0;
        this._totalDistanceRads = 0.0;
        double d = 0.0;
        this._movingMilliseconds = 0L;
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint2 = track.getPoint(n3);
            if (dataPoint2 == null) {
                return false;
            }
            if (!dataPoint2.isWaypoint()) {
                if (dataPoint2.getSegmentStart()) {
                    ++this._numSegments;
                }
                if (dataPoint != null) {
                    double d2 = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2);
                    this._totalDistanceRads += d2;
                    if (!dataPoint2.getSegmentStart()) {
                        this._movingDistanceRads += d2;
                    }
                    d += d2;
                }
                if (dataPoint2.hasAltitude()) {
                    Altitude altitude2 = dataPoint2.getAltitude();
                    this._totalAltitudeRange.addValue(altitude2);
                    if (dataPoint2.getSegmentStart()) {
                        this._movingAltitudeRange.ignoreValue(altitude2);
                    } else {
                        this._movingAltitudeRange.addValue(altitude2);
                        if (altitude != null) {
                            boolean bl;
                            double d3 = altitude2.getMetricValue() - altitude.getMetricValue();
                            double d4 = Distance.convertRadiansToDistance(d, UnitSetLibrary.UNITS_METRES);
                            boolean bl2 = bl = d4 < 0.001 || Math.abs(d3 / d4) > 0.15;
                            if (bl) {
                                this._steepAltitudeRange.ignoreValue(altitude);
                                this._steepAltitudeRange.addValue(altitude2);
                            } else {
                                this._gentleAltitudeRange.ignoreValue(altitude);
                                this._gentleAltitudeRange.addValue(altitude2);
                            }
                        }
                    }
                    altitude = altitude2;
                    d = 0.0;
                }
                if (dataPoint2.hasTimestamp()) {
                    if (this._earliestTimestamp == null || dataPoint2.getTimestamp().isBefore(this._earliestTimestamp)) {
                        this._earliestTimestamp = dataPoint2.getTimestamp();
                    }
                    if (this._latestTimestamp == null || dataPoint2.getTimestamp().isAfter(this._latestTimestamp)) {
                        this._latestTimestamp = dataPoint2.getTimestamp();
                    }
                    if (!dataPoint2.getSegmentStart() && dataPoint != null && dataPoint.hasTimestamp()) {
                        long l = dataPoint2.getTimestamp().getMillisecondsSince(dataPoint.getTimestamp());
                        if (l < 0L) {
                            this._timesOutOfSequence = true;
                        } else {
                            this._movingMilliseconds += l;
                        }
                    }
                } else {
                    this._timesIncomplete = true;
                }
                dataPoint = dataPoint2;
            }
            ++n3;
        }
        return true;
    }

    public boolean isValid() {
        return this._valid;
    }

    public int getStartIndex() {
        return this._startIndex;
    }

    public int getEndIndex() {
        return this._endIndex;
    }

    public int getNumPoints() {
        return this._numPoints;
    }

    public int getNumSegments() {
        return this._numSegments;
    }

    public AltitudeRange getTotalAltitudeRange() {
        return this._totalAltitudeRange;
    }

    public AltitudeRange getMovingAltitudeRange() {
        return this._movingAltitudeRange;
    }

    public AltitudeRange getGentleAltitudeRange() {
        return this._gentleAltitudeRange;
    }

    public AltitudeRange getSteepAltitudeRange() {
        return this._steepAltitudeRange;
    }

    public Timestamp getEarliestTimestamp() {
        return this._earliestTimestamp;
    }

    public Timestamp getLatestTimestamp() {
        return this._latestTimestamp;
    }

    public long getTotalDurationInSeconds() {
        if (this._earliestTimestamp != null && this._latestTimestamp != null) {
            return this._latestTimestamp.getSecondsSince(this._earliestTimestamp);
        }
        return 0L;
    }

    public long getMovingDurationInSeconds() {
        return this._movingMilliseconds / 1000L;
    }

    public boolean getTimestampsIncomplete() {
        return this._timesIncomplete;
    }

    public boolean getTimestampsOutOfSequence() {
        return this._timesOutOfSequence;
    }

    public double getTotalDistance() {
        return Distance.convertRadiansToDistance(this._totalDistanceRads);
    }

    public double getMovingDistance() {
        return Distance.convertRadiansToDistance(this._movingDistanceRads);
    }

    public double getMovingDistanceKilometres() {
        return Distance.convertRadiansToDistance(this._movingDistanceRads, UnitSetLibrary.UNITS_KILOMETRES);
    }

    public double getTotalGradient() {
        double d = Distance.convertRadiansToDistance(this._totalDistanceRads, UnitSetLibrary.UNITS_METRES);
        if (d > 0.0 && this._totalAltitudeRange.hasRange()) {
            return this._totalAltitudeRange.getMetricHeightDiff() / d * 100.0;
        }
        return 0.0;
    }

    public double getMovingGradient() {
        double d = Distance.convertRadiansToDistance(this._movingDistanceRads, UnitSetLibrary.UNITS_METRES);
        if (d > 0.0 && this._movingAltitudeRange.hasRange()) {
            return this._movingAltitudeRange.getMetricHeightDiff() / d * 100.0;
        }
        return 0.0;
    }

    public double getTotalVerticalSpeed() {
        long l = this.getTotalDurationInSeconds();
        if (l > 0L && this._totalAltitudeRange.hasRange()) {
            return this._totalAltitudeRange.getMetricHeightDiff() / (double)l * Config.getUnitSet().getVerticalSpeedUnit().getMultFactorFromStd();
        }
        return 0.0;
    }

    public double getMovingVerticalSpeed() {
        long l = this.getMovingDurationInSeconds();
        if (l > 0L && this._movingAltitudeRange.hasRange()) {
            return this._movingAltitudeRange.getMetricHeightDiff() / (double)l * Config.getUnitSet().getVerticalSpeedUnit().getMultFactorFromStd();
        }
        return 0.0;
    }
}

