/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import tim.prune.gui.map.MapTile;

public class DiskTileCacher
implements Runnable {
    private URL _url = null;
    private File _file = null;
    private ImageObserver _observer = null;
    private static final long CACHE_TIME_LIMIT = 1728000000L;
    private static final HashSet<String> BLOCKED_URLS = new HashSet();

    private DiskTileCacher(URL uRL, File file, ImageObserver imageObserver) {
        this._url = uRL;
        this._file = file;
        this._observer = imageObserver;
    }

    public static MapTile getTile(String string, String string2) {
        if (string == null) {
            return null;
        }
        File file = new File(string, string2);
        Image image = null;
        if (file.exists() && file.canRead() && file.length() > 0L) {
            long l = file.lastModified();
            boolean bl = System.currentTimeMillis() - l > 1728000000L;
            try {
                image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
                return new MapTile(image, bl);
            }
            catch (Exception exception) {
                System.err.println("createImage: " + exception.getClass().getName() + " _ " + exception.getMessage());
            }
        }
        return null;
    }

    public static void saveTile(URL uRL, String string, String string2, ImageObserver imageObserver) {
        if (string == null || string2 == null) {
            return;
        }
        File file = new File(string);
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            return;
        }
        File file2 = new File(file, string2);
        if (DiskTileCacher.isBeingLoaded(file2)) {
            return;
        }
        if (BLOCKED_URLS.contains(uRL.toString())) {
            return;
        }
        File file3 = file2.getParentFile();
        if ((file3.exists() || file3.mkdirs()) && file3.canWrite()) {
            new Thread(new DiskTileCacher(uRL, file2, imageObserver)).start();
        }
    }

    private static boolean isBeingLoaded(File file) {
        File file2 = new File(String.valueOf(file.getAbsolutePath()) + ".temp");
        if (!file2.exists()) {
            return false;
        }
        long l = System.currentTimeMillis() - file2.lastModified();
        return l < 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = new File(String.valueOf(this._file.getAbsolutePath()) + ".temp");
        Object object = DiskTileCacher.class;
        synchronized (DiskTileCacher.class) {
            block29: {
                if (file.exists()) {
                    file.delete();
                }
                try {
                    if (!file.createNewFile()) {
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
                catch (Exception exception) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                try {
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        object = this._url.openConnection();
                        ((URLConnection)object).setRequestProperty("User-Agent", "GpsPrune v19.1");
                        inputStream = ((URLConnection)object).getInputStream();
                        int n = 0;
                        while ((n = inputStream.read()) >= 0) {
                            fileOutputStream.write(n);
                        }
                        bl = true;
                    }
                    catch (IOException iOException) {
                        System.err.println("ioe: " + iOException.getClass().getName() + " - " + iOException.getMessage());
                        BLOCKED_URLS.add(this._url.toString());
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {}
                        if (!bl) {
                            file.delete();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                    if (!bl) {
                        file.delete();
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                if (!bl) {
                    file.delete();
                }
            }
            if (file.exists() && !file.renameTo(this._file)) {
                file.delete();
                this._file.delete();
            }
            this._observer.imageUpdate(null, 32, 0, 0, 0, 0);
            return;
        }
    }
}

