/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs.swing;

import javajs.util.AU;
import javajs.util.SB;
import org.jmol.awtjs.swing.Cell;
import org.jmol.awtjs.swing.GridBagConstraints;
import org.jmol.awtjs.swing.JComponent;

public class Grid {
    private int nrows;
    private int ncols;
    private Cell[][] grid = new Cell[0][0];
    private String renderer;

    Grid(int rows, int cols) {
    }

    public void add(JComponent btn, GridBagConstraints c) {
        if (c.gridx >= this.ncols) {
            this.ncols = c.gridx + 1;
            for (int i = 0; i < this.nrows; ++i) {
                this.grid[i] = (Cell[])AU.ensureLength(this.grid[i], this.ncols * 2);
            }
        }
        if (c.gridy >= this.nrows) {
            int i;
            Cell[][] g = new Cell[c.gridy * 2 + 1][];
            for (i = 0; i < this.nrows; ++i) {
                g[i] = this.grid[i];
            }
            i = g.length;
            while (--i >= this.nrows) {
                g[i] = new Cell[this.ncols * 2 + 1];
            }
            this.grid = g;
            this.nrows = c.gridy + 1;
        }
        this.grid[c.gridy][c.gridx] = new Cell(btn, c);
    }

    public String toHTML(String id) {
        SB sb = new SB();
        id = id + "_grid";
        sb.append("\n<table id='" + id + "' class='Grid' style='width:100%;height:100%'><tr><td style='height:20%;width:20%'></td></tr>");
        for (int i = 0; i < this.nrows; ++i) {
            String rowid = id + "_" + i;
            sb.append("\n<tr id='" + rowid + "'><td></td>");
            for (int j = 0; j < this.ncols; ++j) {
                if (this.grid[i][j] == null) continue;
                sb.append(this.grid[i][j].toHTML(rowid + "_" + j));
            }
            sb.append("</tr>");
        }
        sb.append("\n<tr><td style='height:20%;width:20%'></td></tr></table>\n");
        return sb.toString();
    }
}

