/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.LayerDetails;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class AddWMSLayerPanel
extends AddImageryPanel {
    private transient WMSImagery wms;
    private final JCheckBox endpoint = new JCheckBox(I18n.tr("Store WMS endpoint only, select layers at usage", new Object[0]));
    private final JCheckBox setDefaultLayers = new JCheckBox(I18n.tr("Use selected layers as default", new Object[0]));
    private final transient WMSLayerTree tree = new WMSLayerTree();
    private final JComboBox<String> formats = new JComboBox();
    private final JosmTextArea wmsUrl = new JosmTextArea(3, 40).transferFocusOnTab();
    private final JButton showBounds = new JButton(I18n.tr("Show bounds", new Object[0]));

    public AddWMSLayerPanel() {
        this.add((Component)new JLabel(I18n.tr("{0} Make sure OSM has the permission to use this service", "1.")), GBC.eol());
        this.add((Component)new JLabel(I18n.tr("{0} Enter GetCapabilities URL", "2.")), GBC.eol());
        this.add((Component)this.rawUrl, GBC.eol().fill(2));
        this.rawUrl.setLineWrap(true);
        JButton getLayers = new JButton(I18n.tr("{0} Get layers", "3."));
        this.add((Component)getLayers, GBC.eop().fill(2));
        this.add((Component)new JLabel(I18n.tr("{0} Select layers", "4.")), GBC.eol());
        this.add((Component)this.endpoint, GBC.eol());
        this.setDefaultLayers.setEnabled(false);
        this.add((Component)this.setDefaultLayers, GBC.eol());
        this.add((Component)new JScrollPane(this.tree.getLayerTree()), GBC.eol().fill());
        this.showBounds.setEnabled(false);
        this.add((Component)this.showBounds, GBC.eop().fill(2));
        this.add((Component)new JLabel(I18n.tr("{0} Select image format", "5.")), GBC.eol());
        this.add(this.formats, GBC.eol().fill(2));
        this.addCommonSettings();
        JLabel wmsInstruction = new JLabel(I18n.tr("{0} Edit generated {1} URL (optional)", "6.", "WMS"));
        this.add((Component)wmsInstruction, GBC.eol());
        wmsInstruction.setLabelFor(this.wmsUrl);
        this.add((Component)this.wmsUrl, GBC.eop().fill(2));
        this.wmsUrl.setLineWrap(true);
        this.add((Component)new JLabel(I18n.tr("{0} Enter name for this layer", "7.")), GBC.eol());
        this.add((Component)this.name, GBC.eop().fill(2));
        getLayers.addActionListener(e -> {
            try {
                this.wms = new WMSImagery(this.rawUrl.getText(), this.getCommonHeaders());
                this.tree.updateTree(this.wms);
                Collection<String> wmsFormats = this.wms.getFormats();
                this.formats.setModel(new DefaultComboBoxModel<String>(wmsFormats.toArray(new String[0])));
                this.formats.setSelectedItem(this.wms.getPreferredFormat());
            }
            catch (MalformedURLException ex1) {
                Logging.log(Logging.LEVEL_ERROR, ex1);
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            catch (IOException ex2) {
                Logging.log(Logging.LEVEL_ERROR, ex2);
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            catch (WMSImagery.WMSGetCapabilitiesException ex3) {
                String incomingData = ex3.getIncomingData() != null ? ex3.getIncomingData().trim() : "";
                String title = I18n.tr("WMS Error", new Object[0]);
                StringBuilder message = new StringBuilder(I18n.tr("Could not parse WMS layer list.", new Object[0]));
                Logging.log(Logging.LEVEL_ERROR, "Could not parse WMS layer list. Incoming data:\n" + incomingData, ex3);
                if ((incomingData.startsWith("<html>") || incomingData.startsWith("<HTML>")) && (incomingData.endsWith("</html>") || incomingData.endsWith("</HTML>"))) {
                    GuiHelper.notifyUserHtmlError(this, title, message.toString(), incomingData);
                }
                if (ex3.getMessage() != null) {
                    message.append('\n').append(ex3.getMessage());
                }
                JOptionPane.showMessageDialog(this.getParent(), message.toString(), title, 0);
            }
        });
        ActionListener availabilityManagerAction = a -> {
            this.setDefaultLayers.setEnabled(this.endpoint.isSelected());
            boolean enabled = !this.endpoint.isSelected() || this.setDefaultLayers.isSelected();
            this.tree.getLayerTree().setEnabled(enabled);
            this.showBounds.setEnabled(enabled);
            wmsInstruction.setEnabled(enabled);
            this.formats.setEnabled(enabled);
            this.wmsUrl.setEnabled(enabled);
            if (this.endpoint.isSelected() && !this.setDefaultLayers.isSelected() && this.wms != null) {
                this.name.setText(this.wms.buildRootUrl());
            }
            this.onLayerSelectionChanged();
        };
        this.endpoint.addActionListener(availabilityManagerAction);
        this.setDefaultLayers.addActionListener(availabilityManagerAction);
        this.tree.getLayerTree().addPropertyChangeListener("selectedLayers", evt -> this.onLayerSelectionChanged());
        this.formats.addActionListener(e -> this.onLayerSelectionChanged());
        this.showBounds.addActionListener(e -> {
            if (this.tree.getSelectedLayers().get(0).getBounds() != null) {
                SlippyMapBBoxChooser mapPanel = new SlippyMapBBoxChooser();
                mapPanel.setBoundingBox(this.tree.getSelectedLayers().get(0).getBounds());
                JOptionPane.showMessageDialog(null, mapPanel, I18n.tr("Show Bounds", new Object[0]), -1);
            } else {
                JOptionPane.showMessageDialog(null, I18n.tr("No bounding box was found for this layer.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
        });
        this.registerValidableComponent(this.endpoint);
        this.registerValidableComponent(this.rawUrl);
        this.registerValidableComponent(this.wmsUrl);
        this.registerValidableComponent(this.setDefaultLayers);
    }

    protected final void onLayerSelectionChanged() {
        if (this.wms != null && this.wms.buildRootUrl() != null) {
            this.wmsUrl.setText(this.wms.buildGetMapUrl(this.tree.getSelectedLayers().stream().map(LayerDetails::getName).collect(Collectors.toList()), null, (String)this.formats.getSelectedItem(), true));
            this.name.setText(this.wms.buildRootUrl() + ": " + Utils.join(", ", this.tree.getSelectedLayers()));
        }
        this.showBounds.setEnabled(this.tree.getSelectedLayers().size() == 1);
    }

    @Override
    public ImageryInfo getImageryInfo() {
        ImageryInfo info = null;
        if (this.endpoint.isSelected()) {
            info = new ImageryInfo(this.getImageryName(), this.getImageryRawUrl());
            info.setImageryType(ImageryInfo.ImageryType.WMS_ENDPOINT);
            if (this.setDefaultLayers.isSelected()) {
                info.setDefaultLayers(this.tree.getSelectedLayers().stream().map(x -> new DefaultLayer(ImageryInfo.ImageryType.WMS_ENDPOINT, x.getName(), "", "")).collect(Collectors.toList()));
                info.setServerProjections(this.wms.getServerProjections(this.tree.getSelectedLayers()));
            }
        } else {
            info = this.wms != null && this.wms.buildRootUrl() != null ? this.wms.toImageryInfo(this.getImageryName(), this.tree.getSelectedLayers(), null, true) : new ImageryInfo(this.getImageryName(), this.getWmsUrl());
            info.setImageryType(ImageryInfo.ImageryType.WMS);
        }
        info.setGeoreferenceValid(this.getCommonIsValidGeoreference());
        info.setCustomHttpHeaders(this.getCommonHeaders());
        return info;
    }

    protected final String getWmsUrl() {
        return AddWMSLayerPanel.sanitize(this.wmsUrl.getText(), ImageryInfo.ImageryType.WMS);
    }

    @Override
    protected boolean isImageryValid() {
        if (this.getImageryName().isEmpty()) {
            return false;
        }
        if (this.setDefaultLayers.isSelected() && (this.tree == null || this.tree.getSelectedLayers().isEmpty())) {
            return false;
        }
        if (this.endpoint.isSelected()) {
            return !this.getImageryRawUrl().isEmpty();
        }
        return !this.getWmsUrl().isEmpty();
    }
}

