/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.TypeAnnotationNode;

public class LocalVariableAnnotationNode
extends TypeAnnotationNode {
    public List<LabelNode> start;
    public List<LabelNode> end;
    public List<Integer> index;

    public LocalVariableAnnotationNode(int typeRef, TypePath typePath, LabelNode[] start2, LabelNode[] end2, int[] index2, String desc) {
        this(393216, typeRef, typePath, start2, end2, index2, desc);
    }

    public LocalVariableAnnotationNode(int api, int typeRef, TypePath typePath, LabelNode[] start2, LabelNode[] end2, int[] index2, String desc) {
        super(api, typeRef, typePath, desc);
        this.start = new ArrayList<LabelNode>(start2.length);
        this.start.addAll(Arrays.asList(start2));
        this.end = new ArrayList<LabelNode>(end2.length);
        this.end.addAll(Arrays.asList(end2));
        this.index = new ArrayList<Integer>(index2.length);
        for (int i2 : index2) {
            this.index.add(i2);
        }
    }

    public void accept(MethodVisitor mv, boolean visible) {
        Label[] start2 = new Label[this.start.size()];
        Label[] end2 = new Label[this.end.size()];
        int[] index2 = new int[this.index.size()];
        for (int i2 = 0; i2 < start2.length; ++i2) {
            start2[i2] = this.start.get(i2).getLabel();
            end2[i2] = this.end.get(i2).getLabel();
            index2[i2] = this.index.get(i2);
        }
        this.accept(mv.visitLocalVariableAnnotation(this.typeRef, this.typePath, start2, end2, index2, this.desc, visible));
    }
}

