/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.invoke.MethodHandle;
import org.jruby.ir.IRScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRBlockBody
extends IRBlockBody {
    protected final MethodHandle handle;

    public CompiledIRBlockBody(MethodHandle handle, IRScope closure, long encodedSignature) {
        super(closure, Signature.decode(encodedSignature));
        this.handle = handle;
        closure.getStaticScope().determineModule();
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public boolean canCallDirect() {
        return true;
    }

    public MethodHandle getHandle() {
        return this.handle;
    }

    @Override
    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        context.setCurrentBlockType(Block.Type.PROC);
        try {
            return this.handle.invokeExact(context, block, this.getStaticScope(), null, args2, blockArg, block.getBinding().getMethod(), block.type);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        context.setCurrentBlockType(Block.Type.NORMAL);
        try {
            return this.handle.invokeExact(context, block, this.getStaticScope(), self2, args2, Block.NULL_BLOCK, block.getBinding().getMethod(), block.type);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, Block block, Block.Type type2, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
        throw new UnsupportedOperationException("commonYieldPath not implemented");
    }
}

