/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.javac.resolve;

import com.sun.source.tree.CompilationUnitTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.javac.JavaClassWithClassId;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.javac.resolve.ResolveHelperKt;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ2\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0011j\b\u0012\u0004\u0012\u00020\b`\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001c\u0010\f\u001a\u0004\u0018\u00010\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/javac/resolve/ResolveHelper;", "", "javac", "Lorg/jetbrains/kotlin/javac/JavacWrapper;", "compilationUnit", "Lcom/sun/source/tree/CompilationUnitTree;", "(Lorg/jetbrains/kotlin/javac/JavacWrapper;Lcom/sun/source/tree/CompilationUnitTree;)V", "findImport", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "pathSegments", "", "", "findInnerOrNested", "javaClass", "name", "Lorg/jetbrains/kotlin/name/Name;", "checkedSupertypes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findJavaOrKotlinClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findPackage", "Lorg/jetbrains/kotlin/name/FqName;", "packageName", "getJavaClassFromPathSegments", "findVisibleInnerOrNestedClass", "cli"})
public final class ResolveHelper {
    private final JavacWrapper javac;
    private final CompilationUnitTree compilationUnit;

    @Nullable
    public final JavaClass getJavaClassFromPathSegments(@NotNull JavaClass javaClass, @NotNull List<String> pathSegments) {
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        Intrinsics.checkParameterIsNotNull(pathSegments, "pathSegments");
        return pathSegments.size() == 1 ? javaClass : this.findInnerOrNested(javaClass, CollectionsKt.drop((Iterable)pathSegments, 1));
    }

    @Nullable
    public final JavaClass findImport(@NotNull List<String> pathSegments) {
        Intrinsics.checkParameterIsNotNull(pathSegments, "pathSegments");
        Iterable $receiver$iv = pathSegments;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            JavaClass javaClass;
            FqName fqName2;
            int n = index$iv++;
            String string = (String)item$iv;
            int index2 = n;
            if (index2 == CollectionsKt.getLastIndex(pathSegments)) {
                return null;
            }
            String packageFqName = CollectionsKt.joinToString$default(CollectionsKt.dropLast(pathSegments, index2 + 1), ".", null, null, 0, null, null, 62, null);
            FqName fqName3 = this.findPackage(packageFqName);
            if (fqName3 == null) continue;
            FqName pack = fqName2 = fqName3;
            List<String> className2 = CollectionsKt.takeLast(pathSegments, index2 + 1);
            JavaClass javaClass2 = this.findJavaOrKotlinClass(new ClassId(pack, Name.identifier(CollectionsKt.first(className2))));
            if (javaClass2 != null) {
                JavaClass javaClass3;
                JavaClass javaClass4 = javaClass3 = javaClass2;
                javaClass = this.getJavaClassFromPathSegments(javaClass4, className2);
            } else {
                javaClass = null;
            }
            return javaClass;
        }
        return null;
    }

    @Nullable
    public final JavaClass findJavaOrKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        JavaClass javaClass = JavacWrapper.findClass$default(this.javac, classId, null, 2, null);
        if (javaClass == null) {
            javaClass = this.javac.getKotlinClassifier(classId);
        }
        return javaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JavaClass findInnerOrNested(@NotNull JavaClass javaClass, @NotNull Name name, @NotNull HashSet<JavaClass> checkedSupertypes) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(checkedSupertypes, "checkedSupertypes");
        JavaClass javaClass2 = this.findVisibleInnerOrNestedClass(javaClass, name);
        if (javaClass2 != null) {
            JavaClass javaClass3;
            JavaClass it = javaClass3 = javaClass2;
            checkedSupertypes.addAll((Collection<JavaClass>)ResolveHelperKt.collectAllSupertypes(javaClass));
            return it;
        }
        Iterable iterable = javaClass.getSupertypes();
        void it = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            JavaClass javaClass4;
            JavaClass javaClass5;
            JavaClass supertype;
            Object element$iv$iv = element$iv$iv$iv;
            JavaClassifierType it2 = (JavaClassifierType)element$iv$iv;
            JavaClassifier javaClassifier = it2.getClassifier();
            if (!(javaClassifier instanceof JavaClass)) {
                javaClassifier = null;
            }
            JavaClass javaClass6 = (JavaClass)javaClassifier != null ? (!checkedSupertypes.contains(supertype = javaClass5) ? this.findInnerOrNested(supertype, name, checkedSupertypes) : null) : null;
            if (javaClass6 == null) continue;
            JavaClass it$iv$iv = javaClass4 = javaClass6;
            destination$iv$iv.add(it$iv$iv);
        }
        return (JavaClass)CollectionsKt.singleOrNull((List)destination$iv$iv);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ JavaClass findInnerOrNested$default(ResolveHelper resolveHelper, JavaClass javaClass, Name name, HashSet hashSet, int n, Object object) {
        if ((n & 4) != 0) {
            hashSet = new HashSet<JavaClass>();
        }
        return resolveHelper.findInnerOrNested(javaClass, name, hashSet);
    }

    @Nullable
    public final FqName findPackage(@NotNull String packageName) {
        FqName fqName2;
        Intrinsics.checkParameterIsNotNull(packageName, "packageName");
        Object object = packageName;
        FqName fqName3 = fqName2 = !StringsKt.isBlank((CharSequence)object) ? new FqName(packageName) : FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
        FqName fqName4 = this.javac.hasKotlinPackage(fqName3);
        if (fqName4 != null) {
            Object it = object = fqName4;
            return it;
        }
        JavaPackage javaPackage = JavacWrapper.findPackage$default(this.javac, fqName2, null, 2, null);
        return javaPackage != null ? javaPackage.getFqName() : null;
    }

    private final JavaClass findVisibleInnerOrNestedClass(@NotNull JavaClass $receiver, Name name) {
        JavaClass javaClass;
        JavaClass javaClass2 = $receiver.findInnerClass(name);
        if (javaClass2 != null) {
            JavaClass javaClass3 = javaClass2;
            JavaClass innerOrNestedClass = javaClass3;
            Visibility visibility = innerOrNestedClass.getVisibility();
            if (Intrinsics.areEqual(visibility, Visibilities.PRIVATE)) {
                javaClass = null;
            } else if (Intrinsics.areEqual(visibility, JavaVisibilities.PACKAGE_VISIBILITY)) {
                JavaClass javaClass4 = innerOrNestedClass;
                if (!(javaClass4 instanceof JavaClassWithClassId)) {
                    javaClass4 = null;
                }
                JavaClassWithClassId javaClassWithClassId = (JavaClassWithClassId)javaClass4;
                ClassId classId = javaClassWithClassId != null ? javaClassWithClassId.getClassId() : null;
                Object object = classId;
                String string = object != null && (object = ((ClassId)object).getPackageFqName()) != null ? ((FqName)object).asString() : null;
                Object object2 = this.compilationUnit.getPackageName();
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "";
                }
                javaClass = Intrinsics.areEqual(string, object2) ? (JavaClassWithClassId)innerOrNestedClass : null;
            } else {
                javaClass = innerOrNestedClass;
            }
        } else {
            javaClass = null;
        }
        return javaClass;
    }

    /*
     * WARNING - void declaration
     */
    private final JavaClass findInnerOrNested(@NotNull JavaClass $receiver, List<String> pathSegments) {
        Iterable $receiver$iv = pathSegments;
        JavaClass accumulator$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            void it;
            String string = (String)element$iv;
            JavaClass javaClass = accumulator$iv;
            Name name = Name.identifier((String)it);
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(it)");
            if (ResolveHelper.findInnerOrNested$default(this, javaClass, name, null, 4, null) != null) continue;
            return null;
        }
        return accumulator$iv;
    }

    public ResolveHelper(@NotNull JavacWrapper javac2, @NotNull CompilationUnitTree compilationUnit) {
        Intrinsics.checkParameterIsNotNull(javac2, "javac");
        Intrinsics.checkParameterIsNotNull(compilationUnit, "compilationUnit");
        this.javac = javac2;
        this.compilationUnit = compilationUnit;
    }
}

