"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const debug_1 = require("debug");
const debug = debug_1.default('axm:coverageaction');
const coverage_1 = require("../features/coverage");
const miscellaneous_1 = require("../utils/miscellaneous");
const serviceManager_1 = require("../serviceManager");
class CoverageAction {
    constructor(actionFeature) {
        this.actionFeature = actionFeature;
    }
    init() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.coverageFeature = new coverage_1.default();
            try {
                yield this.coverageFeature.init();
                // expose actions only if the feature is available
                this.exposeActions();
            }
            catch (err) {
                debug(`Failed to load coverage profiler: ${err.message}`);
            }
        });
    }
    destroy() {
        if (this.coverageFeature)
            this.coverageFeature.destroy();
    }
    stopCoverage(reply) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const dumpFile = yield this.coverageFeature.stop();
                return reply({
                    success: true,
                    coverage: true,
                    dump_file: dumpFile,
                    dump_file_size: dumpFile.length,
                    uuid: this.uuid
                });
            }
            catch (err) {
                return reply({
                    success: false,
                    err: err,
                    uuid: this.uuid
                });
            }
        });
    }
    exposeActions() {
        this.actionFeature.action('km:coverage:start', (opts, reply) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!reply) {
                reply = opts;
                opts = {};
            }
            try {
                this.uuid = miscellaneous_1.default.generateUUID();
                yield this.coverageFeature.start(opts);
                reply({ success: true, uuid: this.uuid });
                if (opts.timeout && typeof opts.timeout === 'number') {
                    setTimeout((_) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const reply = (data) => serviceManager_1.ServiceManager.get('transport').send('axm:reply', {
                            return: data,
                            action_name: 'km:coverage:stop'
                        });
                        yield this.stopCoverage(reply);
                    }), opts.timeout);
                }
            }
            catch (err) {
                return reply({
                    success: false,
                    err: err,
                    uuid: this.uuid
                });
            }
        }));
        this.actionFeature.action('km:coverage:stop', this.stopCoverage.bind(this));
    }
}
exports.default = CoverageAction;
//# sourceMappingURL=data:application/json;base64,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