/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.Property;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleHelper;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public abstract class StyleableProperty<N extends Node, V> {
    private static Map<Class, List<StyleableProperty>> styleablesCache = null;
    private final String property;
    private final StyleConverter converter;
    private final V initialValue;
    private final List<StyleableProperty> subProperties;
    private final boolean inherits;

    public void set(N n, V v, Stylesheet.Origin origin) {
        WritableValue<V> writableValue = this.getWritableValue(n);
        assert (writableValue instanceof Property);
        Property property = (Property)((Object)writableValue);
        Stylesheet.Origin origin2 = property.getOrigin();
        V v2 = writableValue.getValue();
        if (origin2 != origin || (v2 != null ? !v2.equals(v) : v != null)) {
            property.applyStyle(origin, v);
        }
    }

    public void set(N n, V v) {
        this.set(n, v, null);
    }

    public static StyleableProperty getStyleableProperty(WritableValue writableValue) {
        if (writableValue instanceof Property) {
            return ((Property)((Object)writableValue)).getStyleableProperty();
        }
        return null;
    }

    public static Stylesheet.Origin getOrigin(WritableValue writableValue) {
        if (writableValue instanceof Property) {
            return ((Property)((Object)writableValue)).getOrigin();
        }
        return null;
    }

    public List<Style> getMatchingStyles(Node node) {
        if (node != null) {
            return this.getMatchingStyles(node.impl_getStyleable());
        }
        return Collections.EMPTY_LIST;
    }

    public List<Style> getMatchingStyles(Styleable styleable) {
        if (styleable != null) {
            StyleHelper styleHelper = styleable.getNode() != null ? styleable.getNode().impl_getStyleHelper() : null;
            return styleHelper != null ? styleHelper.getMatchingStyles(styleable, this) : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    public abstract boolean isSettable(N var1);

    public abstract WritableValue<V> getWritableValue(N var1);

    private static Method getMethod_impl_CSS_STYLEABLES(final Class clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return clazz.getDeclaredMethod("impl_CSS_STYLEABLES", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
    }

    public static List<StyleableProperty> getStyleables(Styleable styleable) {
        return styleable != null ? styleable.getStyleableProperties() : Collections.EMPTY_LIST;
    }

    public static List<StyleableProperty> getStyleables(Node node) {
        return node != null ? node.impl_getStyleableProperties() : Collections.EMPTY_LIST;
    }

    public final String getProperty() {
        return this.property;
    }

    public final StyleConverter getConverter() {
        return this.converter;
    }

    public V getInitialValue(N n) {
        return this.initialValue;
    }

    public final List<StyleableProperty> getSubProperties() {
        return this.subProperties;
    }

    public final boolean isInherits() {
        return this.inherits;
    }

    protected StyleableProperty(String string, StyleConverter styleConverter, V v, boolean bl, List<StyleableProperty> list) {
        this.property = string;
        this.converter = styleConverter;
        this.initialValue = v;
        this.inherits = bl;
        List<StyleableProperty> list2 = this.subProperties = list != null ? Collections.unmodifiableList(list) : null;
        if (this.property == null || this.converter == null) {
            throw new IllegalArgumentException("neither property nor converter can be null");
        }
    }

    protected StyleableProperty(String string, StyleConverter styleConverter, V v, boolean bl) {
        this(string, styleConverter, v, bl, null);
    }

    protected StyleableProperty(String string, StyleConverter styleConverter, V v) {
        this(string, styleConverter, v, false, null);
    }

    protected StyleableProperty(String string, StyleConverter styleConverter) {
        this(string, styleConverter, null, false, null);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StyleableProperty styleableProperty = (StyleableProperty)object;
        return !(this.property == null ? styleableProperty.property != null : !this.property.equals(styleableProperty.property));
    }

    public int hashCode() {
        int n = 3;
        n = 19 * n + (this.property != null ? this.property.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "StyleableProperty {" + "property: " + this.property + ", converter: " + this.converter.toString() + ", initalValue: " + String.valueOf(this.initialValue) + ", inherits: " + this.inherits + ", subProperties: " + (this.subProperties != null ? this.subProperties.toString() : "[]") + "}";
    }

    public static abstract class FONT<T extends Node>
    extends StyleableProperty<T, Font> {
        public FONT(String string, Font font) {
            super(string, FontConverter.getInstance(), font, true, FONT.createSubProperties(string, font));
        }

        private static List<StyleableProperty> createSubProperties(String string, Font font) {
            Font font2 = font != null ? font : Font.getDefault();
            StyleableProperty<Node, Size> styleableProperty = new StyleableProperty<Node, Size>(string.concat("-size"), (StyleConverter)SizeConverter.getInstance(), new Size(font2.getSize(), SizeUnits.PT), true){

                @Override
                public boolean isSettable(Node node) {
                    return false;
                }

                @Override
                public WritableValue<Size> getWritableValue(Node node) {
                    return null;
                }
            };
            StyleableProperty<Node, FontWeight> styleableProperty2 = new StyleableProperty<Node, FontWeight>(string.concat("-weight"), (StyleConverter)SizeConverter.getInstance(), FontWeight.NORMAL, true){

                @Override
                public boolean isSettable(Node node) {
                    return false;
                }

                @Override
                public WritableValue<FontWeight> getWritableValue(Node node) {
                    return null;
                }
            };
            StyleableProperty<Node, FontPosture> styleableProperty3 = new StyleableProperty<Node, FontPosture>(string.concat("-style"), (StyleConverter)SizeConverter.getInstance(), FontPosture.REGULAR, true){

                @Override
                public boolean isSettable(Node node) {
                    return false;
                }

                @Override
                public WritableValue<FontPosture> getWritableValue(Node node) {
                    return null;
                }
            };
            StyleableProperty<Node, String> styleableProperty4 = new StyleableProperty<Node, String>(string.concat("-family"), (StyleConverter)SizeConverter.getInstance(), font2.getFamily(), true){

                @Override
                public boolean isSettable(Node node) {
                    return false;
                }

                @Override
                public WritableValue<String> getWritableValue(Node node) {
                    return null;
                }
            };
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, styleableProperty4, styleableProperty, styleableProperty3, styleableProperty2);
            return Collections.unmodifiableList(arrayList);
        }
    }
}

