/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.FacetNotExistException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LoggerAdminPrx;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.PropertiesAdminPrx;
import com.zeroc.IceGridGUI.LiveDeployment.CommunicatorEditor;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsView;
import com.zeroc.IceGridGUI.LiveDeployment.ShowIceLogDialog;
import com.zeroc.IceGridGUI.LiveDeployment.TreeNode;
import com.zeroc.IceMX.MetricsAdminPrx;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;

public abstract class Communicator
extends TreeNode {
    protected ShowIceLogDialog _showIceLogDialog;
    protected List<MetricsView> _metrics = new LinkedList<MetricsView>();
    protected boolean _metricsRetrieved = false;
    protected final List[] _childrenArray;

    Communicator(TreeNode parent, String id, int arraySize) {
        super(parent, id);
        this._childrenArray = new List[arraySize];
    }

    @Override
    public Enumeration<javax.swing.tree.TreeNode> children() {
        return new Enumeration<javax.swing.tree.TreeNode>(){
            private int _index = 0;
            private Iterator<javax.swing.tree.TreeNode> _p;
            {
                this._p = Communicator.this._childrenArray[0].iterator();
            }

            @Override
            public boolean hasMoreElements() {
                if (this._p.hasNext()) {
                    return true;
                }
                while (++this._index < Communicator.this._childrenArray.length) {
                    this._p = Communicator.this._childrenArray[this._index].iterator();
                    if (!this._p.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public javax.swing.tree.TreeNode nextElement() {
                try {
                    return this._p.next();
                }
                catch (NoSuchElementException nse) {
                    if (this.hasMoreElements()) {
                        return this._p.next();
                    }
                    throw nse;
                }
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public javax.swing.tree.TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        int offset = 0;
        for (List l : this._childrenArray) {
            if (childIndex < offset + l.size()) {
                return (javax.swing.tree.TreeNode)l.get(childIndex - offset);
            }
            offset += l.size();
        }
        throw new ArrayIndexOutOfBoundsException(childIndex);
    }

    @Override
    public int getChildCount() {
        int result = 0;
        for (List l : this._childrenArray) {
            result += l.size();
        }
        return result;
    }

    @Override
    public int getIndex(javax.swing.tree.TreeNode node) {
        int offset = 0;
        for (List l : this._childrenArray) {
            int index = l.indexOf(node);
            if (index == -1) {
                offset += l.size();
                continue;
            }
            return offset + index;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        for (List l : this._childrenArray) {
            if (l.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void retrieveIceLog() {
        if (this._showIceLogDialog == null) {
            String prefix = "Opening Ice Log file for " + this.getServerDisplayName() + "...";
            this.provideAdmin(prefix, admin -> {
                LoggerAdminPrx loggerAdmin = LoggerAdminPrx.uncheckedCast(admin.ice_facet("Logger"));
                String title = this.getDisplayName() + " Ice log";
                String defaultFileName = this.getDefaultFileName();
                SwingUtilities.invokeLater(() -> {
                    this.success(prefix);
                    if (this._showIceLogDialog == null) {
                        this._showIceLogDialog = new ShowIceLogDialog(this, title, loggerAdmin, defaultFileName, this.getRoot().getLogMaxLines(), this.getRoot().getLogInitialLines());
                    } else {
                        this._showIceLogDialog.toFront();
                    }
                });
            });
        } else {
            this._showIceLogDialog.toFront();
        }
    }

    @Override
    public void clearShowIceLogDialog() {
        this._showIceLogDialog = null;
    }

    protected void showRuntimeProperties() {
        String prefix = "Retrieving properties for " + this.getDisplayName() + "...";
        this.provideAdmin(prefix, admin -> {
            PropertiesAdminPrx propertiesAdmin = PropertiesAdminPrx.uncheckedCast(admin.ice_facet("Properties"));
            propertiesAdmin.getPropertiesForPrefixAsync("").whenComplete((result, ex) -> {
                if (ex == null) {
                    SwingUtilities.invokeLater(() -> {
                        this.success(prefix);
                        ((CommunicatorEditor)this.getEditor()).setRuntimeProperties((SortedMap)result, this);
                    });
                } else if (ex instanceof ObjectNotExistException || ex instanceof FacetNotExistException) {
                    SwingUtilities.invokeLater(() -> this.getRoot().getCoordinator().getStatusBar().setText(prefix + " Admin not available."));
                } else {
                    this.amiFailure(prefix, "Failed to retrieve the properties for " + this.getDisplayName(), (Throwable)ex);
                }
            });
        });
    }

    protected void fetchMetricsViewNames() {
        if (this._metricsRetrieved) {
            return;
        }
        this._metricsRetrieved = true;
        String prefix = "Retrieving metrics for " + this.getDisplayName() + "...";
        if (!this.provideAdmin(prefix, admin -> {
            MetricsAdminPrx metricsAdmin = MetricsAdminPrx.uncheckedCast(admin.ice_facet("Metrics"));
            metricsAdmin.getMetricsViewNamesAsync().whenComplete((result, ex) -> {
                if (ex == null) {
                    SwingUtilities.invokeLater(() -> {
                        this.success(prefix);
                        this._metrics.clear();
                        for (String name : result.returnValue) {
                            this.insertSortedChild(new MetricsView(this, name, metricsAdmin, true), this._metrics, null);
                        }
                        for (String name : result.disabledViews) {
                            this.insertSortedChild(new MetricsView(this, name, metricsAdmin, false), this._metrics, null);
                        }
                        this.getRoot().getTreeModel().nodeStructureChanged(this);
                    });
                } else if (ex instanceof ObjectNotExistException || ex instanceof FacetNotExistException) {
                    SwingUtilities.invokeLater(() -> this.getRoot().getCoordinator().getStatusBar().setText(prefix + " Admin not available."));
                } else {
                    this.amiFailure(prefix, "Failed to retrieve the metrics for " + this.getDisplayName(), (Throwable)ex);
                }
            });
        })) {
            this._metricsRetrieved = false;
        }
    }

    void updateMetrics() {
        this._metricsRetrieved = false;
        if (this.getRoot().getTree().isExpanded(this.getPath())) {
            this.fetchMetricsViewNames();
        }
    }

    public List<MetricsView> getMetrics() {
        return new ArrayList<MetricsView>(this._metrics);
    }

    protected abstract CompletableFuture<ObjectPrx> getAdminAsync();

    protected abstract String getDisplayName();

    protected String getServerDisplayName() {
        return this.getDisplayName();
    }

    protected abstract String getDefaultFileName();

    private boolean provideAdmin(String prefix, Consumer<ObjectPrx> consumer) {
        this.getRoot().getCoordinator().getStatusBar().setText(prefix);
        try {
            this.getAdminAsync().whenComplete((admin, adminEx) -> {
                if (adminEx == null && admin != null) {
                    try {
                        consumer.accept((ObjectPrx)admin);
                    }
                    catch (LocalException e) {
                        SwingUtilities.invokeLater(() -> this.getRoot().getCoordinator().getStatusBar().setText(prefix + " " + e.toString() + "."));
                    }
                } else if (adminEx == null || adminEx instanceof ObjectNotExistException) {
                    SwingUtilities.invokeLater(() -> this.getRoot().getCoordinator().getStatusBar().setText(prefix + " Admin not available."));
                } else {
                    this.amiFailure(prefix, "Failed to retrieve the Admin proxy for " + this.getServerDisplayName(), (Throwable)adminEx);
                }
            });
        }
        catch (LocalException e) {
            this.getRoot().getCoordinator().getStatusBar().setText(prefix + " " + e.toString() + ".");
            return false;
        }
        return true;
    }
}

