/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.NodeInfo;
import com.zeroc.IceGridGUI.LiveDeployment.CommunicatorEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Node;
import com.zeroc.IceGridGUI.LiveDeployment.TableField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class NodeEditor
extends CommunicatorEditor {
    private JTextField _hostname = new JTextField(20);
    private JTextField _os = new JTextField(20);
    private JTextField _machineType = new JTextField(20);
    private JLabel _loadAverageLabel = new JLabel();
    private JTextField _loadAverage = new JTextField(20);
    private JButton _refreshLoadButton;
    private boolean _loadRetrieved = false;
    private TableField _loadFactor = new TableField("Application", "Value");

    NodeEditor() {
        this._hostname.setEditable(false);
        this._os.setEditable(false);
        this._machineType.setEditable(false);
        this._loadAverage.setEditable(false);
        AbstractAction refreshLoad = new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeEditor.this._loadAverage.setText("");
                NodeEditor.this._loadRetrieved = false;
                ((Node)NodeEditor.this._target).showLoad();
            }
        };
        refreshLoad.putValue("ShortDescription", "Fetch the latest values from this IceGrid Node");
        this._refreshLoadButton = new JButton(refreshLoad);
    }

    void show(Node node) {
        Node previous = (Node)this._target;
        this._target = node;
        NodeInfo info = node.getStaticInfo();
        if (info == null) {
            this._hostname.setText("Unknown");
            this._os.setText("Unknown");
            this._machineType.setText("Unknown");
            this._loadAverageLabel.setText("Load Average");
            this._loadAverage.setText("Unknown");
            this._loadRetrieved = false;
            this._refreshLoadButton.setEnabled(false);
            this.clearRuntimeProperties("Unknown");
        } else {
            this._hostname.setText(info.hostname);
            this._os.setText(info.os + " " + info.release + " " + info.version);
            this._os.setCaretPosition(0);
            this._machineType.setText(info.machine + " with " + info.nProcessors + " CPU thread" + (info.nProcessors >= 2 ? "s" : ""));
            if (node.isRunningWindows()) {
                this._loadAverageLabel.setText("CPU Usage");
                this._loadAverage.setToolTipText("CPU usage in the past 1 min, 5 min and 15 min period");
            } else {
                this._loadAverageLabel.setText("Load Average");
                this._loadAverage.setToolTipText("Load average in the past 1 min, 5 min and 15 min period");
            }
            if (this._target != previous || !this._loadRetrieved) {
                this._loadAverage.setText("Refreshing load...");
                this._loadRetrieved = true;
                node.showLoad();
                this._refreshLoadButton.setEnabled(true);
            }
            this.showRuntimeProperties(previous);
        }
        this._loadFactor.setSortedMap(node.getLoadFactors());
    }

    void setLoad(String load, Node node) {
        if (node == this._target) {
            this._loadAverage.setText(load);
            this._loadRetrieved = true;
        }
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.appendSeparator("System Information");
        builder.append("Hostname");
        builder.append((Component)this._hostname, 3);
        builder.nextLine();
        builder.append("Operating System");
        builder.append((Component)this._os, 3);
        builder.nextLine();
        builder.append("Machine Type");
        builder.append((Component)this._machineType, 3);
        builder.append((Component)this._loadAverageLabel, (Component)this._loadAverage);
        builder.append(this._refreshLoadButton);
        builder.nextLine();
        this.appendRuntimeProperties(builder);
        builder.appendSeparator("Configuration");
        builder.append("Load Factor");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._loadFactor);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Node Properties");
    }
}

