/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Current;
import Ice.Logger;
import Ice.NativePropertiesAdmin;
import Ice.Properties;
import Ice.PropertiesAdminUpdateCallback;
import Ice._PropertiesAdminDisp;
import IceInternal.Instance;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class PropertiesAdminI
extends _PropertiesAdminDisp
implements NativePropertiesAdmin {
    private final Properties _properties;
    private final Logger _logger;
    private List<PropertiesAdminUpdateCallback> _updateCallbacks = new ArrayList<PropertiesAdminUpdateCallback>();
    private static final String _traceCategory = "Admin.Properties";

    public PropertiesAdminI(Instance instance) {
        this._properties = instance.initializationData().properties;
        this._logger = instance.initializationData().logger;
    }

    @Override
    public synchronized String getProperty(String name, Current current) {
        return this._properties.getProperty(name);
    }

    public synchronized TreeMap<String, String> getPropertiesForPrefix(String name, Current current) {
        return new TreeMap<String, String>(this._properties.getPropertiesForPrefix(name));
    }

    @Override
    public synchronized void setProperties(Map<String, String> props, Current current) {
        Map<String, String> old = this._properties.getPropertiesForPrefix("");
        int traceLevel = this._properties.getPropertyAsInt("Ice.Trace.Admin.Properties");
        HashMap<String, String> added = new HashMap<String, String>();
        HashMap<String, String> changed = new HashMap<String, String>();
        HashMap<String, String> removed = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!old.containsKey(key)) {
                if (value.length() <= 0) continue;
                added.put(key, value);
                continue;
            }
            if (!value.equals(old.get(key))) {
                if (value.length() == 0) {
                    removed.put(key, value);
                } else {
                    changed.put(key, value);
                }
            }
            old.remove(key);
        }
        if (!(traceLevel <= 0 || added.isEmpty() && changed.isEmpty() && removed.isEmpty())) {
            Iterator out = new StringBuilder(128);
            ((StringBuilder)((Object)out)).append("Summary of property changes");
            if (!added.isEmpty()) {
                ((StringBuilder)((Object)out)).append("\nNew properties:");
                for (Map.Entry e : added.entrySet()) {
                    ((StringBuilder)((Object)out)).append("\n  ");
                    ((StringBuilder)((Object)out)).append((String)e.getKey());
                    if (traceLevel <= 1) continue;
                    ((StringBuilder)((Object)out)).append(" = ");
                    ((StringBuilder)((Object)out)).append((String)e.getValue());
                }
            }
            if (!changed.isEmpty()) {
                ((StringBuilder)((Object)out)).append("\nChanged properties:");
                for (Map.Entry e : changed.entrySet()) {
                    ((StringBuilder)((Object)out)).append("\n  ");
                    ((StringBuilder)((Object)out)).append((String)e.getKey());
                    if (traceLevel <= 1) continue;
                    ((StringBuilder)((Object)out)).append(" = ");
                    ((StringBuilder)((Object)out)).append((String)e.getValue());
                    ((StringBuilder)((Object)out)).append(" (old value = ");
                    ((StringBuilder)((Object)out)).append(this._properties.getProperty((String)e.getKey()));
                    ((StringBuilder)((Object)out)).append(")");
                }
            }
            if (!removed.isEmpty()) {
                ((StringBuilder)((Object)out)).append("\nRemoved properties:");
                for (Map.Entry e : removed.entrySet()) {
                    ((StringBuilder)((Object)out)).append("\n  ");
                    ((StringBuilder)((Object)out)).append((String)e.getKey());
                }
            }
            this._logger.trace(_traceCategory, ((StringBuilder)((Object)out)).toString());
        }
        for (Map.Entry entry : added.entrySet()) {
            this._properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : changed.entrySet()) {
            this._properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : removed.entrySet()) {
            this._properties.setProperty((String)entry.getKey(), "");
        }
        if (!this._updateCallbacks.isEmpty()) {
            HashMap<String, String> changes = new HashMap<String, String>(added);
            changes.putAll(changed);
            changes.putAll(removed);
            ArrayList<PropertiesAdminUpdateCallback> arrayList = new ArrayList<PropertiesAdminUpdateCallback>(this._updateCallbacks);
            for (PropertiesAdminUpdateCallback callback : arrayList) {
                try {
                    callback.updated(changes);
                }
                catch (Exception ex) {
                    if (this._properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) <= 1) continue;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._logger.warning("properties admin update callback raised unexpected exception:\n" + sw.toString());
                }
            }
        }
    }

    @Override
    public synchronized void addUpdateCallback(PropertiesAdminUpdateCallback cb) {
        this._updateCallbacks.add(cb);
    }

    @Override
    public synchronized void removeUpdateCallback(PropertiesAdminUpdateCallback cb) {
        this._updateCallbacks.remove(cb);
    }
}

