#ifndef _EFL_UI_MULTI_SELECTABLE_EO_H_
#define _EFL_UI_MULTI_SELECTABLE_EO_H_

#ifndef _EFL_UI_MULTI_SELECTABLE_EO_CLASS_TYPE
#define _EFL_UI_MULTI_SELECTABLE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Multi_Selectable;

#endif

#ifndef _EFL_UI_MULTI_SELECTABLE_EO_TYPES
#define _EFL_UI_MULTI_SELECTABLE_EO_TYPES

/** Type of multi selectable object.
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_SELECT_SINGLE = 0, /**< Only single child is selected. if the child is
                             * selected, previous selected child will be
                             * unselected. */
  EFL_UI_SELECT_SINGLE_ALWAYS, /**< Same as single select except, this will be
                                * selected in every select calls though child
                                * is already been selected. */
  EFL_UI_SELECT_MULTI, /**< allow multiple selection of children. */
  EFL_UI_SELECT_NONE /**< Last value of select mode. child cannot be selected at
                      * all. */
} Efl_Ui_Select_Mode;


#endif
/** Efl UI Multi selectable interface. The container have to control select
 * property of multiple chidren.
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
#define EFL_UI_MULTI_SELECTABLE_INTERFACE efl_ui_multi_selectable_interface_get()

EWAPI const Efl_Class *efl_ui_multi_selectable_interface_get(void);

/**
 * @brief The mode type for children selection.
 *
 * @param[in] obj The object.
 * @param[in] mode Type of selection of children
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI void efl_ui_select_mode_set(Eo *obj, Efl_Ui_Select_Mode mode);

/**
 * @brief The mode type for children selection.
 *
 * @param[in] obj The object.
 *
 * @return Type of selection of children
 *
 * @ingroup Efl_Ui_Multi_Selectable
 */
EOAPI Efl_Ui_Select_Mode efl_ui_select_mode_get(const Eo *obj);

#endif
