/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AStoreable;

final class PSubShortcut
extends AStoreable {
    private final String value;
    private final String type;
    private final PainlessMethod getter;
    private final PainlessMethod setter;

    PSubShortcut(Location location, String value, String type, PainlessMethod getter, PainlessMethod setter) {
        super(location);
        this.value = value;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        if (!(this.getter == null || this.getter.rtn != Void.TYPE && this.getter.arguments.isEmpty())) {
            throw this.createError(new IllegalArgumentException("Illegal get shortcut on field [" + this.value + "] for type [" + this.type + "]."));
        }
        if (this.setter != null && (this.setter.rtn != Void.TYPE || this.setter.arguments.size() != 1)) {
            throw this.createError(new IllegalArgumentException("Illegal set shortcut on field [" + this.value + "] for type [" + this.type + "]."));
        }
        if (this.getter != null && this.setter != null && this.setter.arguments.get(0) != this.getter.rtn) {
            throw this.createError(new IllegalArgumentException("Shortcut argument types must match."));
        }
        if (this.getter == null && this.setter == null || this.read && this.getter == null || this.write && this.setter == null) {
            throw this.createError(new IllegalArgumentException("Illegal shortcut on field [" + this.value + "] for type [" + this.type + "]."));
        }
        this.actual = this.setter != null ? this.setter.arguments.get(0) : this.getter.rtn;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.getter.write(writer);
        if (!this.getter.rtn.equals(this.getter.handle.type().returnType())) {
            writer.checkCast(MethodWriter.getType(this.getter.rtn));
        }
    }

    @Override
    int accessElementCount() {
        return 1;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Class<?> actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.getter.write(writer);
        if (this.getter.rtn != this.getter.handle.type().returnType()) {
            writer.checkCast(MethodWriter.getType(this.getter.rtn));
        }
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.setter.write(writer);
        writer.writePop(MethodWriter.getType(this.setter.rtn).getSize());
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.value);
    }
}

