/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.parser.SimpleTextExtractingPdfContentStreamProcessor;
import java.io.IOException;

public class PdfTextExtractor {
    private final PdfReader reader;
    private final SimpleTextExtractingPdfContentStreamProcessor extractionProcessor;

    public PdfTextExtractor(PdfReader pdfReader) {
        this.reader = pdfReader;
        this.extractionProcessor = new SimpleTextExtractingPdfContentStreamProcessor();
    }

    private byte[] getContentBytesForPage(int n) throws IOException {
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        byte[] byArray = this.reader.getPageContent(n, randomAccessFileOrArray);
        randomAccessFileOrArray.close();
        return byArray;
    }

    public String getTextFromPage(int n) throws IOException {
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
        this.extractionProcessor.processContent(this.getContentBytesForPage(n), pdfDictionary2);
        return this.extractionProcessor.getResultantText();
    }
}

