#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 2.6.0
id: esqueleto-2.6.0-60mbenupCLvB228we58CCQ
key: esqueleto-2.6.0-60mbenupCLvB228we58CCQ
license: BSD-3-Clause
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
author: Felipe Lessa
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.
category: Database
abi: ac9742cfcc3c0608546c9f3aaa35bdaf
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.MySQL
    Database.Esqueleto.PostgreSQL Database.Esqueleto.SQLite
hidden-modules: Database.Esqueleto.Internal.PersistentImport
                Paths_esqueleto
import-dirs: /usr/lib/ghc-8.6.1/site-local/esqueleto-2.6.0
library-dirs: /usr/lib/ghc-8.6.1/site-local/esqueleto-2.6.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.6.1/esqueleto-2.6.0
hs-libraries: HSesqueleto-2.6.0-60mbenupCLvB228we58CCQ
depends:
    base-4.12.0.0 blaze-html-0.9.1.1-W55jLnl9KQ9ftt8MpwW6m
    bytestring-0.10.8.2 conduit-1.3.1-KVXSRHbsNfjAMraP9AIqVV
    monad-logger-0.3.30-5g5Gqyy3Upt7gt9SOSIJt4
    persistent-2.8.2-8ksiDbHVoYpE0rxR4Aj389
    resourcet-1.2.2-IgPyczYAdnHDPKGn1GTTIT
    tagged-0.8.6-FABECvKnqYbBCttH1EeJvB text-1.2.3.1 time-1.8.0.2
    transformers-0.5.5.0 unliftio-0.2.8.1-IQ9RpZ4mp1bGsT3C8RGnfq
    unordered-containers-0.2.9.0-8YwmaeVELNEGd3AzVghTJw
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

