# -*- coding: utf-8 -*-

# Copyright (c) 2018 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to select the pip executable to be used.
"""

from __future__ import unicode_literals

from PyQt5.QtWidgets import QDialog

from .Ui_PipSelectionDialog import Ui_PipSelectionDialog


class PipSelectionDialog(QDialog, Ui_PipSelectionDialog):
    """
    Class implementing a dialog to select the pip executable to be used.
    """
    def __init__(self, pip, parent=None):
        """
        Constructor
        
        @param pip reference to the pip object
        @type Pip
        @param parent reference to the parent widget
        @type QWidget
        """
        super(PipSelectionDialog, self).__init__(parent)
        self.setupUi(self)
        
        self.venvComboBox.addItem(pip.getDefaultEnvironmentString())
        self.venvComboBox.addItems(pip.getVirtualenvNames())
        
        msh = self.minimumSizeHint()
        self.resize(max(self.width(), msh.width()), msh.height())
    
    def getData(self):
        """
        Public method to get the entered data.
        
        @return tuple with the environment name and a flag indicating to
            install to the user install directory
        @rtype tuple of (str, bool)
        """
        return (
            self.venvComboBox.currentText(),
            self.userCheckBox.isChecked(),
        )
