/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.sql.JDBCType;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum DataType {
    NULL(JDBCType.NULL, null, 0, 0, 0),
    UNSUPPORTED(JDBCType.OTHER, null, 0, 0, 0),
    BOOLEAN(JDBCType.BOOLEAN, Boolean.class, 1, 1, 1),
    BYTE(JDBCType.TINYINT, Byte.class, 1, 3, 5, true, false, true),
    SHORT(JDBCType.SMALLINT, Short.class, 2, 5, 6, true, false, true),
    INTEGER(JDBCType.INTEGER, Integer.class, 4, 10, 11, true, false, true),
    LONG(JDBCType.BIGINT, Long.class, 8, 19, 20, true, false, true),
    DOUBLE(JDBCType.DOUBLE, Double.class, 8, 15, 25, false, true, true),
    FLOAT(JDBCType.REAL, Float.class, 4, 7, 15, false, true, true),
    HALF_FLOAT(JDBCType.FLOAT, Double.class, 8, 16, 25, false, true, true),
    SCALED_FLOAT(JDBCType.FLOAT, Double.class, 8, 19, 25, false, true, true),
    KEYWORD(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, 256, 0),
    TEXT(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false, false, false),
    OBJECT(JDBCType.STRUCT, null, -1, 0, 0),
    NESTED(JDBCType.STRUCT, null, -1, 0, 0),
    BINARY(JDBCType.VARBINARY, byte[].class, -1, Integer.MAX_VALUE, 0),
    DATE(JDBCType.TIMESTAMP, Timestamp.class, 8, 24, 24);

    private static final Map<JDBCType, DataType> jdbcToEs;
    public final String esType = this.name().toLowerCase(Locale.ROOT);
    public final JDBCType jdbcType;
    public final int size;
    public final int defaultPrecision;
    public final int displaySize;
    public final boolean isInteger;
    public final boolean isRational;
    public final boolean defaultDocValues;
    private final Class<?> javaClass;

    private DataType(JDBCType jdbcType, Class<?> javaClass, int size, int defaultPrecision, int displaySize, boolean isInteger, boolean isRational, boolean defaultDocValues) {
        this.javaClass = javaClass;
        this.jdbcType = jdbcType;
        this.size = size;
        this.defaultPrecision = defaultPrecision;
        this.displaySize = displaySize;
        this.isInteger = isInteger;
        this.isRational = isRational;
        this.defaultDocValues = defaultDocValues;
    }

    private DataType(JDBCType jdbcType, Class<?> javaClass, int size, int defaultPrecision, int displaySize) {
        this(jdbcType, javaClass, size, defaultPrecision, displaySize, false, false, true);
    }

    public String sqlName() {
        return this.jdbcType.getName();
    }

    public Class<?> javaClass() {
        return this.javaClass;
    }

    public boolean isNumeric() {
        return this.isInteger || this.isRational;
    }

    public boolean isSigned() {
        return this.isNumeric();
    }

    public boolean isString() {
        return this == KEYWORD || this == TEXT;
    }

    public boolean isPrimitive() {
        return this != OBJECT && this != NESTED;
    }

    public static DataType fromJdbcType(JDBCType jdbcType) {
        if (!jdbcToEs.containsKey(jdbcType)) {
            throw new IllegalArgumentException("Unsupported JDBC type [" + jdbcType + "]");
        }
        return jdbcToEs.get(jdbcType);
    }

    public static Class<?> fromJdbcTypeToJava(JDBCType jdbcType) {
        if (!jdbcToEs.containsKey(jdbcType)) {
            throw new IllegalArgumentException("Unsupported JDBC type [" + jdbcType + "]");
        }
        return jdbcToEs.get(jdbcType).javaClass();
    }

    public static DataType fromEsType(String esType) {
        return DataType.valueOf(esType.toUpperCase(Locale.ROOT));
    }

    static {
        jdbcToEs = Arrays.stream(DataType.values()).filter(dataType -> dataType != TEXT && dataType != NESTED && dataType != SCALED_FLOAT).collect(Collectors.toMap(dataType -> dataType.jdbcType, dataType -> dataType));
    }
}

