/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.range.InternalBinaryRange;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public final class BinaryRangeAggregator
extends BucketsAggregator {
    static final Comparator<Range> RANGE_COMPARATOR = (a, b) -> {
        int cmp = BinaryRangeAggregator.compare(a.from, b.from, 1);
        if (cmp == 0) {
            cmp = BinaryRangeAggregator.compare(a.to, b.to, -1);
        }
        return cmp;
    };
    final ValuesSource.Bytes valuesSource;
    final DocValueFormat format;
    final boolean keyed;
    final Range[] ranges;

    private static int compare(BytesRef a, BytesRef b, int m) {
        return a == null ? (b == null ? 0 : -m) : (b == null ? m : a.compareTo(b));
    }

    public BinaryRangeAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes valuesSource, DocValueFormat format, List<Range> ranges, boolean keyed, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.format = format;
        this.keyed = keyed;
        this.ranges = ranges.toArray(new Range[0]);
        Arrays.sort(this.ranges, RANGE_COMPARATOR);
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        if (this.valuesSource instanceof ValuesSource.Bytes.WithOrdinals) {
            SortedSetDocValues values = ((ValuesSource.Bytes.WithOrdinals)this.valuesSource).ordinalsValues(ctx);
            return new SortedSetRangeLeafCollector(values, this.ranges, sub){

                @Override
                protected void doCollect(LeafBucketCollector sub, int doc, long bucket) throws IOException {
                    BinaryRangeAggregator.this.collectBucket(sub, doc, bucket);
                }
            };
        }
        SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new SortedBinaryRangeLeafCollector(values, this.ranges, sub){

            @Override
            protected void doCollect(LeafBucketCollector sub, int doc, long bucket) throws IOException {
                BinaryRangeAggregator.this.collectBucket(sub, doc, bucket);
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        this.consumeBucketsAndMaybeBreak(this.ranges.length);
        ArrayList<InternalBinaryRange.Bucket> buckets = new ArrayList<InternalBinaryRange.Bucket>(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            long bucketOrd = bucket * (long)this.ranges.length + (long)i;
            buckets.add(new InternalBinaryRange.Bucket(this.format, this.keyed, this.ranges[i].key, this.ranges[i].from, this.ranges[i].to, this.bucketDocCount(bucketOrd), this.bucketAggregations(bucketOrd)));
        }
        return new InternalBinaryRange(this.name, this.format, this.keyed, buckets, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalBinaryRange(this.name, this.format, this.keyed, Collections.emptyList(), this.pipelineAggregators(), this.metaData());
    }

    static abstract class SortedBinaryRangeLeafCollector
    extends LeafBucketCollectorBase {
        final Range[] ranges;
        final BytesRef[] maxTos;
        final SortedBinaryDocValues values;
        final LeafBucketCollector sub;

        SortedBinaryRangeLeafCollector(SortedBinaryDocValues values, Range[] ranges, LeafBucketCollector sub) {
            super(sub, values);
            int i;
            for (i = 1; i < ranges.length; ++i) {
                if (RANGE_COMPARATOR.compare(ranges[i - 1], ranges[i]) <= 0) continue;
                throw new IllegalArgumentException("Ranges must be sorted");
            }
            this.values = values;
            this.sub = sub;
            this.ranges = ranges;
            this.maxTos = new BytesRef[ranges.length];
            if (ranges.length > 0) {
                this.maxTos[0] = ranges[0].to;
            }
            for (i = 1; i < ranges.length; ++i) {
                this.maxTos[i] = BinaryRangeAggregator.compare(ranges[i].to, this.maxTos[i - 1], -1) >= 0 ? ranges[i].to : this.maxTos[i - 1];
            }
        }

        @Override
        public void collect(int doc, long bucket) throws IOException {
            if (this.values.advanceExact(doc)) {
                int valuesCount = this.values.docValueCount();
                int lo = 0;
                for (int i = 0; i < valuesCount; ++i) {
                    BytesRef value = this.values.nextValue();
                    lo = this.collect(doc, value, bucket, lo);
                }
            }
        }

        private int collect(int doc, BytesRef value, long bucket, int lowBound) throws IOException {
            int lo = lowBound;
            int hi = this.ranges.length - 1;
            int mid = lo + hi >>> 1;
            while (lo <= hi) {
                if (BinaryRangeAggregator.compare(value, this.ranges[mid].from, 1) < 0) {
                    hi = mid - 1;
                } else {
                    if (BinaryRangeAggregator.compare(value, this.maxTos[mid], -1) < 0) break;
                    lo = mid + 1;
                }
                mid = lo + hi >>> 1;
            }
            if (lo > hi) {
                return lo;
            }
            int startLo = lo;
            int startHi = mid;
            while (startLo <= startHi) {
                int startMid = startLo + startHi >>> 1;
                if (BinaryRangeAggregator.compare(value, this.maxTos[startMid], -1) >= 0) {
                    startLo = startMid + 1;
                    continue;
                }
                startHi = startMid - 1;
            }
            int endLo = mid;
            int endHi = hi;
            while (endLo <= endHi) {
                int endMid = endLo + endHi >>> 1;
                if (BinaryRangeAggregator.compare(value, this.ranges[endMid].from, 1) < 0) {
                    endHi = endMid - 1;
                    continue;
                }
                endLo = endMid + 1;
            }
            assert (startLo == lowBound || BinaryRangeAggregator.compare(value, this.maxTos[startLo - 1], -1) >= 0);
            assert (endHi == this.ranges.length - 1 || BinaryRangeAggregator.compare(value, this.ranges[endHi + 1].from, 1) < 0);
            for (int i = startLo; i <= endHi; ++i) {
                if (BinaryRangeAggregator.compare(value, this.ranges[i].to, -1) >= 0) continue;
                this.doCollect(this.sub, doc, bucket * (long)this.ranges.length + (long)i);
            }
            return endHi + 1;
        }

        protected abstract void doCollect(LeafBucketCollector var1, int var2, long var3) throws IOException;
    }

    static abstract class SortedSetRangeLeafCollector
    extends LeafBucketCollectorBase {
        final long[] froms;
        final long[] tos;
        final long[] maxTos;
        final SortedSetDocValues values;
        final LeafBucketCollector sub;

        SortedSetRangeLeafCollector(SortedSetDocValues values, Range[] ranges, LeafBucketCollector sub) throws IOException {
            super(sub, values);
            int i;
            for (i = 1; i < ranges.length; ++i) {
                if (RANGE_COMPARATOR.compare(ranges[i - 1], ranges[i]) <= 0) continue;
                throw new IllegalArgumentException("Ranges must be sorted");
            }
            this.values = values;
            this.sub = sub;
            this.froms = new long[ranges.length];
            this.tos = new long[ranges.length];
            this.maxTos = new long[ranges.length];
            for (i = 0; i < ranges.length; ++i) {
                long ord;
                if (ranges[i].from == null) {
                    this.froms[i] = 0L;
                } else {
                    this.froms[i] = values.lookupTerm(ranges[i].from);
                    if (this.froms[i] < 0L) {
                        this.froms[i] = -1L - this.froms[i];
                    }
                }
                this.tos[i] = ranges[i].to == null ? values.getValueCount() - 1L : ((ord = values.lookupTerm(ranges[i].to)) < 0L ? -2L - ord : ord - 1L);
            }
            this.maxTos[0] = this.tos[0];
            for (i = 1; i < this.tos.length; ++i) {
                this.maxTos[i] = Math.max(this.maxTos[i - 1], this.tos[i]);
            }
        }

        @Override
        public void collect(int doc, long bucket) throws IOException {
            if (this.values.advanceExact(doc)) {
                int lo = 0;
                long ord = this.values.nextOrd();
                while (ord != -1L) {
                    lo = this.collect(doc, ord, bucket, lo);
                    ord = this.values.nextOrd();
                }
            }
        }

        private int collect(int doc, long ord, long bucket, int lowBound) throws IOException {
            int lo = lowBound;
            int hi = this.froms.length - 1;
            int mid = lo + hi >>> 1;
            while (lo <= hi) {
                if (ord < this.froms[mid]) {
                    hi = mid - 1;
                } else {
                    if (ord <= this.maxTos[mid]) break;
                    lo = mid + 1;
                }
                mid = lo + hi >>> 1;
            }
            if (lo > hi) {
                return lo;
            }
            int startLo = lo;
            int startHi = mid;
            while (startLo <= startHi) {
                int startMid = startLo + startHi >>> 1;
                if (ord > this.maxTos[startMid]) {
                    startLo = startMid + 1;
                    continue;
                }
                startHi = startMid - 1;
            }
            int endLo = mid;
            int endHi = hi;
            while (endLo <= endHi) {
                int endMid = endLo + endHi >>> 1;
                if (ord < this.froms[endMid]) {
                    endHi = endMid - 1;
                    continue;
                }
                endLo = endMid + 1;
            }
            assert (startLo == lowBound || ord > this.maxTos[startLo - 1]);
            assert (endHi == this.froms.length - 1 || ord < this.froms[endHi + 1]);
            for (int i = startLo; i <= endHi; ++i) {
                if (ord > this.tos[i]) continue;
                this.doCollect(this.sub, doc, bucket * (long)this.froms.length + (long)i);
            }
            return endHi + 1;
        }

        protected abstract void doCollect(LeafBucketCollector var1, int var2, long var3) throws IOException;
    }

    public static class Range {
        final String key;
        final BytesRef from;
        final BytesRef to;

        public Range(String key, BytesRef from, BytesRef to) {
            this.key = key;
            this.from = from;
            this.to = to;
        }
    }
}

