/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.JulianChronology;
import org.jruby.Ruby;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.lexer.StrftimeLexer;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.RubyTimeOutputFormatter;

public class RubyDateFormatter {
    private static final String[] FORMAT_MONTHS;
    private static final String[] FORMAT_SHORT_MONTHS;
    private static final String[] FORMAT_WEEKDAYS;
    private static final String[] FORMAT_SHORT_WEEKDAYS;
    private static final Token[] CONVERSION2TOKEN;
    private final Ruby runtime;
    private final StrftimeLexer lexer;

    public static void main(String[] args2) {
        StringBuilder buf = new StringBuilder("cDxFnQRrTXtvZ+z");
        for (int i2 = 65; i2 <= 122; ++i2) {
            if (Format.conversionToToken(i2) == null) continue;
            buf.append((char)i2);
        }
        System.out.println(buf.toString());
    }

    public RubyDateFormatter(ThreadContext context) {
        this.runtime = context.runtime;
        this.lexer = new StrftimeLexer((Reader)null);
    }

    private static void addToPattern(List<Token> compiledPattern, String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                compiledPattern.add(Token.format(c));
                continue;
            }
            compiledPattern.add(Token.str(Character.toString(c)));
        }
    }

    public List<Token> compilePattern(RubyString format, boolean dateLibrary) {
        return this.compilePattern(format.getByteList(), dateLibrary);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Token> compilePattern(ByteList pattern, boolean dateLibrary) {
        Encoding enc = pattern.getEncoding();
        if (!enc.isAsciiCompatible()) {
            throw this.runtime.newArgumentError("format should have ASCII compatible encoding");
        }
        LinkedList<Token> compiledPattern = new LinkedList<Token>();
        if (enc != ASCIIEncoding.INSTANCE) {
            compiledPattern.add(new Token(Format.FORMAT_ENCODING, enc));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(pattern.getUnsafeBytes(), pattern.getBegin(), pattern.getRealSize());
        InputStreamReader reader = new InputStreamReader((InputStream)in, this.runtime.getEncodingService().charsetForEncoding(pattern.getEncoding()));
        this.lexer.yyreset(reader);
        try {
            char c;
            Token token;
            block16: while ((token = this.lexer.yylex()) != null) {
                if (token.format != Format.FORMAT_SPECIAL) {
                    compiledPattern.add(token);
                    continue;
                }
                c = ((Character)token.data).charValue();
                switch (c) {
                    case 'c': {
                        RubyDateFormatter.addToPattern(compiledPattern, "a b e H:M:S Y");
                        continue block16;
                    }
                    case 'D': 
                    case 'x': {
                        RubyDateFormatter.addToPattern(compiledPattern, "m/d/y");
                        continue block16;
                    }
                    case 'F': {
                        RubyDateFormatter.addToPattern(compiledPattern, "Y-m-d");
                        continue block16;
                    }
                    case 'n': {
                        compiledPattern.add(Token.str("\n"));
                        continue block16;
                    }
                    case 'Q': {
                        if (dateLibrary) {
                            compiledPattern.add(new Token(Format.FORMAT_MICROSEC_EPOCH));
                            continue block16;
                        }
                        compiledPattern.add(Token.str("%Q"));
                        continue block16;
                    }
                    case 'R': {
                        RubyDateFormatter.addToPattern(compiledPattern, "H:M");
                        continue block16;
                    }
                    case 'r': {
                        RubyDateFormatter.addToPattern(compiledPattern, "I:M:S p");
                        continue block16;
                    }
                    case 'T': 
                    case 'X': {
                        RubyDateFormatter.addToPattern(compiledPattern, "H:M:S");
                        continue block16;
                    }
                    case 't': {
                        compiledPattern.add(Token.str("\t"));
                        continue block16;
                    }
                    case 'v': {
                        RubyDateFormatter.addToPattern(compiledPattern, "e-");
                        if (!dateLibrary) {
                            compiledPattern.add(Token.formatter(new RubyTimeOutputFormatter("^", 0)));
                        }
                        RubyDateFormatter.addToPattern(compiledPattern, "b-Y");
                        continue block16;
                    }
                    case 'Z': {
                        if (dateLibrary) {
                            compiledPattern.add(Token.zoneOffsetColons(1));
                            continue block16;
                        }
                        compiledPattern.add(new Token(Format.FORMAT_ZONE_ID));
                        continue block16;
                    }
                    case '+': {
                        if (!dateLibrary) {
                            compiledPattern.add(Token.str("%+"));
                            continue block16;
                        }
                        RubyDateFormatter.addToPattern(compiledPattern, "a b e H:M:S ");
                        compiledPattern.add(Token.zoneOffsetColons(1));
                        RubyDateFormatter.addToPattern(compiledPattern, " Y");
                        continue block16;
                    }
                }
            }
            return compiledPattern;
            throw new Error("Unknown special char: " + c);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public RubyString compileAndFormat(RubyString pattern, boolean dateLibrary, DateTime dt, long nsec2, RubyNumeric sub_millis) {
        RubyString out = this.format(this.compilePattern(pattern, dateLibrary), dt, nsec2, sub_millis);
        out.setEncoding(pattern.getEncoding());
        if (pattern.isTaint()) {
            out.setTaint(true);
        }
        return out;
    }

    public RubyString format(List<Token> compiledPattern, DateTime dt, long nsec2, RubyNumeric sub_millis) {
        return this.runtime.newString(this.formatToByteList(compiledPattern, dt, nsec2, sub_millis));
    }

    private ByteList formatToByteList(List<Token> compiledPattern, DateTime dt, long nsec2, RubyNumeric sub_millis) {
        RubyTimeOutputFormatter formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
        ByteList toAppendTo = new ByteList(24);
        block38: for (Token token : compiledPattern) {
            String formatted;
            CharSequence output = null;
            long value2 = 0L;
            FieldType type2 = FieldType.TEXT;
            Format format = token.getFormat();
            switch (format) {
                case FORMAT_ENCODING: {
                    toAppendTo.setEncoding((Encoding)token.getData());
                    continue block38;
                }
                case FORMAT_OUTPUT: {
                    formatter = (RubyTimeOutputFormatter)token.getData();
                    continue block38;
                }
                case FORMAT_STRING: {
                    output = token.getData().toString();
                    break;
                }
                case FORMAT_WEEK_LONG: {
                    int v = (dt.getDayOfWeek() + 1) % 8;
                    output = FORMAT_WEEKDAYS[v == 0 ? 1 : v];
                    break;
                }
                case FORMAT_WEEK_SHORT: {
                    int v = (dt.getDayOfWeek() + 1) % 8;
                    output = FORMAT_SHORT_WEEKDAYS[v == 0 ? 1 : v];
                    break;
                }
                case FORMAT_MONTH_LONG: {
                    output = FORMAT_MONTHS[dt.getMonthOfYear() - 1];
                    break;
                }
                case FORMAT_MONTH_SHORT: {
                    output = FORMAT_SHORT_MONTHS[dt.getMonthOfYear() - 1];
                    break;
                }
                case FORMAT_DAY: {
                    type2 = FieldType.NUMERIC2;
                    value2 = dt.getDayOfMonth();
                    break;
                }
                case FORMAT_DAY_S: {
                    type2 = FieldType.NUMERIC2BLANK;
                    value2 = dt.getDayOfMonth();
                    break;
                }
                case FORMAT_HOUR: {
                    type2 = FieldType.NUMERIC2;
                    value2 = dt.getHourOfDay();
                    break;
                }
                case FORMAT_HOUR_BLANK: {
                    type2 = FieldType.NUMERIC2BLANK;
                    value2 = dt.getHourOfDay();
                    break;
                }
                case FORMAT_HOUR_M: 
                case FORMAT_HOUR_S: {
                    value2 = dt.getHourOfDay();
                    if (value2 == 0L) {
                        value2 = 12L;
                    } else if (value2 > 12L) {
                        value2 -= 12L;
                    }
                    type2 = format == Format.FORMAT_HOUR_M ? FieldType.NUMERIC2 : FieldType.NUMERIC2BLANK;
                    break;
                }
                case FORMAT_DAY_YEAR: {
                    type2 = FieldType.NUMERIC3;
                    value2 = dt.getDayOfYear();
                    break;
                }
                case FORMAT_MINUTES: {
                    type2 = FieldType.NUMERIC2;
                    value2 = dt.getMinuteOfHour();
                    break;
                }
                case FORMAT_MONTH: {
                    type2 = FieldType.NUMERIC2;
                    value2 = dt.getMonthOfYear();
                    break;
                }
                case FORMAT_MERIDIAN: {
                    output = dt.getHourOfDay() < 12 ? "AM" : "PM";
                    break;
                }
                case FORMAT_MERIDIAN_LOWER_CASE: {
                    output = dt.getHourOfDay() < 12 ? "am" : "pm";
                    break;
                }
                case FORMAT_SECONDS: {
                    type2 = FieldType.NUMERIC2;
                    value2 = dt.getSecondOfMinute();
                    break;
                }
                case FORMAT_WEEK_YEAR_M: {
                    type2 = FieldType.NUMERIC2;
                    value2 = RubyDateFormatter.formatWeekYear(dt, 2);
                    break;
                }
                case FORMAT_WEEK_YEAR_S: {
                    type2 = FieldType.NUMERIC2;
                    value2 = RubyDateFormatter.formatWeekYear(dt, 1);
                    break;
                }
                case FORMAT_DAY_WEEK: {
                    type2 = FieldType.NUMERIC;
                    value2 = dt.getDayOfWeek() % 7;
                    break;
                }
                case FORMAT_DAY_WEEK2: {
                    type2 = FieldType.NUMERIC;
                    value2 = dt.getDayOfWeek();
                    break;
                }
                case FORMAT_YEAR_LONG: {
                    value2 = RubyDateFormatter.year(dt, dt.getYear());
                    type2 = value2 >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                    break;
                }
                case FORMAT_YEAR_SHORT: {
                    type2 = FieldType.NUMERIC2;
                    value2 = RubyDateFormatter.year(dt, dt.getYear()) % 100;
                    break;
                }
                case FORMAT_COLON_ZONE_OFF: {
                    value2 = dt.getZone().getOffset(dt.getMillis()) / 1000;
                    int colons = (Integer)token.getData();
                    output = RubyDateFormatter.formatZone(colons, (int)value2, formatter);
                    break;
                }
                case FORMAT_ZONE_ID: {
                    output = RubyTime.getRubyTimeZoneName(this.runtime, dt);
                    break;
                }
                case FORMAT_CENTURY: {
                    type2 = FieldType.NUMERIC;
                    value2 = RubyDateFormatter.year(dt, dt.getYear()) / 100;
                    break;
                }
                case FORMAT_EPOCH: {
                    type2 = FieldType.NUMERIC;
                    value2 = dt.getMillis() / 1000L;
                    break;
                }
                case FORMAT_WEEK_WEEKYEAR: {
                    type2 = FieldType.NUMERIC2;
                    value2 = dt.getWeekOfWeekyear();
                    break;
                }
                case FORMAT_MILLISEC: 
                case FORMAT_NANOSEC: {
                    StringBuilder buff;
                    int defaultWidth = format == Format.FORMAT_NANOSEC ? 9 : 3;
                    int width = formatter.getWidth(defaultWidth);
                    output = RubyTimeOutputFormatter.formatNumber(dt.getMillisOfSecond(), 3, '0');
                    if (width > 3) {
                        buff = new StringBuilder(output.length() + 6).append(output);
                        if (sub_millis == null) {
                            buff.append(RubyTimeOutputFormatter.formatNumber(nsec2, 6, '0'));
                        } else {
                            RubyDateFormatter.formatSubMillisGt3(this.runtime, buff, width, sub_millis);
                        }
                        output = buff;
                    }
                    if (width < output.length()) {
                        output = output.subSequence(0, width);
                    } else {
                        buff = new StringBuilder(width).append(output);
                        while (buff.length() < width) {
                            buff.append('0');
                        }
                        output = buff;
                    }
                    formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
                    break;
                }
                case FORMAT_WEEKYEAR: {
                    value2 = RubyDateFormatter.year(dt, dt.getWeekyear());
                    type2 = value2 >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                    break;
                }
                case FORMAT_WEEKYEAR_SHORT: {
                    type2 = FieldType.NUMERIC2;
                    value2 = RubyDateFormatter.year(dt, dt.getWeekyear()) % 100;
                    break;
                }
                case FORMAT_MICROSEC_EPOCH: {
                    type2 = FieldType.NUMERIC;
                    value2 = dt.getMillis();
                    break;
                }
                case FORMAT_SPECIAL: {
                    throw new Error("FORMAT_SPECIAL is a special token only for the lexer.");
                }
            }
            try {
                formatted = formatter.format(output, value2, type2);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw this.runtime.newErrnoFromErrno(Errno.ERANGE, "strftime");
            }
            formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
            toAppendTo.append(formatted.getBytes(this.runtime.getEncodingService().charsetForEncoding(toAppendTo.getEncoding())));
        }
        return toAppendTo;
    }

    private static void formatSubMillisGt3(Ruby runtime2, StringBuilder buff, int width, RubyNumeric sub_millis) {
        int prec = width - 3;
        ThreadContext context = runtime2.getCurrentContext();
        RubyNumeric power = (RubyNumeric)runtime2.newFixnum(10).op_pow(context, prec);
        RubyNumeric truncated = (RubyNumeric)sub_millis.numerator(context).convertToInteger().op_mul(context, power);
        truncated = (RubyNumeric)truncated.idiv(context, sub_millis.denominator(context));
        long decimals = truncated.convertToInteger().getLongValue();
        buff.append(RubyTimeOutputFormatter.formatNumber(decimals, prec, '0'));
    }

    private static int year(DateTime dt, int year2) {
        Chronology c;
        if (year2 < 0 && ((c = dt.getChronology()) instanceof JulianChronology || c instanceof GJChronology && ((GJChronology)c).getGregorianCutover().isAfter(dt))) {
            return year2 + 1;
        }
        return year2;
    }

    private static int formatWeekYear(DateTime dt, int firstDayOfWeek) {
        GregorianCalendar dtCalendar = dt.toGregorianCalendar();
        dtCalendar.setFirstDayOfWeek(firstDayOfWeek);
        dtCalendar.setMinimalDaysInFirstWeek(7);
        int value2 = dtCalendar.get(3);
        if ((value2 == 52 || value2 == 53) && dtCalendar.get(2) == 0) {
            value2 = 0;
        }
        return value2;
    }

    private static StringBuilder formatZone(int colons, int value2, RubyTimeOutputFormatter formatter) {
        int seconds = Math.abs(value2);
        int hours = seconds / 3600;
        int minutes = (seconds %= 3600) / 60;
        seconds %= 60;
        if (value2 < 0 && hours != 0) {
            hours = -hours;
        }
        CharSequence mm = RubyTimeOutputFormatter.formatNumber(minutes, 2, '0');
        CharSequence ss = RubyTimeOutputFormatter.formatNumber(seconds, 2, '0');
        char padder = formatter.getPadder('0');
        int defaultWidth = -1;
        CharSequence after = null;
        switch (colons) {
            case 0: {
                defaultWidth = 5;
                after = mm;
                break;
            }
            case 1: {
                defaultWidth = 6;
                after = new StringBuilder(mm.length() + 1).append(':').append(mm);
                break;
            }
            case 2: {
                defaultWidth = 9;
                after = new StringBuilder(mm.length() + ss.length() + 2).append(':').append(mm).append(':').append(ss);
                break;
            }
            case 3: {
                StringBuilder sb = new StringBuilder(mm.length() + ss.length() + 2);
                if (minutes != 0 || seconds != 0) {
                    sb.append(':').append(mm);
                }
                if (seconds != 0) {
                    sb.append(':').append(ss);
                }
                after = sb;
                defaultWidth = after.length() + 3;
            }
        }
        int minWidth = defaultWidth - 1;
        int width = formatter.getWidth(defaultWidth);
        if (width < minWidth) {
            width = minWidth;
        }
        StringBuilder before = RubyTimeOutputFormatter.formatSignedNumber(hours, width -= after.length(), padder);
        if (value2 < 0 && hours == 0) {
            for (int i2 = 0; i2 < before.length(); ++i2) {
                if (before.charAt(i2) != '+') continue;
                before.setCharAt(i2, '-');
            }
        }
        return new StringBuilder(before.length() + after.length()).append((CharSequence)before).append(after);
    }

    public Date parse(String source2, ParsePosition pos2) {
        throw new UnsupportedOperationException();
    }

    static {
        DateFormatSymbols FORMAT_SYMBOLS = new DateFormatSymbols(Locale.US);
        FORMAT_MONTHS = FORMAT_SYMBOLS.getMonths();
        FORMAT_SHORT_MONTHS = FORMAT_SYMBOLS.getShortMonths();
        FORMAT_WEEKDAYS = FORMAT_SYMBOLS.getWeekdays();
        FORMAT_SHORT_WEEKDAYS = FORMAT_SYMBOLS.getShortWeekdays();
        CONVERSION2TOKEN = new Token[256];
    }

    static enum FieldType {
        NUMERIC('0', 0),
        NUMERIC2('0', 2),
        NUMERIC2BLANK(' ', 2),
        NUMERIC3('0', 3),
        NUMERIC4('0', 4),
        NUMERIC5('0', 5),
        TEXT(' ', 0);

        final char defaultPadder;
        final int defaultWidth;

        private FieldType(char padder, int width) {
            this.defaultPadder = padder;
            this.defaultWidth = width;
        }
    }

    public static class Token {
        private final Format format;
        private final Object data;

        protected Token(Format format) {
            this(format, null);
        }

        protected Token(Format formatString, Object data2) {
            this.format = formatString;
            this.data = data2;
        }

        public static Token str(String str) {
            return new Token(Format.FORMAT_STRING, str);
        }

        public static Token format(char c) {
            return Format.conversionToToken(c);
        }

        public static Token zoneOffsetColons(int colons) {
            return new Token(Format.FORMAT_COLON_ZONE_OFF, colons);
        }

        public static Token special(char c) {
            return new Token(Format.FORMAT_SPECIAL, Character.valueOf(c));
        }

        public static Token formatter(RubyTimeOutputFormatter formatter) {
            return new Token(Format.FORMAT_OUTPUT, formatter);
        }

        public Object getData() {
            return this.data;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "<Token " + (Object)((Object)this.format) + " " + this.data + ">";
        }
    }

    static enum Format {
        FORMAT_ENCODING,
        FORMAT_STRING,
        FORMAT_OUTPUT,
        FORMAT_SPECIAL,
        FORMAT_WEEK_LONG('A'),
        FORMAT_WEEK_SHORT('a'),
        FORMAT_MONTH_LONG('B'),
        FORMAT_MONTH_SHORT('b', 'h'),
        FORMAT_CENTURY('C'),
        FORMAT_DAY('d'),
        FORMAT_DAY_S('e'),
        FORMAT_WEEKYEAR('G'),
        FORMAT_WEEKYEAR_SHORT('g'),
        FORMAT_HOUR('H'),
        FORMAT_HOUR_M('I'),
        FORMAT_DAY_YEAR('j'),
        FORMAT_HOUR_BLANK('k'),
        FORMAT_MILLISEC('L'),
        FORMAT_HOUR_S('l'),
        FORMAT_MINUTES('M'),
        FORMAT_MONTH('m'),
        FORMAT_NANOSEC('N'),
        FORMAT_MERIDIAN_LOWER_CASE('P'),
        FORMAT_MERIDIAN('p'),
        FORMAT_SECONDS('S'),
        FORMAT_EPOCH('s'),
        FORMAT_WEEK_YEAR_S('U'),
        FORMAT_DAY_WEEK2('u'),
        FORMAT_WEEK_WEEKYEAR('V'),
        FORMAT_WEEK_YEAR_M('W'),
        FORMAT_DAY_WEEK('w'),
        FORMAT_YEAR_LONG('Y'),
        FORMAT_YEAR_SHORT('y'),
        FORMAT_COLON_ZONE_OFF,
        FORMAT_ZONE_ID,
        FORMAT_MICROSEC_EPOCH;


        private Format() {
        }

        private Format(char conversion) {
            Format.addToConversions(conversion, new Token(this));
        }

        private Format(char conversion, char alias) {
            this(conversion);
            Format.addToConversions(alias, Format.conversionToToken(conversion));
        }

        private static void addToConversions(char conversion, Token token) {
            CONVERSION2TOKEN[conversion] = token;
        }

        private static Token conversionToToken(int conversion) {
            return CONVERSION2TOKEN[conversion];
        }
    }
}

