#ifndef _EFL_CONTENT_EO_H_
#define _EFL_CONTENT_EO_H_

#ifndef _EFL_CONTENT_EO_CLASS_TYPE
#define _EFL_CONTENT_EO_CLASS_TYPE

typedef Eo Efl_Content;

#endif

#ifndef _EFL_CONTENT_EO_TYPES
#define _EFL_CONTENT_EO_TYPES


#endif
/**
 * @brief Common interface for objects that have a (single) content.
 *
 * This is used for the default content part of widgets, as well as for
 * individual parts through @ref Efl_Part.
 *
 * @ingroup Efl_Content
 */
#define EFL_CONTENT_INTERFACE efl_content_interface_get()

EWAPI const Efl_Class *efl_content_interface_get(void);

/**
 * @brief Swallowed sub-object contained in this object.
 *
 * @param[in] obj The object.
 * @param[in] content The object to swallow.
 *
 * @return @c true on success, @c false otherwise
 *
 * @ingroup Efl_Content
 */
EOAPI Eina_Bool efl_content_set(Eo *obj, Efl_Gfx_Entity *content);

/**
 * @brief Swallowed sub-object contained in this object.
 *
 * @param[in] obj The object.
 *
 * @return The object to swallow.
 *
 * @ingroup Efl_Content
 */
EOAPI Efl_Gfx_Entity *efl_content_get(const Eo *obj);

/**
 * @brief Unswallow the object in the current container and return it.
 *
 * @param[in] obj The object.
 *
 * @return Unswallowed object
 *
 * @ingroup Efl_Content
 */
EOAPI Efl_Gfx_Entity *efl_content_unset(Eo *obj);

#endif
