// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceMX;

/**
 * The base class for metrics. A metrics object represents a
 * collection of measurements associated to a given a system.
 **/
public class Metrics extends com.zeroc.Ice.Value
{
    public Metrics()
    {
        this.id = "";
        this.total = 0L;
        this.current = 0;
        this.totalLifetime = 0L;
        this.failures = 0;
    }

    public Metrics(String id, long total, int current, long totalLifetime, int failures)
    {
        this.id = id;
        this.total = total;
        this.current = current;
        this.totalLifetime = totalLifetime;
        this.failures = failures;
    }

    /**
     * The metrics identifier.
     **/
    public String id;

    /**
     * The total number of objects that were observed by this metrics.
     **/
    public long total;

    /**
     * The current number of objects observed by this metrics.
     **/
    public int current;

    /**
     * The sum of the lifetime of each observed objects. This does not
     * include the lifetime of objects which are currently observed.
     **/
    public long totalLifetime;

    /**
     * The number of failures observed.
     **/
    public int failures;

    public Metrics clone()
    {
        return (Metrics)super.clone();
    }

    public static String ice_staticId()
    {
        return "::IceMX::Metrics";
    }

    @Override
    public String ice_id()
    {
        return ice_staticId();
    }

    public static final long serialVersionUID = 5637578887472768063L;

    @Override
    protected void _iceWriteImpl(com.zeroc.Ice.OutputStream ostr_)
    {
        ostr_.startSlice(ice_staticId(), -1, true);
        ostr_.writeString(id);
        ostr_.writeLong(total);
        ostr_.writeInt(current);
        ostr_.writeLong(totalLifetime);
        ostr_.writeInt(failures);
        ostr_.endSlice();
    }

    @Override
    protected void _iceReadImpl(com.zeroc.Ice.InputStream istr_)
    {
        istr_.startSlice();
        id = istr_.readString();
        total = istr_.readLong();
        current = istr_.readInt();
        totalLifetime = istr_.readLong();
        failures = istr_.readInt();
        istr_.endSlice();
    }
}
