/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.logging.NbLogging;
import org.openide.util.RequestProcessor;

public final class PrintStreamLogger
extends PrintStream
implements Runnable {
    static final int BUFFER_THRESHOLD = 0x200000;
    private static final int BUFFER_MIN_CAPACITY = 0x100000;
    static final int BUFFER_SHRINK_TIME = 10000;
    private static final int BUFFER_CAPACITY_DIV = 5;
    private Logger log;
    private final Object lock = new String("lock");
    private StringBuilder sb = new StringBuilder();
    private int bufferTop = 0;
    private int maxBufferSize;
    private long lastCleanupTime;
    private static RequestProcessor RP = new RequestProcessor("StdErr Flush");
    private RequestProcessor.Task flush = RP.create((Runnable)this, true);
    private final RequestProcessor.Task cleanupTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PrintStreamLogger.this.lock;
            synchronized (object) {
                PrintStreamLogger.this.maybeFreeBuffer();
            }
        }
    });

    private PrintStreamLogger(Logger logger) {
        super(new ByteArrayOutputStream());
        this.log = logger;
    }

    public static boolean isLogger(PrintStream printStream) {
        return printStream.getClass().getName().equals(PrintStreamLogger.class.getName());
    }

    public static PrintStream create(String string) {
        return new PrintStreamLogger(Logger.getLogger(string));
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        String string = new String(byArray, n, n2);
        this.print(string);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        if (RP.isRequestProcessorThread()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.sb.append((char)n);
            this.checkFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String string) {
        if (NbLogging.DEBUG != null && !NbLogging.wantsMessage(string)) {
            new Exception().printStackTrace(NbLogging.DEBUG);
        }
        Object object = this.lock;
        synchronized (object) {
            this.sb.append(string);
            this.checkFlush();
        }
    }

    @Override
    public void println(String string) {
        this.print(string);
        this.print(System.getProperty("line.separator"));
    }

    @Override
    public void println(Object object) {
        String string = String.valueOf(object);
        this.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            bl = this.sb.length() == 0;
        }
        if (!bl) {
            try {
                this.flush.schedule(0);
                this.flush.waitFinished(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.flush();
    }

    private void checkFlush() {
        boolean bl = this.sb.length() - this.bufferTop > 0x200000;
        try {
            this.flush.schedule(bl ? 0 : 100);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void maybeFreeBuffer() {
        int n = this.sb.capacity();
        long l = System.currentTimeMillis();
        if (l - this.lastCleanupTime > 10000L) {
            if (n > 0x100000 && n / 5 > this.maxBufferSize) {
                this.sb = new StringBuilder(this.sb);
            }
            this.maxBufferSize = this.sb.length();
            this.lastCleanupTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block3: while (true) {
            String string;
            int n;
            Object object = this.lock;
            synchronized (object) {
                if (this.sb.length() == 0) {
                    break;
                }
                this.maxBufferSize = Math.max(this.maxBufferSize, this.sb.length());
                n = -1;
                for (int i = this.sb.length() - 1; i >= this.bufferTop; --i) {
                    if (this.sb.charAt(i) != '\n') continue;
                    n = i;
                    break;
                }
                if (n == -1) {
                    this.bufferTop = this.sb.length();
                    break;
                }
                string = this.sb.substring(0, n + 1);
                this.sb.delete(0, n + 1);
                this.bufferTop = this.sb.length();
                this.maybeFreeBuffer();
                this.cleanupTask.schedule(10000);
                this.lock.notifyAll();
            }
            int n2 = 0;
            while (true) {
                if (n2 >= string.length()) continue block3;
                n = string.indexOf(10, n2);
                this.log.log(Level.INFO, string.substring(n2, n + 1));
                n2 = n + 1;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] bufferSizes() {
        Object object = this.lock;
        synchronized (object) {
            return new int[]{this.sb.length(), this.sb.capacity()};
        }
    }
}

