/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.BaseUtilities;

abstract class WeakListenerImpl
implements EventListener {
    private static final Logger LOG = Logger.getLogger(WeakListenerImpl.class.getName());
    private ListenerReference ref;
    Class<?> listenerClass;
    private Reference<Object> source;

    protected WeakListenerImpl(Class<?> clazz, EventListener eventListener) {
        this(clazz, eventListener, null);
    }

    protected WeakListenerImpl(Class<?> clazz, EventListener eventListener, String string) {
        this.listenerClass = clazz;
        this.ref = new ListenerReference(eventListener, string, this);
    }

    protected final void setSource(Object object) {
        this.source = object == null ? null : new WeakReference<Object>(object);
    }

    final Object getSource() {
        Reference<Object> reference = this.source;
        return reference == null ? null : reference.get();
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject eventObject) {
        Object t = this.ref.get();
        if (t == null) {
            this.ref.requestCleanUp(eventObject == null ? null : eventObject.getSource());
        }
        return (EventListener)t;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Object t = this.ref.get();
        return this.getClass().getName() + "[" + (t == null ? "null" : t.getClass().getName() + "]");
    }

    public static <T extends EventListener> T create(Class<T> clazz, Class<? super T> clazz2, T t, Object object) {
        ProxyListener proxyListener = new ProxyListener(clazz, clazz2, t);
        proxyListener.setSource(object);
        return (T)((EventListener)clazz.cast(proxyListener.proxy));
    }

    private static final class ListenerReference
    extends WeakReference<Object>
    implements Runnable {
        private static Class<?> lastClass;
        private static Class<?> lastNClass;
        private static String lastMethodName;
        private static String lastNMethodName;
        private static Method lastRemove;
        private static Method lastNRemove;
        private static final Object LOCK;
        WeakListenerImpl weakListener;
        private String name;

        ListenerReference(Object object, String string, WeakListenerImpl weakListenerImpl) {
            super(object, BaseUtilities.activeReferenceQueue());
            this.weakListener = weakListenerImpl;
            this.name = string;
        }

        public synchronized void requestCleanUp(Object object) {
            if (this.weakListener == null) {
                return;
            }
            if (this.weakListener.getSource() != object) {
                this.weakListener.source = new WeakReference<Object>(object){
                    ListenerReference doNotGCRef;
                    {
                        this.doNotGCRef = new ListenerReference(new Object(), ListenerReference.this.name, ListenerReference.this.weakListener);
                    }
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                WeakListenerImpl weakListenerImpl;
                Object object = null;
                Method method = null;
                Class<Object> clazz = this;
                synchronized (clazz) {
                    block29: {
                        block28: {
                            weakListenerImpl = this.weakListener;
                            if (weakListenerImpl.source == null) break block28;
                            Object t = weakListenerImpl.source.get();
                            object = t;
                            if (t != null) break block29;
                        }
                        return;
                    }
                    this.weakListener = null;
                }
                clazz = object instanceof Class ? (Class)object : object.getClass();
                String string = weakListenerImpl.removeMethodName();
                Object object2 = LOCK;
                synchronized (object2) {
                    if (this.name == null) {
                        if (lastClass == clazz && lastRemove != null && string.equals(lastMethodName)) {
                            method = lastRemove;
                        }
                    } else if (lastNClass == clazz && lastNRemove != null && string.equals(lastNMethodName)) {
                        method = lastNRemove;
                    }
                }
                if (method == null) {
                    if (this.name == null) {
                        method = this.getRemoveMethod(clazz, string, weakListenerImpl.listenerClass);
                    }
                    if (method == null) {
                        method = this.getRemoveMethod(clazz, string, String.class, weakListenerImpl.listenerClass);
                    }
                    if (method == null) {
                        LOG.log(Level.WARNING, "Can''t remove {0} using method {1}.{2} from {3}", new Object[]{weakListenerImpl.listenerClass.getName(), clazz.getName(), string, object});
                        return;
                    }
                    object2 = LOCK;
                    synchronized (object2) {
                        if (this.name == null) {
                            lastClass = clazz;
                            lastMethodName = string;
                            lastRemove = method;
                        } else {
                            lastNClass = clazz;
                            lastNMethodName = string;
                            lastNRemove = method;
                        }
                    }
                }
                try {
                    if (method.getParameterTypes().length == 1) {
                        method.invoke(object, weakListenerImpl.getImplementator());
                    } else {
                        object2 = this.name == null ? "" : this.name;
                        method.invoke(object, object2, weakListenerImpl.getImplementator());
                    }
                }
                catch (Exception exception) {
                    if ("removePreferenceChangeListener".equals(string) || "removeNodeChangeListener".equals(string)) break block27;
                    String string2 = "Problem encountered while calling " + clazz + "." + string + "(" + method + ") on " + object + "\n" + weakListenerImpl.getImplementator();
                    LOG.warning(string2);
                    boolean bl = exception instanceof InvocationTargetException || "object is not an instance of declaring class".equals(exception.getMessage());
                    LOG.log(Level.WARNING, bl ? string2 : null, exception);
                }
            }
        }

        private Method getRemoveMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            Method method = null;
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                do {
                    try {
                        method = clazz.getDeclaredMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                    clazz = clazz.getSuperclass();
                } while (method == null && clazz != Object.class);
            }
            catch (RuntimeException runtimeException) {
                LOG.log(Level.WARNING, "called get[Declared]Method on " + clazz.getName(), runtimeException);
            }
            catch (LinkageError linkageError) {
                LOG.log(Level.WARNING, null, linkageError);
            }
            if (!(method == null || Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
                method.setAccessible(true);
            }
            return method;
        }

        static {
            LOCK = new Object();
        }
    }

    private static class ProxyListener
    extends WeakListenerImpl
    implements InvocationHandler {
        private static Method equalsMth;
        private static final Map<Class<?>, Reference<Constructor<?>>> constructors;
        public final Object proxy;

        ProxyListener(Class<?> clazz, Class<?> clazz2, EventListener eventListener) {
            super(clazz2, eventListener);
            try {
                Object object;
                Constructor<?> constructor;
                Reference<Constructor<?>> reference = constructors.get(clazz);
                Constructor<?> constructor2 = constructor = reference == null ? null : reference.get();
                if (constructor == null) {
                    object = Proxy.getProxyClass(clazz.getClassLoader(), clazz);
                    constructor = ((Class)object).getConstructor(InvocationHandler.class);
                    constructor.setAccessible(true);
                    constructors.put(clazz, new SoftReference(constructor));
                }
                try {
                    object = constructor.newInstance(this);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
                }
                this.proxy = object;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }

        private static Method getEquals() {
            if (equalsMth == null) {
                try {
                    equalsMth = Object.class.getMethod("equals", Object.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
            }
            return equalsMth;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                if (method.getDeclaringClass() == Object.class) {
                    if (method == ProxyListener.getEquals()) {
                        return this.equals(objectArray[0]);
                    }
                    return method.invoke((Object)this, objectArray);
                }
                EventObject eventObject = objectArray != null && objectArray[0] instanceof EventObject ? (EventObject)objectArray[0] : null;
                EventListener eventListener = super.get(eventObject);
                if (eventListener != null) {
                    return method.invoke((Object)eventListener, objectArray);
                }
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }

        @Override
        protected String removeMethodName() {
            String string = this.listenerClass.getName();
            int n = string.lastIndexOf(46);
            int n2 = (string = string.substring(n + 1)).lastIndexOf(36);
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            return "remove".concat(string);
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.listenerClass + "]";
        }

        public boolean equals(Object object) {
            return this.proxy == object || this == object;
        }

        @Override
        Object getImplementator() {
            return this.proxy;
        }

        static {
            constructors = Collections.synchronizedMap(new WeakHashMap());
        }
    }

    static final class Focus
    extends WeakListenerImpl
    implements FocusListener {
        Focus(FocusListener focusListener) {
            super(FocusListener.class, focusListener);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeFocusListener";
        }
    }

    static final class Change
    extends WeakListenerImpl
    implements ChangeListener {
        Change(ChangeListener changeListener) {
            super(ChangeListener.class, changeListener);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ChangeListener changeListener = (ChangeListener)super.get(changeEvent);
            if (changeListener != null) {
                changeListener.stateChanged(changeEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeChangeListener";
        }
    }

    static final class Document
    extends WeakListenerImpl
    implements DocumentListener {
        Document(DocumentListener documentListener) {
            super(DocumentListener.class, documentListener);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.changedUpdate(documentEvent);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.insertUpdate(documentEvent);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.removeUpdate(documentEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent documentEvent) {
            DocumentListener documentListener = (DocumentListener)((WeakListenerImpl)this).ref.get();
            if (documentListener == null) {
                ((WeakListenerImpl)this).ref.requestCleanUp(documentEvent.getDocument());
            }
            return documentListener;
        }
    }

    static class VetoableChange
    extends WeakListenerImpl
    implements VetoableChangeListener {
        VetoableChange(VetoableChangeListener vetoableChangeListener) {
            super(VetoableChangeListener.class, vetoableChangeListener);
        }

        VetoableChange(VetoableChangeListener vetoableChangeListener, String string) {
            super(VetoableChangeListener.class, vetoableChangeListener, string);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)super.get(propertyChangeEvent);
            if (vetoableChangeListener != null) {
                vetoableChangeListener.vetoableChange(propertyChangeEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }
    }

    static class PropertyChange
    extends WeakListenerImpl
    implements PropertyChangeListener {
        PropertyChange(PropertyChangeListener propertyChangeListener) {
            super(PropertyChangeListener.class, propertyChangeListener);
        }

        PropertyChange(Class<?> clazz, PropertyChangeListener propertyChangeListener) {
            super(clazz, propertyChangeListener);
        }

        PropertyChange(PropertyChangeListener propertyChangeListener, String string) {
            super(PropertyChangeListener.class, propertyChangeListener, string);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)super.get(propertyChangeEvent);
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }

        @Override
        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }
    }
}

