/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum JobState implements Writeable
{
    CLOSING,
    CLOSED,
    OPENED,
    FAILED,
    OPENING;


    public static JobState fromString(String name) {
        return JobState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static JobState fromStream(StreamInput in) throws IOException {
        return (JobState)in.readEnum(JobState.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        JobState state = this;
        if (this == OPENING && out.getVersion().before(Version.V_5_5_0)) {
            state = CLOSED;
        }
        out.writeEnum((Enum)state);
    }

    public String value() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isAnyOf(JobState ... candidates) {
        return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

