/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.search;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.search.searches.SuperMethodsSearch;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.QueryExecutor;

public class MethodSuperSearcher
implements QueryExecutor<MethodSignatureBackedByPsiMethod, SuperMethodsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.MethodSuperSearcher");

    @Override
    public boolean execute(@NotNull SuperMethodsSearch.SearchParameters queryParameters, @NotNull Processor<MethodSignatureBackedByPsiMethod> consumer) {
        if (queryParameters == null) {
            MethodSuperSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MethodSuperSearcher.$$$reportNull$$$0(1);
        }
        PsiClass parentClass = queryParameters.getPsiClass();
        PsiMethod method = queryParameters.getMethod();
        return ReadAction.compute(() -> {
            if (queryParameters == null) {
                MethodSuperSearcher.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                MethodSuperSearcher.$$$reportNull$$$0(3);
            }
            HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
            boolean checkBases = queryParameters.isCheckBases();
            boolean allowStaticMethod = queryParameters.isAllowStaticMethod();
            List<HierarchicalMethodSignature> supers = signature.getSuperSignatures();
            for (HierarchicalMethodSignature superSignature : supers) {
                if (!MethodSignatureUtil.isSubsignature(superSignature, signature) || MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean addSuperMethods(HierarchicalMethodSignature signature, PsiMethod method, PsiClass parentClass, boolean allowStaticMethod, boolean checkBases, Processor<MethodSignatureBackedByPsiMethod> consumer) {
        PsiMethod signatureMethod = signature.getMethod();
        PsiClass hisClass = signatureMethod.getContainingClass();
        if ((parentClass == null || InheritanceUtil.isInheritorOrSelf(parentClass, hisClass, true)) && MethodSuperSearcher.isAcceptable(signatureMethod, method, allowStaticMethod)) {
            if (parentClass != null && !parentClass.equals(hisClass) && !checkBases) {
                return true;
            }
            LOG.assertTrue(signatureMethod != method, method);
            return consumer.process(signature);
        }
        for (HierarchicalMethodSignature superSignature : signature.getSuperSignatures()) {
            if (!MethodSignatureUtil.isSubsignature(superSignature, signature)) continue;
            MethodSuperSearcher.addSuperMethods(superSignature, method, parentClass, allowStaticMethod, checkBases, consumer);
        }
        return true;
    }

    private static boolean isAcceptable(PsiMethod superMethod, PsiMethod method, boolean allowStaticMethod) {
        boolean hisStatic = superMethod.hasModifierProperty("static");
        return hisStatic == method.hasModifierProperty("static") && (allowStaticMethod || !hisStatic) && JavaPsiFacade.getInstance(method.getProject()).getResolveHelper().isAccessible(superMethod, method, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/search/MethodSuperSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

