/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackFrameSegment
extends TagBounds {
    private static final int FRAME_DIV = 512;
    HprofHeap hprofHeap;
    final int methodIDOffset;
    final int stackFrameIDOffset;
    final int lengthOffset;
    final int sourceIDOffset;
    final int methodSignatureIDOffset;
    final int timeOffset;
    final int classSerialNumberOffset;
    final int lineNumberOffset;
    private Map idToFrame;
    private Map classCache = Collections.synchronizedMap(new LoadClassCache());

    StackFrameSegment(HprofHeap hprofHeap, long l, long l2) {
        super(4, l, l2);
        int n = hprofHeap.dumpBuffer.getIDSize();
        this.hprofHeap = hprofHeap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackFrameIDOffset = this.lengthOffset + 4;
        this.methodIDOffset = this.stackFrameIDOffset + n;
        this.methodSignatureIDOffset = this.methodIDOffset + n;
        this.sourceIDOffset = this.methodSignatureIDOffset + n;
        this.classSerialNumberOffset = this.sourceIDOffset + n;
        this.lineNumberOffset = this.classSerialNumberOffset + 4;
    }

    StackFrame getStackFrameByID(long l) {
        this.initIdToFrame();
        Long l2 = (Long)this.idToFrame.get(new Long(l / 512L));
        if (l2 == null) {
            l2 = new Long(this.startOffset);
        }
        long[] lArray = new long[]{l2};
        while (lArray[0] < this.endOffset) {
            long l3 = lArray[0];
            long l4 = this.readStackFrameTag(lArray);
            if (l4 != l) continue;
            return new StackFrame(this, l3);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        return this.hprofHeap.dumpBuffer;
    }

    private long readStackFrameTag(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 4) {
            return 0L;
        }
        return this.getDumpBuffer().getID(l + (long)this.stackFrameIDOffset);
    }

    private synchronized void initIdToFrame() {
        if (this.idToFrame == null) {
            long[] lArray = new long[]{this.startOffset};
            this.idToFrame = new HashMap();
            while (lArray[0] < this.endOffset) {
                long l = lArray[0];
                long l2 = this.readStackFrameTag(lArray);
                Long l3 = new Long(l2 / 512L);
                Long l4 = (Long)this.idToFrame.get(l3);
                if (l4 != null && l4 <= l) continue;
                this.idToFrame.put(l3, new Long(l));
            }
        }
    }

    String getClassNameBySerialNumber(int n) {
        Integer n2 = n;
        String string = (String)this.classCache.get(n2);
        if (string == null) {
            LoadClass loadClass = this.hprofHeap.getLoadClassSegment().getClassBySerialNumber(n);
            string = loadClass != null ? loadClass.getName() : "N/A";
            this.classCache.put(n2, string);
        }
        return string;
    }

    private static class LoadClassCache
    extends LinkedHashMap {
        private static final int SIZE = 1000;

        LoadClassCache() {
            super(1000, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 1000;
        }
    }
}

