/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.embed.EmbeddedSceneDragSourceInterface;
import com.sun.javafx.tk.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javafx.embed.swing.DataFlavorUtils;
import javafx.embed.swing.SwingDnD;
import javafx.scene.input.TransferMode;

final class SwingDragSource
implements EmbeddedSceneDragSourceInterface {
    private Map<String, Object> mimeType2Data = Collections.EMPTY_MAP;
    private int sourceActions;
    private Set<TransferMode> cachedTransferModes;

    SwingDragSource(DropTargetDragEvent dropTargetDragEvent) {
        this.setContents(dropTargetDragEvent);
    }

    void updateContents(DropTargetDragEvent dropTargetDragEvent) {
        this.updateSourceActions(dropTargetDragEvent.getSourceActions());
        this.updateData(dropTargetDragEvent.getTransferable());
    }

    private void setContents(DropTargetDragEvent dropTargetDragEvent) {
        this.sourceActions = 0;
        this.cachedTransferModes = null;
        this.mimeType2Data = Collections.EMPTY_MAP;
        this.updateContents(dropTargetDragEvent);
    }

    private void updateSourceActions(int n) {
        if (n != this.sourceActions) {
            this.sourceActions = n;
            this.cachedTransferModes = null;
        }
    }

    private void updateData(Transferable transferable) {
        Map<String, DataFlavor> map = DataFlavorUtils.adjustSwingDataFlavors(transferable.getTransferDataFlavors());
        if (((Object)map.keySet()).equals(this.mimeType2Data.keySet())) {
            return;
        }
        try {
            this.mimeType2Data = DataFlavorUtils.readAllData(transferable, map);
        }
        catch (Exception exception) {
            this.mimeType2Data = Collections.EMPTY_MAP;
        }
    }

    @Override
    public Set<TransferMode> getSupportedActions() {
        assert (Toolkit.getToolkit().isFxUserThread());
        if (this.cachedTransferModes == null) {
            this.cachedTransferModes = SwingDnD.dropActionsToTransferModes(this.sourceActions);
        }
        return this.cachedTransferModes;
    }

    @Override
    public Object getData(String string) {
        assert (Toolkit.getToolkit().isFxUserThread());
        return this.mimeType2Data.get(string);
    }

    @Override
    public String[] getMimeTypes() {
        assert (Toolkit.getToolkit().isFxUserThread());
        return this.mimeType2Data.keySet().toArray(new String[0]);
    }

    @Override
    public boolean isMimeTypeAvailable(String string) {
        assert (Toolkit.getToolkit().isFxUserThread());
        return Arrays.asList(this.getMimeTypes()).contains(string);
    }

    @Override
    public void dragDropEnd(TransferMode transferMode) {
        throw new UnsupportedOperationException();
    }
}

