/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.modules;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.openide.modules.ConstructorDelegate;
import org.openide.modules.PatchFor;
import org.openide.modules.PatchedPublic;

public class PatchedPublicProcessor
extends AbstractProcessor {
    private static final Set<String> ANNOTATIONS = new HashSet<String>(Arrays.asList(PatchedPublic.class.getCanonicalName(), PatchFor.class.getCanonicalName(), ConstructorDelegate.class.getCanonicalName()));
    private List<Element> originatingElements;
    private Map<String, String> superclasses = new HashMap<String, String>();
    private TypeElement implForElement;
    private Element valueElement;
    private boolean reported;
    private static final String IMPL_FOR_NAME = PatchFor.class.getName();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ANNOTATIONS;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.originatingElements = new ArrayList<Element>();
    }

    private void flush(RoundEnvironment roundEnvironment) {
        if (!this.originatingElements.isEmpty()) {
            try (OutputStream outputStream = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/.bytecodePatched", this.originatingElements.toArray(new Element[this.originatingElements.size()])).openOutputStream();){
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                for (Map.Entry<String, String> entry : this.superclasses.entrySet()) {
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    bufferedWriter.append("extend.").append(string).append("=").append(string2);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.getMessage());
            }
        }
    }

    private TypeElement getImplFor() {
        this.implForElement = this.processingEnv.getElementUtils().getTypeElement(IMPL_FOR_NAME);
        if (this.implForElement == null) {
            if (!this.reported) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot find @ImplementationFor annotation");
                this.reported = true;
            }
            return null;
        }
        for (Element element : this.implForElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals("value")) continue;
            this.valueElement = element;
            break;
        }
        return this.implForElement;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            this.flush(roundEnvironment);
            return false;
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(PatchedPublic.class)) {
            if (element.getAnnotationMirrors().size() > 1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot currently mix @PatchedPublic with other annotations", element);
                continue;
            }
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@PatchedPublic cannot be applied to what is already public", element);
                continue;
            }
            this.originatingElements.add(element);
        }
        block1: for (Element element : roundEnvironment.getElementsAnnotatedWith(PatchFor.class)) {
            AnnotatedConstruct annotatedConstruct;
            Object object;
            List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
            String string = null;
            TypeElement typeElement = null;
            for (AnnotationMirror annotationMirror : list) {
                object = annotationMirror.getAnnotationType().asElement();
                if (object != this.getImplFor()) continue;
                AnnotationValue annotationValue = annotationMirror.getElementValues().get(this.valueElement);
                if (!(annotationValue.getValue() instanceof DeclaredType)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Value for @PatchFor must be a valid class", element);
                    continue block1;
                }
                annotatedConstruct = ((DeclaredType)annotationValue.getValue()).asElement();
                if (!(annotatedConstruct instanceof TypeElement)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Value for @PatchFor must be a valid class", element);
                    continue block1;
                }
                typeElement = (TypeElement)annotatedConstruct;
                if (typeElement.getKind() != ElementKind.CLASS) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@PatchFor can be only applied on classes", element);
                    continue block1;
                }
                string = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
                break;
            }
            if (typeElement == null) {
                throw new IllegalStateException();
            }
            TypeElement typeElement2 = (TypeElement)element;
            boolean bl = false;
            for (Element element2 : typeElement2.getEnclosedElements()) {
                if (element2.getKind() != ElementKind.CONSTRUCTOR || !((ExecutableElement)element2).getParameters().isEmpty()) continue;
                boolean bl2 = true;
                break;
            }
            object = this.processingEnv.getElementUtils().getBinaryName(typeElement2).toString();
            TypeMirror typeMirror = typeElement2.getSuperclass();
            annotatedConstruct = typeElement.getSuperclass();
            if (!this.processingEnv.getTypeUtils().isSameType(typeMirror, (TypeMirror)annotatedConstruct)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "API class and the substitue differ in their superclasses", element);
                continue;
            }
            this.superclasses.put(string, (String)object);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Adding injection of " + (String)object + " as a superclass of API " + string);
            this.originatingElements.add(element);
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

