/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.IonValue;
import software.amazon.ion.impl.IonReaderBinarySystemX;
import software.amazon.ion.impl.IonReaderBinaryUserX;
import software.amazon.ion.impl.IonReaderTextSystemX;
import software.amazon.ion.impl.IonReaderTextUserX;
import software.amazon.ion.impl.IonReaderTreeSystem;
import software.amazon.ion.impl.IonReaderTreeUserX;
import software.amazon.ion.impl.PrivateIonConstants;
import software.amazon.ion.impl.UnifiedInputStreamX;
import software.amazon.ion.util.IonStreamUtils;

@Deprecated
public final class PrivateIonReaderFactory {
    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, byte[] bytes2) {
        return PrivateIonReaderFactory.makeReader(system, catalog, bytes2, 0, bytes2.length);
    }

    public static IonReader makeSystemReader(IonSystem system, byte[] bytes2) {
        return PrivateIonReaderFactory.makeSystemReader(system, bytes2, 0, bytes2.length);
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, byte[] bytes2, int offset, int length) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(bytes2, offset, length);
            return PrivateIonReaderFactory.makeReader(system, catalog, uis, offset);
        }
        catch (IOException e2) {
            throw new IonException(e2);
        }
    }

    public static IonReader makeSystemReader(IonSystem system, byte[] bytes2, int offset, int length) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(bytes2, offset, length);
            return PrivateIonReaderFactory.makeSystemReader(system, uis, offset);
        }
        catch (IOException e2) {
            throw new IonException(e2);
        }
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, char[] chars2) {
        return PrivateIonReaderFactory.makeReader(system, catalog, chars2, 0, chars2.length);
    }

    public static final IonReader makeSystemReader(IonSystem system, char[] chars2) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2);
        return new IonReaderTextSystemX(system, in);
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, char[] chars2, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2, offset, length);
        return new IonReaderTextUserX(system, catalog, in, offset);
    }

    public static final IonReader makeSystemReader(IonSystem system, char[] chars2, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2, offset, length);
        return new IonReaderTextSystemX(system, in);
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, CharSequence chars2) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2);
        return new IonReaderTextUserX(system, catalog, in);
    }

    public static final IonReader makeSystemReader(IonSystem system, CharSequence chars2) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2);
        return new IonReaderTextSystemX(system, in);
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, CharSequence chars2, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2, offset, length);
        return new IonReaderTextUserX(system, catalog, in, offset);
    }

    public static final IonReader makeSystemReader(IonSystem system, CharSequence chars2, int offset, int length) {
        UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2, offset, length);
        return new IonReaderTextSystemX(system, in);
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, InputStream is2) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(is2);
            return PrivateIonReaderFactory.makeReader(system, catalog, uis, 0);
        }
        catch (IOException e2) {
            throw new IonException(e2);
        }
    }

    public static IonReader makeSystemReader(IonSystem system, InputStream is2) {
        try {
            UnifiedInputStreamX uis = PrivateIonReaderFactory.makeUnifiedStream(is2);
            return PrivateIonReaderFactory.makeSystemReader(system, uis, 0);
        }
        catch (IOException e2) {
            throw new IonException(e2);
        }
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, Reader chars2) {
        try {
            UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2);
            return new IonReaderTextUserX(system, catalog, in);
        }
        catch (IOException e2) {
            throw new IonException(e2);
        }
    }

    public static final IonReader makeSystemReader(IonSystem system, Reader chars2) {
        try {
            UnifiedInputStreamX in = UnifiedInputStreamX.makeStream(chars2);
            return new IonReaderTextSystemX(system, in);
        }
        catch (IOException e2) {
            throw new IonException(e2);
        }
    }

    public static final IonReader makeReader(IonSystem system, IonCatalog catalog, IonValue value) {
        return new IonReaderTreeUserX(value, catalog);
    }

    public static final IonReader makeSystemReader(IonSystem system, IonValue value) {
        if (system != null && system != value.getSystem()) {
            throw new IonException("you can't mix values from different systems");
        }
        return new IonReaderTreeSystem(value);
    }

    private static IonReader makeReader(IonSystem system, IonCatalog catalog, UnifiedInputStreamX uis, int offset) throws IOException {
        IonReader r = PrivateIonReaderFactory.has_binary_cookie(uis) ? new IonReaderBinaryUserX(system, catalog, uis, offset) : new IonReaderTextUserX(system, catalog, uis, offset);
        return r;
    }

    private static IonReader makeSystemReader(IonSystem system, UnifiedInputStreamX uis, int offset) throws IOException {
        IonReader r = PrivateIonReaderFactory.has_binary_cookie(uis) ? new IonReaderBinarySystemX(system, uis) : new IonReaderTextSystemX(system, uis);
        return r;
    }

    private static UnifiedInputStreamX makeUnifiedStream(byte[] bytes2, int offset, int length) throws IOException {
        UnifiedInputStreamX uis;
        if (IonStreamUtils.isGzip(bytes2, offset, length)) {
            ByteArrayInputStream baos = new ByteArrayInputStream(bytes2, offset, length);
            GZIPInputStream gzip = new GZIPInputStream(baos);
            uis = UnifiedInputStreamX.makeStream(gzip);
        } else {
            uis = UnifiedInputStreamX.makeStream(bytes2, offset, length);
        }
        return uis;
    }

    private static UnifiedInputStreamX makeUnifiedStream(InputStream in) throws IOException {
        in.getClass();
        in = IonStreamUtils.unGzip(in);
        UnifiedInputStreamX uis = UnifiedInputStreamX.makeStream(in);
        return uis;
    }

    private static final boolean has_binary_cookie(UnifiedInputStreamX uis) throws IOException {
        int c;
        int len;
        byte[] bytes2 = new byte[PrivateIonConstants.BINARY_VERSION_MARKER_SIZE];
        for (len = 0; len < PrivateIonConstants.BINARY_VERSION_MARKER_SIZE && (c = uis.read()) != -1; ++len) {
            bytes2[len] = (byte)c;
        }
        int ii = len;
        while (ii > 0) {
            uis.unread(bytes2[--ii] & 0xFF);
        }
        boolean is_cookie = IonStreamUtils.isIonBinary(bytes2, 0, len);
        return is_cookie;
    }
}

