/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;

class UFFOOPCalc
extends Calculation {
    UFFOOPCalc() {
    }

    @Override
    void setData(Lst<Object[]> calc, int ib, int elemNo, double dd) {
        this.b = this.calcs.minAtoms[ib];
        int[] atomList = this.b.getBondedAtomIndexes();
        this.ia = atomList[0];
        this.a = this.calcs.minAtoms[this.ia];
        this.ic = atomList[1];
        this.c = this.calcs.minAtoms[this.ic];
        this.id = atomList[2];
        this.d = this.calcs.minAtoms[this.id];
        double a0 = 1.0;
        double a1 = -1.0;
        double a2 = 0.0;
        double koop = 25.1208;
        switch (elemNo) {
            case 6: {
                if ((this.b.sType != "C_2" || this.b.hCount <= 1) && this.b.sType != "C_2+" && this.a.sType != "O_2" && this.c.sType != "O_2" && this.d.sType != "O_2") break;
                koop += 184.2192;
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            default: {
                koop = 92.1096;
                double phi = Math.PI / 180;
                switch (elemNo) {
                    case 15: {
                        phi *= 84.4339;
                        break;
                    }
                    case 33: {
                        phi *= 86.9735;
                        break;
                    }
                    case 51: {
                        phi *= 87.7047;
                        break;
                    }
                    case 83: {
                        phi *= 90.0;
                    }
                }
                double cosPhi = Math.cos(phi);
                a0 = cosPhi * cosPhi;
                a1 = -2.0 * cosPhi;
                a2 = 1.0;
            }
        }
        calc.addLast((Object)new Object[]{new int[]{this.ia, ib, this.ic, this.id}, new double[]{koop /= 3.0, a0, a1, a2, koop * 10.0}});
        calc.addLast((Object)new Object[]{new int[]{this.ic, ib, this.id, this.ia}, new double[]{koop, a0, a1, a2, koop * 10.0}});
        calc.addLast((Object)new Object[]{new int[]{this.id, ib, this.ia, this.ic}, new double[]{koop, a0, a1, a2, koop * 10.0}});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        double koop = this.calcs.isPreliminary ? this.dData[4] : this.dData[0];
        double a0 = this.dData[1];
        double a1 = this.dData[2];
        double a2 = this.dData[3];
        this.calcs.setOopVariables(this, true);
        double cosTheta = Math.cos(this.theta);
        this.energy = koop * (a0 + a1 * cosTheta + a2 * cosTheta * cosTheta);
        if (this.calcs.gradients) {
            this.dE = koop * (a1 * Math.sin(this.theta) + a2 * 2.0 * Math.sin(this.theta) * cosTheta);
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(4, this));
        }
        return this.energy;
    }
}

