/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public final class BioResolver
implements Comparator<String[]> {
    public static final Map<String, Short> htGroup = new Hashtable<String, Short>();
    private Viewer vwr;
    private V3 vAB;
    private V3 vNorm;
    private P4 plane;
    private ModelLoader ml;
    private ModelSet ms;
    private BS bsAddedMask;
    private int lastSetH = Integer.MIN_VALUE;
    private int maxSerial = 0;
    private boolean haveHsAlready;
    private BS bsAddedHydrogens;
    private BS bsAtomsForHs;
    private Map<String, String> htBondMap;
    private Map<String, Boolean> htGroupBonds;
    private String[] hNames;
    private int baseBondIndex = 0;
    private BS bsAssigned;
    private static STR[] types = new STR[]{STR.HELIXPI, STR.HELIXALPHA, STR.SHEET, STR.HELIX310, STR.TURN};
    private static int[] mytypes = new int[]{0, 2, 3, 4, 6};
    private static Map<String, String[][]> htPdbBondInfo;
    public static final String[] pdbBondInfo;
    private static final int[] pdbHydrogenCount;
    private static final String allCarbohydrates = ",[AHR],[ALL],[AMU],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLC],[GXL],[GUP],[LXC],[MAN],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[GCU],[MTL],[NAG],[NDG],[RHA],[SOR],[SOL],[SOE],[XYL],[A2G],[LBT],[NGA],[SIA],[SLB],[AFL],[AGC],[GLB],[NAN],[RAA]";
    private static int group3Count;
    static final char[] predefinedGroup1Names;
    public static short group3NameCount;
    private static final String[] predefinedGroup3Names;
    private static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    private static Map<String, Byte> htSpecialAtoms;
    private static final int[] argbsAmino;
    private static final int[] argbsNucleic;
    private static final int[] argbsChainAtom;
    private static final int[] argbsChainHetero;
    private static final int[] argbsShapely;

    public BioResolver setLoader(ModelLoader modelLoader) {
        this.ml = modelLoader;
        this.bsAddedMask = null;
        this.lastSetH = Integer.MIN_VALUE;
        this.maxSerial = 0;
        this.haveHsAlready = false;
        if (modelLoader == null) {
            this.ms = null;
            this.bsAssigned = null;
            this.bsAtomsForHs = null;
            this.bsAddedHydrogens = null;
            this.htBondMap = null;
            this.htGroupBonds = null;
            this.hNames = null;
        } else {
            Group.specialAtomNames = specialAtomNames;
            this.ms = modelLoader.ms;
            this.vwr = modelLoader.ms.vwr;
            modelLoader.specialAtomIndexes = new int[ATOMID_MAX];
        }
        return this;
    }

    public BioResolver setViewer(Viewer vwr) {
        this.vwr = vwr;
        if (Group.standardGroupList == null) {
            int i;
            SB s = new SB();
            for (i = 1; i < 42; ++i) {
                s.append(",[").append(predefinedGroup3Names[i]).append("]");
            }
            s.append(allCarbohydrates);
            group3Count = s.length() / 6;
            Group.standardGroupList = s.toString();
            int n = predefinedGroup3Names.length;
            for (i = 0; i < n; ++i) {
                BioResolver.addGroup3Name(predefinedGroup3Names[i].trim());
            }
        }
        return this;
    }

    public Model getBioModel(int modelIndex, int trajectoryBaseIndex, String jmolData, Properties modelProperties, Map<String, Object> modelAuxiliaryInfo) {
        return new BioModel(this.ms, modelIndex, trajectoryBaseIndex, jmolData, modelProperties, modelAuxiliaryInfo);
    }

    public Group distinguishAndPropagateGroup(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes, Atom[] atoms) {
        int mask = 0;
        int i = ATOMID_MAX;
        while (--i >= 0) {
            specialAtomIndexes[i] = Integer.MIN_VALUE;
        }
        for (i = lastAtomIndex; i >= firstAtomIndex; --i) {
            byte specialAtomID = atoms[i].atomID;
            if (specialAtomID <= 0) continue;
            if (specialAtomID < 14) {
                mask |= 1 << specialAtomID;
            }
            specialAtomIndexes[specialAtomID] = i;
        }
        Monomer m = null;
        if ((mask & 0xE) == 14) {
            m = AminoMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes, atoms);
        } else if (mask == 4) {
            m = AlphaMonomer.validateAndAllocateA(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes);
        } else if ((mask & 0x1FC0) == 8128) {
            m = NucleicMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes);
        } else if (mask == 8192) {
            m = PhosphorusMonomer.validateAndAllocateP(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, specialAtomIndexes);
        } else if (BioResolver.checkCarbohydrate(group3)) {
            m = CarbohydrateMonomer.validateAndAllocate(chain, group3, seqcode, firstAtomIndex, lastAtomIndex);
        }
        return m != null && m.leadAtomIndex >= 0 ? m : null;
    }

    public void setHaveHsAlready(boolean b) {
        this.haveHsAlready = b;
    }

    public void initializeHydrogenAddition() {
        this.baseBondIndex = this.ms.bondCount;
        this.bsAddedHydrogens = new BS();
        this.bsAtomsForHs = new BS();
        this.htBondMap = new Hashtable<String, String>();
        this.htGroupBonds = new Hashtable<String, Boolean>();
        this.hNames = new String[3];
        this.vAB = new V3();
        this.vNorm = new V3();
        this.plane = new P4();
    }

    public void addImplicitHydrogenAtoms(JmolAdapter adapter, int iGroup, int nH) {
        int nH1;
        String group3 = this.ml.getGroup3(iGroup);
        if (this.haveHsAlready || group3 == null || (nH1 = BioResolver.getStandardPdbHydrogenCount(group3)) == 0) {
            return;
        }
        nH = nH1 < 0 ? -1 : nH1 + nH;
        Object model = null;
        int iFirst = this.ml.getFirstAtomIndex(iGroup);
        int ac = this.ms.ac;
        if (nH < 0) {
            if (ac - iFirst == 1) {
                return;
            }
            model = this.vwr.getLigandModel(group3, "ligand_", "_data", null);
            if (model == null) {
                return;
            }
            nH = adapter.getHydrogenAtomCount(model);
            if (nH < 1) {
                return;
            }
        }
        this.getBondInfo(adapter, group3, model);
        this.ms.am[this.ms.at[iFirst].mi].isPdbWithMultipleBonds = true;
        this.bsAtomsForHs.setBits(iFirst, ac);
        this.bsAddedHydrogens.setBits(ac, ac + nH);
        boolean isHetero = this.ms.at[iFirst].isHetero();
        P3 xyz = P3.new3((float)Float.NaN, (float)Float.NaN, (float)Float.NaN);
        Atom a = this.ms.at[iFirst];
        for (int i = 0; i < nH; ++i) {
            this.ms.addAtom((int)a.mi, a.group, 1, "H", null, 0, a.getSeqID(), 0, xyz, Float.NaN, null, 0, 0.0f, 1.0f, 0.0f, null, isHetero, (byte)0, null).delete(null);
        }
    }

    private void getBondInfo(JmolAdapter adapter, String group3, Object model) {
        String[][] bondInfo;
        if (this.htGroupBonds.get(group3) != null) {
            return;
        }
        String[][] stringArray = bondInfo = model == null ? this.getPdbBondInfo(group3, this.vwr.g.legacyHAddition) : this.getLigandBondInfo(adapter, model, group3);
        if (bondInfo == null) {
            return;
        }
        this.htGroupBonds.put(group3, Boolean.TRUE);
        for (int i = 0; i < bondInfo.length; ++i) {
            if (bondInfo[i] == null) continue;
            if (bondInfo[i][1].charAt(0) == 'H') {
                this.htBondMap.put(group3 + "." + bondInfo[i][0], bondInfo[i][1]);
                continue;
            }
            this.htBondMap.put(group3 + ":" + bondInfo[i][0] + ":" + bondInfo[i][1], bondInfo[i][2]);
        }
    }

    private String[][] getLigandBondInfo(JmolAdapter adapter, Object model, String group3) {
        String[][] dataIn = adapter.getBondList(model);
        Hashtable<String, P3> htAtoms = new Hashtable<String, P3>();
        JmolAdapterAtomIterator iterAtom = adapter.getAtomIterator(model);
        while (iterAtom.hasNext()) {
            htAtoms.put(iterAtom.getAtomName(), iterAtom.getXYZ());
        }
        String[][] bondInfo = new String[dataIn.length * 2][];
        int n = 0;
        for (int i = 0; i < dataIn.length; ++i) {
            String[] b = dataIn[i];
            if (b[0].charAt(0) != 'H') {
                bondInfo[n++] = new String[]{b[0], b[1], b[2], b[1].startsWith("H") ? "0" : "1"};
            }
            if (b[1].charAt(0) == 'H') continue;
            bondInfo[n++] = new String[]{b[1], b[0], b[2], b[0].startsWith("H") ? "0" : "1"};
        }
        Arrays.sort(bondInfo, this);
        int i = 0;
        while (i < n) {
            String[] t = bondInfo[i];
            String a1 = t[0];
            int nH = 0;
            int nC = 0;
            while (i < n && (t = bondInfo[i])[0].equals(a1)) {
                if (t[3].equals("0")) {
                    ++nH;
                } else if (t[3].equals("1")) {
                    ++nC;
                }
                ++i;
            }
            int pt = i - nH - nC;
            if (nH == 1) continue;
            switch (nC) {
                case 1: {
                    char sep = nH == 2 ? (char)'@' : '|';
                    for (int j = 1; j < nH; ++j) {
                        String[] stringArray = bondInfo[pt];
                        stringArray[1] = stringArray[1] + sep + bondInfo[pt + j][1];
                        bondInfo[pt + j] = null;
                    }
                    break;
                }
                case 2: {
                    if (nH != 2) break;
                    String name = bondInfo[pt][0];
                    String name1 = bondInfo[pt + nH][1];
                    String name2 = bondInfo[pt + nH + 1][1];
                    int factor = name1.compareTo(name2);
                    Measure.getPlaneThroughPoints((T3)((T3)htAtoms.get(name1)), (T3)((T3)htAtoms.get(name)), (T3)((T3)htAtoms.get(name2)), (V3)this.vNorm, (V3)this.vAB, (P4)this.plane);
                    float d = Measure.distanceToPlane((P4)this.plane, (T3)((T3)htAtoms.get(bondInfo[pt][1]))) * (float)factor;
                    bondInfo[pt][1] = d > 0.0f ? bondInfo[pt][1] + "@" + bondInfo[pt + 1][1] : bondInfo[pt + 1][1] + "@" + bondInfo[pt][1];
                    bondInfo[pt + 1] = null;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            String[] t = bondInfo[i];
            if (t != null && t[1].charAt(0) != 'H' && t[0].compareTo(t[1]) > 0) {
                bondInfo[i] = null;
                continue;
            }
            if (t == null) continue;
            Logger.info((String)(" ligand " + group3 + ": " + bondInfo[i][0] + " - " + bondInfo[i][1] + " order " + bondInfo[i][2]));
        }
        return bondInfo;
    }

    @Override
    public int compare(String[] a, String[] b) {
        return b == null ? (a == null ? 0 : -1) : (a == null ? 1 : (a[0].compareTo(b[0]) < 0 ? -1 : (a[0].compareTo(b[0]) > 0 ? 1 : (a[3].compareTo(b[3]) < 0 ? -1 : (a[3].compareTo(b[3]) > 0 ? 1 : (a[1].compareTo(b[1]) < 0 ? -1 : (a[1].compareTo(b[1]) > 0 ? 1 : 0)))))));
    }

    public void finalizeHydrogens() {
        this.vwr.getLigandModel(null, null, null, null);
        this.finalizePdbMultipleBonds();
        this.addHydrogens();
    }

    private void addHydrogens() {
        if (this.bsAddedHydrogens.nextSetBit(0) < 0) {
            return;
        }
        this.bsAddedMask = BSUtil.copy((BS)this.bsAddedHydrogens);
        this.finalizePdbCharges();
        int[] nTotal = new int[1];
        P3[][] pts = this.ms.calculateHydrogens(this.bsAtomsForHs, nTotal, true, false, null);
        Group groupLast = null;
        int ipt = 0;
        block8: for (int i = 0; i < pts.length; ++i) {
            if (pts[i] == null) continue;
            Atom atom = this.ms.at[i];
            Group g = atom.group;
            if (g != groupLast) {
                groupLast = g;
                ipt = g.lastAtomIndex;
                while (this.bsAddedHydrogens.get(ipt)) {
                    --ipt;
                }
            }
            String gName = atom.getGroup3(false);
            String aName = atom.getAtomName();
            String hName = this.htBondMap.get(gName + "." + aName);
            if (hName == null) continue;
            boolean isChiral = hName.contains("@");
            boolean isMethyl = hName.endsWith("?") || hName.indexOf("|") >= 0;
            int n = pts[i].length;
            if (n == 3 && !isMethyl && hName.equals("H@H2")) {
                hName = "H|H2|H3";
                isMethyl = true;
                isChiral = false;
            }
            if (isChiral && n == 3 || isMethyl != (n == 3)) {
                Logger.info((String)("Error adding H atoms to " + gName + g.getResno() + ": " + pts[i].length + " atoms should not be added to " + aName));
                continue;
            }
            int pt = hName.indexOf("@");
            switch (pts[i].length) {
                case 1: {
                    if (pt > 0) {
                        hName = hName.substring(0, pt);
                    }
                    this.setHydrogen(i, ++ipt, hName, pts[i][0]);
                    continue block8;
                }
                case 2: {
                    String hName1;
                    String hName2;
                    float d = -1.0f;
                    Bond[] bonds = atom.bonds;
                    if (bonds != null) {
                        switch (bonds.length) {
                            case 2: {
                                Atom atom1 = bonds[0].getOtherAtom(atom);
                                Atom atom2 = bonds[1].getOtherAtom(atom);
                                int factor = atom1.getAtomName().compareTo(atom2.getAtomName());
                                d = Measure.distanceToPlane((P4)Measure.getPlaneThroughPoints((T3)atom1, (T3)atom, (T3)atom2, (V3)this.vNorm, (V3)this.vAB, (P4)this.plane), (T3)pts[i][0]) * (float)factor;
                            }
                        }
                    }
                    if (pt < 0) {
                        Logger.info((String)("Error adding H atoms to " + gName + g.getResno() + ": expected to only need 1 H but needed 2"));
                        hName2 = "H";
                        hName1 = "H";
                    } else if (d < 0.0f) {
                        hName2 = hName.substring(0, pt);
                        hName1 = hName.substring(pt + 1);
                    } else {
                        hName1 = hName.substring(0, pt);
                        hName2 = hName.substring(pt + 1);
                    }
                    this.setHydrogen(i, ++ipt, hName1, pts[i][0]);
                    this.setHydrogen(i, ++ipt, hName2, pts[i][1]);
                    continue block8;
                }
                case 3: {
                    int pt1 = hName.indexOf(124);
                    if (pt1 >= 0) {
                        int pt2 = hName.lastIndexOf(124);
                        this.hNames[0] = hName.substring(0, pt1);
                        this.hNames[1] = hName.substring(pt1 + 1, pt2);
                        this.hNames[2] = hName.substring(pt2 + 1);
                    } else {
                        this.hNames[0] = hName.replace('?', '1');
                        this.hNames[1] = hName.replace('?', '2');
                        this.hNames[2] = hName.replace('?', '3');
                    }
                    this.setHydrogen(i, ++ipt, this.hNames[0], pts[i][0]);
                    this.setHydrogen(i, ++ipt, this.hNames[1], pts[i][2]);
                    this.setHydrogen(i, ++ipt, this.hNames[2], pts[i][1]);
                }
            }
        }
        this.deleteUnneededAtoms();
        this.ms.fixFormalCharges(BSUtil.newBitSet2((int)this.ml.baseAtomIndex, (int)this.ml.ms.ac));
    }

    private void deleteUnneededAtoms() {
        BS bsBondsDeleted = new BS();
        int i = this.bsAtomsForHs.nextSetBit(0);
        while (i >= 0) {
            Atom atom = this.ms.at[i];
            if (atom.isHetero() && atom.getElementNumber() == 8 && atom.getFormalCharge() == 0 && atom.getCovalentBondCount() == 2) {
                Bond[] bonds = atom.bonds;
                Atom atom1 = bonds[0].getOtherAtom(atom);
                Atom atomH = bonds[1].getOtherAtom(atom);
                if (atom1.getElementNumber() == 1) {
                    Atom a = atom1;
                    atom1 = atomH;
                    atomH = a;
                }
                if (atomH.getElementNumber() == 1) {
                    Bond[] bonds1 = atom1.bonds;
                    for (int j = 0; j < bonds1.length; ++j) {
                        Atom atomO;
                        if (bonds1[j].order != 2 || (atomO = bonds1[j].getOtherAtom(atom1)).getElementNumber() != 8) continue;
                        this.bsAddedHydrogens.set(atomH.i);
                        atomH.delete(bsBondsDeleted);
                        break;
                    }
                }
            }
            i = this.bsAtomsForHs.nextSetBit(i + 1);
        }
        this.ms.deleteBonds(bsBondsDeleted, true);
        this.deleteAtoms(this.bsAddedHydrogens);
    }

    private void deleteAtoms(BS bsDeletedAtoms) {
        int i;
        int[] mapOldToNew = new int[this.ms.ac];
        int[] mapNewToOld = new int[this.ms.ac - bsDeletedAtoms.cardinality()];
        int n = this.ml.baseAtomIndex;
        Model[] models = this.ms.am;
        Atom[] atoms = this.ms.at;
        for (i = this.ml.baseAtomIndex; i < this.ms.ac; ++i) {
            models[atoms[i].mi].bsAtoms.clear(i);
            models[atoms[i].mi].bsAtomsDeleted.clear(i);
            if (bsDeletedAtoms.get(i)) {
                mapOldToNew[i] = n - 1;
                --models[atoms[i].mi].act;
                continue;
            }
            mapNewToOld[n] = i;
            mapOldToNew[i] = n++;
        }
        this.ms.msInfo.put("bsDeletedAtoms", bsDeletedAtoms);
        for (i = this.ml.baseGroupIndex; i < this.ml.groups.length; ++i) {
            Group g = this.ml.groups[i];
            if (g.firstAtomIndex < this.ml.baseAtomIndex) continue;
            g.firstAtomIndex = mapOldToNew[g.firstAtomIndex];
            g.lastAtomIndex = mapOldToNew[g.lastAtomIndex];
            if (g.leadAtomIndex < 0) continue;
            g.leadAtomIndex = mapOldToNew[g.leadAtomIndex];
        }
        this.ms.adjustAtomArrays(mapNewToOld, this.ml.baseAtomIndex, n);
        this.ms.calcBoundBoxDimensions(null, 1.0f);
        this.ms.resetMolecules();
        this.ms.validateBspf(false);
        this.bsAddedMask = BSUtil.deleteBits((BS)this.bsAddedMask, (BS)bsDeletedAtoms);
        for (i = this.ml.baseModelIndex; i < this.ms.mc; ++i) {
            this.fixAnnotations(i, "domains", 1073741925);
            this.fixAnnotations(i, "validation", 1073742189);
        }
    }

    private void fixAnnotations(int i, String name, int type) {
        Object dbObj;
        Object o = this.ml.ms.getInfo(i, name);
        if (o != null && (dbObj = ((BioModel)this.ms.am[i]).getCachedAnnotationMap(name, o)) != null) {
            this.vwr.getAnnotationParser(false).fixAtoms(i, (SV)dbObj, this.bsAddedMask, type, 20);
        }
    }

    private void finalizePdbCharges() {
        Atom[] atoms = this.ms.at;
        int i = this.bsAtomsForHs.nextSetBit(0);
        while (i >= 0) {
            Atom a = atoms[i];
            if (a.group.getNitrogenAtom() == a && a.getCovalentBondCount() == 1) {
                a.setFormalCharge(1);
            }
            if ((i = this.bsAtomsForHs.nextClearBit(i + 1)) < 0) break;
            i = this.bsAtomsForHs.nextSetBit(i + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void finalizePdbMultipleBonds() {
        void var5_11;
        Hashtable<String, Boolean> htKeysUsed = new Hashtable<String, Boolean>();
        int bondCount = this.ms.bondCount;
        Bond[] bonds = this.ms.bo;
        for (int i = this.baseBondIndex; i < bondCount; ++i) {
            Atom atom = bonds[i].atom1;
            Atom a2 = bonds[i].atom2;
            Group g = atom.group;
            if (g != a2.group) continue;
            SB key = new SB().append(g.getGroup3());
            key.append(":");
            String n1 = atom.getAtomName();
            String n2 = a2.getAtomName();
            if (n1.compareTo(n2) > 0) {
                key.append(n2).append(":").append(n1);
            } else {
                key.append(n1).append(":").append(n2);
            }
            String skey = key.toString();
            String type = this.htBondMap.get(skey);
            if (type == null) continue;
            htKeysUsed.put(skey, Boolean.TRUE);
            bonds[i].setOrder(PT.parseInt((String)type));
        }
        for (String string : this.htBondMap.keySet()) {
            if (htKeysUsed.get(string) != null) continue;
            if (string.indexOf(":") < 0) {
                htKeysUsed.put(string, Boolean.TRUE);
                continue;
            }
            String value = this.htBondMap.get(string);
            Logger.info((String)("bond " + string + " was not used; order=" + value));
            if (!this.htBondMap.get(string).equals("1")) continue;
            htKeysUsed.put(string, Boolean.TRUE);
        }
        Hashtable<String, String> htKeysBad = new Hashtable<String, String>();
        for (String key : this.htBondMap.keySet()) {
            if (htKeysUsed.get(key) != null) continue;
            htKeysBad.put(key.substring(0, key.lastIndexOf(":")), this.htBondMap.get(key));
        }
        if (htKeysBad.isEmpty()) {
            return;
        }
        boolean bl = false;
        while (var5_11 < bondCount) {
            String value;
            Atom a1 = bonds[var5_11].atom1;
            Atom a2 = bonds[var5_11].atom2;
            if (a1.group != a2.group && ((value = (String)htKeysBad.get(a1.getGroup3(false) + ":" + a1.getAtomName())) != null || (value = (String)htKeysBad.get(a2.getGroup3(false) + ":" + a2.getAtomName())) != null)) {
                bonds[var5_11].setOrder(PT.parseInt((String)value));
                Logger.info((String)("assigning order " + bonds[var5_11].order + " to bond " + bonds[var5_11]));
            }
            ++var5_11;
        }
    }

    private void setHydrogen(int iTo, int iAtom, String name, P3 pt) {
        if (!this.bsAddedHydrogens.get(iAtom)) {
            return;
        }
        Atom[] atoms = this.ms.at;
        if (this.lastSetH == Integer.MIN_VALUE || atoms[iAtom].mi != atoms[this.lastSetH].mi) {
            this.lastSetH = iAtom;
            this.maxSerial = ((int[])this.ms.getInfo((int)atoms[this.lastSetH].mi, "PDB_CONECT_firstAtom_count_max"))[2];
        }
        this.bsAddedHydrogens.clear(iAtom);
        this.ms.setAtomName(iAtom, name, false);
        atoms[iAtom].setT((T3)pt);
        this.ms.setAtomNumber(iAtom, ++this.maxSerial, false);
        atoms[iAtom].atomSymmetry = atoms[iTo].atomSymmetry;
        this.ml.undeleteAtom(iAtom);
        this.ms.bondAtoms(atoms[iTo], atoms[iAtom], 1, this.ms.getDefaultMadFromOrder(1), null, 0.0f, true, false);
    }

    public Object fixPropertyValue(BS bsAtoms, Object data, boolean toHydrogens) {
        Atom[] atoms = this.ms.at;
        float[] fData = (float[])data;
        float[] newData = new float[bsAtoms.cardinality()];
        float lastData = 0.0f;
        int pt = 0;
        int iAtom = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            block3: {
                block2: {
                    block1: {
                        if (atoms[i].getElementNumber() != 1) break block1;
                        if (toHydrogens) break block2;
                        break block3;
                    }
                    lastData = fData[pt++];
                }
                newData[iAtom] = lastData;
            }
            i = bsAtoms.nextSetBit(i + 1);
            ++iAtom;
        }
        return newData;
    }

    static BioPolymer allocateBioPolymer(Group[] groups, int firstGroupIndex, boolean checkConnections, int pt0) {
        Group group;
        Object previous = null;
        int count = 0;
        for (int i = firstGroupIndex; i < groups.length && (group = groups[i]) instanceof Monomer; ++i) {
            Monomer current = (Monomer)group;
            if (current.bioPolymer != null || previous != null && previous.getClass() != ((Object)((Object)current)).getClass() || checkConnections && !current.isConnectedAfter((Monomer)((Object)previous))) break;
            previous = current;
            ++count;
        }
        if (count < 2) {
            return null;
        }
        Monomer[] monomers = new Monomer[count];
        for (int j = 0; j < count; ++j) {
            monomers[j] = (Monomer)groups[firstGroupIndex + j];
        }
        if (previous instanceof AminoMonomer) {
            return new AminoPolymer(monomers, pt0);
        }
        if (previous instanceof AlphaMonomer) {
            return new AlphaPolymer(monomers, pt0);
        }
        if (previous instanceof NucleicMonomer) {
            return new NucleicPolymer(monomers);
        }
        if (previous instanceof PhosphorusMonomer) {
            return new PhosphorusPolymer(monomers);
        }
        if (previous instanceof CarbohydrateMonomer) {
            return new CarbohydratePolymer(monomers);
        }
        Logger.error((String)("Polymer.allocatePolymer() ... no matching polymer for monomor " + previous));
        throw new NullPointerException();
    }

    public void iterateOverAllNewStructures(JmolAdapter adapter, Object atomSetCollection) {
        JmolAdapterStructureIterator iterStructure = adapter.getStructureIterator(atomSetCollection);
        if (iterStructure == null) {
            return;
        }
        BS bs = iterStructure.getStructuredModels();
        if (bs != null) {
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.ml.structuresDefinedInFile.set(this.ml.baseModelIndex + i);
                i = bs.nextSetBit(i + 1);
            }
        }
        while (iterStructure.hasNext()) {
            if (iterStructure.getStructureType() == STR.TURN) continue;
            this.setStructure(iterStructure);
        }
        iterStructure = adapter.getStructureIterator(atomSetCollection);
        while (iterStructure.hasNext()) {
            if (iterStructure.getStructureType() != STR.TURN) continue;
            this.setStructure(iterStructure);
        }
    }

    private void setStructure(JmolAdapterStructureIterator iterStructure) {
        int m0;
        int m1;
        STR t = iterStructure.getSubstructureType();
        String id = iterStructure.getStructureID();
        int serID = iterStructure.getSerialID();
        int count = iterStructure.getStrandCount();
        int[] atomRange = iterStructure.getAtomIndices();
        int[] modelRange = iterStructure.getModelIndices();
        BS[] bsAll = iterStructure.getBSAll();
        Model[] models = this.ms.am;
        if (this.ml.isTrajectory) {
            m0 = m1 = modelRange[0];
        } else {
            m0 = modelRange[0] + this.ml.baseModelIndex;
            m1 = modelRange[1] + this.ml.baseModelIndex;
        }
        this.ml.structuresDefinedInFile.setBits(m0, m1 + 1);
        if (bsAll != null) {
            for (int i = m0; i <= m1; ++i) {
                Model m = models[i];
                if (!(m instanceof BioModel)) continue;
                for (int j = 0; j < 5; ++j) {
                    int t0 = mytypes[j];
                    BS bs = bsAll[t0];
                    if (bs == null) continue;
                    ((BioModel)m).addStructureByBS(0, t0, types[j], bs);
                }
            }
            return;
        }
        int startChainID = iterStructure.getStartChainID();
        int startSequenceNumber = iterStructure.getStartSequenceNumber();
        char startInsertionCode = iterStructure.getStartInsertionCode();
        int endSequenceNumber = iterStructure.getEndSequenceNumber();
        int endChainID = iterStructure.getEndChainID();
        char endInsertionCode = iterStructure.getEndInsertionCode();
        STR type = t == STR.NOT ? STR.NONE : t;
        int startSeqCode = Group.getSeqcodeFor((int)startSequenceNumber, (char)startInsertionCode);
        int endSeqCode = Group.getSeqcodeFor((int)endSequenceNumber, (char)endInsertionCode);
        if (this.bsAssigned == null) {
            this.bsAssigned = new BS();
        }
        int i0 = 0;
        for (int i = m0; i <= m1; ++i) {
            Model m = models[i];
            if (!(m instanceof BioModel)) continue;
            i0 = m.firstAtomIndex;
            ((BioModel)m).addSecondaryStructure(type, id, serID, count, startChainID, startSeqCode, endChainID, endSeqCode, i0 + atomRange[0], i0 + atomRange[1], this.bsAssigned);
        }
    }

    public void setGroupLists(int ipt) {
        this.ml.group3Lists[ipt + 1] = Group.standardGroupList;
        this.ml.group3Counts[ipt + 1] = new int[group3Count + 10];
        if (this.ml.group3Lists[0] == null) {
            this.ml.group3Lists[0] = Group.standardGroupList;
            this.ml.group3Counts[0] = new int[group3Count + 10];
        }
    }

    public boolean isKnownPDBGroup(String g3, int max) {
        short pt = BioResolver.knownGroupID(g3);
        return pt > 0 ? pt < max : max == Integer.MAX_VALUE && BioResolver.checkCarbohydrate(g3);
    }

    public byte lookupSpecialAtomID(String name) {
        Byte boxedAtomID;
        if (htSpecialAtoms == null) {
            htSpecialAtoms = new Hashtable<String, Byte>();
            int i = specialAtomNames.length;
            while (--i >= 0) {
                String specialAtomName = specialAtomNames[i];
                if (specialAtomName == null) continue;
                htSpecialAtoms.put(specialAtomName, (byte)i);
            }
        }
        return (boxedAtomID = htSpecialAtoms.get(name)) == null ? (byte)0 : boxedAtomID;
    }

    private String[][] getPdbBondInfo(String group3, boolean isLegacy) {
        String[][] info;
        if (htPdbBondInfo == null) {
            htPdbBondInfo = new Hashtable<String, String[][]>();
        }
        if ((info = htPdbBondInfo.get(group3)) != null) {
            return info;
        }
        int pt = BioResolver.knownGroupID(group3);
        if (pt < 0 || pt > pdbBondInfo.length) {
            return null;
        }
        String s = pdbBondInfo[pt];
        if (isLegacy && (pt = s.indexOf("O3'")) >= 0) {
            s = s.substring(0, pt);
        }
        String[] temp = PT.getTokens((String)s);
        info = new String[temp.length / 2][];
        int p = 0;
        for (int i = 0; i < info.length; ++i) {
            String target;
            String source = temp[p++];
            if ((target = temp[p++]).length() == 1) {
                switch (target.charAt(0)) {
                    case 'N': {
                        target = "H@H2";
                        break;
                    }
                    case 'B': {
                        target = "HB3@HB2";
                        break;
                    }
                    case 'D': {
                        target = "HD3@HD2";
                        break;
                    }
                    case 'G': {
                        target = "HG3@HG2";
                        break;
                    }
                    case '2': {
                        target = "H2'@H2''";
                        break;
                    }
                    case '5': {
                        target = "H5''@H5'";
                    }
                }
            }
            if (target.charAt(0) != 'H' && source.compareTo(target) > 0) {
                s = target;
                target = source;
                source = s;
            }
            info[i] = new String[]{source, target, target.startsWith("H") ? "1" : "2"};
        }
        htPdbBondInfo.put(group3, info);
        return info;
    }

    public static short knownGroupID(String group3) {
        if (group3 == null || group3.length() == 0) {
            return 0;
        }
        Short boxedGroupID = htGroup.get(group3);
        return boxedGroupID == null ? (short)-1 : (short)boxedGroupID;
    }

    private static final boolean checkCarbohydrate(String group3) {
        return group3 != null && allCarbohydrates.indexOf("[" + group3.toUpperCase() + "]") >= 0;
    }

    public boolean isHetero(String group3) {
        switch (group3.length()) {
            case 1: {
                group3 = group3 + "  ";
                break;
            }
            case 2: {
                group3 = group3 + " ";
                break;
            }
            case 3: {
                break;
            }
            default: {
                return true;
            }
        }
        int pt = Group.standardGroupList.indexOf(group3);
        return pt < 0 || pt / 6 + 1 >= 42;
    }

    public String toStdAmino3(String g1) {
        int i;
        if (g1.length() == 0) {
            return "";
        }
        SB s = new SB();
        int pt = BioResolver.knownGroupID("==A");
        if (pt < 0) {
            for (i = 1; i <= 20; ++i) {
                pt = BioResolver.knownGroupID(predefinedGroup3Names[i]);
                htGroup.put("==" + predefinedGroup1Names[i], (short)pt);
            }
        }
        int n = g1.length();
        for (i = 0; i < n; ++i) {
            char ch = g1.charAt(i);
            pt = BioResolver.knownGroupID("==" + ch);
            if (pt < 0) {
                pt = 23;
            }
            s.append(" ").append(predefinedGroup3Names[pt]);
        }
        return s.toString().substring(1);
    }

    public short getGroupID(String g3) {
        return BioResolver.getGroupIdFor(g3);
    }

    static short getGroupIdFor(String group3) {
        short groupID;
        if (group3 != null) {
            group3 = group3.trim();
        }
        return (groupID = BioResolver.knownGroupID(group3)) == -1 ? BioResolver.addGroup3Name(group3) : groupID;
    }

    private static synchronized short addGroup3Name(String group3) {
        if (group3NameCount == Group.group3Names.length) {
            Group.group3Names = AU.doubleLengthS((String[])Group.group3Names);
        }
        short s = group3NameCount;
        group3NameCount = (short)(s + 1);
        short groupID = s;
        Group.group3Names[groupID] = group3;
        htGroup.put(group3, groupID);
        return groupID;
    }

    private static int getStandardPdbHydrogenCount(String group3) {
        short pt = BioResolver.knownGroupID(group3);
        return pt < 0 || pt >= pdbHydrogenCount.length ? -1 : pdbHydrogenCount[pt];
    }

    static final String getSpecialAtomName(int atomID) {
        return specialAtomNames[atomID];
    }

    public int[] getArgbs(int tok) {
        switch (tok) {
            case 0x20000E: {
                return argbsNucleic;
            }
            case 0x200002: {
                return argbsAmino;
            }
            case 0x40000140: {
                return argbsShapely;
            }
            case 0x44000001: {
                return argbsChainAtom;
            }
            case 0x60200006: {
                return argbsChainHetero;
            }
        }
        return null;
    }

    static {
        pdbBondInfo = new String[]{"", "N N CA HA C O CB HB?", "N N CA HA C O CB B CG G CD D NE HE CZ NH1 NH1 HH11@HH12 NH2 HH22@HH21", "N N CA HA C O CB B CG OD1 ND2 HD21@HD22", "N N CA HA C O CB B CG OD1", "N N CA HA C O CB B SG HG", "N N CA HA C O CB B CG G CD OE1 NE2 HE22@HE21", "N N CA HA C O CB B CG G CD OE1", "N N CA HA2@HA3 C O", "N N CA HA C O CB B CG CD2 ND1 CE1 ND1 HD1 CD2 HD2 CE1 HE1 NE2 HE2", "N N CA HA C O CB HB CG1 HG13@HG12 CG2 HG2? CD1 HD1?", "N N CA HA C O CB B CG HG CD1 HD1? CD2 HD2?", "N N CA HA C O CB B CG G CD HD2@HD3 CE HE3@HE2 NZ HZ?", "N N CA HA C O CB B CG G CE HE?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 CZ HZ", "N H CA HA C O CB B CG G CD D", "N N CA HA C O CB B OG HG", "N N CA HA C O CB HB OG1 HG1 CG2 HG2?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 NE1 HE1 CE3 CZ3 CE3 HE3 CZ2 CH2 CZ2 HZ2 CZ3 HZ3 CH2 HH2", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 OH HH", "N N CA HA C O CB HB CG1 HG1? CG2 HG2?", "N N CA HA C O CB B", "N N CA HA C O CB B CG G", "", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H22@H21 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H22@H21 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'"};
        pdbHydrogenCount = new int[]{0, 6, 16, 7, 6, 6, 9, 8, 4, 9, 12, 12, 14, 10, 10, 8, 6, 8, 11, 10, 10, 3, 5, 0, 13, 13, 13, -1, 12, 12, 13, 13, 13, 14, 12, 12};
        predefinedGroup1Names = new char[]{'\u0000', 'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'A', 'G', '?', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I'};
        predefinedGroup3Names = new String[]{"   ", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "G  ", "C  ", "A  ", "T  ", "U  ", "I  ", "DG ", "DC ", "DA ", "DT ", "DU ", "DI ", "+G ", "+C ", "+A ", "+T ", "+U ", "+I ", "HOH", "DOD", "WAT", "UREA", "PO4", "SO4", "UNL"};
        specialAtomNames = new String[]{null, "N", "CA", "C", "O", "O1", "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", "OD1", "OD2", "OE1", "OE2", "SG", null, null, null, null, null, null, null, null, null, null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4", "C7", "H1", "H2", "H3", null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "H5T", "O5T", "O1P", "OP1", "O2P", "OP2", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", "HO3'", "HO5'", "HA2", "HA3", "HA2", "H5'", "H5''", "H2'", "H2''", "HO2'", "O3P", "OP3"};
        ATOMID_MAX = specialAtomNames.length;
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476, -4284306};
        argbsNucleic = new int[]{-4284306, -6250336, -15760881, -1645056, -1701366, -15443201, -16720676, -16720676, -15760881, -1645056, -1701366, -15443201, -16720676, -16720676, -15760881, -1645056, -1701366, -15443201, -16720676, -16720676};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        argbsShapely = new int[]{-65281, -16777092, -33680, -7536756, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -11318190, -4677566, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073};
        if (argbsShapely.length != 42) {
            Logger.error((String)"argbsShapely wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 24) {
            Logger.error((String)"argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsChainHetero.length != argbsChainAtom.length) {
            Logger.error((String)"argbsChainHetero wrong length");
            throw new NullPointerException();
        }
    }
}

