/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class Wien2kReader
extends AtomSetCollectionReader {
    private boolean isrhombohedral;
    private char latticeCode = '\u0000';
    private boolean doSymmetry = true;
    private final String cxyz = " x y z";

    public void initializeReader() throws Exception {
        this.doSymmetry = !this.sgName.equals("none");
        this.setFractionalCoordinates(true);
        this.asc.setCollectionName(this.rd());
        this.readUnitCell();
        this.readAtoms();
        this.readSymmetry();
        this.readEmbeddedScript();
        this.continuing = false;
    }

    private void readUnitCell() throws Exception {
        float gamma;
        this.rd();
        this.latticeCode = this.line.charAt(0);
        boolean bl = this.isrhombohedral = this.latticeCode == 'R';
        if (this.line.startsWith("CYZ")) {
            this.latticeCode = (char)65;
        } else if (this.line.startsWith("CXZ")) {
            this.latticeCode = (char)66;
        } else if (this.line.startsWith("B")) {
            this.latticeCode = (char)73;
        }
        if (this.latticeCode != 'R' && this.latticeCode != 'H') {
            this.asc.getXSymmetry().setLatticeParameter((int)this.latticeCode);
        }
        if (this.line.length() > 32) {
            String name = this.line.substring(32).trim();
            if (name.indexOf(" ") >= 0) {
                name = name.substring(name.indexOf(" ") + 1);
            }
            if (name.indexOf("_") >= 0) {
                name = name.substring(name.indexOf("_") + 1);
            }
            this.setSpaceGroupName(name);
        }
        float factor = this.rd().toLowerCase().indexOf("ang") >= 0 ? 1.0f : 0.5291772f;
        this.rd();
        float a = this.parseFloatRange(this.line, 0, 10) * factor;
        float b = this.parseFloatRange(this.line, 10, 20) * factor;
        float c = this.parseFloatRange(this.line, 20, 30) * factor;
        int l = this.line.length();
        float alpha = l >= 40 ? this.parseFloatRange(this.line, 30, 40) : 0.0f;
        float beta = l >= 50 ? this.parseFloatRange(this.line, 40, 50) : 0.0f;
        float f = gamma = l >= 60 ? this.parseFloatRange(this.line, 50, 60) : 0.0f;
        if (this.isrhombohedral) {
            float ar = (float)Math.sqrt(a * a / 3.0f + c * c / 9.0f);
            beta = gamma = (float)(Math.acos((2.0f * c * c - 3.0f * a * a) / (2.0f * c * c + 6.0f * a * a)) * 180.0 / Math.PI);
            alpha = gamma;
            b = c = ar;
            a = c;
        }
        if (Float.isNaN(alpha) || alpha == 0.0f) {
            alpha = 90.0f;
        }
        if (Float.isNaN(beta) || beta == 0.0f) {
            beta = 90.0f;
        }
        if (Float.isNaN(gamma) || gamma == 0.0f) {
            gamma = 90.0f;
        }
        this.setUnitCell(a, b, c, alpha, beta, gamma);
    }

    private void readAtoms() throws Exception {
        this.rd();
        while (this.line != null && (this.line.indexOf("ATOM") == 0 || !this.doSymmetry && this.line.indexOf(":") == 8)) {
            String atomName;
            String sym;
            int thisAtom = this.asc.ac;
            this.addAtom();
            if (this.rd().indexOf("MULT=") == 10) {
                int i = this.parseIntRange(this.line, 15, 18);
                while (--i >= 0) {
                    this.rd();
                    if (this.doSymmetry) continue;
                    this.addAtom();
                }
            }
            if ((sym = (atomName = this.line.substring(0, 10)).substring(0, 2).trim()).length() == 2 && PT.isDigit((char)sym.charAt(1))) {
                sym = sym.substring(0, 1);
            }
            atomName = PT.rep((String)atomName, (String)" ", (String)"");
            int n = 0;
            int i = this.asc.ac;
            while (--i >= thisAtom) {
                Atom atom = this.asc.atoms[i];
                atom.elementSymbol = sym;
                atom.atomName = atomName + "_" + n++;
            }
            while (this.rd() != null && this.line.indexOf("ATOM") < 0 && this.line.indexOf("SYMMETRY") < 0) {
            }
        }
    }

    private void addAtom() {
        float a = this.parseFloatRange(this.line, 12, 22);
        float b = this.parseFloatRange(this.line, 25, 35);
        float c = this.parseFloatRange(this.line, 38, 48);
        Atom atom = this.asc.addNewAtom();
        this.setAtomCoordXYZ(atom, a, b, c);
    }

    private void readSymmetry() throws Exception {
        int n;
        if (this.line.indexOf("SYMMETRY") < 0) {
            return;
        }
        int i = n = this.parseIntRange(this.line, 0, 4);
        while (--i >= 0) {
            String xyz = this.getJones() + "," + this.getJones() + "," + this.getJones();
            if (this.doSymmetry) {
                this.setSymmetryOperator(xyz);
            }
            this.rd();
        }
    }

    private String getJones() throws Exception {
        this.rd();
        String xyz = "";
        float trans = this.parseFloatStr(this.line.substring(6));
        for (int i = 0; i < 6; ++i) {
            if (this.line.charAt(i) == '-') {
                xyz = xyz + "-";
            }
            if (this.line.charAt(++i) != '1') continue;
            xyz = xyz + " x y z".charAt(i);
            if (trans > 0.0f) {
                xyz = xyz + "+";
            }
            if (trans == 0.0f) continue;
            xyz = xyz + trans;
        }
        return xyz;
    }

    private void readEmbeddedScript() throws Exception {
        while (this.line != null) {
            this.checkCurrentLineForScript();
            this.rd();
        }
    }
}

