/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;

public abstract class PDFTextUtil
extends org.apache.fop.pdf.PDFTextUtil {
    private FontInfo fontInfo;
    private Font font;
    private int encoding;

    public PDFTextUtil(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    @Override
    protected void initValues() {
        super.initValues();
        this.font = null;
    }

    public Font getCurrentFont() {
        return this.font;
    }

    public int getCurrentEncoding() {
        return this.encoding;
    }

    public void setCurrentFont(Font f) {
        this.font = f;
    }

    public void setCurrentEncoding(int encoding) {
        this.encoding = encoding;
    }

    protected boolean isMultiByteFont(String name) {
        Typeface f = this.fontInfo.getFonts().get(name);
        return f.isMultiByte();
    }

    public void writeTf(Font f) {
        String fontName = f.getFontName();
        float fontSize = (float)f.getFontSize() / 1000.0f;
        boolean isMultiByte = this.isMultiByteFont(fontName);
        if (!isMultiByte && this.encoding != 0) {
            this.updateTf(fontName + "_" + Integer.toString(this.encoding), fontSize, isMultiByte);
        } else {
            this.updateTf(fontName, fontSize, isMultiByte);
        }
    }
}

