/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.search.ResultView;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class SearchDisplayer {
    public static final String ATTR_OUTPUT_LINE = "output line";
    private OutputWriter ow = null;
    private Reference<OutputWriter> owRef = null;

    SearchDisplayer() {
    }

    void prepareOutput() {
        String string = NbBundle.getMessage(ResultView.class, (String)"TITLE_SEARCH_RESULTS");
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        this.ow = inputOutput.getOut();
        this.owRef = new WeakReference<OutputWriter>(this.ow);
        inputOutput.select();
    }

    static void clearOldOutput(Reference<OutputWriter> reference) {
        OutputWriter outputWriter;
        if (reference != null && (outputWriter = reference.get()) != null) {
            try {
                outputWriter.reset();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    void displayNodes(Node[] nodeArray) {
        final String[] stringArray = new String[nodeArray.length];
        final OutputListener[] outputListenerArray = new OutputListener[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            Object object = node.getValue(ATTR_OUTPUT_LINE);
            stringArray[i] = object instanceof String ? (String)object : node.getShortDescription();
            outputListenerArray[i] = node instanceof OutputListener ? (OutputListener)node : null;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < stringArray.length; ++i) {
                            OutputListener outputListener = outputListenerArray[i];
                            if (outputListener != null) {
                                SearchDisplayer.this.ow.println(stringArray[i], outputListener);
                                continue;
                            }
                            SearchDisplayer.this.ow.println(stringArray[i]);
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(4096, (Throwable)exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    void finishDisplaying() {
        this.ow.flush();
        this.ow.close();
        this.ow = null;
    }

    Reference<OutputWriter> getOutputWriterRef() {
        return this.owRef;
    }
}

