/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.instrumentation.ClassRewriter;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public class SingleMethodScaner
implements JavaClassConstants {
    private static byte[] reusableBytecodes = new byte[100];
    protected ClassInfo clazz;
    protected byte[] bytecodes;
    protected byte[] origMethodInfo;
    protected int bytecodesLength;
    protected int bytecodesStartIdx;
    protected int methodIdx;

    public SingleMethodScaner() {
    }

    public SingleMethodScaner(ClassInfo classInfo, int n) {
        this.setClassAndMethod(classInfo, n);
    }

    public void setClassAndMethod(ClassInfo classInfo, int n) {
        this.clazz = classInfo;
        this.methodIdx = n;
        this.origMethodInfo = classInfo.getMethodInfo(n);
        this.bytecodesStartIdx = classInfo.getMethodBytecodeOffsetInMethodInfo(n);
        this.bytecodesLength = classInfo.getMethodBytecodesLength(n);
        this.initBytecodesArray();
    }

    protected static int getU2(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    protected static int getU4(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    protected static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    protected int opcodeLength(int n) {
        int n2;
        int n3 = this.bytecodes[n] & 0xFF;
        try {
            n2 = opc_length[n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("*** JFluid warning: unknown opcode: " + n3 + " detected at offset " + n + "in class/method " + this.clazz.getName() + "." + this.clazz.getMethodName(this.methodIdx) + this.clazz.getMethodSignature(this.methodIdx));
            ClassRewriter.saveToDisk(this.clazz.getName(), this.bytecodes);
            return 1;
        }
        if (n2 != 0) {
            return n2;
        }
        if (n3 == 196) {
            n3 = this.bytecodes[n + 1] & 0xFF;
            if (n3 >= 21 && n3 <= 25 || n3 >= 54 && n3 <= 58 || n3 == 169) {
                return 4;
            }
            if (n3 == 132) {
                return 6;
            }
            return 2;
        }
        int n4 = SingleMethodScaner.align(n + 1) - (n + 1);
        switch (n3) {
            case 170: {
                int n5 = this.getInt(n + 1 + n4 + 4);
                int n6 = this.getInt(n + 1 + n4 + 8);
                int n7 = n6 - n5 + 1;
                return 1 + n4 + 4 * (3 + n7);
            }
            case 171: {
                int n8 = this.getInt(n + 1 + n4 + 4);
                return 1 + n4 + 4 * (2 + 2 * n8);
            }
        }
        System.err.println("*** Profiler Engine: error - should not reach here in opcodeLength()");
        return 0;
    }

    protected static void putByte(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 & 0xFF);
    }

    protected static void putU2(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    protected static void putU4(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    protected int getByte(int n) {
        return this.bytecodes[n] & 0xFF;
    }

    protected int getInt(int n) {
        return this.getU4(n);
    }

    protected short getShort(int n) {
        return (short)(((this.bytecodes[n] & 0xFF) << 8) + (this.bytecodes[n + 1] & 0xFF));
    }

    protected int getU2(int n) {
        return ((this.bytecodes[n] & 0xFF) << 8) + (this.bytecodes[n + 1] & 0xFF);
    }

    protected int getU4(int n) {
        return ((this.bytecodes[n] & 0xFF) << 24) + ((this.bytecodes[n + 1] & 0xFF) << 16) + ((this.bytecodes[n + 2] & 0xFF) << 8) + (this.bytecodes[n + 3] & 0xFF);
    }

    protected void initBytecodesArray() {
        if (reusableBytecodes.length < this.bytecodesLength * 8) {
            reusableBytecodes = new byte[this.bytecodesLength * 8];
        }
        System.arraycopy(this.origMethodInfo, this.bytecodesStartIdx, reusableBytecodes, 0, this.bytecodesLength);
        this.bytecodes = reusableBytecodes;
    }

    protected void putInt(int n, int n2) {
        this.putU4(n, n2);
    }

    protected void putShort(int n, short s) {
        this.bytecodes[n] = (byte)(s >> 8 & 0xFF);
        this.bytecodes[n + 1] = (byte)(s & 0xFF);
    }

    protected void putU4(int n, int n2) {
        this.bytecodes[n] = (byte)(n2 >> 24 & 0xFF);
        this.bytecodes[n + 1] = (byte)(n2 >> 16 & 0xFF);
        this.bytecodes[n + 2] = (byte)(n2 >> 8 & 0xFF);
        this.bytecodes[n + 3] = (byte)(n2 & 0xFF);
    }
}

