/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BitBuffer;
import com.sun.java.help.search.IntegerArray;
import java.io.DataOutput;
import java.io.IOException;

class Compressor {
    private static final int NBits = 32;
    private static final int BeginK = 5;
    private BitBuffer _buffer = new BitBuffer();

    Compressor() {
    }

    public void write(DataOutput dataOutput) throws IOException {
        this._buffer.write(dataOutput);
    }

    public int byteCount() {
        return this._buffer.byteCount();
    }

    public void clear() {
        this._buffer.clear();
    }

    public void concatenate(Compressor compressor) {
        this._buffer.concatenate(compressor._buffer);
    }

    public void encode(IntegerArray integerArray, int n) {
        int n2 = 1 << n;
        int n3 = 0;
        for (int i = 0; i < integerArray.cardinality(); ++i) {
            int n4 = integerArray.at(i) >>> n;
            int n5 = integerArray.at(i) % n2;
            if (n4 != n3) {
                int n6 = n3;
                int n7 = n3;
                int n8 = 0;
                int n9 = 1;
                if (n4 > n3) {
                    int n10 = n3;
                    while (n10 < n4) {
                        if ((n7 & 1) != 0) {
                            n6 -= n9;
                        } else {
                            n10 += n9;
                        }
                        n7 >>>= 1;
                        n9 <<= 1;
                        ++n8;
                    }
                } else {
                    while (n6 > n4) {
                        if ((n7 & 1) != 0) {
                            n6 -= n9;
                        }
                        n7 >>>= 1;
                        n9 <<= 1;
                        ++n8;
                    }
                }
                if (n8 * 2 + 1 + n <= 32) {
                    this._buffer.append((1 << n8 | n4 - n6) << n | n5, n8 * 2 + 1 + n);
                } else {
                    if (n8 * 2 + 1 <= 32) {
                        this._buffer.append(1 << n8 | n4 - n6, n8 * 2 + 1);
                    } else {
                        this._buffer.append(0, n8);
                        this._buffer.append(1 << n8 | n4 - n6, n8 + 1);
                    }
                    this._buffer.append(n5, n);
                }
                n3 = n4;
                continue;
            }
            this._buffer.append(n5 | n2, n + 1);
        }
        this._buffer.append(2 | n3 & 1, 3);
        this._buffer.close();
    }

    public void encode(IntegerArray integerArray, IntegerArray integerArray2, int n, int n2) {
        int n3 = 1 << n;
        int n4 = 0;
        for (int i = 0; i < integerArray.cardinality(); ++i) {
            int n5 = integerArray.at(i) >>> n;
            int n6 = integerArray.at(i) % n3;
            if (n5 != n4) {
                int n7 = n4;
                int n8 = n4;
                int n9 = 0;
                int n10 = 1;
                if (n5 > n4) {
                    int n11 = n4;
                    while (n11 < n5) {
                        if ((n8 & 1) != 0) {
                            n7 -= n10;
                        } else {
                            n11 += n10;
                        }
                        n8 >>>= 1;
                        n10 <<= 1;
                        ++n9;
                    }
                } else {
                    while (n7 > n5) {
                        if ((n8 & 1) != 0) {
                            n7 -= n10;
                        }
                        n8 >>>= 1;
                        n10 <<= 1;
                        ++n9;
                    }
                }
                if (n9 * 2 + 1 + n <= 32) {
                    this._buffer.append((1 << n9 | n5 - n7) << n | n6, n9 * 2 + 1 + n);
                } else {
                    if (n9 * 2 + 1 <= 32) {
                        this._buffer.append(1 << n9 | n5 - n7, n9 * 2 + 1);
                    } else {
                        this._buffer.append(0, n9);
                        this._buffer.append(1 << n9 | n5 - n7, n9 + 1);
                    }
                    this._buffer.append(n6, n);
                }
                this._buffer.append(integerArray2.at(i), n2);
                n4 = n5;
                continue;
            }
            this._buffer.append((n6 | n3) << n2 | integerArray2.at(i), n + n2 + 1);
        }
        this._buffer.append(2 | n4 & 1, 3);
        this._buffer.close();
    }

    public int minimize(IntegerArray integerArray, int n) {
        BitBuffer bitBuffer = new BitBuffer();
        int n2 = n;
        this._buffer.clear();
        this.encode(integerArray, n);
        int n3 = this._buffer.bitCount();
        bitBuffer.setFrom(this._buffer);
        this._buffer.clear();
        this.encode(integerArray, n + 1);
        if (this._buffer.bitCount() < n3) {
            int n4 = n + 1;
            do {
                bitBuffer.setFrom(this._buffer);
                n3 = this._buffer.bitCount();
                n2 = n4++;
                this._buffer.clear();
                this.encode(integerArray, n4);
            } while (this._buffer.bitCount() < n3);
        } else {
            int n5 = n - 1;
            while (n5 > 0) {
                this._buffer.clear();
                this.encode(integerArray, n5);
                if (this._buffer.bitCount() >= n3) break;
                bitBuffer.setFrom(this._buffer);
                n3 = this._buffer.bitCount();
                n2 = n5--;
            }
        }
        this._buffer.setFrom(bitBuffer);
        return n2;
    }

    public int compressAscending(IntegerArray integerArray) {
        IntegerArray integerArray2 = new IntegerArray(integerArray.cardinality());
        integerArray.toDifferences(integerArray2);
        return this.minimize(integerArray2, 5);
    }
}

