/*
 * Decompiled with CFR 0.152.
 */
package com.acme.JPM.Decoders;

import com.acme.JPM.Decoders.ImageDecoderRead;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class ImageDecoder
implements ImageProducer {
    private InputStream in;
    private int width;
    private int height;
    private boolean[] rowsRead;
    private int[][] rgbPixels;
    private boolean startedRead = false;
    private boolean gotSize = false;
    private boolean err = false;
    private boolean producing = false;
    private Vector consumers = new Vector();
    private static final ColorModel model = ColorModel.getRGBdefault();

    public ImageDecoder(InputStream in) {
        this.in = in;
    }

    abstract void readHeader(InputStream var1) throws IOException;

    abstract int getWidth();

    abstract int getHeight();

    abstract void readRow(InputStream var1, int var2, int[] var3) throws IOException;

    void readImage() {
        try {
            this.readHeader(this.in);
            this.width = this.getWidth();
            this.height = this.getHeight();
            if (this.width == -1 || this.height == -1) {
                this.err = true;
            } else {
                this.rowsRead = new boolean[this.height];
                int row = 0;
                while (row < this.height) {
                    this.rowsRead[row] = false;
                    ++row;
                }
                this.gotSize = true;
                this.notifyThem();
                this.rgbPixels = new int[this.height][this.width];
                row = 0;
                while (row < this.height) {
                    this.readRow(this.in, row, this.rgbPixels[row]);
                    this.rowsRead[row] = true;
                    this.notifyThem();
                    ++row;
                }
            }
        }
        catch (IOException e) {
            this.err = true;
            this.width = -1;
            this.height = -1;
            this.rowsRead = null;
            this.rgbPixels = null;
        }
    }

    private synchronized void notifyThem() {
        this.notifyAll();
    }

    void sendImage() {
        ImageConsumer[] c = new ImageConsumer[this.consumers.size()];
        int i = 0;
        while (i < c.length) {
            c[i] = (ImageConsumer)this.consumers.elementAt(i);
            ++i;
        }
        this.waitForSize();
        i = 0;
        while (i < c.length) {
            this.sendHead(c[i]);
            ++i;
        }
        int row = 0;
        while (row < this.height) {
            i = 0;
            while (i < c.length) {
                this.sendPixelRow(c[i], row);
                ++i;
            }
            ++row;
        }
        i = 0;
        while (i < c.length) {
            this.sendTail(c[i]);
            ++i;
        }
        this.producing = false;
    }

    private synchronized void waitForSize() {
        while (!this.err && !this.gotSize) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void waitForRow(int row) {
        while (!this.err && !this.rowsRead[row]) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void sendHead(ImageConsumer ic) {
        if (this.err) {
            return;
        }
        ic.setDimensions(this.width, this.height);
        ic.setColorModel(model);
        ic.setHints(30);
    }

    private void sendPixelRow(ImageConsumer ic, int row) {
        if (this.err) {
            return;
        }
        this.waitForRow(row);
        if (this.err) {
            return;
        }
        ic.setPixels(0, row, this.width, 1, model, this.rgbPixels[row], 0, this.width);
    }

    private void sendTail(ImageConsumer ic) {
        if (this.err) {
            ic.imageComplete(1);
        } else {
            ic.imageComplete(3);
        }
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
        if (ic != null && !this.isConsumer(ic)) {
            this.consumers.addElement(ic);
        }
    }

    @Override
    public boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
        this.consumers.removeElement(ic);
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        if (!this.startedRead) {
            this.startedRead = true;
            new ImageDecoderRead(this);
        }
        if (!this.producing) {
            this.producing = true;
            this.sendImage();
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
        this.addConsumer(ic);
        this.waitForSize();
        this.sendHead(ic);
        int row = 0;
        while (row < this.height) {
            this.sendPixelRow(ic, row);
            ++row;
        }
        this.sendTail(ic);
    }
}

