/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;

final class InstanceList
implements PrimitiveList {
    private Instance[] instances;
    private Instance[] lights;

    InstanceList() {
        this.instances = new Instance[0];
        this.clearLightSources();
    }

    InstanceList(Instance[] instanceArray) {
        this.instances = instanceArray;
        this.clearLightSources();
    }

    void addLightSourceInstances(Instance[] instanceArray) {
        this.lights = instanceArray;
    }

    void clearLightSources() {
        this.lights = new Instance[0];
    }

    public final float getPrimitiveBound(int n, int n2) {
        if (n < this.instances.length) {
            return this.instances[n].getBounds().getBound(n2);
        }
        return this.lights[n - this.instances.length].getBounds().getBound(n2);
    }

    public final BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        for (Instance instance : this.instances) {
            boundingBox.include(instance.getBounds());
        }
        for (Instance instance : this.lights) {
            boundingBox.include(instance.getBounds());
        }
        return boundingBox;
    }

    public final void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        if (n < this.instances.length) {
            this.instances[n].intersect(ray, intersectionState);
        } else {
            this.lights[n - this.instances.length].intersect(ray, intersectionState);
        }
    }

    public final int getNumPrimitives() {
        return this.instances.length + this.lights.length;
    }

    public final int getNumPrimitives(int n) {
        return n < this.instances.length ? this.instances[n].getNumPrimitives() : this.lights[n - this.instances.length].getNumPrimitives();
    }

    public final void prepareShadingState(ShadingState shadingState) {
        shadingState.getInstance().prepareShadingState(shadingState);
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        return true;
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

