/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.zeroc.Glacier2.RouterPrx;
import com.zeroc.Ice.ACMHeartbeat;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointParseException;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.ProxyParseException;
import com.zeroc.IceGrid.AdapterObserverPrx;
import com.zeroc.IceGrid.AdminPrx;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.ApplicationObserverPrx;
import com.zeroc.IceGrid.NodeObserverPrx;
import com.zeroc.IceGrid.ObjectObserverPrx;
import com.zeroc.IceGrid.ObserverAlreadyRegisteredException;
import com.zeroc.IceGrid.RegistryObserverPrx;
import com.zeroc.IceGridGUI.AdapterObserverI;
import com.zeroc.IceGridGUI.AdminRouter;
import com.zeroc.IceGridGUI.ApplicationObserverI;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.NodeObserverI;
import com.zeroc.IceGridGUI.ObjectObserverI;
import com.zeroc.IceGridGUI.RegistryObserverI;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceLocatorDiscovery.Plugin;
import com.zeroc.IceLocatorDiscovery.PluginFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Stack;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;

public class SessionKeeper {
    private ConnectionManagerDialog _connectionManagerDialog;
    private CertificateManagerDialog _certificateManagerDialog;
    private static AuthDialog _authDialog;
    private final Coordinator _coordinator;
    private Plugin _discoveryPlugin;
    private Session _session;
    private boolean _connectedToMaster = false;
    private String _replicaName = "";

    private static JScrollPane createStrippedScrollPane(Component component) {
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private boolean containsSecureEndpoints(String str) {
        try {
            for (Endpoint endpoint : this._coordinator.getCommunicator().stringToProxy(str).ice_getEndpoints()) {
                if (!endpoint.getInfo().secure()) continue;
                return true;
            }
        }
        catch (EndpointParseException endpointParseException) {
        }
        catch (ProxyParseException proxyParseException) {
            // empty catch block
        }
        return false;
    }

    public boolean checkCertificateRequirePassword(String alias) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(this._coordinator.getDataDirectory() + File.separator + "MyCerts.jks"), null);
            if (keyStore.isKeyEntry(alias)) {
                keyStore.getKey(alias, new char[0]);
            }
        }
        catch (UnrecoverableKeyException ex) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean checkCertificatePassword(String alias, char[] password) {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(this._coordinator.getDataDirectory() + File.separator + "MyCerts.jks"), null);
            if (keyStore.isKeyEntry(alias)) {
                keyStore.getKey(alias, password);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static JPanel getSubjectPanel(X509Certificate cert) throws InvalidNameException {
        HashMap<String, java.lang.Object> details = new HashMap<String, java.lang.Object>();
        LdapName dn = new LdapName(cert.getSubjectX500Principal().getName());
        for (Rdn rdn : dn.getRdns()) {
            details.put(rdn.getType().toUpperCase(), rdn.getValue());
        }
        FormLayout layout = new FormLayout("right:pref, 2dlu, left:pref:grow", "pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.addSeparator("Subject");
        builder.nextLine();
        if (details.get("CN") != null) {
            builder.append((Component)new JLabel("<html><b>Common Name (CN):</b></html>"), (Component)new JLabel(details.get("CN").toString()));
        } else {
            builder.append(new JLabel("<html><b>Common Name (CN):</b></html>"));
        }
        if (details.get("O") != null) {
            builder.append((Component)new JLabel("<html><b>Organization (O):</b></html>"), (Component)new JLabel(details.get("O").toString()));
        } else {
            builder.append(new JLabel("<html><b>Organization (O):</b></html>"));
        }
        if (details.get("OU") != null) {
            builder.append((Component)new JLabel("<html><b>Organization Unit (OU):</b></html>"), (Component)new JLabel(details.get("OU").toString()));
        } else {
            builder.append(new JLabel("<html><b>Organization Unit (OU):</b></html>"));
        }
        builder.append((Component)new JLabel("<html><b>Serial Number:</b></html>"), (Component)new JLabel(cert.getSerialNumber().toString()));
        return builder.getPanel();
    }

    public static JPanel getIssuerPanel(X509Certificate cert) throws InvalidNameException {
        HashMap<String, java.lang.Object> details = new HashMap<String, java.lang.Object>();
        LdapName dn = new LdapName(cert.getIssuerX500Principal().getName());
        for (Rdn rdn : dn.getRdns()) {
            details.put(rdn.getType().toUpperCase(), rdn.getValue());
        }
        FormLayout layout = new FormLayout("right:pref, 2dlu, left:pref:grow", "pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.addSeparator("Issuer");
        builder.nextLine();
        if (details.get("CN") != null) {
            builder.append((Component)new JLabel("<html><b>Common Name (CN):</b></html>"), (Component)new JLabel(details.get("CN").toString()));
        } else {
            builder.append(new JLabel("<html><b>Common Name (CN):</b></html>"));
        }
        if (details.get("O") != null) {
            builder.append((Component)new JLabel("<html><b>Organization (O):</b></html>"), (Component)new JLabel(details.get("O").toString()));
        } else {
            builder.append(new JLabel("<html><b>Organization (O):</b></html>"));
        }
        if (details.get("OU") != null) {
            builder.append((Component)new JLabel("<html><b>Organization Unit (OU):</b></html>"), (Component)new JLabel(details.get("OU").toString()));
        } else {
            builder.append(new JLabel("<html><b>Organization Unit (OU):</b></html>"));
        }
        return builder.getPanel();
    }

    public static JPanel getValidityPanel(X509Certificate cert) {
        FormLayout layout = new FormLayout("right:pref, 2dlu, left:pref:grow", "pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.addSeparator("Validity");
        builder.nextLine();
        builder.append((Component)new JLabel("<html><b>Issued On:</b></html>"), (Component)new JLabel(cert.getNotBefore().toString()));
        builder.append((Component)new JLabel("<html><b>Expires On:</b></html>"), (Component)new JLabel(cert.getNotAfter().toString()));
        builder.nextLine();
        return builder.getPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPanel getFingerprintPanel(X509Certificate cert) throws GeneralSecurityException {
        FormLayout layout = new FormLayout("right:pref, 2dlu, left:pref:grow", "pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.addSeparator("Fingerprints");
        builder.nextLine();
        String sha1Fingerprint = "";
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(digest.length * 2);
        try (Formatter formatter = new Formatter(sb);){
            int i = 0;
            while (i < digest.length) {
                formatter.format("%02x", digest[i]);
                if (++i >= digest.length) continue;
                sb.append(":");
            }
        }
        sha1Fingerprint = sb.toString().toUpperCase();
        builder.append((Component)new JLabel("<html><b>SHA-1 Fingerprint:</b></html>"), (Component)new JLabel(sha1Fingerprint));
        builder.nextLine();
        String md5Fingerprint = "";
        MessageDigest md2 = MessageDigest.getInstance("MD5");
        byte[] der2 = cert.getEncoded();
        md2.update(der2);
        byte[] digest2 = md2.digest();
        StringBuilder sb2 = new StringBuilder(digest2.length * 2);
        try (Formatter formatter = new Formatter(sb2);){
            int i = 0;
            while (i < digest2.length) {
                formatter.format("%02x", digest2[i]);
                if (++i >= digest2.length) continue;
                sb2.append(":");
            }
        }
        md5Fingerprint = sb2.toString().toUpperCase();
        builder.append((Component)new JLabel("<html><b>MD5 Fingerprint:</b></html>"), (Component)new JLabel(md5Fingerprint));
        builder.nextLine();
        return builder.getPanel();
    }

    public static JPanel getSubjectAlternativeNamesPanel(X509Certificate cert) throws CertificateParsingException {
        FormLayout layout = new FormLayout("right:pref, 2dlu, left:pref:grow", "pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.addSeparator("Subject Alternate Names");
        builder.nextLine();
        Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
        if (altNames != null) {
            for (List<?> l : altNames) {
                Integer kind = (Integer)l.get(0);
                String value = l.get(1).toString();
                if (kind == 2) {
                    builder.append((Component)new JLabel("<html><b>DNS Name:</b></html>"), (Component)new JLabel(value));
                    builder.nextLine();
                    continue;
                }
                if (kind != 7) continue;
                builder.append((Component)new JLabel("<html><b>IP Address:</b></html>"), (Component)new JLabel(value));
                builder.nextLine();
            }
        }
        return builder.getPanel();
    }

    SessionKeeper(Coordinator coordinator) {
        this._coordinator = coordinator;
    }

    void connectionManager() {
        if (this._connectionManagerDialog == null) {
            this._connectionManagerDialog = new ConnectionManagerDialog();
            Utils.addEscapeListener(this._connectionManagerDialog);
        }
        this._connectionManagerDialog.showDialog();
    }

    public CertificateManagerDialog certificateManager(Component parent) {
        if (this._certificateManagerDialog == null) {
            try {
                this._certificateManagerDialog = new CertificateManagerDialog();
                Utils.addEscapeListener(this._certificateManagerDialog);
            }
            catch (KeyStoreException ex) {
                JOptionPane.showMessageDialog(parent, ex.toString(), "Failed to load certificate manager dialog", 0);
                return null;
            }
            if (!this._certificateManagerDialog.load()) {
                this._certificateManagerDialog.dispose();
                this._certificateManagerDialog = null;
            }
        }
        return this._certificateManagerDialog;
    }

    private void login(final JDialog parent, final ConnectionInfo info) {
        if (_authDialog != null) {
            _authDialog.dispose();
            _authDialog = null;
        }
        if (info.getAuth() == AuthType.UsernamePasswordAuthType) {
            if (info.getPassword() == null || info.getPassword().length == 0 || info.getUseX509Certificate() && this.checkCertificateRequirePassword(info.getAlias()) && (info.getKeyPassword() == null || info.getKeyPassword().length == 0)) {
                class UsernamePasswordAuthDialog
                extends AuthDialog {
                    private JTextField _username;
                    private JPasswordField _password;
                    private JCheckBox _storePassword;
                    private JTextField _keyAlias;
                    private JPasswordField _keyPassword;
                    private JCheckBox _storeKeyPassword;

                    UsernamePasswordAuthDialog() {
                        super(jDialog, "Login - IceGrid GUI");
                        Container contentPane = this.getContentPane();
                        contentPane.setLayout(new BoxLayout(contentPane, 1));
                        FormLayout layout = new FormLayout("pref, 2dlu, pref:grow, 2dlu, pref", "");
                        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                        builder.border(Borders.DIALOG);
                        if (info.getPassword() == null || info.getPassword().length == 0) {
                            this._username = new JTextField(20);
                            this._username.setText(info.getUsername());
                            this._username.setEditable(false);
                            builder.append((Component)new JLabel("Username"), (Component)this._username);
                            builder.nextLine();
                            this._password = new JPasswordField(20);
                            builder.append((Component)new JLabel("Password"), (Component)this._password);
                            builder.nextLine();
                            this._storePassword = new JCheckBox("Save Password.");
                            this._storePassword.setEnabled(this._password.getPassword() != null && this._password.getPassword().length > 0);
                            this._password.getDocument().addDocumentListener(new DocumentListener(){

                                @Override
                                public void changedUpdate(DocumentEvent e) {
                                    _storePassword.setEnabled(_password.getPassword() != null && _password.getPassword().length > 0);
                                }

                                @Override
                                public void removeUpdate(DocumentEvent e) {
                                    _storePassword.setEnabled(_password.getPassword() != null && _password.getPassword().length > 0);
                                }

                                @Override
                                public void insertUpdate(DocumentEvent e) {
                                    _storePassword.setEnabled(_password.getPassword() != null && _password.getPassword().length > 0);
                                }
                            });
                            builder.append("", (Component)this._storePassword);
                            builder.nextLine();
                        }
                        if (info.getUseX509Certificate() && (info.getKeyPassword() == null || info.getKeyPassword().length == 0)) {
                            this._keyAlias = new JTextField(20);
                            this._keyAlias.setText(info.getAlias());
                            this._keyAlias.setEditable(false);
                            builder.append((Component)new JLabel("Key Alias"), (Component)this._keyAlias);
                            builder.nextLine();
                            this._keyPassword = new JPasswordField(20);
                            builder.append((Component)new JLabel("Key Password"), (Component)this._keyPassword);
                            builder.nextLine();
                            this._storeKeyPassword = new JCheckBox("Save Key Password.");
                            this._storeKeyPassword.setEnabled(this._keyPassword.getPassword() != null && this._keyPassword.getPassword().length > 0);
                            this._keyPassword.getDocument().addDocumentListener(new DocumentListener(){

                                @Override
                                public void changedUpdate(DocumentEvent e) {
                                    _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                                }

                                @Override
                                public void removeUpdate(DocumentEvent e) {
                                    _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                                }

                                @Override
                                public void insertUpdate(DocumentEvent e) {
                                    _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                                }
                            });
                            builder.append("", (Component)this._storeKeyPassword);
                            builder.nextLine();
                        }
                        contentPane.add(builder.getPanel());
                        final JButton okButton = new JButton();
                        final JButton cancelButton = new JButton();
                        AbstractAction okAction = new AbstractAction("OK"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (SessionKeeper.this._session != null) {
                                    SessionKeeper.this.logout(true);
                                }
                                assert (SessionKeeper.this._session == null);
                                if (_password != null) {
                                    info.setPassword(_password.getPassword());
                                    info.setStorePassword(_storePassword.isSelected());
                                }
                                if (_keyPassword != null) {
                                    info.setKeyPassword(_keyPassword.getPassword());
                                    info.setStoreKeyPassword(_storeKeyPassword.isSelected());
                                }
                                if (SessionKeeper.this.checkCertificateRequirePassword(info.getAlias()) && !SessionKeeper.this.checkCertificatePassword(info.getAlias(), info.getKeyPassword())) {
                                    this.dispose();
                                    SessionKeeper.this.permissionDenied(parent, info, "Invalid certificate password");
                                } else {
                                    _authDialog.setCursor(Cursor.getPredefinedCursor(3));
                                    _authDialog.setDefaultCloseOperation(0);
                                    Utils.removeEscapeListener(_authDialog);
                                    okButton.setEnabled(false);
                                    cancelButton.setEnabled(false);
                                    SessionKeeper.this._coordinator.login(SessionKeeper.this, info, parent);
                                }
                            }
                        };
                        okButton.setAction(okAction);
                        AbstractAction cancelAction = new AbstractAction("Cancel"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                this.dispose();
                            }
                        };
                        cancelButton.setAction(cancelAction);
                        JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(okButton, cancelButton).addGlue().build();
                        buttonBar.setBorder(Borders.DIALOG);
                        contentPane.add(buttonBar);
                        this.getRootPane().setDefaultButton(okButton);
                        this.pack();
                        this.setResizable(false);
                    }
                }
                _authDialog = new UsernamePasswordAuthDialog();
                Utils.addEscapeListener(_authDialog);
                _authDialog.showDialog();
            } else {
                if (this._session != null) {
                    this.logout(true);
                }
                assert (this._session == null);
                if (info.getUseX509Certificate() && this.checkCertificateRequirePassword(info.getAlias()) && !this.checkCertificatePassword(info.getAlias(), info.getKeyPassword())) {
                    this.permissionDenied(parent, info, "Invalid certificate password");
                } else {
                    _authDialog = new StoredPasswordAuthDialog(parent);
                    _authDialog.setCursor(Cursor.getPredefinedCursor(3));
                    _authDialog.setDefaultCloseOperation(0);
                    this._coordinator.login(this, info, parent);
                    _authDialog.showDialog();
                }
            }
        } else if ((info.getKeyPassword() == null || info.getKeyPassword().length == 0) && this.checkCertificateRequirePassword(info.getAlias())) {
            class X509CertificateAuthDialog
            extends AuthDialog {
                private JPasswordField _keyPassword;
                private JCheckBox _storeKeyPassword;

                X509CertificateAuthDialog() {
                    super(jDialog, "Login - IceGrid GUI");
                    this._keyPassword = new JPasswordField(20);
                    Container contentPane = this.getContentPane();
                    contentPane.setLayout(new BoxLayout(contentPane, 1));
                    FormLayout layout = new FormLayout("pref, 2dlu, pref:grow, 2dlu, pref", "");
                    DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                    builder.border(Borders.DIALOG);
                    builder.append((Component)new JLabel("Key Password"), (Component)this._keyPassword);
                    builder.nextLine();
                    this._storeKeyPassword = new JCheckBox("Save Key Password.");
                    this._storeKeyPassword.setEnabled(false);
                    this._keyPassword.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                        }
                    });
                    builder.append("", (Component)this._storeKeyPassword);
                    builder.nextLine();
                    contentPane.add(builder.getPanel());
                    final JButton okButton = new JButton();
                    final JButton cancelButton = new JButton();
                    AbstractAction okAction = new AbstractAction("OK"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (SessionKeeper.this._session != null) {
                                SessionKeeper.this.logout(true);
                            }
                            assert (SessionKeeper.this._session == null);
                            info.setKeyPassword(_keyPassword.getPassword());
                            if (SessionKeeper.this.checkCertificateRequirePassword(info.getAlias()) && !SessionKeeper.this.checkCertificatePassword(info.getAlias(), info.getKeyPassword())) {
                                this.dispose();
                                SessionKeeper.this.permissionDenied(parent, info, "Invalid certificate password");
                            } else {
                                _authDialog.setCursor(Cursor.getPredefinedCursor(3));
                                _authDialog.setDefaultCloseOperation(0);
                                Utils.removeEscapeListener(_authDialog);
                                okButton.setEnabled(false);
                                cancelButton.setEnabled(false);
                                SessionKeeper.this._coordinator.login(SessionKeeper.this, info, parent);
                            }
                        }
                    };
                    okButton.setAction(okAction);
                    AbstractAction cancelAction = new AbstractAction("Cancel"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            this.dispose();
                        }
                    };
                    cancelButton.setAction(cancelAction);
                    JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(okButton, cancelButton).addGlue().build();
                    buttonBar.setBorder(Borders.DIALOG);
                    contentPane.add(buttonBar);
                    this.getRootPane().setDefaultButton(okButton);
                    this.pack();
                    this.setResizable(false);
                }
            }
            _authDialog = new X509CertificateAuthDialog();
            Utils.addEscapeListener(_authDialog);
            _authDialog.showDialog();
        } else {
            if (this._session != null) {
                this.logout(true);
            }
            assert (this._session == null);
            if (this.checkCertificateRequirePassword(info.getAlias()) && !this.checkCertificatePassword(info.getAlias(), info.getKeyPassword())) {
                this.permissionDenied(parent, info, "Invalid certificate password");
            } else {
                _authDialog = new StoredPasswordAuthDialog(parent);
                _authDialog.setCursor(Cursor.getPredefinedCursor(3));
                _authDialog.setDefaultCloseOperation(0);
                this._coordinator.login(this, info, parent);
                _authDialog.showDialog();
            }
        }
    }

    public void loginSuccess(JDialog parent, long sessionTimeout, int acmTimeout, AdminSessionPrx adminSession, ConnectionInfo info) {
        try {
            if (!info.getStorePassword()) {
                info.setPassword(null);
            }
            if (!info.getStoreKeyPassword()) {
                info.setKeyPassword(null);
            }
            info.save();
            this._connectionManagerDialog.load();
        }
        catch (BackingStoreException ex) {
            JOptionPane.showMessageDialog(parent, ex.toString(), "Error saving connection", 0);
        }
        assert (adminSession != null);
        try {
            this._replicaName = adminSession.getReplicaName();
        }
        catch (LocalException e) {
            this.logout(true);
            JOptionPane.showMessageDialog(parent, "Could not retrieve replica name: " + e.toString(), "Login failed", 0);
            return;
        }
        this._coordinator.setConnected(true);
        this._connectedToMaster = this._replicaName.equals("Master");
        if (this._connectedToMaster) {
            this._coordinator.getStatusBar().setText("Logged into Master Registry");
        } else {
            this._coordinator.getStatusBar().setText("Logged into Slave Registry '" + this._replicaName + "'");
        }
        this._coordinator.getExecutor().submit(() -> {
            try {
                Session session = new Session(adminSession, sessionTimeout, acmTimeout, !info.getDirect(), parent);
                SwingUtilities.invokeAndWait(() -> {
                    this._session = session;
                });
                try {
                    session.registerObservers();
                }
                catch (LocalException e) {
                    while (true) {
                        try {
                            SwingUtilities.invokeAndWait(() -> {
                                this.logout(true);
                                JOptionPane.showMessageDialog(parent, "Could not register observers: " + e.toString(), "Login failed", 0);
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        catch (InvocationTargetException ex) {
                        }
                        break;
                    }
                }
            }
            catch (Throwable e) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (_authDialog != null) {
                    _authDialog.dispose();
                    _authDialog = null;
                }
                this._connectionManagerDialog.setConnectionWizard(null);
                this._connectionManagerDialog.setVisible(false);
            });
        });
    }

    public void loginFailed() {
        if (_authDialog != null) {
            _authDialog.dispose();
            _authDialog = null;
        }
    }

    public void permissionDenied(final JDialog parent, final ConnectionInfo info, String msg) {
        JOptionPane.showMessageDialog(parent, "Permission denied: " + msg, "Login failed", 0);
        class PermissionDeniedAuthDialog
        extends AuthDialog {
            private JTextField _username;
            private JPasswordField _password;
            private JCheckBox _storePassword;
            private JTextField _keyAlias;
            private JPasswordField _keyPassword;
            private JCheckBox _storeKeyPassword;

            PermissionDeniedAuthDialog() {
                super(jDialog, "Login - IceGrid GUI");
                Container contentPane = this.getContentPane();
                contentPane.setLayout(new BoxLayout(contentPane, 1));
                FormLayout layout = new FormLayout("pref, 2dlu, pref:grow, 2dlu, pref", "");
                DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                builder.border(Borders.DIALOG);
                if (info.getAuth() == AuthType.UsernamePasswordAuthType) {
                    this._username = new JTextField(20);
                    this._username.setText(info.getUsername());
                    this._username.setEditable(false);
                    builder.append((Component)new JLabel("Username"), (Component)this._username);
                    builder.nextLine();
                    this._password = new JPasswordField(20);
                    if (info.getPassword() != null) {
                        this._password.setText(new String(info.getPassword()));
                    }
                    builder.append((Component)new JLabel("Password"), (Component)this._password);
                    builder.nextLine();
                    this._storePassword = new JCheckBox("Save Password.");
                    this._storePassword.setSelected(info.getStorePassword());
                    this._storePassword.setEnabled(this._password.getPassword() != null && this._password.getPassword().length > 0);
                    this._password.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            _storePassword.setEnabled(_password.getPassword() != null && _password.getPassword().length > 0);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            _storePassword.setEnabled(_password.getPassword() != null && _password.getPassword().length > 0);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            _storePassword.setEnabled(_password.getPassword() != null && _password.getPassword().length > 0);
                        }
                    });
                    builder.append("", (Component)this._storePassword);
                    builder.nextLine();
                }
                if (info.getUseX509Certificate()) {
                    this._keyAlias = new JTextField(20);
                    this._keyAlias.setText(info.getAlias());
                    this._keyAlias.setEditable(false);
                    builder.append((Component)new JLabel("Key Alias"), (Component)this._keyAlias);
                    builder.nextLine();
                    this._keyPassword = new JPasswordField(20);
                    if (info.getKeyPassword() != null) {
                        this._keyPassword.setText(new String(info.getKeyPassword()));
                    }
                    builder.append((Component)new JLabel("Key Password"), (Component)this._keyPassword);
                    builder.nextLine();
                    this._storeKeyPassword = new JCheckBox("Save Key Password.");
                    this._storeKeyPassword.setSelected(info.getStoreKeyPassword());
                    this._storeKeyPassword.setEnabled(this._keyPassword.getPassword() != null && this._keyPassword.getPassword().length > 0);
                    this._keyPassword.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            _storeKeyPassword.setEnabled(_keyPassword.getPassword() != null && _keyPassword.getPassword().length > 0);
                        }
                    });
                    builder.append("", (Component)this._storeKeyPassword);
                    builder.nextLine();
                }
                contentPane.add(builder.getPanel());
                final JButton okButton = new JButton();
                final JButton editConnectionButton = new JButton();
                final JButton cancelButton = new JButton();
                AbstractAction okAction = new AbstractAction("OK"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (SessionKeeper.this._session != null) {
                            SessionKeeper.this.logout(true);
                        }
                        assert (SessionKeeper.this._session == null);
                        if (_password != null) {
                            info.setPassword(_password.getPassword());
                            info.setStorePassword(_storePassword.isSelected());
                        }
                        boolean certificatePasswordMatch = true;
                        if (_keyPassword != null) {
                            info.setKeyPassword(_keyPassword.getPassword());
                            info.setStoreKeyPassword(_storeKeyPassword.isSelected());
                            certificatePasswordMatch = SessionKeeper.this.checkCertificatePassword(info.getAlias(), info.getKeyPassword());
                        }
                        if (!certificatePasswordMatch) {
                            this.dispose();
                            SessionKeeper.this.permissionDenied(parent, info, "Invalid certificate password");
                        } else {
                            _authDialog.setCursor(Cursor.getPredefinedCursor(3));
                            okButton.setEnabled(false);
                            editConnectionButton.setEnabled(false);
                            cancelButton.setEnabled(false);
                            Utils.removeEscapeListener(_authDialog);
                            _authDialog.setDefaultCloseOperation(0);
                            SessionKeeper.this._coordinator.login(SessionKeeper.this, info, parent);
                        }
                    }
                };
                AbstractAction editAction = new AbstractAction("Edit Connection"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        info.load();
                        this.dispose();
                        _authDialog = null;
                        ConnectionWizardDialog dialog = new ConnectionWizardDialog(info, parent);
                        Utils.addEscapeListener(dialog);
                        dialog.setLocationRelativeTo(parent);
                        dialog.setVisible(true);
                    }
                };
                AbstractAction cancelAction = new AbstractAction("Cancel"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        info.load();
                        this.dispose();
                        _authDialog = null;
                    }
                };
                JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(okButton, editConnectionButton, cancelButton).addGlue().build();
                buttonBar.setBorder(Borders.DIALOG);
                contentPane.add(buttonBar);
                this.getRootPane().setDefaultButton(okButton);
                this.pack();
                this.setResizable(false);
            }
        }
        _authDialog = new PermissionDeniedAuthDialog();
        Utils.addEscapeListener(_authDialog);
        _authDialog.showDialog();
    }

    void sessionLost(String message) {
        JOptionPane.showMessageDialog(this._coordinator.getMainFrame(), message, "Session lost", 0);
        this.logout(false);
    }

    void logout(boolean destroySession) {
        if (this._session != null) {
            this._session.logout(destroySession);
            this._session = null;
        }
    }

    AdminSessionPrx getSession() {
        return this._session == null ? null : this._session.getSession();
    }

    AdminPrx getAdmin() {
        return this._session == null ? null : this._session.getAdmin();
    }

    String getServerAdminCategory() {
        return this._session == null ? null : this._session.getServerAdminCategory();
    }

    ObjectPrx addCallback(Object servant, String name, String facet) {
        return this._session == null ? null : this._session.addCallback(servant, name, facet);
    }

    ObjectPrx retrieveCallback(String name, String facet) {
        return this._session == null ? null : this._session.retrieveCallback(name, facet);
    }

    Object removeCallback(String name, String facet) {
        return this._session == null ? null : this._session.removeCallback(name, facet);
    }

    AdminPrx getRoutedAdmin() {
        return this._session == null ? null : this._session.getRoutedAdmin();
    }

    boolean connectedToMaster() {
        return this._session != null && this._connectedToMaster;
    }

    String getReplicaName() {
        return this._replicaName;
    }

    class StoredPasswordAuthDialog
    extends AuthDialog {
        StoredPasswordAuthDialog(JDialog parent) {
            super(parent, "Login - IceGrid GUI");
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            FormLayout layout = new FormLayout("pref:grow", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.append(new JLabel("Connecting please wait"));
            contentPane.add(builder.getPanel());
            this.pack();
            this.setResizable(false);
        }
    }

    class AuthDialog
    extends JDialog {
        public AuthDialog(JDialog parent, String title) {
            super(parent, title, true);
            this.setDefaultCloseOperation(2);
        }

        public void showDialog() {
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
        }
    }

    public class CertificateManagerDialog
    extends JDialog {
        private JTabbedPane _tabs;
        private KeyStorePanel _identityCertificatesPanel;
        private KeyStorePanel _serverCertificatesPanel;
        private KeyStorePanel _authorityCertificatesPanel;

        CertificateManagerDialog() throws KeyStoreException {
            super(SessionKeeper.this._coordinator.getMainFrame(), "Certificate Manager - IceGrid GUI", true);
            this._tabs = new JTabbedPane();
            this._identityCertificatesPanel = new KeyStorePanel();
            this._tabs.addTab("My Certificates", this._identityCertificatesPanel);
            this._serverCertificatesPanel = new KeyStorePanel();
            this._tabs.addTab("Server Certificates", this._serverCertificatesPanel);
            this._authorityCertificatesPanel = new KeyStorePanel();
            this._tabs.addTab("Trusted CAs", this._authorityCertificatesPanel);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(this._tabs);
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateManagerDialog.this.setVisible(false);
                }
            });
            this.getRootPane().setDefaultButton(closeButton);
            JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton((JComponent)closeButton).build();
            buttonBar.setBorder(Borders.DIALOG);
            contentPane.add(buttonBar);
            this.setResizable(false);
            this.pack();
        }

        boolean load() {
            try {
                this._identityCertificatesPanel.load(SessionKeeper.this._coordinator.getDataDirectory() + File.separator + "MyCerts.jks");
                this._serverCertificatesPanel.load(SessionKeeper.this._coordinator.getDataDirectory() + File.separator + "ServerCerts.jks");
                this._authorityCertificatesPanel.load(SessionKeeper.this._coordinator.getDataDirectory() + File.separator + "AuthorityCerts.jks");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.toString(), "Error loading keystore", 0);
                return false;
            }
            return true;
        }

        Vector<String> myCertsAliases() {
            return this._identityCertificatesPanel.aliases();
        }

        void setActiveTab(int index) {
            this._tabs.setSelectedIndex(index);
        }

        void showDialog() {
            if (!this.isVisible()) {
                this.setLocationRelativeTo(SessionKeeper.this._coordinator.getMainFrame());
                this.setVisible(true);
            }
        }
    }

    public class CertificateDetailDialog
    extends JDialog {
        CertificateDetailDialog(X509Certificate cert) throws GeneralSecurityException, IOException, InvalidNameException {
            super(SessionKeeper.this._coordinator.getMainFrame(), "Certificate Details - IceGrid GUI", true);
            this.setDefaultCloseOperation(2);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(SessionKeeper.getSubjectPanel(cert));
            contentPane.add(SessionKeeper.getSubjectAlternativeNamesPanel(cert));
            contentPane.add(SessionKeeper.getIssuerPanel(cert));
            contentPane.add(SessionKeeper.getValidityPanel(cert));
            contentPane.add(SessionKeeper.getFingerprintPanel(cert));
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateDetailDialog.this.dispose();
                }
            });
            JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton((JComponent)closeButton).build();
            buttonBar.setBorder(Borders.DIALOG);
            contentPane.add(buttonBar);
            this.pack();
            this.setResizable(false);
        }

        void showDialog() {
            if (!this.isVisible()) {
                this.setLocationRelativeTo(SessionKeeper.this._coordinator.getMainFrame());
                this.setVisible(true);
            }
        }
    }

    public class KeyStorePanel
    extends JPanel {
        private JTable _certificatesTable;
        private JButton _importButton;
        private JButton _viewButton;
        private JButton _removeButton;
        private KeyStore _keyStore = KeyStore.getInstance("JKS");
        private String _keyStorePath;
        private Vector<String> _aliases;
        private AbstractTableModel _tableModel;

        public RequestPasswordResult requestPassword(String title, String label) {
            RequestPasswordResult r = new RequestPasswordResult();
            final JPasswordField passwordField = new JPasswordField();
            JOptionPane optionPane = new JOptionPane(new JComponent[]{new JLabel(label), passwordField}, 3, 2);
            JDialog dialog = optionPane.createDialog(this, title);
            Utils.addEscapeListener(dialog);
            dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    SwingUtilities.invokeLater(() -> passwordField.requestFocusInWindow());
                }
            });
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            java.lang.Object result = optionPane.getValue();
            dialog.dispose();
            if (result != null && result instanceof Integer && (Integer)result == 0) {
                r.password = passwordField.getPassword();
                r.accepted = true;
            } else {
                r.accepted = false;
            }
            return r;
        }

        public KeyStorePanel() throws KeyStoreException {
            FormLayout layout = new FormLayout("pref:grow", "pref:grow");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            final String[] columnNames = new String[]{"Alias", "Subject", "Issuer"};
            this._tableModel = new AbstractTableModel(){

                @Override
                public String getColumnName(int col) {
                    return columnNames[col].toString();
                }

                @Override
                public int getRowCount() {
                    if (KeyStorePanel.this._aliases == null) {
                        return 0;
                    }
                    return KeyStorePanel.this._aliases.size();
                }

                @Override
                public int getColumnCount() {
                    return columnNames.length;
                }

                @Override
                public java.lang.Object getValueAt(int row, int col) {
                    if (KeyStorePanel.this._aliases == null) {
                        return "";
                    }
                    if (col == 0) {
                        return KeyStorePanel.this._aliases.get(row);
                    }
                    try {
                        Certificate cert = KeyStorePanel.this._keyStore.getCertificate((String)KeyStorePanel.this._aliases.get(row));
                        if (cert instanceof X509Certificate) {
                            X509Certificate x509Cert = (X509Certificate)cert;
                            if (col == 1) {
                                return x509Cert.getSubjectX500Principal().toString();
                            }
                            if (col == 2) {
                                return x509Cert.getIssuerX500Principal().toString();
                            }
                        }
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                    return "";
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }

                @Override
                public void setValueAt(java.lang.Object value, int row, int col) {
                }
            };
            this._certificatesTable = new JTable(this._tableModel);
            JScrollPane certificatesScroll = SessionKeeper.createStrippedScrollPane(this._certificatesTable);
            certificatesScroll.setMinimumSize(new Dimension(500, 200));
            certificatesScroll.setPreferredSize(new Dimension(500, 200));
            builder.add(certificatesScroll);
            this._importButton = new JButton();
            AbstractAction importAction = new AbstractAction("Import"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String defaultPath = Coordinator.getPreferences().node("Configurations").get("importDirectory", "");
                    JFileChooser chooser = new JFileChooser(defaultPath.equals("") ? null : new File(defaultPath));
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            return f != null && (f.getName().toUpperCase().endsWith(".PFX") || f.getName().toUpperCase().endsWith(".P12"));
                        }

                        @Override
                        public String getDescription() {
                            return "PKCS12 Files (*.pfx, *.p12)";
                        }
                    });
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            return f != null && (f.getName().toUpperCase().endsWith(".PEM") || f.getName().toUpperCase().endsWith(".CRT"));
                        }

                        @Override
                        public String getDescription() {
                            return "PEM Files (*.pem, *.crt)";
                        }
                    });
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            return f != null && f.getName().toUpperCase().endsWith(".JKS");
                        }

                        @Override
                        public String getDescription() {
                            return "Java Key Store Files (*.jks)";
                        }
                    });
                    File keyFile = null;
                    if (chooser.showOpenDialog(KeyStorePanel.this) == 0) {
                        String filePath = chooser.getSelectedFile().getAbsolutePath();
                        boolean pkcs12 = filePath.toUpperCase().endsWith(".PFX") || filePath.toUpperCase().endsWith(".P12");
                        boolean pem = filePath.toUpperCase().endsWith(".PEM") || filePath.toUpperCase().endsWith(".CRT");
                        keyFile = new File(filePath);
                        if (pkcs12) {
                            KeyStore keyStore = null;
                            boolean loaded = false;
                            while (true) {
                                try {
                                    keyStore = KeyStore.getInstance("pkcs12");
                                    RequestPasswordResult r = KeyStorePanel.this.requestPassword("KeyStore Password - IceGrid GUI", "KeyStore password:");
                                    if (!r.accepted) break;
                                    keyStore.load(new FileInputStream(keyFile), r.password);
                                    loaded = true;
                                }
                                catch (IOException ex) {
                                    JOptionPane.showMessageDialog(KeyStorePanel.this, "Invalid certificate password", "Invalid certificate password", 0);
                                    continue;
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(KeyStorePanel.this, ex.toString(), "Error importing certificate", 0);
                                    return;
                                }
                                break;
                            }
                            if (loaded) {
                                try {
                                    KeyStorePanel.this.importKeyStore(keyStore);
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(KeyStorePanel.this, ex.toString(), "Error importing certificate", 0);
                                    return;
                                }
                            }
                        } else {
                            if (pem) {
                                try {
                                    FileInputStream fis = new FileInputStream(keyFile);
                                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                    Collection<? extends Certificate> c = cf.generateCertificates(fis);
                                    for (Certificate certificate : c) {
                                        String newAlias = JOptionPane.showInputDialog(KeyStorePanel.this, "Certificate Alias", "Certificate Alias", 1);
                                        if (newAlias == null || newAlias.length() == 0 || KeyStorePanel.this._keyStore.containsAlias(newAlias) && JOptionPane.showConfirmDialog(KeyStorePanel.this, "<html>Your KeyStore already contains a certificate with alias `" + newAlias + "'<br/>Do you want to update the certificate?</html>", "Confirm Certificate Update - IceGrid GUI", 0) == 1) continue;
                                        KeyStorePanel.this._keyStore.setCertificateEntry(newAlias, certificate);
                                    }
                                    KeyStorePanel.this._keyStore.store(new FileOutputStream(KeyStorePanel.this._keyStorePath), new char[0]);
                                    KeyStorePanel.this.load(KeyStorePanel.this._keyStorePath);
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog(KeyStorePanel.this, ex.toString(), "Error importing certificate", 0);
                                    return;
                                }
                            }
                            try {
                                KeyStore keyStore = KeyStore.getInstance("JKS");
                                keyStore.load(new FileInputStream(keyFile), null);
                                KeyStorePanel.this.importKeyStore(keyStore);
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(KeyStorePanel.this, ex.toString(), "Error importing certificate", 0);
                                return;
                            }
                        }
                    }
                    if (keyFile != null) {
                        Coordinator.getPreferences().node("Configurations").put("importDirectory", keyFile.getParent());
                    }
                }
            };
            this._importButton.setAction(importAction);
            this._viewButton = new JButton();
            AbstractAction viewAction = new AbstractAction("View"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = KeyStorePanel.this._certificatesTable.getSelectionModel().getMinSelectionIndex();
                    if (index != -1) {
                        try {
                            Certificate cert = KeyStorePanel.this._keyStore.getCertificate((String)KeyStorePanel.this._aliases.get(index));
                            if (cert instanceof X509Certificate) {
                                X509Certificate x509Cert = (X509Certificate)cert;
                                CertificateDetailDialog d = new CertificateDetailDialog(x509Cert);
                                d.showDialog();
                            }
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(KeyStorePanel.this, ex.toString(), "Error loading certificate", 0);
                            return;
                        }
                    }
                }
            };
            this._viewButton.setAction(viewAction);
            this._removeButton = new JButton();
            AbstractAction removeAction = new AbstractAction("Remove"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = KeyStorePanel.this._certificatesTable.getSelectionModel().getMinSelectionIndex();
                    if (index != -1 && JOptionPane.showConfirmDialog(KeyStorePanel.this, "Do you want to remove the certficate with alias `" + (String)KeyStorePanel.this._aliases.get(index) + "'?", "Remove Certificate - IceGrid GUI", 0) == 0) {
                        try {
                            KeyStorePanel.this._keyStore.deleteEntry((String)KeyStorePanel.this._aliases.get(index));
                            KeyStorePanel.this._keyStore.store(new FileOutputStream(KeyStorePanel.this._keyStorePath), new char[0]);
                            KeyStorePanel.this.load(KeyStorePanel.this._keyStorePath);
                            KeyStorePanel.this._tableModel.fireTableStructureChanged();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(KeyStorePanel.this, ex.toString(), "Error removing certificate", 0);
                            return;
                        }
                    }
                }
            };
            this._removeButton.setAction(removeAction);
            this.setLayout(new BoxLayout(this, 1));
            this.add(builder.getPanel());
            JPanel buttonBar = new ButtonBarBuilder().addButton(this._importButton, this._viewButton, this._removeButton).addGlue().build();
            buttonBar.setBorder(Borders.DIALOG);
            this.add(buttonBar);
        }

        public void importKeyStore(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException, GeneralSecurityException, FileNotFoundException, IOException {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (keyStore.isKeyEntry(alias)) {
                    RequestPasswordResult r = null;
                    Key key = null;
                    while (true) {
                        try {
                            r = this.requestPassword("Certificate Password For <" + alias + "> - IceGrid GUI", "Certificate password for <" + alias + ">:");
                            if (!r.accepted) break;
                            key = keyStore.getKey(alias, r.password);
                        }
                        catch (UnrecoverableKeyException ex) {
                            JOptionPane.showMessageDialog(this, "Invalid certificate password", "Invalid certificate password", 0);
                            continue;
                        }
                        break;
                    }
                    if (key == null) continue;
                    Certificate[] chain = keyStore.getCertificateChain(alias);
                    String newAlias = alias;
                    if (newAlias == null || newAlias.length() == 0 || this._keyStore.containsAlias(newAlias)) {
                        newAlias = JOptionPane.showInputDialog(this, "Certificate Alias For <" + alias + ">", "certificate alias for <" + alias + ">:", 1);
                    }
                    if (newAlias == null || this._keyStore.containsAlias(newAlias) && JOptionPane.showConfirmDialog(this, "<html>Your KeyStore already contains a certificate with alias `" + newAlias + "'<br/>Do you want to update the certificate?</html>", "Confirm Certificate Update - IceGrid GUI", 0) == 1) continue;
                    this._keyStore.setKeyEntry(newAlias, key, r.password, chain);
                    continue;
                }
                if (!keyStore.isCertificateEntry(alias)) continue;
                String newAlias = alias;
                if (newAlias == null || newAlias.length() == 0 || this._keyStore.containsAlias(newAlias)) {
                    newAlias = JOptionPane.showInputDialog(this, "Certificate Alias For <" + alias + ">", "certificate alias for <" + alias + ">:", 1);
                }
                if (this._keyStore.containsAlias(newAlias) && JOptionPane.showConfirmDialog(this, "<html>Your KeyStore already contains a certificate with alias `" + newAlias + "'<br/>Do you want to update the certificate?</html>", "Confirm Certificate Update - IceGrid GUI", 0) == 1) continue;
                this._keyStore.setCertificateEntry(newAlias, keyStore.getCertificate(alias));
            }
            this._keyStore.store(new FileOutputStream(this._keyStorePath), new char[0]);
            this.load(this._keyStorePath);
        }

        public void load(String path) throws IOException, GeneralSecurityException {
            this._keyStorePath = path;
            FileInputStream is = null;
            if (new File(path).isFile()) {
                is = new FileInputStream(new File(path));
            }
            this._keyStore.load(is, null);
            if (is == null) {
                this._keyStore.store(new FileOutputStream(this._keyStorePath), new char[0]);
            }
            this._aliases = new Vector();
            Enumeration<String> e = this._keyStore.aliases();
            while (e.hasMoreElements()) {
                this._aliases.add(e.nextElement());
            }
            this._tableModel.fireTableStructureChanged();
        }

        public Vector<String> aliases() {
            return this._aliases;
        }

        public class RequestPasswordResult {
            public char[] password;
            public boolean accepted;
        }
    }

    private class ConnectionManagerDialog
    extends JDialog {
        private JList _connectionList;
        private ConnectionListModel _connectionListModel;
        private JButton _newConnectionButton;
        private JButton _viewConnectionButton;
        private JButton _editConnectionButton;
        private JButton _setDefaultConnectionButton;
        private JButton _removeConnectionButton;
        private JDialog _connectionWizard;
        private JButton _connectButton;

        ConnectionManagerDialog() {
            super(SessionKeeper.this._coordinator.getMainFrame(), "Saved Connections - IceGrid GUI", true);
            this.setDefaultCloseOperation(1);
            JPanel connectionActionPanel = null;
            FormLayout layout = new FormLayout("pref, 2dlu, pref, 2dlu, pref, 2dlu, pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            this._newConnectionButton = new JButton("New Connection");
            this._newConnectionButton.setToolTipText("Configure a new connection with IceGrid registry");
            this._newConnectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog dialog = new ConnectionWizardDialog(ConnectionManagerDialog.this);
                    ConnectionManagerDialog.this.setConnectionWizard(dialog);
                    Utils.addEscapeListener(dialog);
                    dialog.setLocationRelativeTo(ConnectionManagerDialog.this);
                    dialog.setVisible(true);
                }
            });
            builder.append(this._newConnectionButton);
            builder.nextLine();
            this._viewConnectionButton = new JButton("View Connection");
            this._viewConnectionButton.setToolTipText("View connection details.");
            this._viewConnectionButton.setEnabled(false);
            this._viewConnectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.lang.Object obj = ConnectionManagerDialog.this._connectionList.getSelectedValue();
                    if (obj != null && obj instanceof ConnectionInfo) {
                        ConnectionInfo inf = (ConnectionInfo)obj;
                        ConnectionDetailDialog dialog = new ConnectionDetailDialog(inf);
                        Utils.addEscapeListener(dialog);
                        dialog.setLocationRelativeTo(ConnectionManagerDialog.this);
                        dialog.setVisible(true);
                    }
                }
            });
            builder.append(this._viewConnectionButton);
            builder.nextLine();
            this._editConnectionButton = new JButton("Edit Connection");
            this._editConnectionButton.setToolTipText("Edit connection configuration");
            this._editConnectionButton.setEnabled(false);
            this._editConnectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.lang.Object obj = ConnectionManagerDialog.this._connectionList.getSelectedValue();
                    if (obj != null && obj instanceof ConnectionInfo) {
                        ConnectionInfo inf = (ConnectionInfo)obj;
                        ConnectionWizardDialog dialog = new ConnectionWizardDialog(inf, ConnectionManagerDialog.this);
                        Utils.addEscapeListener(dialog);
                        dialog.setLocationRelativeTo(ConnectionManagerDialog.this);
                        dialog.setVisible(true);
                    }
                }
            });
            builder.append(this._editConnectionButton);
            builder.nextLine();
            this._setDefaultConnectionButton = new JButton("Set As Default");
            this._setDefaultConnectionButton.setToolTipText("Set the connection to use by default");
            this._setDefaultConnectionButton.setEnabled(false);
            this._setDefaultConnectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionManagerDialog.this._connectionListModel.setDefault();
                }
            });
            builder.append(this._setDefaultConnectionButton);
            builder.nextLine();
            this._removeConnectionButton = new JButton("Remove Connection");
            this._removeConnectionButton.setToolTipText("Remove connection configuration");
            this._removeConnectionButton.setEnabled(false);
            this._removeConnectionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ConnectionManagerDialog.this._connectionList.getSelectedIndex();
                    java.lang.Object obj = ConnectionManagerDialog.this._connectionList.getSelectedValue();
                    if (obj != null && obj instanceof ConnectionInfo) {
                        ConnectionInfo inf = (ConnectionInfo)obj;
                        if (JOptionPane.showConfirmDialog(ConnectionManagerDialog.this, "Do you want to remove the selected configuration?", "Remove Configuration - IceGrid GUI", 0) == 0) {
                            try {
                                String uuid = inf.getUUID();
                                Preferences prefs = Coordinator.getPreferences().node("Configurations");
                                Preferences preferences = prefs = prefs == null ? null : prefs.node(uuid);
                                if (prefs != null) {
                                    prefs.removeNode();
                                    ConnectionManagerDialog.this.load();
                                    if (index > 0) {
                                        ConnectionManagerDialog.this._connectionList.setSelectedIndex(index - 1);
                                    }
                                    if (ConnectionManagerDialog.this._connectionListModel.size() > 0) {
                                        ConnectionManagerDialog.this._connectionList.setSelectedIndex(0);
                                    }
                                    if (ConnectionManagerDialog.this._connectionList.getSelectedIndex() == -1) {
                                        ConnectionManagerDialog.this._viewConnectionButton.setEnabled(false);
                                        ConnectionManagerDialog.this._editConnectionButton.setEnabled(false);
                                        ConnectionManagerDialog.this._setDefaultConnectionButton.setEnabled(false);
                                        ConnectionManagerDialog.this._removeConnectionButton.setEnabled(false);
                                        ConnectionManagerDialog.this._connectButton.setEnabled(false);
                                    }
                                }
                            }
                            catch (BackingStoreException ex) {
                                JOptionPane.showMessageDialog(ConnectionManagerDialog.this, ex.toString(), "Error removing saved connection", 0);
                            }
                        }
                    }
                }
            });
            builder.append(this._removeConnectionButton);
            builder.nextLine();
            connectionActionPanel = builder.getPanel();
            connectionActionPanel.setBorder(Borders.DIALOG);
            JPanel savedConfigurationsPanel = null;
            FormLayout layout2 = new FormLayout("left:pref", "pref");
            DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
            builder2.border(Borders.DIALOG);
            builder2.rowGroupingEnabled(true);
            this._connectionListModel = new ConnectionListModel();
            this._connectionList = new JList(this._connectionListModel){

                @Override
                public String getToolTipText(MouseEvent evt) {
                    int index = this.locationToIndex(evt.getPoint());
                    if (index < 0) {
                        return null;
                    }
                    java.lang.Object obj = this.getModel().getElementAt(index);
                    if (obj != null && obj instanceof ConnectionInfo) {
                        ConnectionInfo inf = (ConnectionInfo)obj;
                        return inf.toString();
                    }
                    return null;
                }
            };
            class ConnectionListRenderer
            extends DefaultListCellRenderer {
                ConnectionListRenderer() {
                }

                @Override
                public Component getListCellRendererComponent(JList list, java.lang.Object value, int index, boolean selected, boolean hasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
                    if (value instanceof ConnectionInfo) {
                        ConnectionInfo conn = (ConnectionInfo)value;
                        ImageIcon icon = Utils.getIcon(conn.isDefault() ? "/icons/16x16/default.png" : "/icons/16x16/transparent.png");
                        label.setIcon(icon);
                    }
                    return label;
                }
            }
            this._connectionList.setCellRenderer(new ConnectionListRenderer());
            this._connectionList.setVisibleRowCount(7);
            this._connectionList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting()) {
                        ConnectionManagerDialog.this._connectButton.setEnabled(true);
                        ConnectionManagerDialog.this._viewConnectionButton.setEnabled(true);
                        ConnectionManagerDialog.this._editConnectionButton.setEnabled(true);
                        ConnectionManagerDialog.this._removeConnectionButton.setEnabled(true);
                        java.lang.Object selected = ConnectionManagerDialog.this._connectionList.getSelectedValue();
                        if (selected != null && ((ConnectionInfo)selected).isDefault()) {
                            ConnectionManagerDialog.this._setDefaultConnectionButton.setEnabled(false);
                        } else {
                            ConnectionManagerDialog.this._setDefaultConnectionButton.setEnabled(true);
                        }
                    }
                }
            });
            this._connectionList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    java.lang.Object obj;
                    int index;
                    if (e.getClickCount() == 2 && e.getButton() == 1 && (index = ConnectionManagerDialog.this._connectionList.locationToIndex(e.getPoint())) != -1 && (obj = ConnectionManagerDialog.this._connectionListModel.getElementAt(index)) != null && obj instanceof ConnectionInfo) {
                        ConnectionInfo inf = (ConnectionInfo)obj;
                        SessionKeeper.this.login(ConnectionManagerDialog.this, inf);
                    }
                }
            });
            this._connectionList.setFixedCellWidth(500);
            builder2.append(SessionKeeper.createStrippedScrollPane(this._connectionList));
            savedConfigurationsPanel = builder2.getPanel();
            JPanel mainPanel = null;
            FormLayout layout3 = new FormLayout("pref:grow, 2dlu, pref", "pref");
            CellConstraints cc = new CellConstraints();
            mainPanel = new JPanel(layout3);
            mainPanel.add((Component)savedConfigurationsPanel, cc.xy(1, 1));
            mainPanel.add((Component)connectionActionPanel, cc.xy(3, 1));
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(mainPanel);
            this._connectButton = new JButton("Connect");
            this._connectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.lang.Object obj = ConnectionManagerDialog.this._connectionList.getSelectedValue();
                    if (obj != null && obj instanceof ConnectionInfo) {
                        ConnectionInfo inf = (ConnectionInfo)obj;
                        SessionKeeper.this.login(ConnectionManagerDialog.this, inf);
                    }
                }
            });
            this._connectButton.setEnabled(false);
            this.getRootPane().setDefaultButton(this._connectButton);
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionManagerDialog.this.setVisible(false);
                }
            });
            JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(this._connectButton, closeButton).build();
            buttonBar.setBorder(Borders.DIALOG);
            contentPane.add(buttonBar);
            this.pack();
            this.setResizable(false);
            this.load();
        }

        void load() {
            int selected = this._connectionList.getSelectedIndex();
            int defaultIndex = -1;
            Preferences prefs = Coordinator.getPreferences().node("Configurations");
            this._connectionListModel.clear();
            try {
                String[] childrenNames = prefs.childrenNames();
                for (int i = 0; i < childrenNames.length; ++i) {
                    ConnectionInfo info = new ConnectionInfo(childrenNames[i], prefs.node(childrenNames[i]));
                    if (info.isDefault()) {
                        defaultIndex = i;
                    }
                    this._connectionListModel.addElement(info);
                }
                if (selected >= 0 && selected < this._connectionListModel.size()) {
                    this._connectionList.setSelectedIndex(selected);
                } else if (defaultIndex >= 0 && defaultIndex < this._connectionListModel.size()) {
                    this._connectionList.setSelectedIndex(defaultIndex);
                    this._setDefaultConnectionButton.setEnabled(false);
                } else if (selected == -1) {
                    this._connectionList.setSelectedIndex(0);
                } else {
                    this._editConnectionButton.setEnabled(false);
                    this._removeConnectionButton.setEnabled(false);
                    this._setDefaultConnectionButton.setEnabled(false);
                    this._connectButton.setEnabled(false);
                }
            }
            catch (BackingStoreException ex) {
                JOptionPane.showMessageDialog(this, ex.toString(), "Failed to load saved connections", 0);
            }
        }

        void showDialog() {
            if (!this.isVisible()) {
                this.setLocationRelativeTo(SessionKeeper.this._coordinator.getMainFrame());
                this.setVisible(true);
            }
        }

        public void setConnectionWizard(JDialog dialog) {
            if (this._connectionWizard != null) {
                this._connectionWizard.dispose();
            }
            this._connectionWizard = dialog;
        }

        class ConnectionListModel
        extends DefaultListModel {
            ConnectionListModel() {
            }

            public void setDefault() {
                ConnectionInfo info = (ConnectionInfo)ConnectionManagerDialog.this._connectionList.getSelectedValue();
                if (info == null) {
                    return;
                }
                info.setIsDefault(true);
                try {
                    info.save();
                }
                catch (BackingStoreException ex) {
                    JOptionPane.showMessageDialog(SessionKeeper.this._coordinator.getMainFrame(), ex.toString(), "Error saving connection", 0);
                }
                for (java.lang.Object obj : this.toArray()) {
                    if (obj == info) continue;
                    ((ConnectionInfo)obj).setIsDefault(false);
                    try {
                        ((ConnectionInfo)obj).save();
                    }
                    catch (BackingStoreException ex) {
                        JOptionPane.showMessageDialog(SessionKeeper.this._coordinator.getMainFrame(), ex.toString(), "Error saving connection", 0);
                    }
                }
                ConnectionManagerDialog.this._setDefaultConnectionButton.setEnabled(false);
                this.fireContentsChanged(this, 0, this.size() - 1);
            }
        }
    }

    private class ConnectionDetailDialog
    extends JDialog {
        ConnectionDetailDialog(ConnectionInfo inf) {
            super(SessionKeeper.this._coordinator.getMainFrame(), "Connection Details - IceGrid GUI", true);
            this.setDefaultCloseOperation(2);
            JPanel detailsPane = null;
            FormLayout layout = new FormLayout("right:pref, 2dlu, left:pref:grow", "pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
            builder.addSeparator("Connection Details");
            builder.nextLine();
            if (inf.getDirect()) {
                builder.append((Component)new JLabel("<html><b>IceGrid instance name:</b></html>"), (Component)new JLabel(inf.getInstanceName()));
            } else {
                builder.append((Component)new JLabel("<html><b>IceGrid instance name:</b></html>"), (Component)new JLabel(inf.getInstanceName()));
            }
            boolean ssl = false;
            if (inf.getDefaultEndpoint()) {
                builder.append((Component)new JLabel("<html><b>Hostname:</b></html>"), (Component)new JLabel(inf.getHost()));
                builder.append((Component)new JLabel("<html><b>Port:</b></html>"), (Component)new JLabel(Integer.toString(inf.getPort())));
                if (inf.getSSL()) {
                    builder.append((Component)new JLabel("<html><b>Protocol:</b></html>"), (Component)new JLabel("SSL"));
                } else {
                    builder.append((Component)new JLabel("<html><b>Protocol:</b></html>"), (Component)new JLabel("TCP"));
                }
                ssl = inf.getSSL();
            } else {
                builder.append((Component)new JLabel("<html><b>Endpoints:</b></html>"), (Component)new JLabel(inf.getEndpoint()));
                Identity id = new Identity();
                id.name = inf.getDirect() ? "Locator" : "router";
                id.category = inf.getInstanceName();
                StringBuilder endpoint = new StringBuilder();
                endpoint.append(SessionKeeper.this._coordinator.getCommunicator().identityToString(id));
                endpoint.append(":");
                endpoint.append(inf.getEndpoint());
                ssl = SessionKeeper.this.containsSecureEndpoints(endpoint.toString());
            }
            if (inf.getAuth() == AuthType.UsernamePasswordAuthType) {
                builder.append((Component)new JLabel("<html><b>Authentication mode:</b></html>"), (Component)new JLabel("Username and password"));
            } else {
                builder.append((Component)new JLabel("<html><b>Authentication mode:</b></html>"), (Component)new JLabel("SSL Certificate"));
            }
            if (ssl) {
                if (inf.getUseX509Certificate()) {
                    builder.append((Component)new JLabel("<html><b>Use SSL Client Certificate:</b></html>"), (Component)new JLabel("Yes"));
                } else {
                    builder.append((Component)new JLabel("<html><b>Use SSL Client Certificate:</b></html>"), (Component)new JLabel("No"));
                }
            }
            detailsPane = builder.getPanel();
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(detailsPane);
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionDetailDialog.this.dispose();
                }
            });
            JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton((JComponent)closeButton).build();
            buttonBar.setBorder(Borders.DIALOG);
            contentPane.add(buttonBar);
            this.getRootPane().setDefaultButton(closeButton);
            this.pack();
            this.setResizable(false);
        }
    }

    static final class AuthType
    extends Enum<AuthType> {
        public static final /* enum */ AuthType UsernamePasswordAuthType = new AuthType();
        public static final /* enum */ AuthType X509CertificateAuthType = new AuthType();
        private static final /* synthetic */ AuthType[] $VALUES;

        public static AuthType[] values() {
            return (AuthType[])$VALUES.clone();
        }

        static {
            $VALUES = new AuthType[]{UsernamePasswordAuthType, X509CertificateAuthType};
        }
    }

    static final class WizardStep
    extends Enum<WizardStep> {
        public static final /* enum */ WizardStep ConnectionTypeStep = new WizardStep();
        public static final /* enum */ WizardStep DirectMasterStep = new WizardStep();
        public static final /* enum */ WizardStep DirectDiscoveryChooseStep = new WizardStep();
        public static final /* enum */ WizardStep DirectEndpointStep = new WizardStep();
        public static final /* enum */ WizardStep DirectDefaultEndpointStep = new WizardStep();
        public static final /* enum */ WizardStep DirectCustomEnpointStep = new WizardStep();
        public static final /* enum */ WizardStep RoutedEndpointStep = new WizardStep();
        public static final /* enum */ WizardStep RoutedDefaultEndpointStep = new WizardStep();
        public static final /* enum */ WizardStep RoutedCustomEnpointStep = new WizardStep();
        public static final /* enum */ WizardStep X509CertificateStep = new WizardStep();
        public static final /* enum */ WizardStep DirectX509CredentialsStep = new WizardStep();
        public static final /* enum */ WizardStep RoutedX509CredentialsStep = new WizardStep();
        public static final /* enum */ WizardStep AuthStep = new WizardStep();
        public static final /* enum */ WizardStep DirectUsernamePasswordCredentialsStep = new WizardStep();
        public static final /* enum */ WizardStep RoutedUsernamePasswordCredentialsStep = new WizardStep();
        private static final /* synthetic */ WizardStep[] $VALUES;

        public static WizardStep[] values() {
            return (WizardStep[])$VALUES.clone();
        }

        static {
            $VALUES = new WizardStep[]{ConnectionTypeStep, DirectMasterStep, DirectDiscoveryChooseStep, DirectEndpointStep, DirectDefaultEndpointStep, DirectCustomEnpointStep, RoutedEndpointStep, RoutedDefaultEndpointStep, RoutedCustomEnpointStep, X509CertificateStep, DirectX509CredentialsStep, RoutedX509CredentialsStep, AuthStep, DirectUsernamePasswordCredentialsStep, RoutedUsernamePasswordCredentialsStep};
        }
    }

    private class ConnectionWizardDialog
    extends JDialog {
        private JPanel _cardPanel;
        private CardLayout _cardLayout;
        private JButton _backButton;
        private JButton _nextButton;
        private JButton _finishButton;
        private JButton _cancelButton;
        private JRadioButton _directConnection;
        private JRadioButton _routedConnection;
        private JLabel _directInstanceName;
        private JCheckBox _directConnectToMaster;
        private JList<LocatorPrx> _directDiscoveryLocatorList;
        private DefaultListModel<LocatorPrx> _directDiscoveryLocatorModel;
        private JRadioButton _directDiscoveryDiscoveredLocators;
        private JLabel _discoveryStatus;
        private JButton _discoveryRefresh;
        private JRadioButton _directDiscoveryManualEndpoint;
        private JRadioButton _directDefaultEndpoints;
        private JRadioButton _directCustomEndpoints;
        private JTextField _directDefaultEndpointHost;
        private JTextField _directDefaultEndpointPort;
        private JRadioButton _directDefaultEndpointTCP;
        private JRadioButton _directDefaultEndpointSSL;
        private JTextField _directCustomEndpointValue;
        private JLabel _routedInstanceName;
        private JRadioButton _routedDefaultEndpoints;
        private JRadioButton _routedCustomEndpoints;
        private JTextField _routedDefaultEndpointHost;
        private JTextField _routedDefaultEndpointPort;
        private JRadioButton _routedDefaultEndpointTCP;
        private JRadioButton _routedDefaultEndpointSSL;
        private JTextField _routedCustomEndpointValue;
        private JRadioButton _x509CertificateNoButton;
        private JRadioButton _x509CertificateYesButton;
        private JComboBox _directCertificateAliases;
        private JButton _directImportCertificate;
        private JPasswordField _directCertificatePassword;
        private JComboBox _routedCertificateAliases;
        private JButton _routedImportCertificate;
        private JPasswordField _routedCertificatePassword;
        private JRadioButton _usernamePasswordAuthButton;
        private JRadioButton _certificateAuthButton;
        private JTextField _directUsername;
        private JPasswordField _directPassword;
        private JTextField _routedUsername;
        private JPasswordField _routedPassword;
        private boolean _connectNow;
        Stack<WizardStep> _wizardSteps;
        ConnectionInfo _conf;
        private boolean _x509CertificateDefault;

        ConnectionWizardDialog(JDialog parent) {
            super((Dialog)parent, true);
            this._wizardSteps = new Stack();
            this._x509CertificateDefault = true;
            this.initialize("New Connection - IceGrid GUI", parent);
            this._connectNow = true;
        }

        ConnectionWizardDialog(ConnectionInfo inf, JDialog parent) {
            super((Dialog)parent, true);
            this._wizardSteps = new Stack();
            this._conf = inf;
            this._x509CertificateDefault = false;
            this.initialize("Edit Connection - IceGrid GUI", parent);
            this._connectNow = false;
            this._nextButton.requestFocusInWindow();
        }

        public void refreshDiscoveryLocators() {
            Communicator communicator = SessionKeeper.this._coordinator.getCommunicator();
            this._discoveryStatus.setText("Searching for registries...");
            try {
                SessionKeeper.this._coordinator.getExecutor().submit(() -> {
                    SessionKeeper sessionKeeper = SessionKeeper.this;
                    synchronized (sessionKeeper) {
                        try {
                            if (SessionKeeper.this._discoveryPlugin == null) {
                                PluginFactory f = new PluginFactory();
                                SessionKeeper.this._discoveryPlugin = (Plugin)f.create(communicator, "IceGridAdmin.Discovery", null);
                                SessionKeeper.this._discoveryPlugin.initialize();
                            }
                            List<LocatorPrx> locators = SessionKeeper.this._discoveryPlugin.getLocators("", 1000);
                            SwingUtilities.invokeLater(() -> {
                                this._directDiscoveryLocatorModel.clear();
                                for (LocatorPrx locator : locators) {
                                    this._directDiscoveryLocatorModel.addElement(locator);
                                }
                                if (this._directDiscoveryLocatorModel.size() > 0 && this._directDiscoveryLocatorList.getSelectedIndex() == -1) {
                                    this._directDiscoveryLocatorList.setSelectedIndex(0);
                                }
                                if (this._directDiscoveryLocatorModel.size() > 0) {
                                    this._discoveryStatus.setText("");
                                } else {
                                    this._discoveryStatus.setText("No registries found");
                                }
                            });
                        }
                        catch (LocalException ex) {
                            SwingUtilities.invokeLater(() -> {
                                this._discoveryStatus.setText("No registries found");
                                JOptionPane.showMessageDialog(this, ex.toString(), "Error while looking up registries", 0);
                            });
                        }
                    }
                });
            }
            catch (LocalException ex) {
                JOptionPane.showMessageDialog(this, ex.toString(), "Error while looking up registries", 0);
            }
        }

        private void initialize(String title, final JDialog parent) {
            this.setTitle(title);
            this.getContentPane().setLayout(new BorderLayout());
            this._cardPanel = new JPanel();
            this._cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
            this._cardLayout = new CardLayout();
            this._cardPanel.setLayout(this._cardLayout);
            this._wizardSteps.push(WizardStep.ConnectionTypeStep);
            this._directInstanceName = new JLabel();
            this._routedInstanceName = new JLabel();
            FormLayout layout = new FormLayout("pref", "pref");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            ButtonGroup group = new ButtonGroup();
            this._directConnection = new JRadioButton(new AbstractAction("Direct Connection"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            this._directConnection.setSelected(true);
            group.add(this._directConnection);
            this._routedConnection = new JRadioButton(new AbstractAction("Routed Connection"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            group.add(this._routedConnection);
            builder.append(new JLabel("<html><b>Connection Type</b></html>"));
            builder.append(this._directConnection);
            builder.append(new JLabel("Connect directly to an IceGrid registry."));
            builder.append(this._routedConnection);
            builder.append(new JLabel("Connect to an IceGrid registry through a Glacier2 router."));
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.ConnectionTypeStep.toString());
            this._directDiscoveryLocatorModel = new DefaultListModel();
            this._directDiscoveryLocatorList = new JList(this._directDiscoveryLocatorModel){

                @Override
                public String getToolTipText(MouseEvent evt) {
                    int index = this.locationToIndex(evt.getPoint());
                    if (index < 0) {
                        return null;
                    }
                    java.lang.Object obj = this.getModel().getElementAt(index);
                    if (obj != null && obj instanceof LocatorPrx) {
                        return obj.toString();
                    }
                    return null;
                }
            };
            this._directDiscoveryLocatorList.setVisibleRowCount(7);
            this._directDiscoveryLocatorList.setFixedCellWidth(500);
            this._directDiscoveryLocatorList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    java.lang.Object obj;
                    int index;
                    if (e.getClickCount() == 2 && e.getButton() == 1 && (index = ConnectionWizardDialog.this._directDiscoveryLocatorList.locationToIndex(e.getPoint())) != -1 && (obj = ConnectionWizardDialog.this._directDiscoveryLocatorModel.getElementAt(index)) != null && obj instanceof LocatorPrx) {
                        ConnectionWizardDialog.this._nextButton.doClick(0);
                    }
                }
            });
            this._directDiscoveryLocatorList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            ButtonGroup group2 = new ButtonGroup();
            this._directDiscoveryDiscoveredLocators = new JRadioButton(new AbstractAction("Discovered Registries"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this._directDiscoveryLocatorList.setEnabled(true);
                    ConnectionWizardDialog.this._discoveryStatus.setEnabled(true);
                    ConnectionWizardDialog.this._discoveryRefresh.setEnabled(true);
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this.refreshDiscoveryLocators();
                }
            });
            this._directDiscoveryDiscoveredLocators.setSelected(true);
            group2.add(this._directDiscoveryDiscoveredLocators);
            FormLayout layout2 = new FormLayout("pref:grow, 2dlu, pref", "");
            DefaultFormBuilder builder2 = new DefaultFormBuilder(layout2);
            this._discoveryStatus = new JLabel();
            this._discoveryRefresh = new JButton(new AbstractAction("Refresh"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.refreshDiscoveryLocators();
                }
            });
            builder2.rowGroupingEnabled(true);
            builder2.append((Component)this._discoveryStatus, (Component)this._discoveryRefresh);
            JPanel discoveryStatus = builder2.getPanel();
            this._directDiscoveryManualEndpoint = new JRadioButton(new AbstractAction("Manual Endpoint"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this._directDiscoveryLocatorList.setEnabled(false);
                    ConnectionWizardDialog.this._discoveryStatus.setEnabled(false);
                    ConnectionWizardDialog.this._discoveryRefresh.setEnabled(false);
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            group2.add(this._directDiscoveryManualEndpoint);
            layout2 = new FormLayout("pref:grow", "pref");
            builder2 = new DefaultFormBuilder(layout2);
            builder2.border(Borders.DIALOG);
            builder2.rowGroupingEnabled(false);
            builder2.append(this._directDiscoveryDiscoveredLocators);
            builder2.append(SessionKeeper.createStrippedScrollPane(this._directDiscoveryLocatorList));
            builder2.append(discoveryStatus);
            builder2.append(this._directDiscoveryManualEndpoint);
            this._cardPanel.add((Component)builder2.getPanel(), WizardStep.DirectDiscoveryChooseStep.toString());
            layout = new FormLayout("pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            this._directConnectToMaster = new JCheckBox("Connect to a Master Registry.");
            this._directConnectToMaster.setSelected(true);
            builder.append(this._directConnectToMaster);
            builder.append(new JLabel("You need to connect to a Master Registry to change definitions."));
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.DirectMasterStep.toString());
            layout = new FormLayout("pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            group = new ButtonGroup();
            this._directDefaultEndpoints = new JRadioButton(new AbstractAction("A hostname and a port number?"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            this._directDefaultEndpoints.setSelected(true);
            group.add(this._directDefaultEndpoints);
            this._directCustomEndpoints = new JRadioButton(new AbstractAction("An endpoint string?"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            group.add(this._directCustomEndpoints);
            builder.append(new JLabel("<html><b>Addressing Information</b></html>"));
            builder.append(new JLabel("Do you want to provide addressing information for the IceGrid registry as:"));
            builder.append(this._directDefaultEndpoints);
            builder.append(this._directCustomEndpoints);
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.DirectEndpointStep.toString());
            layout = new FormLayout("pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            group = new ButtonGroup();
            this._routedDefaultEndpoints = new JRadioButton(new AbstractAction("A hostname and a port number?"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            this._routedDefaultEndpoints.setSelected(true);
            group.add(this._routedDefaultEndpoints);
            this._routedCustomEndpoints = new JRadioButton(new AbstractAction("An endpoint string?"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            group.add(this._routedCustomEndpoints);
            builder.append(new JLabel("<html><b>Addressing Information</b></html>"));
            builder.append(new JLabel("Do you want to provide addressing information for the Glacier2 router as:"));
            builder.append(this._routedDefaultEndpoints);
            builder.append(this._routedCustomEndpoints);
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.RoutedEndpointStep.toString());
            layout = new FormLayout("pref, 2dlu, pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            this._directDefaultEndpointHost = new JTextField(20);
            this._directDefaultEndpointHost.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directDefaultEndpointHost.requestFocusInWindow();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directDefaultEndpointHost.requestFocusInWindow();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directDefaultEndpointHost.requestFocusInWindow();
                }
            });
            builder.append("<html><b>Hostname:</b></html>", (Component)this._directDefaultEndpointHost);
            builder.append("", (Component)new JLabel("The hostname or IP address of the IceGrid registry."));
            builder.nextLine();
            this._directDefaultEndpointPort = new JTextField(5);
            this._directDefaultEndpointPort.addFocusListener(new FocusListener(this._directDefaultEndpointPort));
            this._directDefaultEndpointPort.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directDefaultEndpointPort.requestFocusInWindow();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directDefaultEndpointPort.requestFocusInWindow();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directDefaultEndpointPort.requestFocusInWindow();
                }
            });
            builder.append("<html><b>Port number:</b></html>", (Component)this._directDefaultEndpointPort);
            builder.append("", (Component)new JLabel("<html>The port number the IceGrid registry listens on; leave empty to use the default <br/>IceGrid registry port number.</html>"));
            builder.nextLine();
            group = new ButtonGroup();
            this._directDefaultEndpointTCP = new JRadioButton(new AbstractAction("TCP"){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            group.add(this._directDefaultEndpointTCP);
            this._directDefaultEndpointSSL = new JRadioButton(new AbstractAction("SSL"){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            group.add(this._directDefaultEndpointSSL);
            this._directDefaultEndpointTCP.setSelected(true);
            DefaultFormBuilder protocolBuilder = new DefaultFormBuilder(new FormLayout("pref, 2dlu, pref", "pref"));
            protocolBuilder.append((Component)this._directDefaultEndpointTCP, (Component)this._directDefaultEndpointSSL);
            JPanel protocolOptionPane = protocolBuilder.getPanel();
            builder.append("<html><b>Protocol:</b></html>", (Component)protocolOptionPane);
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.DirectDefaultEndpointStep.toString());
            layout = new FormLayout("pref, 2dlu, pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            this._routedDefaultEndpointHost = new JTextField(20);
            this._routedDefaultEndpointHost.addFocusListener(new FocusListener(this._routedDefaultEndpointHost));
            this._routedDefaultEndpointHost.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedDefaultEndpointHost.requestFocusInWindow();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedDefaultEndpointHost.requestFocusInWindow();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedDefaultEndpointHost.requestFocusInWindow();
                }
            });
            builder.append("<html><b>Hostname:</b></html>", (Component)this._routedDefaultEndpointHost);
            builder.append("", (Component)new JLabel("The hostname or IP address of the Glacier2 router."));
            builder.nextLine();
            this._routedDefaultEndpointPort = new JTextField(5);
            this._routedDefaultEndpointPort.addFocusListener(new FocusListener(this._routedDefaultEndpointPort));
            this._routedDefaultEndpointPort.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedDefaultEndpointPort.requestFocusInWindow();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedDefaultEndpointPort.requestFocusInWindow();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedDefaultEndpointPort.requestFocusInWindow();
                }
            });
            builder.append("<html><b>Port:</b></html>", (Component)this._routedDefaultEndpointPort);
            builder.append("", (Component)new JLabel("<html>The port number the Glacier2 router listens on; leave empty to use the default <br/>Glacier2 router port number.</html>"));
            builder.nextLine();
            group = new ButtonGroup();
            this._routedDefaultEndpointTCP = new JRadioButton(new AbstractAction("TCP"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            group.add(this._routedDefaultEndpointTCP);
            this._routedDefaultEndpointSSL = new JRadioButton(new AbstractAction("SSL"){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            group.add(this._routedDefaultEndpointSSL);
            this._routedDefaultEndpointTCP.setSelected(true);
            protocolBuilder = new DefaultFormBuilder(new FormLayout("pref, 2dlu, pref", "pref"));
            protocolBuilder.append((Component)this._routedDefaultEndpointTCP, (Component)this._routedDefaultEndpointSSL);
            protocolOptionPane = protocolBuilder.getPanel();
            builder.append("<html><b>Protocol:</b></html>", (Component)protocolOptionPane);
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.RoutedDefaultEndpointStep.toString());
            layout = new FormLayout("pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            this._directCustomEndpointValue = new JTextField(20);
            this._directCustomEndpointValue.addFocusListener(new FocusListener(this._directCustomEndpointValue));
            this._directCustomEndpointValue.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            builder.append(new JLabel("<html><b>IceGrid Registry Endpoint(s)</b></html>"));
            builder.append(this._directCustomEndpointValue);
            builder.append(new JLabel("<html>Corresponds to the client endpoints of the IceGrid registry.<br/>For example: tcp -h registry.domain.com -p 4061</html>"));
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.DirectCustomEnpointStep.toString());
            layout = new FormLayout("pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            this._routedCustomEndpointValue = new JTextField(20);
            this._routedCustomEndpointValue.addFocusListener(new FocusListener(this._routedCustomEndpointValue));
            this._routedCustomEndpointValue.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            builder.append(new JLabel("<html><b>Glacier2 Router Endpoint(s)</b></html>"));
            builder.append(this._routedCustomEndpointValue);
            builder.append(new JLabel("<html>Corresponds to the client endpoints of the Glacier2 router.<br/>For example: tcp -h router.domain.com -p 4063</html>"));
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.RoutedCustomEnpointStep.toString());
            layout = new FormLayout("pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            group = new ButtonGroup();
            this._x509CertificateNoButton = new JRadioButton(new AbstractAction("No"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this._x509CertificateDefault = false;
                    ConnectionWizardDialog.this._usernamePasswordAuthButton.setSelected(true);
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            this._x509CertificateNoButton.setSelected(true);
            group.add(this._x509CertificateNoButton);
            this._x509CertificateYesButton = new JRadioButton(new AbstractAction("Yes"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this._x509CertificateDefault = false;
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            group.add(this._x509CertificateYesButton);
            builder.append(new JLabel("<html><b>Do you want to provide an X.509 certificate for SSL authentication?</b></html>"));
            builder.append(this._x509CertificateNoButton);
            builder.append(this._x509CertificateYesButton);
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.X509CertificateStep.toString());
            this._directCertificateAliases = new JComboBox();
            this._directCertificateAliases.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            this._directImportCertificate = new JButton(new AbstractAction("Import..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateManagerDialog d = SessionKeeper.this.certificateManager(ConnectionWizardDialog.this);
                    if (d != null) {
                        d.load();
                        d.setActiveTab(0);
                        d.showDialog();
                        ConnectionWizardDialog.this.loadCertificateAliases(ConnectionWizardDialog.this._directCertificateAliases);
                        ConnectionWizardDialog.this.validatePanel();
                    }
                }
            });
            FormLayout layout3 = new FormLayout("pref:grow, 2dlu, pref", "");
            DefaultFormBuilder builder3 = new DefaultFormBuilder(layout3);
            builder3.rowGroupingEnabled(true);
            builder3.append((Component)this._directCertificateAliases, (Component)this._directImportCertificate);
            JPanel alias = builder3.getPanel();
            layout2 = new FormLayout("pref, 2dlu, pref:grow", "");
            builder2 = new DefaultFormBuilder(layout2);
            builder2.rowGroupingEnabled(true);
            builder2.append("<html><b>Alias:</b></html>", (Component)alias);
            builder2.append("", (Component)new JLabel("<html><p>Your X.509 certificate for SSL authentication.</p></html>"));
            this._directCertificatePassword = new JPasswordField();
            builder2.append("<html><b>Password:</b></html>", (Component)this._directCertificatePassword);
            builder2.append("", (Component)new JLabel("<html>Enter your certificate password above to save it with this connection; otherwise<br>you will need to enter this password each time you connect.</p></html>"));
            JPanel panel = builder2.getPanel();
            layout2 = new FormLayout("pref:grow", "pref");
            builder2 = new DefaultFormBuilder(layout2);
            builder2.border(Borders.DIALOG);
            builder2.rowGroupingEnabled(true);
            builder2.append(new JLabel("<html><b>X.509 Certificate</b></html>"));
            builder2.append(panel);
            this._cardPanel.add((Component)builder2.getPanel(), WizardStep.DirectX509CredentialsStep.toString());
            this._routedCertificateAliases = new JComboBox();
            this._routedCertificateAliases.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            this._routedImportCertificate = new JButton(new AbstractAction("Import..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateManagerDialog d = SessionKeeper.this.certificateManager(ConnectionWizardDialog.this);
                    if (d != null) {
                        d.load();
                        d.setActiveTab(0);
                        d.showDialog();
                        ConnectionWizardDialog.this.loadCertificateAliases(ConnectionWizardDialog.this._routedCertificateAliases);
                        ConnectionWizardDialog.this.validatePanel();
                    }
                }
            });
            layout3 = new FormLayout("pref:grow, 2dlu, pref", "");
            builder3 = new DefaultFormBuilder(layout3);
            builder3.rowGroupingEnabled(true);
            builder3.append((Component)this._routedCertificateAliases, (Component)this._routedImportCertificate);
            alias = builder3.getPanel();
            layout2 = new FormLayout("pref, 2dlu, pref:grow", "");
            builder2 = new DefaultFormBuilder(layout2);
            builder2.rowGroupingEnabled(true);
            builder2.append("<html><b>Alias:</b></html>", (Component)alias);
            builder2.append("", (Component)new JLabel("<html><p>Your X.509 certificate for SSL authentication.</p></html>"));
            this._routedCertificatePassword = new JPasswordField();
            builder2.append("<html><b>Password:</b></html>", (Component)this._routedCertificatePassword);
            builder2.append("", (Component)new JLabel("<html>Enter your certificate password above to save it with this connection; otherwise<br>you will need to enter this password each time you connect.</p></html>"));
            panel = builder2.getPanel();
            layout2 = new FormLayout("pref:grow", "pref");
            builder2 = new DefaultFormBuilder(layout2);
            builder2.border(Borders.DIALOG);
            builder2.rowGroupingEnabled(true);
            builder2.append(new JLabel("<html><b>X.509 Certificate</b></html>"));
            builder2.append(panel);
            this._cardPanel.add((Component)builder2.getPanel(), WizardStep.RoutedX509CredentialsStep.toString());
            layout = new FormLayout("pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            group = new ButtonGroup();
            this._usernamePasswordAuthButton = new JRadioButton(new AbstractAction("Log in with a username and password"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            this._usernamePasswordAuthButton.setSelected(true);
            group.add(this._usernamePasswordAuthButton);
            this._certificateAuthButton = new JRadioButton(new AbstractAction("Log in with my X.509 certificate"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                }
            });
            group.add(this._certificateAuthButton);
            builder.append(new JLabel("<html><b>Authentication Type</b></html>"));
            builder.append(this._usernamePasswordAuthButton);
            builder.append(this._certificateAuthButton);
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.AuthStep.toString());
            layout = new FormLayout("pref, 2dlu, pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            this._directUsername = new JTextField();
            this._directUsername.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directUsername.requestFocusInWindow();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directUsername.requestFocusInWindow();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._directUsername.requestFocusInWindow();
                }
            });
            builder.append("<html><b>Username:</b></html>", (Component)this._directUsername);
            this._directPassword = new JPasswordField();
            builder.append("<html><b>Password:</b></html>", (Component)this._directPassword);
            builder.append("", (Component)new JLabel("<html>Enter your password above to save it with this connection; otherwise you will<br>need to enter your password each time you connect.</p></html>"));
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.DirectUsernamePasswordCredentialsStep.toString());
            layout = new FormLayout("pref, 2dlu, pref:grow", "pref");
            builder = new DefaultFormBuilder(layout);
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            this._routedUsername = new JTextField();
            this._routedUsername.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedUsername.requestFocusInWindow();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedUsername.requestFocusInWindow();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ConnectionWizardDialog.this.validatePanel();
                    ConnectionWizardDialog.this._routedUsername.requestFocusInWindow();
                }
            });
            builder.append("<html><b>Username:</b></html>", (Component)this._routedUsername);
            this._routedPassword = new JPasswordField();
            builder.append("<html><b>Password:</b></html>", (Component)this._routedPassword);
            builder.append("", (Component)new JLabel("<html>Enter your Glacier2 password above to save it with this connection; otherwise<br>you will need to enter your password each time you connect.</p></html>"));
            this._cardPanel.add((Component)builder.getPanel(), WizardStep.RoutedUsernamePasswordCredentialsStep.toString());
            this._backButton = new JButton();
            AbstractAction backAction = new AbstractAction("< Back"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConnectionWizardDialog.this._wizardSteps.size() <= 1) {
                        ConnectionWizardDialog.this._backButton.setEnabled(false);
                        return;
                    }
                    ConnectionWizardDialog.this._wizardSteps.pop();
                    ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, ((WizardStep)((java.lang.Object)ConnectionWizardDialog.this._wizardSteps.elementAt(ConnectionWizardDialog.this._wizardSteps.size() - 1))).toString());
                    if (ConnectionWizardDialog.this._wizardSteps.size() <= 1) {
                        ConnectionWizardDialog.this._backButton.setEnabled(false);
                    }
                    ConnectionWizardDialog.this.validatePanel();
                }
            };
            this._backButton.setAction(backAction);
            this._backButton.setEnabled(false);
            this._nextButton = new JButton();
            AbstractAction nextAction = new AbstractAction("Next >"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionWizardDialog.this._nextButton.setEnabled(false);
                    WizardStep step = (WizardStep)((java.lang.Object)ConnectionWizardDialog.this._wizardSteps.elementAt(ConnectionWizardDialog.this._wizardSteps.size() - 1));
                    switch (step) {
                        case ConnectionTypeStep: {
                            if (ConnectionWizardDialog.this._directConnection.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectMasterStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectMasterStep);
                                break;
                            }
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedEndpointStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedEndpointStep);
                            break;
                        }
                        case DirectMasterStep: {
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectDiscoveryChooseStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectDiscoveryChooseStep);
                            if (!ConnectionWizardDialog.this._directDiscoveryDiscoveredLocators.isSelected()) break;
                            ConnectionWizardDialog.this.refreshDiscoveryLocators();
                            break;
                        }
                        case DirectDiscoveryChooseStep: {
                            if (ConnectionWizardDialog.this._directDiscoveryManualEndpoint.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectEndpointStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectEndpointStep);
                                break;
                            }
                            LocatorPrx locator = (LocatorPrx)ConnectionWizardDialog.this._directDiscoveryLocatorList.getSelectedValue();
                            ConnectionWizardDialog.this._directInstanceName.setText(locator.ice_getIdentity().category);
                            String endpoints = null;
                            for (Endpoint endpoint : locator.ice_getEndpoints()) {
                                endpoints = endpoints == null ? endpoint.toString() : endpoints + ":" + endpoint.toString();
                            }
                            ConnectionWizardDialog.this._directCustomEndpointValue.setText(endpoints);
                            ConnectionWizardDialog.this._directCustomEndpoints.setSelected(true);
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectCustomEnpointStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectCustomEnpointStep);
                            break;
                        }
                        case DirectEndpointStep: {
                            if (ConnectionWizardDialog.this._directDefaultEndpoints.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectDefaultEndpointStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectDefaultEndpointStep);
                                break;
                            }
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectCustomEnpointStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectCustomEnpointStep);
                            break;
                        }
                        case RoutedEndpointStep: {
                            if (ConnectionWizardDialog.this._routedDefaultEndpoints.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedDefaultEndpointStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedDefaultEndpointStep);
                                break;
                            }
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedCustomEnpointStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedCustomEnpointStep);
                            break;
                        }
                        case DirectDefaultEndpointStep: {
                            if (ConnectionWizardDialog.this._directDefaultEndpointSSL.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.X509CertificateStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.X509CertificateStep);
                            } else {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectUsernamePasswordCredentialsStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectUsernamePasswordCredentialsStep);
                            }
                            if (!ConnectionWizardDialog.this._x509CertificateDefault) break;
                            if (ConnectionWizardDialog.this._directDefaultEndpointSSL.isSelected()) {
                                ConnectionWizardDialog.this._x509CertificateYesButton.setSelected(true);
                                ConnectionWizardDialog.this._certificateAuthButton.setSelected(true);
                                break;
                            }
                            ConnectionWizardDialog.this._x509CertificateNoButton.setSelected(true);
                            ConnectionWizardDialog.this._usernamePasswordAuthButton.setSelected(true);
                            break;
                        }
                        case RoutedDefaultEndpointStep: {
                            if (ConnectionWizardDialog.this._routedDefaultEndpointSSL.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.X509CertificateStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.X509CertificateStep);
                            } else {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedUsernamePasswordCredentialsStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedUsernamePasswordCredentialsStep);
                            }
                            if (!ConnectionWizardDialog.this._x509CertificateDefault) break;
                            if (ConnectionWizardDialog.this._routedDefaultEndpointSSL.isSelected()) {
                                ConnectionWizardDialog.this._x509CertificateYesButton.setSelected(true);
                                ConnectionWizardDialog.this._certificateAuthButton.setSelected(true);
                                break;
                            }
                            ConnectionWizardDialog.this._x509CertificateNoButton.setSelected(true);
                            ConnectionWizardDialog.this._usernamePasswordAuthButton.setSelected(true);
                            break;
                        }
                        case DirectCustomEnpointStep: {
                            try {
                                Identity id = new Identity();
                                id.name = "Locator";
                                id.category = ConnectionWizardDialog.this._directInstanceName.getText();
                                StringBuilder endpoint = new StringBuilder();
                                endpoint.append(SessionKeeper.this._coordinator.getCommunicator().identityToString(id));
                                endpoint.append(":");
                                endpoint.append(ConnectionWizardDialog.this._directCustomEndpointValue.getText());
                                SessionKeeper.this._coordinator.getCommunicator().stringToProxy(endpoint.toString());
                                if (SessionKeeper.this.containsSecureEndpoints(endpoint.toString())) {
                                    ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.X509CertificateStep.toString());
                                    ConnectionWizardDialog.this._wizardSteps.push(WizardStep.X509CertificateStep);
                                } else {
                                    ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectUsernamePasswordCredentialsStep.toString());
                                    ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectUsernamePasswordCredentialsStep);
                                }
                            }
                            catch (EndpointParseException ex) {
                                JOptionPane.showMessageDialog(ConnectionWizardDialog.this, ex.str, "Error parsing endpoint", 0);
                                return;
                            }
                            catch (ProxyParseException ex) {
                                JOptionPane.showMessageDialog(ConnectionWizardDialog.this, ex.str, "Error parsing endpoint", 0);
                                return;
                            }
                            if (!ConnectionWizardDialog.this._x509CertificateDefault) break;
                            if (SessionKeeper.this.containsSecureEndpoints(ConnectionWizardDialog.this._directCustomEndpointValue.getText())) {
                                ConnectionWizardDialog.this._x509CertificateYesButton.setSelected(true);
                                ConnectionWizardDialog.this._certificateAuthButton.setSelected(true);
                                break;
                            }
                            ConnectionWizardDialog.this._x509CertificateNoButton.setSelected(true);
                            ConnectionWizardDialog.this._usernamePasswordAuthButton.setSelected(true);
                            break;
                        }
                        case RoutedCustomEnpointStep: {
                            try {
                                Identity id = new Identity();
                                id.name = "router";
                                id.category = ConnectionWizardDialog.this._routedInstanceName.getText();
                                StringBuilder endpoint = new StringBuilder();
                                endpoint.append(SessionKeeper.this._coordinator.getCommunicator().identityToString(id));
                                endpoint.append(":");
                                endpoint.append(ConnectionWizardDialog.this._routedCustomEndpointValue.getText());
                                SessionKeeper.this._coordinator.getCommunicator().stringToProxy(endpoint.toString());
                                if (SessionKeeper.this.containsSecureEndpoints(endpoint.toString())) {
                                    ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.X509CertificateStep.toString());
                                    ConnectionWizardDialog.this._wizardSteps.push(WizardStep.X509CertificateStep);
                                } else {
                                    ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedUsernamePasswordCredentialsStep.toString());
                                    ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedUsernamePasswordCredentialsStep);
                                }
                            }
                            catch (EndpointParseException ex) {
                                JOptionPane.showMessageDialog(ConnectionWizardDialog.this, ex.str, "Error parsing endpoint", 0);
                                return;
                            }
                            catch (ProxyParseException ex) {
                                JOptionPane.showMessageDialog(ConnectionWizardDialog.this, ex.str, "Error parsing endpoint", 0);
                                return;
                            }
                            if (!ConnectionWizardDialog.this._x509CertificateDefault) break;
                            if (SessionKeeper.this.containsSecureEndpoints(ConnectionWizardDialog.this._routedCustomEndpointValue.getText())) {
                                ConnectionWizardDialog.this._x509CertificateYesButton.setSelected(true);
                                ConnectionWizardDialog.this._certificateAuthButton.setSelected(true);
                                break;
                            }
                            ConnectionWizardDialog.this._x509CertificateNoButton.setSelected(true);
                            ConnectionWizardDialog.this._usernamePasswordAuthButton.setSelected(true);
                            break;
                        }
                        case X509CertificateStep: {
                            if (ConnectionWizardDialog.this._x509CertificateYesButton.isSelected()) {
                                if (ConnectionWizardDialog.this._directConnection.isSelected()) {
                                    ConnectionWizardDialog.this.loadCertificateAliases(ConnectionWizardDialog.this._directCertificateAliases);
                                    ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectX509CredentialsStep.toString());
                                    ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectX509CredentialsStep);
                                    break;
                                }
                                ConnectionWizardDialog.this.loadCertificateAliases(ConnectionWizardDialog.this._routedCertificateAliases);
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedX509CredentialsStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedX509CredentialsStep);
                                break;
                            }
                            if (ConnectionWizardDialog.this._directConnection.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectUsernamePasswordCredentialsStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectUsernamePasswordCredentialsStep);
                                break;
                            }
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedUsernamePasswordCredentialsStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedUsernamePasswordCredentialsStep);
                            break;
                        }
                        case RoutedX509CredentialsStep: 
                        case DirectX509CredentialsStep: {
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.AuthStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.AuthStep);
                            break;
                        }
                        case AuthStep: {
                            if (!ConnectionWizardDialog.this._usernamePasswordAuthButton.isSelected()) break;
                            if (ConnectionWizardDialog.this._directConnection.isSelected()) {
                                ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.DirectUsernamePasswordCredentialsStep.toString());
                                ConnectionWizardDialog.this._wizardSteps.push(WizardStep.DirectUsernamePasswordCredentialsStep);
                                break;
                            }
                            ConnectionWizardDialog.this._cardLayout.show(ConnectionWizardDialog.this._cardPanel, WizardStep.RoutedUsernamePasswordCredentialsStep.toString());
                            ConnectionWizardDialog.this._wizardSteps.push(WizardStep.RoutedUsernamePasswordCredentialsStep);
                            break;
                        }
                    }
                    if (ConnectionWizardDialog.this._wizardSteps.size() > 0) {
                        ConnectionWizardDialog.this._backButton.setEnabled(true);
                    }
                    ConnectionWizardDialog.this.validatePanel();
                }
            };
            this._nextButton.setAction(nextAction);
            this._nextButton.setEnabled(false);
            this._finishButton = new JButton();
            AbstractAction finishAction = new AbstractAction("Finish"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionKeeper sessionKeeper = SessionKeeper.this;
                    synchronized (sessionKeeper) {
                        if (SessionKeeper.this._discoveryPlugin != null) {
                            SessionKeeper.this._discoveryPlugin.destroy();
                            SessionKeeper.this._discoveryPlugin = null;
                        }
                    }
                    ConnectionInfo inf = ConnectionWizardDialog.this.getConfiguration();
                    if (inf == null) {
                        inf = new ConnectionInfo();
                    }
                    boolean direct = ConnectionWizardDialog.this._directConnection.isSelected();
                    inf.setDirect(direct);
                    if (direct) {
                        inf.setInstanceName(ConnectionWizardDialog.this._directInstanceName.getText());
                        inf.setConnectToMaster(ConnectionWizardDialog.this._directConnectToMaster.isSelected());
                        if (ConnectionWizardDialog.this._usernamePasswordAuthButton.isSelected()) {
                            inf.setUsername(ConnectionWizardDialog.this._directUsername.getText());
                            if (ConnectionWizardDialog.this._directPassword.getPassword() != null && ConnectionWizardDialog.this._directPassword.getPassword().length > 0) {
                                inf.setPassword(ConnectionWizardDialog.this._directPassword.getPassword());
                                inf.setStorePassword(true);
                            } else {
                                inf.setPassword(null);
                                inf.setStorePassword(false);
                            }
                        }
                        if (ConnectionWizardDialog.this._x509CertificateYesButton.isSelected()) {
                            inf.setAlias((String)ConnectionWizardDialog.this._directCertificateAliases.getSelectedItem());
                            if (ConnectionWizardDialog.this._directCertificatePassword.getPassword() != null && ConnectionWizardDialog.this._directCertificatePassword.getPassword().length > 0) {
                                inf.setKeyPassword(ConnectionWizardDialog.this._directCertificatePassword.getPassword());
                                inf.setStoreKeyPassword(true);
                            } else {
                                inf.setKeyPassword(null);
                                inf.setStoreKeyPassword(false);
                            }
                        }
                        if (ConnectionWizardDialog.this._directDefaultEndpoints.isSelected()) {
                            inf.setHost(ConnectionWizardDialog.this._directDefaultEndpointHost.getText());
                            inf.setSSL(ConnectionWizardDialog.this._directDefaultEndpointSSL.isSelected());
                            String port = ConnectionWizardDialog.this._directDefaultEndpointPort.getText();
                            if (port != null && !port.isEmpty()) {
                                try {
                                    inf.setPort(Integer.parseInt(port));
                                    inf.setDefaultPort(false);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            } else {
                                inf.setDefaultPort(true);
                            }
                        } else {
                            inf.setEndpoint(ConnectionWizardDialog.this._directCustomEndpointValue.getText());
                        }
                    } else {
                        inf.setInstanceName(ConnectionWizardDialog.this._routedInstanceName.getText());
                        if (ConnectionWizardDialog.this._usernamePasswordAuthButton.isSelected()) {
                            inf.setUsername(ConnectionWizardDialog.this._routedUsername.getText());
                            if (ConnectionWizardDialog.this._routedPassword.getPassword() != null && ConnectionWizardDialog.this._routedPassword.getPassword().length > 0) {
                                inf.setPassword(ConnectionWizardDialog.this._routedPassword.getPassword());
                                inf.setStorePassword(true);
                            } else {
                                inf.setPassword(null);
                                inf.setStorePassword(false);
                            }
                        }
                        if (ConnectionWizardDialog.this._x509CertificateYesButton.isSelected()) {
                            inf.setAlias((String)ConnectionWizardDialog.this._routedCertificateAliases.getSelectedItem());
                            if (ConnectionWizardDialog.this._routedCertificatePassword.getPassword() != null && ConnectionWizardDialog.this._routedCertificatePassword.getPassword().length > 0) {
                                inf.setKeyPassword(ConnectionWizardDialog.this._routedCertificatePassword.getPassword());
                                inf.setStoreKeyPassword(true);
                            } else {
                                inf.setKeyPassword(null);
                                inf.setStoreKeyPassword(false);
                            }
                        }
                        if (ConnectionWizardDialog.this._routedDefaultEndpoints.isSelected()) {
                            inf.setHost(ConnectionWizardDialog.this._routedDefaultEndpointHost.getText());
                            inf.setSSL(ConnectionWizardDialog.this._routedDefaultEndpointSSL.isSelected());
                            String port = ConnectionWizardDialog.this._routedDefaultEndpointPort.getText();
                            if (port != null && !port.isEmpty()) {
                                try {
                                    inf.setPort(Integer.parseInt(port));
                                    inf.setDefaultPort(false);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            } else {
                                inf.setDefaultPort(true);
                            }
                        } else {
                            inf.setEndpoint(ConnectionWizardDialog.this._routedCustomEndpointValue.getText());
                        }
                    }
                    if (ConnectionWizardDialog.this._usernamePasswordAuthButton.isSelected()) {
                        inf.setAuth(AuthType.UsernamePasswordAuthType);
                        inf.setUseX509Certificate(ConnectionWizardDialog.this._x509CertificateYesButton.isSelected());
                    } else {
                        inf.setAuth(AuthType.X509CertificateAuthType);
                        inf.setUseX509Certificate(true);
                    }
                    if (ConnectionWizardDialog.this._connectNow) {
                        SessionKeeper.this.login(parent, inf);
                    } else {
                        ConnectionWizardDialog.this.dispose();
                    }
                }
            };
            this._finishButton.setAction(finishAction);
            this._finishButton.setEnabled(false);
            this._cancelButton = new JButton();
            AbstractAction cancelAction = new AbstractAction("Cancel"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionKeeper sessionKeeper = SessionKeeper.this;
                    synchronized (sessionKeeper) {
                        if (SessionKeeper.this._discoveryPlugin != null) {
                            SessionKeeper.this._discoveryPlugin.destroy();
                            SessionKeeper.this._discoveryPlugin = null;
                        }
                    }
                    ConnectionWizardDialog.this.dispose();
                }
            };
            this._cancelButton.setAction(cancelAction);
            JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(this._backButton, this._nextButton).addUnrelatedGap().addButton(this._finishButton, this._cancelButton).build();
            buttonBar.setBorder(Borders.DIALOG);
            this.getContentPane().add((Component)buttonBar, "South");
            this.getContentPane().add((Component)this._cardPanel, "Center");
            this.pack();
            this.setResizable(false);
            this.load();
            this.validatePanel();
        }

        boolean validatePanel() {
            WizardStep step = (WizardStep)((java.lang.Object)this._wizardSteps.elementAt(this._wizardSteps.size() - 1));
            boolean lastStep = false;
            switch (step) {
                case DirectDiscoveryChooseStep: {
                    if (this._directDiscoveryManualEndpoint.isSelected()) {
                        this._directDiscoveryManualEndpoint.requestFocusInWindow();
                        break;
                    }
                    this._directDiscoveryLocatorList.requestFocusInWindow();
                    break;
                }
                case DirectEndpointStep: {
                    if (this._directDefaultEndpoints.isSelected()) {
                        this._directDefaultEndpoints.requestFocusInWindow();
                        break;
                    }
                    this._directCustomEndpoints.requestFocusInWindow();
                    break;
                }
                case DirectDefaultEndpointStep: {
                    this._directDefaultEndpointHost.requestFocusInWindow();
                    break;
                }
                case DirectCustomEnpointStep: {
                    this._directCustomEndpointValue.requestFocusInWindow();
                    break;
                }
                case RoutedEndpointStep: {
                    if (this._routedDefaultEndpoints.isSelected()) {
                        this._routedDefaultEndpoints.requestFocusInWindow();
                        break;
                    }
                    this._routedCustomEndpoints.requestFocusInWindow();
                    break;
                }
                case RoutedDefaultEndpointStep: {
                    this._routedDefaultEndpointHost.requestFocusInWindow();
                    break;
                }
                case RoutedCustomEnpointStep: {
                    this._routedCustomEndpointValue.requestFocusInWindow();
                    break;
                }
                case X509CertificateStep: {
                    if (this._x509CertificateYesButton.isSelected()) {
                        this._x509CertificateYesButton.requestFocusInWindow();
                    } else {
                        this._x509CertificateNoButton.requestFocusInWindow();
                    }
                }
                case DirectX509CredentialsStep: {
                    this._directCertificateAliases.requestFocusInWindow();
                    break;
                }
                case RoutedX509CredentialsStep: {
                    this._routedCertificateAliases.requestFocusInWindow();
                    break;
                }
                case AuthStep: {
                    if (this._usernamePasswordAuthButton.isSelected()) {
                        this._usernamePasswordAuthButton.requestFocusInWindow();
                        break;
                    }
                    lastStep = true;
                    this._certificateAuthButton.requestFocusInWindow();
                    break;
                }
                case DirectUsernamePasswordCredentialsStep: {
                    lastStep = true;
                    this._directUsername.requestFocusInWindow();
                    break;
                }
                case RoutedUsernamePasswordCredentialsStep: {
                    lastStep = true;
                    this._routedUsername.requestFocusInWindow();
                    break;
                }
            }
            boolean validated = this.validateWizardStep(step);
            this._nextButton.setEnabled(validated && !lastStep);
            if (!validated) {
                return false;
            }
            this._finishButton.setEnabled(this.validateConfiguration());
            if (lastStep) {
                this.getRootPane().setDefaultButton(this._finishButton);
            } else {
                this.getRootPane().setDefaultButton(this._nextButton);
            }
            return validated;
        }

        boolean validateWizardStep(WizardStep step) {
            boolean validated = false;
            switch (step) {
                case ConnectionTypeStep: {
                    validated = true;
                    break;
                }
                case DirectDiscoveryChooseStep: {
                    if (this._directDiscoveryManualEndpoint.isSelected()) {
                        validated = true;
                        break;
                    }
                    validated = this._directDiscoveryLocatorList.getSelectedValue() != null;
                    break;
                }
                case DirectDefaultEndpointStep: {
                    validated = this._directDefaultEndpointHost.getText() != null && this._directDefaultEndpointHost.getText().length() > 0;
                    String port = this._directDefaultEndpointPort.getText();
                    if (port == null || port.length() <= 0) break;
                    try {
                        Integer.parseInt(port);
                    }
                    catch (NumberFormatException ex) {
                        validated = false;
                        JOptionPane.showMessageDialog(this, "Invalid port number `" + port + "'", "Invalid port Number", 0);
                    }
                    break;
                }
                case DirectCustomEnpointStep: {
                    validated = this._directCustomEndpointValue.getText() != null && this._directCustomEndpointValue.getText().length() > 0;
                    break;
                }
                case RoutedDefaultEndpointStep: {
                    validated = this._routedDefaultEndpointHost.getText() != null && this._routedDefaultEndpointHost.getText().length() > 0;
                    String port = this._routedDefaultEndpointPort.getText();
                    if (port == null || port.length() <= 0) break;
                    try {
                        Integer.parseInt(port);
                    }
                    catch (NumberFormatException ex) {
                        validated = false;
                        JOptionPane.showMessageDialog(this, "Invalid port number `" + port + "'", "Invalid port Number", 0);
                    }
                    break;
                }
                case RoutedCustomEnpointStep: {
                    validated = this._routedCustomEndpointValue.getText() != null && this._routedCustomEndpointValue.getText().length() > 0;
                    break;
                }
                case DirectX509CredentialsStep: {
                    validated = this._directCertificateAliases.getSelectedItem() != null;
                    break;
                }
                case RoutedX509CredentialsStep: {
                    validated = this._routedCertificateAliases.getSelectedItem() != null;
                    break;
                }
                case DirectUsernamePasswordCredentialsStep: {
                    validated = this._directUsername.getText() != null && this._directUsername.getText().length() > 0;
                    break;
                }
                case RoutedUsernamePasswordCredentialsStep: {
                    validated = this._routedUsername.getText() != null && this._routedUsername.getText().length() > 0;
                    break;
                }
                case DirectMasterStep: 
                case DirectEndpointStep: 
                case RoutedEndpointStep: 
                case X509CertificateStep: 
                case AuthStep: {
                    validated = true;
                    break;
                }
            }
            return validated;
        }

        boolean validateConfiguration() {
            if (!this.hasSecureEndpoints()) {
                this._x509CertificateNoButton.setSelected(true);
                this._usernamePasswordAuthButton.setSelected(true);
            }
            if (!this.validateWizardStep(WizardStep.ConnectionTypeStep)) {
                return false;
            }
            if (this._directConnection.isSelected() ? (this._directDefaultEndpoints.isSelected() ? !this.validateWizardStep(WizardStep.DirectDefaultEndpointStep) : !this.validateWizardStep(WizardStep.DirectCustomEnpointStep)) : (this._routedDefaultEndpoints.isSelected() ? !this.validateWizardStep(WizardStep.RoutedDefaultEndpointStep) : !this.validateWizardStep(WizardStep.RoutedCustomEnpointStep))) {
                return false;
            }
            if (this._x509CertificateYesButton.isSelected() && (this._directConnection.isSelected() ? !this.validateWizardStep(WizardStep.DirectX509CredentialsStep) : !this.validateWizardStep(WizardStep.RoutedX509CredentialsStep))) {
                return false;
            }
            return !this._usernamePasswordAuthButton.isSelected() || !(this._directConnection.isSelected() ? !this.validateWizardStep(WizardStep.DirectUsernamePasswordCredentialsStep) : !this.validateWizardStep(WizardStep.RoutedUsernamePasswordCredentialsStep));
        }

        public void loadCertificateAliases(JComboBox component) {
            CertificateManagerDialog certificateManager = SessionKeeper.this.certificateManager(this);
            if (certificateManager != null) {
                String item = (String)component.getSelectedItem();
                component.setModel(new DefaultComboBoxModel<String>(certificateManager.myCertsAliases()));
                if (item != null) {
                    component.setSelectedItem(item);
                }
            }
        }

        private void load() {
            if (this._conf != null) {
                if (this._conf.getDirect()) {
                    this._directDiscoveryManualEndpoint.setSelected(true);
                    this._directConnection.setSelected(true);
                    this._directConnectToMaster.setSelected(this._conf.getConnectToMaster());
                    this._directInstanceName.setText(this._conf.getInstanceName());
                    if (this._conf.getAuth() == AuthType.UsernamePasswordAuthType) {
                        this._directUsername.setText(this._conf.getUsername());
                        if (this._conf.getPassword() != null && this._conf.getStorePassword()) {
                            this._directPassword.setText(new String(this._conf.getPassword()));
                        }
                    }
                    if (this._conf.getUseX509Certificate()) {
                        this._directCertificateAliases.setSelectedItem(this._conf.getAlias());
                        if (this._conf.getKeyPassword() != null && this._conf.getStoreKeyPassword()) {
                            this._directCertificatePassword.setText(new String(this._conf.getKeyPassword()));
                        }
                    }
                    if (this._conf.getDefaultEndpoint()) {
                        this._directDefaultEndpoints.setSelected(true);
                        this._directDefaultEndpointHost.setText(this._conf.getHost());
                        if (this._conf.getSSL()) {
                            this._directDefaultEndpointSSL.setSelected(true);
                            if (!this._conf.getDefaultPort()) {
                                this._directDefaultEndpointPort.setText(Integer.toString(this._conf.getPort()));
                            }
                        } else {
                            this._directDefaultEndpointTCP.setSelected(true);
                            if (!this._conf.getDefaultPort()) {
                                this._directDefaultEndpointPort.setText(Integer.toString(this._conf.getPort()));
                            }
                        }
                    } else {
                        this._directCustomEndpoints.setSelected(true);
                        this._directCustomEndpointValue.setText(this._conf.getEndpoint());
                    }
                } else {
                    this._routedConnection.setSelected(true);
                    this._routedInstanceName.setText(this._conf.getInstanceName());
                    if (this._conf.getAuth() == AuthType.UsernamePasswordAuthType) {
                        this._routedUsername.setText(this._conf.getUsername());
                        if (this._conf.getPassword() != null && this._conf.getStorePassword()) {
                            this._routedPassword.setText(new String(this._conf.getPassword()));
                        }
                    }
                    if (this._conf.getUseX509Certificate()) {
                        this._routedCertificateAliases.setSelectedItem(this._conf.getAlias());
                        if (this._conf.getKeyPassword() != null && this._conf.getStoreKeyPassword()) {
                            this._routedCertificatePassword.setText(new String(this._conf.getKeyPassword()));
                        }
                    }
                    if (this._conf.getDefaultEndpoint()) {
                        this._routedDefaultEndpoints.setSelected(true);
                        this._routedDefaultEndpointHost.setText(this._conf.getHost());
                        if (this._conf.getSSL()) {
                            this._routedDefaultEndpointSSL.setSelected(true);
                            if (!this._conf.getDefaultPort()) {
                                this._routedDefaultEndpointPort.setText(Integer.toString(this._conf.getPort()));
                            }
                        } else {
                            this._routedDefaultEndpointTCP.setSelected(true);
                            if (!this._conf.getDefaultPort()) {
                                this._routedDefaultEndpointPort.setText(Integer.toString(this._conf.getPort()));
                            }
                        }
                    } else {
                        this._routedCustomEndpoints.setSelected(true);
                        this._routedCustomEndpointValue.setText(this._conf.getEndpoint());
                    }
                }
                if (this._conf.getAuth() == AuthType.UsernamePasswordAuthType) {
                    this._usernamePasswordAuthButton.setSelected(true);
                    if (this._conf.getUseX509Certificate()) {
                        this._x509CertificateYesButton.setSelected(true);
                    } else {
                        this._x509CertificateNoButton.setSelected(true);
                    }
                } else {
                    this._x509CertificateYesButton.setSelected(true);
                    this._certificateAuthButton.setSelected(true);
                }
                this.validateConfiguration();
            }
        }

        private ConnectionInfo getConfiguration() {
            return this._conf;
        }

        public boolean hasSecureEndpoints() {
            if (this._directConnection.isSelected()) {
                if (this._directDefaultEndpoints.isSelected()) {
                    return this._directDefaultEndpointSSL.isSelected();
                }
                Identity id = new Identity();
                id.name = "Locator";
                id.category = this._directInstanceName.getText();
                StringBuilder endpoint = new StringBuilder();
                endpoint.append(SessionKeeper.this._coordinator.getCommunicator().identityToString(id));
                endpoint.append(":");
                endpoint.append(this._directCustomEndpointValue.getText());
                return SessionKeeper.this.containsSecureEndpoints(endpoint.toString());
            }
            if (this._routedDefaultEndpoints.isSelected()) {
                return this._routedDefaultEndpointSSL.isSelected();
            }
            Identity id = new Identity();
            id.name = "router";
            id.category = this._routedInstanceName.getText();
            StringBuilder endpoint = new StringBuilder();
            endpoint.append(SessionKeeper.this._coordinator.getCommunicator().identityToString(id));
            endpoint.append(":");
            endpoint.append(this._routedCustomEndpointValue.getText());
            return SessionKeeper.this.containsSecureEndpoints(endpoint.toString());
        }
    }

    public class FocusListener
    implements java.awt.event.FocusListener {
        private JTextComponent _field;

        public FocusListener(JTextComponent field) {
            this._field = field;
        }

        @Override
        public void focusGained(FocusEvent fe) {
            this._field.setCaretPosition(this._field.getDocument().getLength());
        }

        @Override
        public void focusLost(FocusEvent fe) {
        }
    }

    public class ConnectionInfo
    implements Comparable<ConnectionInfo> {
        private Preferences _prefs;
        private String _uuid;
        private String _instanceName = "";
        private boolean _defaultEndpoint;
        private boolean _customEndpoint;
        private String _host = "";
        private boolean _defaultPort;
        private int _port;
        private boolean _ssl;
        private String _endpoint = "";
        private AuthType _auth = AuthType.UsernamePasswordAuthType;
        private boolean _direct;
        private boolean _connectToMaster;
        private String _username = "";
        private char[] _password;
        private boolean _storePassword;
        private boolean _useX509Certificate;
        private String _alias = "";
        private char[] _keyPassword;
        private boolean _storeKeyPassword;
        private boolean _isDefault;

        public ConnectionInfo() {
        }

        public ConnectionInfo(String uuid, Preferences prefs) {
            this._uuid = uuid;
            this._prefs = prefs;
            this.load();
        }

        public synchronized String toString() {
            String name = this.getInstanceName();
            name = name + ":";
            if (this.getDefaultEndpoint()) {
                name = this.getSSL() ? name + "ssl" : name + "tcp";
                String host = this.getHost();
                if (host.indexOf(34) == -1) {
                    host = "\"" + host + "\"";
                }
                name = name + " -h " + host + " -p " + Integer.toString(this.getPort());
            } else {
                name = name + this.getEndpoint();
            }
            return name;
        }

        @Override
        public int compareTo(ConnectionInfo other) {
            return this._instanceName.compareTo(other._instanceName);
        }

        public synchronized void save() throws BackingStoreException {
            if (this._prefs == null) {
                Preferences prefs = Coordinator.getPreferences().node("Configurations");
                if (this._uuid == null) {
                    this._uuid = UUID.randomUUID().toString();
                }
                this._prefs = prefs.node(this._uuid);
            }
            if (Coordinator.getPreferences().node("Configurations").childrenNames().length == 1) {
                this.setIsDefault(true);
            }
            this._prefs.clear();
            this._prefs.put("instanceName", this._instanceName);
            if (this._defaultEndpoint) {
                this._prefs.putBoolean("defaultEndpoint", true);
                this._prefs.putBoolean("defaultPort", this._defaultPort);
                this._prefs.put("host", this._host);
                if (!this._defaultPort) {
                    this._prefs.putInt("port", this._port);
                }
                this._prefs.putBoolean("SSL", this._ssl);
            } else {
                this._prefs.putBoolean("customEndpoint", true);
                this._prefs.put("endpoint", this._endpoint);
            }
            this._prefs.put("auth", this._auth.toString());
            if (this._auth == AuthType.UsernamePasswordAuthType) {
                this._prefs.put("username", this._username);
                this._prefs.putBoolean("storePassword", this._storePassword);
                if (this._storePassword) {
                    this._prefs.put("password", this.getPassword() != null ? new String(this.getPassword()) : null);
                }
                if (this._useX509Certificate) {
                    this._prefs.putBoolean("useX509Certificate", true);
                }
            }
            if (this._auth == AuthType.X509CertificateAuthType || this._useX509Certificate) {
                this._prefs.put("alias", this._alias);
                this._prefs.putBoolean("storeKeyPassword", this._storeKeyPassword);
                if (this._storeKeyPassword) {
                    this._prefs.put("keyPassword", this.getKeyPassword() != null ? new String(this.getKeyPassword()) : null);
                }
                this._prefs.putBoolean("useX509Certificate", true);
            }
            this._prefs.putBoolean("direct", this._direct);
            if (this._direct) {
                this._prefs.putBoolean("connectToMaster", this._connectToMaster);
            }
            this._prefs.putBoolean("isDefault", this._isDefault);
            this._prefs.flush();
        }

        public synchronized void load() {
            if (this._prefs == null) {
                return;
            }
            this.setDirect(this._prefs.getBoolean("direct", false));
            if (this._direct) {
                this.setConnectToMaster(this._prefs.getBoolean("connectToMaster", false));
            }
            this.setInstanceName(this._prefs.get("instanceName", ""));
            if (this._prefs.getBoolean("defaultEndpoint", false)) {
                this.setDefaultPort(this._prefs.getBoolean("defaultPort", true));
                this.setHost(this._prefs.get("host", ""));
                this.setSSL(this._prefs.getBoolean("SSL", true));
                int port = 0;
                port = this.getDefaultPort() ? (this.getDirect() ? (this.getSSL() ? 4062 : 4061) : (this.getSSL() ? 4064 : 4063)) : (this.getDirect() ? (this.getSSL() ? this._prefs.getInt("port", 4062) : this._prefs.getInt("port", 4062)) : (this.getSSL() ? this._prefs.getInt("port", 4064) : this._prefs.getInt("port", 4063)));
                this.setPort(port);
            } else {
                this.setEndpoint(this._prefs.get("endpoint", ""));
            }
            if (this._prefs.get("auth", AuthType.X509CertificateAuthType.toString()).equals(AuthType.UsernamePasswordAuthType.toString())) {
                this.setAuth(AuthType.UsernamePasswordAuthType);
                this.setUsername(this._prefs.get("username", ""));
                this.setStorePassword(this._prefs.getBoolean("storePassword", false));
                if (this._storePassword) {
                    String tmp = this._prefs.get("password", "");
                    char[] password = new char[tmp.length()];
                    tmp.getChars(0, tmp.length(), password, 0);
                    this.setPassword(password);
                    tmp = null;
                }
                this.setUseX509Certificate(this._prefs.getBoolean("useX509Certificate", false));
            } else {
                this.setAuth(AuthType.X509CertificateAuthType);
            }
            if (this._useX509Certificate || this._auth == AuthType.X509CertificateAuthType) {
                this.setAlias(this._prefs.get("alias", ""));
                this.setStoreKeyPassword(this._prefs.getBoolean("storeKeyPassword", false));
                this.setUseX509Certificate(this._prefs.getBoolean("useX509Certificate", false));
                if (this._storeKeyPassword) {
                    String tmp = this._prefs.get("keyPassword", "");
                    char[] keyPassword = new char[tmp.length()];
                    tmp.getChars(0, tmp.length(), keyPassword, 0);
                    this.setKeyPassword(keyPassword);
                    java.lang.Object var1_3 = null;
                }
            }
            this.setIsDefault(this._prefs.getBoolean("isDefault", false));
        }

        public synchronized String getUUID() {
            return this._uuid;
        }

        public synchronized void setUUID(String uuid) {
            this._uuid = uuid;
        }

        public synchronized String getInstanceName() {
            return this._instanceName;
        }

        public synchronized void setInstanceName(String instanceName) {
            this._instanceName = instanceName == null ? null : instanceName.trim();
        }

        public synchronized boolean getDefaultEndpoint() {
            return this._defaultEndpoint;
        }

        public synchronized void setDefaultEndpoint(boolean value) {
            this._defaultEndpoint = value;
            if (!this._defaultEndpoint) {
                this._host = null;
            }
        }

        public synchronized boolean getCustomEndpoint() {
            return this._customEndpoint;
        }

        public synchronized void setCustomEndpoint(boolean value) {
            this._customEndpoint = value;
            if (!this._customEndpoint) {
                this._endpoint = null;
            }
        }

        public synchronized void setHost(String host) {
            this._host = host == null ? null : host.trim();
            this.setDefaultEndpoint(true);
            this.setCustomEndpoint(false);
        }

        public String getHost() {
            return this._host;
        }

        public synchronized void setDefaultPort(boolean value) {
            this._defaultPort = value;
        }

        public synchronized boolean getDefaultPort() {
            return this._defaultPort;
        }

        public synchronized void setPort(int port) {
            this._port = port;
            this.setDefaultEndpoint(true);
            this.setCustomEndpoint(false);
        }

        public synchronized int getPort() {
            if (this._defaultPort) {
                if (this.getDirect()) {
                    if (this.getSSL()) {
                        return 4062;
                    }
                    return 4061;
                }
                if (this.getSSL()) {
                    return 4064;
                }
                return 4063;
            }
            return this._port;
        }

        public synchronized void setSSL(boolean ssl) {
            this._ssl = ssl;
            this.setDefaultEndpoint(true);
            this.setCustomEndpoint(false);
        }

        public synchronized boolean getSSL() {
            return this._ssl;
        }

        public synchronized void setEndpoint(String endpoint) {
            this._endpoint = endpoint == null ? null : endpoint.trim();
            this.setDefaultEndpoint(false);
            this.setCustomEndpoint(true);
        }

        public String getEndpoint() {
            return this._endpoint;
        }

        public synchronized void setAuth(AuthType value) {
            this._auth = value;
        }

        public synchronized AuthType getAuth() {
            return this._auth;
        }

        public synchronized boolean getDirect() {
            return this._direct;
        }

        public synchronized void setDirect(boolean direct) {
            this._direct = direct;
        }

        public synchronized void setConnectToMaster(boolean connectToMaster) {
            this._connectToMaster = connectToMaster;
        }

        public synchronized boolean getConnectToMaster() {
            return this._connectToMaster;
        }

        public synchronized void setUseX509Certificate(boolean useX509Certificate) {
            this._useX509Certificate = useX509Certificate;
        }

        public boolean getUseX509Certificate() {
            return this._useX509Certificate;
        }

        public synchronized String getUsername() {
            return this._username;
        }

        public synchronized void setUsername(String username) {
            this._username = username == null ? null : username.trim();
        }

        public synchronized char[] getPassword() {
            return this._password;
        }

        public synchronized void setPassword(char[] password) {
            this._password = password;
        }

        private synchronized boolean getStorePassword() {
            return this._storePassword;
        }

        private synchronized void setStorePassword(boolean value) {
            this._storePassword = value;
        }

        public synchronized String getAlias() {
            return this._alias;
        }

        public synchronized void setAlias(String alias) {
            this._alias = alias;
        }

        private synchronized boolean getStoreKeyPassword() {
            return this._storeKeyPassword;
        }

        private synchronized void setStoreKeyPassword(boolean value) {
            this._storeKeyPassword = value;
        }

        public synchronized void setKeyPassword(char[] password) {
            this._keyPassword = password;
        }

        public synchronized char[] getKeyPassword() {
            return this._keyPassword;
        }

        public synchronized boolean isDefault() {
            return this._isDefault;
        }

        public synchronized void setIsDefault(boolean isDefault) {
            this._isDefault = isDefault;
        }
    }

    private class Session {
        private final AdminSessionPrx _session;
        private final boolean _routed;
        private Future<?> _keepAliveFuture;
        private ObjectAdapter _adapter;
        private AdminPrx _admin;
        private String _serverAdminCategory;
        private String _adminCallbackCategory;
        private AdminPrx _routedAdmin;
        private Identity _applicationObserverIdentity = new Identity();
        private Identity _adapterObserverIdentity = new Identity();
        private Identity _objectObserverIdentity = new Identity();
        private Identity _registryObserverIdentity = new Identity();
        private Identity _nodeObserverIdentity = new Identity();

        Session(AdminSessionPrx session, long sessionTimeout, int acmTimeout, boolean routed, Component parent) throws Throwable {
            this._session = session;
            this._routed = routed;
            try {
                this._admin = this._session.getAdmin();
            }
            catch (LocalException e) {
                while (true) {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            this.logout(true);
                            JOptionPane.showMessageDialog(parent, "Could not retrieve Admin proxy: " + e.toString(), "Login failed", 0);
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        // empty catch block
                    }
                    break;
                }
                throw e;
            }
            try {
                ObjectPrx adminCallbackTemplate;
                if (!routed && (adminCallbackTemplate = this._session.getAdminCallbackTemplate()) != null) {
                    this._adminCallbackCategory = adminCallbackTemplate.ice_getIdentity().category;
                    String publishedEndpoints = null;
                    for (Endpoint endpoint : adminCallbackTemplate.ice_getEndpoints()) {
                        String endpointString = endpoint.toString();
                        publishedEndpoints = publishedEndpoints == null ? endpointString : publishedEndpoints + ":" + endpointString;
                    }
                    SessionKeeper.this._coordinator.getCommunicator().getProperties().setProperty("CallbackAdapter.PublishedEndpoints", publishedEndpoints);
                }
                this._serverAdminCategory = this._admin.getServerAdminCategory();
            }
            catch (OperationNotExistException e) {
                while (true) {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            this.logout(true);
                            JOptionPane.showMessageDialog(parent, "This version of IceGrid GUI requires a newer IceGrid Registry", "Login failed: Version Mismatch", 0);
                        });
                    }
                    catch (InterruptedException publishedEndpoints) {
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        // empty catch block
                    }
                    break;
                }
                throw e;
            }
            catch (LocalException e) {
                while (true) {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            this.logout(true);
                            JOptionPane.showMessageDialog(parent, "Could not retrieve admin callback template or server admin category: " + e.toString(), "Login failed", 0);
                        });
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        // empty catch block
                    }
                    break;
                }
                throw e;
            }
            if (acmTimeout > 0) {
                this._session.ice_getConnection().setACM(OptionalInt.of(acmTimeout), null, Optional.of(ACMHeartbeat.HeartbeatAlways));
                this._session.ice_getConnection().setCloseCallback(con -> {
                    try {
                        con.getInfo();
                        assert (false);
                    }
                    catch (LocalException ex) {
                        SwingUtilities.invokeLater(() -> SessionKeeper.this.sessionLost("Failed to contact the IceGrid registry: " + ex.toString()));
                    }
                });
            } else {
                this._keepAliveFuture = SessionKeeper.this._coordinator.getScheduledExecutor().scheduleAtFixedRate(() -> this._session.keepAliveAsync().whenComplete((result, ex) -> {
                    if (ex != null) {
                        SwingUtilities.invokeLater(() -> SessionKeeper.this.sessionLost("Failed to contact the IceGrid registry: " + ex.toString()));
                    }
                }), sessionTimeout / 2L, sessionTimeout / 2L, TimeUnit.SECONDS);
            }
        }

        void logout(boolean destroySession) {
            this.close(destroySession);
            SessionKeeper.this._coordinator.sessionLost();
            SessionKeeper.this._connectedToMaster = false;
            SessionKeeper.this._replicaName = "";
        }

        AdminSessionPrx getSession() {
            return this._session;
        }

        AdminPrx getAdmin() {
            return this._admin;
        }

        String getServerAdminCategory() {
            return this._serverAdminCategory;
        }

        AdminPrx getRoutedAdmin() {
            assert (this._admin != null);
            if (this._routedAdmin == null) {
                ObjectAdapter adminRouterAdapter = SessionKeeper.this._coordinator.getCommunicator().createObjectAdapterWithEndpoints("IceGrid.AdminRouter", "tcp -h localhost");
                this._routedAdmin = AdminPrx.uncheckedCast(adminRouterAdapter.addWithUUID(new AdminRouter(this._admin)));
                adminRouterAdapter.activate();
            }
            return this._routedAdmin;
        }

        ObjectPrx addCallback(Object servant, String name, String facet) {
            if (this._adminCallbackCategory == null) {
                return null;
            }
            return this._adapter.addFacet(servant, new Identity(name, this._adminCallbackCategory), facet);
        }

        ObjectPrx retrieveCallback(String name, String facet) {
            if (this._adminCallbackCategory == null) {
                return null;
            }
            Identity ident = new Identity(name, this._adminCallbackCategory);
            if (this._adapter.findFacet(ident, facet) == null) {
                return null;
            }
            return this._adapter.createProxy(ident).ice_facet(facet);
        }

        Object removeCallback(String name, String facet) {
            if (this._adminCallbackCategory == null || this._adapter == null) {
                return null;
            }
            return this._adapter.removeFacet(new Identity(name, this._adminCallbackCategory), facet);
        }

        void close(boolean destroySession) {
            if (this._keepAliveFuture != null) {
                this._keepAliveFuture.cancel(false);
                this._keepAliveFuture = null;
            }
            if (this._adapter != null) {
                this._adapter.destroy();
                this._adapter = null;
            }
            this._session.ice_getConnection().setCloseCallback(null);
            if (destroySession) {
                SessionKeeper.this._coordinator.destroySession(this._session, this._routed);
            }
            SessionKeeper.this._coordinator.setConnected(false);
        }

        public void registerObservers() throws Throwable {
            String category;
            if (!this._routed) {
                category = "observer";
                String adapterName = this._adminCallbackCategory == null ? "" : "CallbackAdapter";
                this._adapter = SessionKeeper.this._coordinator.getCommunicator().createObjectAdapter(adapterName);
                this._adapter.activate();
                this._session.ice_getConnection().setAdapter(this._adapter);
            } else {
                RouterPrx router = RouterPrx.uncheckedCast(SessionKeeper.this._coordinator.getCommunicator().getDefaultRouter());
                this._adminCallbackCategory = category = router.getCategoryForClient();
                this._adapter = SessionKeeper.this._coordinator.getCommunicator().createObjectAdapterWithRouter("RoutedAdapter", router);
                this._adapter.activate();
            }
            this._applicationObserverIdentity.name = "application-" + UUID.randomUUID().toString();
            this._applicationObserverIdentity.category = category;
            this._adapterObserverIdentity.name = "adapter-" + UUID.randomUUID().toString();
            this._adapterObserverIdentity.category = category;
            this._objectObserverIdentity.name = "object-" + UUID.randomUUID().toString();
            this._objectObserverIdentity.category = category;
            this._registryObserverIdentity.name = "registry-" + UUID.randomUUID().toString();
            this._registryObserverIdentity.category = category;
            this._nodeObserverIdentity.name = "node-" + UUID.randomUUID().toString();
            this._nodeObserverIdentity.category = category;
            while (true) {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        ApplicationObserverI applicationObserverServant;
                        block4: {
                            applicationObserverServant = new ApplicationObserverI(this._admin.ice_getIdentity().category, SessionKeeper.this._coordinator);
                            ApplicationObserverPrx applicationObserver = ApplicationObserverPrx.uncheckedCast(this._adapter.add(applicationObserverServant, this._applicationObserverIdentity));
                            AdapterObserverPrx adapterObserver = AdapterObserverPrx.uncheckedCast(this._adapter.add(new AdapterObserverI(SessionKeeper.this._coordinator), this._adapterObserverIdentity));
                            ObjectObserverPrx objectObserver = ObjectObserverPrx.uncheckedCast(this._adapter.add(new ObjectObserverI(SessionKeeper.this._coordinator), this._objectObserverIdentity));
                            RegistryObserverPrx registryObserver = RegistryObserverPrx.uncheckedCast(this._adapter.add(new RegistryObserverI(SessionKeeper.this._coordinator), this._registryObserverIdentity));
                            NodeObserverPrx nodeObserver = NodeObserverPrx.uncheckedCast(this._adapter.add(new NodeObserverI(SessionKeeper.this._coordinator), this._nodeObserverIdentity));
                            try {
                                if (this._routed) {
                                    this._session.setObservers(registryObserver, nodeObserver, applicationObserver, adapterObserver, objectObserver);
                                } else {
                                    this._session.setObserversByIdentity(this._registryObserverIdentity, this._nodeObserverIdentity, this._applicationObserverIdentity, this._adapterObserverIdentity, this._objectObserverIdentity);
                                }
                            }
                            catch (ObserverAlreadyRegisteredException ex) {
                                if ($assertionsDisabled) break block4;
                                throw new AssertionError();
                            }
                        }
                        applicationObserverServant.waitForInit();
                    });
                }
                catch (InterruptedException router) {
                    continue;
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
                break;
            }
        }
    }
}

