/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Application;
import Ice.Identity;
import Ice.ObjectPrx;
import Ice.Properties;
import IceBox.AlreadyStartedException;
import IceBox.AlreadyStoppedException;
import IceBox.NoSuchServiceException;
import IceBox.ServiceManagerPrx;
import IceBox.ServiceManagerPrxHelper;
import java.util.ArrayList;

public final class Admin {
    public static void main(String[] args) {
        Client app = new Client();
        int rc = app.main("IceBox.Admin", args);
        System.exit(rc);
    }

    private static class Client
    extends Application {
        private Client() {
        }

        private void usage() {
            System.err.println("Usage: " + Client.appName() + " [options] [command...]\nOptions:\n-h, --help          Show this message.\n\nCommands:\nstart SERVICE       Start a service.\nstop SERVICE        Stop a service.\nshutdown            Shutdown the server.");
        }

        @Override
        public int run(String[] args) {
            ServiceManagerPrx manager;
            ArrayList<String> commands = new ArrayList<String>();
            for (int idx = 0; idx < args.length; ++idx) {
                if (args[idx].equals("-h") || args[idx].equals("--help")) {
                    this.usage();
                    return 1;
                }
                if (args[idx].charAt(0) == '-') {
                    System.err.println(Client.appName() + ": unknown option `" + args[idx] + "'");
                    this.usage();
                    return 1;
                }
                commands.add(args[idx]);
            }
            if (commands.isEmpty()) {
                this.usage();
                return 0;
            }
            ObjectPrx base = Client.communicator().propertyToProxy("IceBoxAdmin.ServiceManager.Proxy");
            if (base == null) {
                String managerProxy;
                Properties properties = Client.communicator().getProperties();
                Identity managerIdentity = new Identity();
                managerIdentity.category = properties.getPropertyWithDefault("IceBox.InstanceName", "IceBox");
                managerIdentity.name = "ServiceManager";
                if (properties.getProperty("Ice.Default.Locator").length() == 0) {
                    String managerEndpoints = properties.getProperty("IceBox.ServiceManager.Endpoints");
                    if (managerEndpoints.length() == 0) {
                        System.err.println(Client.appName() + ": property `IceBoxAdmin.ServiceManager.Proxy' is not set");
                        return 1;
                    }
                    managerProxy = "\"" + Client.communicator().identityToString(managerIdentity) + "\" :" + managerEndpoints;
                } else {
                    String managerAdapterId = properties.getProperty("IceBox.ServiceManager.AdapterId");
                    if (managerAdapterId.length() == 0) {
                        System.err.println(Client.appName() + ": property `IceBoxAdmin.ServiceManager.Proxy' is not set");
                        return 1;
                    }
                    managerProxy = "\"" + Client.communicator().identityToString(managerIdentity) + "\" @" + managerAdapterId;
                }
                base = Client.communicator().stringToProxy(managerProxy);
            }
            if ((manager = ServiceManagerPrxHelper.checkedCast(base)) == null) {
                System.err.println(Client.appName() + ": `" + base.toString() + "' is not an IceBox::ServiceManager");
                return 1;
            }
            for (int i = 0; i < commands.size(); ++i) {
                String service;
                String command = (String)commands.get(i);
                if (command.equals("shutdown")) {
                    manager.shutdown();
                    continue;
                }
                if (command.equals("start")) {
                    if (++i >= commands.size()) {
                        System.err.println(Client.appName() + ": no service name specified.");
                        return 1;
                    }
                    service = (String)commands.get(i);
                    try {
                        manager.startService(service);
                        continue;
                    }
                    catch (NoSuchServiceException ex) {
                        System.err.println(Client.appName() + ": unknown service `" + service + "'");
                        return 1;
                    }
                    catch (AlreadyStartedException ex) {
                        System.err.println(Client.appName() + "service already started.");
                        continue;
                    }
                }
                if (command.equals("stop")) {
                    if (++i >= commands.size()) {
                        System.err.println(Client.appName() + ": no service name specified.");
                        return 1;
                    }
                    service = (String)commands.get(i);
                    try {
                        manager.stopService(service);
                        continue;
                    }
                    catch (NoSuchServiceException ex) {
                        System.err.println(Client.appName() + ": unknown service `" + service + "'");
                        return 1;
                    }
                    catch (AlreadyStoppedException ex) {
                        System.err.println(Client.appName() + "service already stopped.");
                        continue;
                    }
                }
                System.err.println(Client.appName() + ": unknown command `" + command + "'");
                this.usage();
                return 1;
            }
            return 0;
        }
    }
}

