/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.features.ObjectsFeatureModes;
import org.netbeans.modules.profiler.v2.features.ObjectsFeatureUI;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.netbeans.modules.profiler.v2.ui.TitledMenuSeparator;
import org.openide.util.Lookup;

final class ObjectsFeature
extends ProfilerFeature.Basic {
    private final WeakProcessor processor;
    private FeatureMode currentMode;
    private FeatureMode appliedMode;
    private ObjectsFeatureModes.AllClassesMode allClassesMode;
    private ObjectsFeatureModes.ProjectClassesMode projectClassesMode;
    private ObjectsFeatureModes.SelectedClassesMode selectedClassesMode;
    private ObjectsFeatureModes.CustomClassesMode definedClassesMode;
    private static final String MODE_FLAG = "MODE_FLAG";
    private static final String SETTINGS_FLAG = "SETTINGS_FLAG";
    private JPanel settingsUI;
    private JButton modeButton;
    private JPanel settingsContainer;
    private JButton applyButton;
    private ObjectsFeatureUI ui;
    private Runnable refresher;
    private volatile boolean running;
    private ObjectsResetter resetter;

    private ObjectsFeature(ProfilerSession profilerSession) {
        super(Icons.getIcon((String)"ProfilerIcons.Memory"), Bundle.ObjectsFeature_name(), Bundle.ObjectsFeature_description(), 13, profilerSession);
        assert (!SwingUtilities.isEventDispatchThread());
        Lookup.Provider provider = profilerSession.getProject();
        String string = provider == null ? "External Process" : ProjectUtilities.getDisplayName((Lookup.Provider)provider);
        this.processor = new WeakProcessor("ObjectsFeature Processor for " + string);
        this.initModes();
    }

    @Override
    public boolean supportsConfiguration(Lookup lookup) {
        if (lookup.lookup(SourceClassInfo.class) != null) {
            return true;
        }
        ClientUtils.SourceCodeSelection sourceCodeSelection = (ClientUtils.SourceCodeSelection)lookup.lookup(ClientUtils.SourceCodeSelection.class);
        return sourceCodeSelection != null && "*".equals(sourceCodeSelection.getMethodName());
    }

    @Override
    public void configure(Lookup lookup) {
        ClientUtils.SourceCodeSelection sourceCodeSelection;
        SourceClassInfo sourceClassInfo = (SourceClassInfo)lookup.lookup(SourceClassInfo.class);
        if (sourceClassInfo != null) {
            this.selectClassForProfiling(sourceClassInfo);
        }
        if ((sourceCodeSelection = (ClientUtils.SourceCodeSelection)lookup.lookup(ClientUtils.SourceCodeSelection.class)) != null && "*".equals(sourceCodeSelection.getMethodName())) {
            this.selectForProfiling(sourceCodeSelection);
        }
    }

    private void selectClassForProfiling(SourceClassInfo sourceClassInfo) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(sourceClassInfo.getQualifiedName(), "*", null));
    }

    private void selectForProfiling(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectedClassesMode.getSelection().add(sourceCodeSelection);
    }

    private void initModes() {
        this.allClassesMode = new ObjectsFeatureModes.AllClassesMode(){

            @Override
            String readFlag(String string, String string2) {
                return ObjectsFeature.this.readFlag(this.getID() + "_" + string, string2);
            }

            @Override
            void storeFlag(String string, String string2) {
                ObjectsFeature.this.storeFlag(this.getID() + "_" + string, string2);
            }

            @Override
            void settingsChanged() {
                ObjectsFeature.this.settingsChanged();
            }
        };
        if (this.getSession().getProject() != null) {
            this.projectClassesMode = new ObjectsFeatureModes.ProjectClassesMode(){

                @Override
                String readFlag(String string, String string2) {
                    return ObjectsFeature.this.readFlag(this.getID() + "_" + string, string2);
                }

                @Override
                void storeFlag(String string, String string2) {
                    ObjectsFeature.this.storeFlag(this.getID() + "_" + string, string2);
                }

                @Override
                void settingsChanged() {
                    ObjectsFeature.this.settingsChanged();
                }

                @Override
                Lookup.Provider getProject() {
                    return ObjectsFeature.this.getSession().getProject();
                }
            };
        }
        this.selectedClassesMode = new ObjectsFeatureModes.SelectedClassesMode(){

            @Override
            String readFlag(String string, String string2) {
                return ObjectsFeature.this.readFlag(this.getID() + "_" + string, string2);
            }

            @Override
            void storeFlag(String string, String string2) {
                ObjectsFeature.this.storeFlag(this.getID() + "_" + string, string2);
            }

            @Override
            ProfilerSession getSession() {
                return ObjectsFeature.this.getSession();
            }

            @Override
            void selectForProfiling(Collection<SourceClassInfo> collection) {
                for (SourceClassInfo sourceClassInfo : collection) {
                    ObjectsFeature.this.selectClassForProfiling(sourceClassInfo);
                }
            }

            @Override
            void settingsChanged() {
                ObjectsFeature.this.settingsChanged();
            }

            @Override
            void selectionChanging() {
                ObjectsFeature.this.setMode(this);
                ObjectsFeature.this.getSettingsUI().setVisible(true);
            }

            @Override
            void selectionChanged() {
                ObjectsFeature.this.selectionChanged();
                if (ObjectsFeature.this.ui != null && ObjectsFeature.this.ui.hasResultsUI()) {
                    ObjectsFeature.this.ui.getResultsUI().repaint();
                }
            }
        };
        if (ProfilerIDESettings.getInstance().getEnableExpertSettings()) {
            this.definedClassesMode = new ObjectsFeatureModes.CustomClassesMode(){

                @Override
                String readFlag(String string, String string2) {
                    return ObjectsFeature.this.readFlag(this.getID() + "_" + string, string2);
                }

                @Override
                void storeFlag(String string, String string2) {
                    ObjectsFeature.this.storeFlag(this.getID() + "_" + string, string2);
                }

                @Override
                void settingsChanged() {
                    ObjectsFeature.this.settingsChanged();
                }
            };
        }
        String string = this.readFlag(MODE_FLAG, this.allClassesMode.getID());
        this.currentMode = this.projectClassesMode != null && string.equals(this.projectClassesMode.getID()) ? this.projectClassesMode : (string.equals(this.selectedClassesMode.getID()) ? this.selectedClassesMode : (this.definedClassesMode != null && string.equals(this.definedClassesMode.getID()) ? this.definedClassesMode : this.allClassesMode));
        this.appliedMode = this.currentMode;
    }

    private void saveMode() {
        this.storeFlag(MODE_FLAG, this.currentMode.getID());
    }

    private void setMode(FeatureMode featureMode) {
        if (this.currentMode == featureMode) {
            return;
        }
        this.currentMode = featureMode;
        this.modeChanged();
    }

    private void confirmMode() {
        this.appliedMode = this.currentMode;
    }

    private void modeChanged() {
        this.updateModeName();
        this.updateModeUI();
        this.configurationChanged();
        this.saveMode();
    }

    @Override
    public boolean supportsSettings(ProfilingSettings profilingSettings) {
        return !ProfilingSettings.isCPUSettings((ProfilingSettings)profilingSettings) && !ProfilingSettings.isJDBCSettings((ProfilingSettings)profilingSettings);
    }

    @Override
    public void configureSettings(ProfilingSettings profilingSettings) {
        this.currentMode.configureSettings(profilingSettings);
    }

    @Override
    public boolean currentSettingsValid() {
        return this.currentMode.currentSettingsValid();
    }

    private void submitChanges() {
        this.confirmMode();
        this.confirmSettings();
        this.fireChange();
    }

    private boolean pendingChanges() {
        if (this.appliedMode != this.currentMode) {
            return true;
        }
        return this.currentMode.pendingChanges();
    }

    private void configurationChanged() {
        assert (this.isActivated());
        ProfilerSession profilerSession = this.getSession();
        if (!profilerSession.inProgress()) {
            this.submitChanges();
        } else {
            this.updateApplyButton(profilerSession.getState());
        }
    }

    private void confirmSettings() {
        this.currentMode.confirmSettings();
    }

    private void confirmAllSettings() {
        if (this.allClassesMode != null) {
            this.allClassesMode.confirmSettings();
        }
        if (this.projectClassesMode != null) {
            this.projectClassesMode.confirmSettings();
        }
        if (this.selectedClassesMode != null) {
            this.selectedClassesMode.confirmSettings();
        }
        if (this.definedClassesMode != null) {
            this.definedClassesMode.confirmSettings();
        }
    }

    private void settingsChanged() {
        this.configurationChanged();
    }

    private void selectionChanged() {
        this.configurationChanged();
        if (this.getSession().inProgress() || this.getSession().isAttach()) {
            this.checkArrays();
        }
    }

    private void checkArrays() {
        HashSet<ClientUtils.SourceCodeSelection> hashSet = this.selectedClassesMode.getSelection();
        for (ClientUtils.SourceCodeSelection sourceCodeSelection : hashSet) {
            if (!sourceCodeSelection.getClassName().endsWith("[]")) continue;
            ProfilerDialogs.displayWarningDNSA((String)Bundle.ObjectsFeature_arrayWarningMsg(), (String)Bundle.ObjectsFeature_arrayWarningCaption(), null, (String)"ObjectsFeature.arraysDNSA", (boolean)true);
            break;
        }
    }

    @Override
    public JPanel getSettingsUI() {
        if (this.settingsUI == null) {
            this.settingsUI = new JPanel(new GridBagLayout()){

                @Override
                public void setVisible(boolean bl) {
                    if (bl && this.getComponentCount() == 0) {
                        ObjectsFeature.this.populateSettingsUI();
                    }
                    super.setVisible(bl);
                    ObjectsFeature.this.storeFlag(ObjectsFeature.SETTINGS_FLAG, bl ? Boolean.TRUE.toString() : null);
                }

                @Override
                public Dimension getPreferredSize() {
                    if (this.getComponentCount() == 0) {
                        return new Dimension();
                    }
                    return super.getPreferredSize();
                }
            };
            String string = this.readFlag(SETTINGS_FLAG, null);
            boolean bl = string == null ? false : Boolean.parseBoolean(string);
            this.settingsUI.setVisible(bl || this.currentMode != this.allClassesMode);
        }
        return this.settingsUI;
    }

    private void populateSettingsUI() {
        this.settingsUI.setOpaque(false);
        this.settingsUI.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SettingsPanel settingsPanel = new SettingsPanel();
        settingsPanel.add(new JLabel(Bundle.ObjectsFeature_profileMode()));
        settingsPanel.add(Box.createHorizontalStrut(5));
        this.modeButton = new PopupButton(this.currentMode.getName()){

            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new TitledMenuSeparator(Bundle.ObjectsFeature_samplingModes()));
                jPopupMenu.add(new JRadioButtonMenuItem(ObjectsFeature.this.allClassesMode.getName(), ObjectsFeature.this.currentMode == ObjectsFeature.this.allClassesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ObjectsFeature.this.setMode(ObjectsFeature.this.allClassesMode);
                    }
                });
                if (ObjectsFeature.this.projectClassesMode != null) {
                    jPopupMenu.add(new JRadioButtonMenuItem(ObjectsFeature.this.projectClassesMode.getName(), ObjectsFeature.this.currentMode == ObjectsFeature.this.projectClassesMode){

                        @Override
                        protected void fireActionPerformed(ActionEvent actionEvent) {
                            ObjectsFeature.this.setMode(ObjectsFeature.this.projectClassesMode);
                        }
                    });
                }
                jPopupMenu.add(new TitledMenuSeparator(Bundle.ObjectsFeature_instrModes()));
                jPopupMenu.add(new JRadioButtonMenuItem(ObjectsFeature.this.selectedClassesMode.getName(), ObjectsFeature.this.currentMode == ObjectsFeature.this.selectedClassesMode){

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        ObjectsFeature.this.setMode(ObjectsFeature.this.selectedClassesMode);
                    }
                });
                if (ObjectsFeature.this.definedClassesMode != null) {
                    jPopupMenu.add(new JRadioButtonMenuItem(ObjectsFeature.this.definedClassesMode.getName(), ObjectsFeature.this.currentMode == ObjectsFeature.this.definedClassesMode){

                        @Override
                        protected void fireActionPerformed(ActionEvent actionEvent) {
                            ObjectsFeature.this.setMode(ObjectsFeature.this.definedClassesMode);
                        }
                    });
                }
            }
        };
        settingsPanel.add(this.modeButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.settingsUI.add((Component)settingsPanel, gridBagConstraints);
        this.settingsContainer = new JPanel(new BorderLayout());
        this.settingsContainer.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 18;
        this.settingsUI.add((Component)this.settingsContainer, gridBagConstraints);
        SettingsPanel settingsPanel2 = new SettingsPanel();
        final Component component = Box.createHorizontalStrut(10);
        settingsPanel2.add(component);
        this.applyButton = new SmallButton(Bundle.ObjectsFeature_applyButton()){

            protected void fireActionPerformed(ActionEvent actionEvent) {
                ObjectsFeature.this.stopResults();
                ObjectsFeature.this.resetResults();
                ObjectsFeature.this.submitChanges();
                ObjectsFeature.this.unpauseResults();
            }

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                component.setVisible(bl);
            }
        };
        settingsPanel2.add(this.applyButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        this.settingsUI.add((Component)settingsPanel2, gridBagConstraints);
        this.updateModeUI();
        this.updateApplyButton(this.getSession().getState());
    }

    private void updateModeName() {
        if (this.modeButton != null) {
            this.modeButton.setText(this.currentMode.getName());
        }
    }

    private void updateModeUI() {
        if (this.settingsContainer != null) {
            this.settingsContainer.removeAll();
            JComponent jComponent = this.currentMode.getUI();
            if (jComponent != null) {
                this.settingsContainer.add(jComponent);
            }
            this.settingsContainer.doLayout();
            this.settingsContainer.repaint();
        }
    }

    private void updateApplyButton(int n) {
        if (this.applyButton != null) {
            boolean bl = n != 1;
            this.applyButton.setVisible(bl);
            if (bl) {
                this.applyButton.setEnabled(this.currentSettingsValid() && this.pendingChanges());
            }
        }
    }

    @Override
    public JPanel getResultsUI() {
        return this.getUI().getResultsUI();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        return this.getUI().getToolbar();
    }

    private ObjectsFeatureUI getUI() {
        if (this.ui == null) {
            this.ui = new ObjectsFeatureUI(){

                @Override
                Set<ClientUtils.SourceCodeSelection> getSelection() {
                    return ObjectsFeature.this.selectedClassesMode.getSelection();
                }

                @Override
                void selectForProfiling(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                    ObjectsFeature.this.selectForProfiling(sourceCodeSelection);
                }

                @Override
                Lookup.Provider getProject() {
                    return ObjectsFeature.this.getSession().getProject();
                }

                @Override
                ProfilerClient getProfilerClient() {
                    Profiler profiler = ObjectsFeature.this.getSession().getProfiler();
                    return profiler.getTargetAppRunner().getProfilerClient();
                }

                @Override
                int getSessionState() {
                    return ObjectsFeature.this.getSessionState();
                }

                @Override
                void refreshResults() {
                    ObjectsFeature.this.refreshResults();
                }
            };
        }
        return this.ui;
    }

    private void startResults() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.refresher = new Runnable(){

            @Override
            public void run() {
                if (ObjectsFeature.this.running) {
                    ObjectsFeature.this.refreshView();
                    ObjectsFeature.this.refreshResults(1500);
                }
            }
        };
        this.refreshResults(1000);
    }

    private void refreshView() {
        if (this.ui != null && ResultsManager.getDefault().resultsAvailable()) {
            try {
                this.ui.refreshData();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                this.stopResults();
            }
        }
    }

    private void refreshResults() {
        if (this.running) {
            this.processor.post(new Runnable(){

                @Override
                public void run() {
                    if (ObjectsFeature.this.ui != null) {
                        ObjectsFeature.this.ui.setForceRefresh();
                    }
                    ObjectsFeature.this.refreshView();
                }
            });
        }
    }

    private void refreshResults(int n) {
        if (this.running && this.refresher != null) {
            this.processor.post(this.refresher, n);
        }
    }

    private void resetResults() {
        if (this.ui != null) {
            this.ui.resetData();
        }
    }

    private void stopResults() {
        if (this.refresher != null) {
            this.running = false;
            this.refresher = null;
        }
    }

    private void unpauseResults() {
        if (this.ui != null) {
            this.ui.resetPause();
        }
    }

    @Override
    public void notifyActivated() {
        this.resetResults();
        this.resetter = (ObjectsResetter)Lookup.getDefault().lookup(ObjectsResetter.class);
        this.resetter.controller = this;
        if (this.getSession().inProgress() && !this.currentMode.currentSettingsValid()) {
            final String string = this.currentMode.getName();
            final String string2 = this.allClassesMode.getName();
            this.setMode(this.allClassesMode);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerDialogs.displayInfo((String)Bundle.MethodsFeature_modeReset(string, string2));
                }
            });
        }
    }

    @Override
    public void notifyDeactivated() {
        this.resetResults();
        if (this.resetter != null) {
            this.resetter.controller = null;
            this.resetter = null;
        }
        if (this.ui != null) {
            this.ui.cleanup();
            this.ui = null;
        }
        this.settingsUI = null;
    }

    @Override
    protected void profilingStateChanged(int n, int n2) {
        if (n2 == 1 || n2 == 128) {
            this.stopResults();
            this.confirmAllSettings();
        } else if (this.isActivated() && n2 == 4) {
            this.startResults();
        } else if (n2 == 2) {
            this.resetResults();
            this.unpauseResults();
        }
        if (this.ui != null) {
            this.ui.sessionStateChanged(this.getSessionState());
        }
        this.updateApplyButton(n2);
    }

    public static final class Provider
    extends ProfilerFeature.Provider {
        @Override
        public ProfilerFeature getFeature(ProfilerSession profilerSession) {
            return new ObjectsFeature(profilerSession);
        }
    }

    public static final class ObjectsResetter
    implements ResultsListener {
        private ObjectsFeature controller;

        @Override
        public void resultsAvailable() {
        }

        @Override
        public void resultsReset() {
            if (this.controller != null && this.controller.ui != null) {
                this.controller.ui.resetData();
            }
        }
    }
}

