/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.tree.TreeNode;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.cpu.CPUTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUTreeTableView;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.cpu.ThreadsSelector;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;

public abstract class LiveCPUView
extends JPanel {
    private CPUResultsSnapshot snapshot;
    private CPUResultsSnapshot refSnapshot;
    private boolean sampled;
    private boolean mergedThreads;
    private Collection<Integer> selectedThreads;
    private DataView lastFocused;
    private CPUTableView hotSpotsView;
    private CPUTreeTableView forwardCallsView;
    private CPUTreeTableView reverseCallsView;
    private ThreadsSelector threadsSelector;
    private long lastupdate;
    private volatile boolean refreshIsRunning;
    private ExecutorService executor;

    public LiveCPUView(Set<ClientUtils.SourceCodeSelection> set) {
        this.initUI(set);
        this.registerActions();
    }

    public void setView(boolean bl, boolean bl2, boolean bl3) {
        this.forwardCallsView.setVisible(bl);
        this.hotSpotsView.setVisible(bl2);
        this.reverseCallsView.setVisible(bl3);
    }

    public ThreadsSelector createThreadSelector() {
        this.threadsSelector = new ThreadsSelector(){

            @Override
            protected CPUResultsSnapshot getSnapshot() {
                return LiveCPUView.this.snapshot;
            }

            @Override
            protected void selectionChanged(Collection<Integer> collection, boolean bl) {
                LiveCPUView.this.mergedThreads = bl;
                LiveCPUView.this.selectedThreads = collection;
                LiveCPUView.this.setData();
            }

            @Override
            void reset() {
                super.reset();
                LiveCPUView.this.mergedThreads = false;
                LiveCPUView.this.selectedThreads = null;
            }
        };
        return this.threadsSelector;
    }

    public boolean isRefreshRunning() {
        return this.refreshIsRunning;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public void setData(final CPUResultsSnapshot cPUResultsSnapshot, final boolean bl) {
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.snapshot = cPUResultsSnapshot;
                LiveCPUView.this.sampled = bl;
                LiveCPUView.this.setData();
            }
        });
    }

    private void setData() {
        if (this.snapshot == null) {
            this.resetData();
            this.refreshIsRunning = false;
        } else {
            this.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    final CPUResultsSnapshot cPUResultsSnapshot = LiveCPUView.this.refSnapshot == null ? LiveCPUView.this.snapshot : LiveCPUView.this.refSnapshot.createDiff(LiveCPUView.this.snapshot);
                    final FlatProfileContainer flatProfileContainer = cPUResultsSnapshot.getFlatProfile(LiveCPUView.this.selectedThreads, 0);
                    final Map map = cPUResultsSnapshot.getMethodIDMap(0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                boolean bl = cPUResultsSnapshot instanceof CPUResultsDiff;
                                LiveCPUView.this.forwardCallsView.setData(cPUResultsSnapshot, map, 0, LiveCPUView.this.selectedThreads, LiveCPUView.this.mergedThreads, LiveCPUView.this.sampled, bl);
                                LiveCPUView.this.hotSpotsView.setData(flatProfileContainer, map, LiveCPUView.this.sampled, bl);
                                LiveCPUView.this.reverseCallsView.setData(cPUResultsSnapshot, map, 0, LiveCPUView.this.selectedThreads, LiveCPUView.this.mergedThreads, LiveCPUView.this.sampled, bl);
                            }
                            finally {
                                LiveCPUView.this.refreshIsRunning = false;
                                LiveCPUView.this.lastupdate = System.currentTimeMillis();
                            }
                        }
                    });
                }
            });
        }
    }

    public boolean setDiffView(final boolean bl) {
        if (this.snapshot == null) {
            return false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.refSnapshot = bl ? LiveCPUView.this.snapshot : null;
                LiveCPUView.this.setData();
            }
        });
        return true;
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.forwardCallsView.resetData();
                LiveCPUView.this.hotSpotsView.resetData();
                LiveCPUView.this.reverseCallsView.resetData();
                LiveCPUView.this.snapshot = null;
                LiveCPUView.this.refSnapshot = null;
                LiveCPUView.this.sampled = true;
                if (LiveCPUView.this.threadsSelector != null) {
                    LiveCPUView.this.threadsSelector.reset();
                }
            }
        });
    }

    public void showSelectionColumn() {
        this.forwardCallsView.showSelectionColumn();
        this.hotSpotsView.showSelectionColumn();
        this.reverseCallsView.showSelectionColumn();
    }

    public void refreshSelection() {
        this.forwardCallsView.refreshSelection();
        this.hotSpotsView.refreshSelection();
        this.reverseCallsView.refreshSelection();
    }

    protected boolean profileMethodSupported() {
        return true;
    }

    protected boolean profileClassSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    protected void foundInForwardCalls() {
    }

    protected void foundInHotSpots() {
    }

    protected void foundInReverseCalls() {
    }

    private void profileMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(sourceCodeSelection);
    }

    private void profileClass(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(sourceCodeSelection.getClassName(), "*", null));
    }

    private void initUI(Set<ClientUtils.SourceCodeSelection> set) {
        this.setLayout(new BorderLayout(0, 0));
        this.forwardCallsView = new CPUTreeTableView(set, false){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.forwardCallsView, jPopupMenu, object, sourceCodeSelection);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.forwardCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.forwardCallsView;
            }
        });
        this.hotSpotsView = new CPUTableView(set){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.hotSpotsView, jPopupMenu, object, sourceCodeSelection);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.hotSpotsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.hotSpotsView;
            }
        });
        this.reverseCallsView = new CPUTreeTableView(set, true){

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
                if (LiveCPUView.this.showSourceSupported()) {
                    LiveCPUView.this.showSource(sourceCodeSelection);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
                LiveCPUView.this.populatePopup(LiveCPUView.this.reverseCallsView, jPopupMenu, object, sourceCodeSelection);
            }

            @Override
            protected void popupShowing() {
                LiveCPUView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveCPUView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.reverseCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveCPUView.this.lastFocused = LiveCPUView.this.reverseCallsView;
            }
        });
        JExtendedSplitPane jExtendedSplitPane = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider basicSplitPaneDivider;
                super(n);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color color = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    basicSplitPaneDivider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color));
                }
            }
        };
        jExtendedSplitPane.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)jExtendedSplitPane).setTopComponent(this.forwardCallsView);
        ((JSplitPane)jExtendedSplitPane).setBottomComponent(this.hotSpotsView);
        jExtendedSplitPane.setDividerLocation(0.5);
        jExtendedSplitPane.setResizeWeight(0.5);
        JExtendedSplitPane jExtendedSplitPane2 = new JExtendedSplitPane(0){
            {
                BasicSplitPaneDivider basicSplitPaneDivider;
                super(n);
                this.setBorder(null);
                this.setDividerSize(5);
                if (this.getUI() instanceof BasicSplitPaneUI && (basicSplitPaneDivider = ((BasicSplitPaneUI)this.getUI()).getDivider()) != null) {
                    Color color = UIUtils.isNimbus() || UIUtils.isAquaLookAndFeel() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
                    basicSplitPaneDivider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color));
                }
            }
        };
        jExtendedSplitPane2.setBorder(BorderFactory.createEmptyBorder());
        ((JSplitPane)jExtendedSplitPane2).setTopComponent(jExtendedSplitPane);
        ((JSplitPane)jExtendedSplitPane2).setBottomComponent(this.reverseCallsView);
        jExtendedSplitPane2.setDividerLocation(0.66);
        jExtendedSplitPane2.setResizeWeight(0.66);
        this.add((Component)jExtendedSplitPane2, "Center");
    }

    private void registerActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = LiveCPUView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateFilter();
                }
            }
        });
        actionMap.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataView dataView = LiveCPUView.this.getLastFocused();
                if (dataView != null) {
                    dataView.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null) {
            if (this.forwardCallsView.isShowing()) {
                this.lastFocused = this.forwardCallsView;
            } else if (this.hotSpotsView.isShowing()) {
                this.lastFocused = this.hotSpotsView;
            } else if (this.reverseCallsView.isShowing()) {
                this.lastFocused = this.reverseCallsView;
            }
        }
        return this.lastFocused;
    }

    private void populatePopup(final DataView dataView, JPopupMenu jPopupMenu, final Object object, final ClientUtils.SourceCodeSelection sourceCodeSelection) {
        int n;
        Object object2;
        JMenuItem jMenuItem2;
        JMenuItem[] jMenuItemArray;
        if (this.showSourceSupported()) {
            jPopupMenu.add(new JMenuItem(CPUView.ACTION_GOTOSOURCE){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveCPUView.this.showSource(sourceCodeSelection);
                }
            });
            jPopupMenu.addSeparator();
        }
        if (this.profileMethodSupported()) {
            jPopupMenu.add(new JMenuItem(CPUView.ACTION_PROFILE_METHOD){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null && CPUTableView.isSelectable(sourceCodeSelection));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveCPUView.this.profileMethod(sourceCodeSelection);
                }
            });
        }
        if (this.profileClassSupported()) {
            jPopupMenu.add(new JMenuItem(CPUView.ACTION_PROFILE_CLASS){
                {
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    LiveCPUView.this.profileClass(sourceCodeSelection);
                }
            });
        }
        if (this.profileMethodSupported() || this.profileClassSupported()) {
            jPopupMenu.addSeparator();
        }
        if ((jMenuItemArray = dataView.createCustomMenuItems(this, object, sourceCodeSelection)) != null) {
            for (JMenuItem jMenuItem2 : jMenuItemArray) {
                jPopupMenu.add(jMenuItem2);
            }
            jPopupMenu.addSeparator();
        }
        this.customizeNodePopup(dataView, jPopupMenu, object, sourceCodeSelection);
        if (dataView == this.forwardCallsView) {
            object2 = (ProfilerTreeTable)this.forwardCallsView.getResultsComponent();
            n = ((JTable)object2).convertColumnIndexToView(((ProfilerTable)object2).getMainColumn());
            final String string = ((ProfilerTreeTable)object2).getStringValue((TreeNode)object, n);
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = LiveCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, string)) {
                        LiveCPUView.this.hotSpotsView.setVisible(true);
                        LiveCPUView.this.foundInHotSpots();
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)LiveCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTreeTable, string, true, true, LiveCPUView.createSearchHelper())) {
                        LiveCPUView.this.reverseCallsView.setVisible(true);
                        LiveCPUView.this.foundInReverseCalls();
                        profilerTreeTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.addSeparator();
            jMenuItem2 = new JMenu(CPUView.SHOW_MENU);
            jPopupMenu.add(jMenuItem2);
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.SHOW_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    LiveCPUView.this.threadsSelector.addThread(prestimeCPUCCTNode.getThreadId(), true);
                }
            });
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.HIDE_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    LiveCPUView.this.threadsSelector.removeThread(prestimeCPUCCTNode.getThreadId());
                }
            });
            JMenu jMenu = new JMenu(CPUView.EXPAND_MENU);
            jPopupMenu.add(jMenu);
            jMenu.add(new JMenuItem(CPUView.EXPAND_PLAIN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandPlainPath(this.val$ttable.getSelectedRow(), 2);
                }
            });
            jMenu.add(new JMenuItem(CPUView.EXPAND_TOPMOST_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandFirstPath(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_CHILDREN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseChildren(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_ALL_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseAll();
                }
            });
        } else if (dataView == this.hotSpotsView) {
            object2 = object.toString().replace("(", " (");
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS, (String)object2){
                final /* synthetic */ String val$searchString;
                {
                    this.val$searchString = string2;
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = LiveCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, this.val$searchString)) {
                        LiveCPUView.this.forwardCallsView.setVisible(true);
                        LiveCPUView.this.foundInForwardCalls();
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_REVERSECALLS, (String)object2){
                final /* synthetic */ String val$searchString;
                {
                    this.val$searchString = string2;
                    super(string);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTreeTable profilerTreeTable = (ProfilerTreeTable)LiveCPUView.this.reverseCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTreeTable, this.val$searchString, true, true, LiveCPUView.createSearchHelper())) {
                        LiveCPUView.this.reverseCallsView.setVisible(true);
                        LiveCPUView.this.foundInReverseCalls();
                        profilerTreeTable.requestFocusInWindow();
                    }
                }
            });
        } else if (dataView == this.reverseCallsView) {
            object2 = (ProfilerTreeTable)this.reverseCallsView.getResultsComponent();
            n = ((JTable)object2).convertColumnIndexToView(((ProfilerTable)object2).getMainColumn());
            final String string = ((ProfilerTreeTable)object2).getStringValue((TreeNode)object, n);
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_FORWARDCALLS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = LiveCPUView.this.forwardCallsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, string)) {
                        LiveCPUView.this.forwardCallsView.setVisible(true);
                        LiveCPUView.this.foundInForwardCalls();
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.add(new JMenuItem(CPUView.FIND_IN_HOTSPOTS){
                {
                    super(string3);
                    this.setEnabled(sourceCodeSelection != null);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    ProfilerTable profilerTable = LiveCPUView.this.hotSpotsView.getResultsComponent();
                    if (SearchUtils.findString(profilerTable, string)) {
                        LiveCPUView.this.hotSpotsView.setVisible(true);
                        LiveCPUView.this.foundInHotSpots();
                        profilerTable.requestFocusInWindow();
                    }
                }
            });
            jPopupMenu.addSeparator();
            jMenuItem2 = new JMenu(CPUView.SHOW_MENU);
            jPopupMenu.add(jMenuItem2);
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.SHOW_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    LiveCPUView.this.threadsSelector.addThread(prestimeCPUCCTNode.getThreadId(), true);
                }
            });
            ((JMenu)jMenuItem2).add(new JMenuItem(CPUView.HIDE_THREAD_ITEM){
                {
                    super(string);
                    this.setEnabled(!LiveCPUView.this.mergedThreads && LiveCPUView.this.threadsSelector != null && object instanceof PrestimeCPUCCTNode && LiveCPUView.this.snapshot.getNThreads() > 1 && (LiveCPUView.this.selectedThreads == null || LiveCPUView.this.selectedThreads.size() > 1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                    LiveCPUView.this.threadsSelector.removeThread(prestimeCPUCCTNode.getThreadId());
                }
            });
            JMenu jMenu = new JMenu(CPUView.EXPAND_MENU);
            jPopupMenu.add(jMenu);
            jMenu.add(new JMenuItem(CPUView.EXPAND_PLAIN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandPlainPath(this.val$ttable.getSelectedRow(), 1);
                }
            });
            jMenu.add(new JMenuItem(CPUView.EXPAND_TOPMOST_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.expandFirstPath(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.addSeparator();
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_CHILDREN_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseChildren(this.val$ttable.getSelectedRow());
                }
            });
            jMenu.add(new JMenuItem(CPUView.COLLAPSE_ALL_ITEM, (ProfilerTreeTable)object2){
                final /* synthetic */ ProfilerTreeTable val$ttable;
                {
                    this.val$ttable = profilerTreeTable;
                    super(string);
                }

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    this.val$ttable.collapseAll();
                }
            });
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(dataView.createCopyMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateFilter();
            }
        });
        jPopupMenu.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                dataView.activateSearch();
            }
        });
    }

    private static SearchUtils.TreeHelper createSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode treeNode) {
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)treeNode;
                CCTNode cCTNode = prestimeCPUCCTNode.getParent();
                if (cCTNode == null) {
                    return 100;
                }
                if (prestimeCPUCCTNode.isThreadNode()) {
                    return 100;
                }
                if (prestimeCPUCCTNode.isSelfTimeNode()) {
                    return 101;
                }
                if (((PrestimeCPUCCTNode)cCTNode).isThreadNode() || cCTNode.getParent() == null) {
                    return 11;
                }
                return 101;
            }
        };
    }

    protected void customizeNodePopup(DataView dataView, JPopupMenu jPopupMenu, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }
}

